/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.regattalike;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorHandicapInfoEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnTimeFactorEvent;
import com.sap.sailing.domain.abstractlog.regatta.impl.BaseRegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.impl.CompetitorTimeOnDistanceAllowancePerNauticalMileFinder;
import com.sap.sailing.domain.abstractlog.regatta.impl.CompetitorTimeOnTimeFactorFinder;
import com.sap.sailing.domain.abstractlog.regatta.impl.RegattaLogEventListener;
import com.sap.sailing.domain.base.BaseCompetitorChangeListener;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorChangeListener;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeListener;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.shared.util.WeakReferenceWithCleanerCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public abstract class BaseRegattaLikeImpl
implements IsRegattaLike {
    private static final long serialVersionUID = -5629172342837950344L;
    private final RegattaLog regattaLog;
    private final RegattaLikeIdentifier identifier;
    private transient Set<RegattaLikeListener> listeners = new HashSet<RegattaLikeListener>();

    public BaseRegattaLikeImpl(RegattaLikeIdentifier identifier, RegattaLogStore store) {
        this.regattaLog = store.getRegattaLog(identifier, true);
        this.identifier = identifier;
        this.regattaLog.addListener((Object)new RegattaLogEventForwarder(identifier));
    }

    @Override
    public RegattaLog getRegattaLog() {
        return this.regattaLog;
    }

    @Override
    public RegattaLikeIdentifier getRegattaLikeIdentifier() {
        return this.identifier;
    }

    @Override
    public void addListener(RegattaLikeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RegattaLikeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean canBoatsOfCompetitorsChangePerRace() {
        return false;
    }

    @Override
    public CompetitorRegistrationType getCompetitorRegistrationType() {
        return CompetitorRegistrationType.CLOSED;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listeners = new HashSet<RegattaLikeListener>();
        this.regattaLog.addListener((Object)new RegattaLogEventForwarder(this.identifier));
    }

    @Override
    public Double getTimeOnTimeFactor(Competitor competitor, Optional<Runnable> changeCallback) {
        Double competitorTimeOnTimeFactorDefault;
        changeCallback.ifPresent(callback -> {
            RegattaLogCompetitorTimeOnTimeFactorChangeListener regattaLogCompetitorTimeOnTimeFactorChangeListener = new RegattaLogCompetitorTimeOnTimeFactorChangeListener((Runnable)callback, this.getRegattaLog(), competitor);
        });
        changeCallback.ifPresent(callback -> {
            CompetitorTimeOnTimeFactorChangeListener competitorTimeOnTimeFactorChangeListener = new CompetitorTimeOnTimeFactorChangeListener((Runnable)callback, competitor);
        });
        Double timeOnTimeFactorFromRegattaLog = this.getTimeOnTimeFactorFromRegattaLog(competitor);
        Double result = timeOnTimeFactorFromRegattaLog == null ? ((competitorTimeOnTimeFactorDefault = competitor.getTimeOnTimeFactor()) == null ? Double.valueOf(1.0) : competitorTimeOnTimeFactorDefault) : timeOnTimeFactorFromRegattaLog;
        return result;
    }

    @Override
    public Duration getTimeOnDistanceAllowancePerNauticalMile(Competitor competitor, Optional<Runnable> changeCallback) {
        Duration competitorAllowanceDefault;
        changeCallback.ifPresent(callback -> {
            RegattaLogCompetitorTimeOnDistanceAllowanceChangeListener regattaLogCompetitorTimeOnDistanceAllowanceChangeListener = new RegattaLogCompetitorTimeOnDistanceAllowanceChangeListener((Runnable)callback, this.getRegattaLog(), competitor);
        });
        changeCallback.ifPresent(callback -> {
            CompetitorTimeOnDistanceFactorChangeListener competitorTimeOnDistanceFactorChangeListener = new CompetitorTimeOnDistanceFactorChangeListener((Runnable)callback, competitor);
        });
        Duration timeOnDistanceAllowancePerNauticalMileFromRegattaLog = this.getTimeOnDistanceAllowancePerNauticalMileFromRegattaLog(competitor);
        Duration result = timeOnDistanceAllowancePerNauticalMileFromRegattaLog == null ? ((competitorAllowanceDefault = competitor.getTimeOnDistanceAllowancePerNauticalMile()) == null ? Duration.NULL : competitorAllowanceDefault) : timeOnDistanceAllowancePerNauticalMileFromRegattaLog;
        return result;
    }

    private Double getTimeOnTimeFactorFromRegattaLog(Competitor competitor) {
        return (Double)new CompetitorTimeOnTimeFactorFinder(this.getRegattaLog(), competitor).analyze();
    }

    private Duration getTimeOnDistanceAllowancePerNauticalMileFromRegattaLog(Competitor competitor) {
        return (Duration)new CompetitorTimeOnDistanceAllowancePerNauticalMileFinder(this.getRegattaLog(), competitor).analyze();
    }

    private static abstract class CompetitorHandicapValueChangeListener
    implements BaseCompetitorChangeListener {
        private static final long serialVersionUID = -7462757662510693195L;
        private final WeakReferenceWithCleanerCallback<Runnable> callback;

        public CompetitorHandicapValueChangeListener(Runnable callback, Competitor competitor) {
            competitor.addCompetitorChangeListener((CompetitorChangeListener)this);
            this.callback = new WeakReferenceWithCleanerCallback((Object)callback, () -> competitor.removeCompetitorChangeListener((CompetitorChangeListener)this));
        }

        protected void tryToNotifyCallback() {
            Runnable theCallback = (Runnable)this.callback.get();
            if (theCallback != null) {
                theCallback.run();
            }
        }
    }

    private static class CompetitorTimeOnDistanceFactorChangeListener
    extends CompetitorHandicapValueChangeListener {
        private static final long serialVersionUID = -7462757662510693195L;

        public CompetitorTimeOnDistanceFactorChangeListener(Runnable callback, Competitor competitor) {
            super(callback, competitor);
        }

        public void timeOnDistanceAllowancePerNauticalMileChanged(Duration oldTimeOnDistanceAllowancePerNauticalMile, Duration newTimeOnDistanceAllowancePerNauticalMile) {
            if (!Util.equalsWithNull((Object)oldTimeOnDistanceAllowancePerNauticalMile, (Object)newTimeOnDistanceAllowancePerNauticalMile)) {
                this.tryToNotifyCallback();
            }
        }
    }

    private static class CompetitorTimeOnTimeFactorChangeListener
    extends CompetitorHandicapValueChangeListener {
        private static final long serialVersionUID = -7462757662510693195L;

        public CompetitorTimeOnTimeFactorChangeListener(Runnable callback, Competitor competitor) {
            super(callback, competitor);
        }

        public void timeOnTimeFactorChanged(Double oldTimeOnTimeFactor, Double newTimeOnTimeFactor) {
            if (!Util.equalsWithNull((Object)oldTimeOnTimeFactor, (Object)newTimeOnTimeFactor)) {
                this.tryToNotifyCallback();
            }
        }
    }

    private static class RegattaLogCompetitorHandicapValueChangeListener
    extends BaseRegattaLogEventVisitor {
        private static final Logger logger = Logger.getLogger(RegattaLogCompetitorTimeOnTimeFactorChangeListener.class.getName());
        private final WeakReferenceWithCleanerCallback<Runnable> callback;
        protected final Competitor competitorToLookFor;
        private final RegattaLog logToObserve;
        private final Class<? extends RegattaLogSetCompetitorHandicapInfoEvent> regattaLogEventClass;

        public RegattaLogCompetitorHandicapValueChangeListener(Runnable callback, RegattaLog logToObserve, Competitor competitorToLookFor, Class<? extends RegattaLogSetCompetitorHandicapInfoEvent> regattaLogEventClass) {
            this.logToObserve = logToObserve;
            this.regattaLogEventClass = regattaLogEventClass;
            logToObserve.addListener((Object)this);
            this.callback = new WeakReferenceWithCleanerCallback((Object)callback, () -> logToObserve.removeListener((Object)this));
            this.competitorToLookFor = competitorToLookFor;
        }

        public void visit(RegattaLogRevokeEvent event) {
            RegattaLogEvent revokedEvent;
            this.logToObserve.lockForRead();
            try {
                revokedEvent = (RegattaLogEvent)this.logToObserve.getEventById(event.getRevokedEventId());
            }
            finally {
                this.logToObserve.unlockAfterRead();
            }
            if (revokedEvent == null) {
                logger.warning("Unable to find revoked event with ID " + event.getRevokedEventId());
            } else if (this.regattaLogEventClass.isInstance(revokedEvent) && ((RegattaLogSetCompetitorHandicapInfoEvent)revokedEvent).getCompetitor() == this.competitorToLookFor) {
                this.tryToNotifyCallback();
            }
        }

        protected void tryToNotifyCallback() {
            Runnable theCallback = (Runnable)this.callback.get();
            if (theCallback != null) {
                theCallback.run();
            }
        }
    }

    private static class RegattaLogCompetitorTimeOnDistanceAllowanceChangeListener
    extends RegattaLogCompetitorHandicapValueChangeListener {
        public RegattaLogCompetitorTimeOnDistanceAllowanceChangeListener(Runnable callback, RegattaLog logToObserve, Competitor competitorToLookFor) {
            super(callback, logToObserve, competitorToLookFor, RegattaLogSetCompetitorTimeOnTimeFactorEvent.class);
        }

        public void visit(RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent event) {
            if (event.getCompetitor() == this.competitorToLookFor) {
                this.tryToNotifyCallback();
            }
        }
    }

    private static class RegattaLogCompetitorTimeOnTimeFactorChangeListener
    extends RegattaLogCompetitorHandicapValueChangeListener {
        public RegattaLogCompetitorTimeOnTimeFactorChangeListener(Runnable callback, RegattaLog logToObserve, Competitor competitorToLookFor) {
            super(callback, logToObserve, competitorToLookFor, RegattaLogSetCompetitorTimeOnTimeFactorEvent.class);
        }

        public void visit(RegattaLogSetCompetitorTimeOnTimeFactorEvent event) {
            if (event.getCompetitor() == this.competitorToLookFor) {
                this.tryToNotifyCallback();
            }
        }
    }

    private class RegattaLogEventForwarder
    extends RegattaLogEventListener {
        private final RegattaLikeIdentifier identifier;

        private RegattaLogEventForwarder(RegattaLikeIdentifier identifier) {
            this.identifier = identifier;
        }

        protected void eventAdded(RegattaLogEvent event) {
            for (RegattaLikeListener listener : BaseRegattaLikeImpl.this.listeners) {
                listener.onRegattaLogEvent(this.identifier, event);
            }
        }
    }
}

