/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.orc.AverageWindOnLegCache;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveCourse;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.orc.ORCPerformanceCurve;
import com.sap.sailing.domain.orc.ORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.impl.NoCachingWindLegTypeAndLegBearingCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.common.util.CubicSpline;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.math.ArgumentOutsideDomainException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.polynomials.PolynomialFunctionLagrangeForm;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.analysis.solvers.NewtonRaphsonSolver;
import org.apache.commons.math3.exception.DimensionMismatchException;

public class ORCPerformanceCurveImpl
implements Serializable,
ORCPerformanceCurve {
    private static final Logger logger = Logger.getLogger(ORCPerformanceCurveImpl.class.getName());
    private static final long serialVersionUID = 4113356173492168453L;
    private final ORCPerformanceCurveCourse course;
    private final UnivariateDifferentiableFunction functionImpliedWindInKnotsToAverageSpeedInKnotsForCourse;
    private final Bearing[] trueWindAngles;
    private final Speed[] trueWindSpeeds;

    public ORCPerformanceCurveImpl(ORCCertificate certificate, ORCPerformanceCurveCourse course) throws FunctionEvaluationException {
        this(certificate, course, new NoCachingWindLegTypeAndLegBearingCache());
    }

    public ORCPerformanceCurveImpl(ORCCertificate certificate, ORCPerformanceCurveCourse course, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        this.course = course;
        this.trueWindAngles = certificate.getTrueWindAngles();
        this.trueWindSpeeds = certificate.getTrueWindSpeeds();
        this.functionImpliedWindInKnotsToAverageSpeedInKnotsForCourse = this.createPerformanceCurve(certificate, cache);
    }

    private UnivariateDifferentiableFunction createPerformanceCurve(ORCCertificate certificate, ORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        LinkedHashMap<Speed, Duration> allowancesForCoursePerTrueWindSpeed = this.createAllowancesPerCourse(certificate, cache);
        double[] xs = new double[certificate.getTrueWindSpeeds().length + 2];
        double[] ys = new double[certificate.getTrueWindSpeeds().length + 2];
        int i = 0;
        xs[i] = 0.0;
        ys[i] = 0.0;
        ++i;
        for (Map.Entry entry : allowancesForCoursePerTrueWindSpeed.entrySet()) {
            xs[i] = ((Speed)entry.getKey()).getKnots();
            ys[i] = this.getCourse().getTotalLength().inTime((Duration)entry.getValue()).getKnots();
            ++i;
        }
        xs[i] = 10000.0;
        ys[i] = ys[i - 1];
        final CubicSpline interpolator = CubicSpline.interpolateBoundariesSorted((double[])xs, (double[])ys, (CubicSpline.SplineBoundaryCondition)CubicSpline.SplineBoundaryCondition.ParabolicallyTerminated, (double)0.0, (CubicSpline.SplineBoundaryCondition)CubicSpline.SplineBoundaryCondition.ParabolicallyTerminated, (double)0.0);
        UnivariateDifferentiableFunction splineFunction = new UnivariateDifferentiableFunction(){

            public double value(double x) {
                return interpolator.interpolate(x);
            }

            public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
                return new DerivativeStructure(t.getFreeParameters(), t.getOrder(), new double[]{interpolator.interpolate(t.getValue()), interpolator.differentiate(t.getValue())});
            }
        };
        return splineFunction;
    }

    public LinkedHashMap<Speed, Duration> createAllowancesPerCourse(ORCCertificate certificate, ORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        LinkedHashMap<Speed, Duration> result = new LinkedHashMap<Speed, Duration>();
        HashMap<ORCPerformanceCurveLeg, Map<Speed, Duration>> allowancesPerLeg = new HashMap<ORCPerformanceCurveLeg, Map<Speed, Duration>>();
        for (ORCPerformanceCurveLeg leg : this.course.getLegs()) {
            allowancesPerLeg.put(leg, this.createAllowancePerLeg(leg, certificate, cache));
        }
        Speed[] speedArray = certificate.getTrueWindSpeeds();
        int n = speedArray.length;
        int n2 = 0;
        while (n2 < n) {
            Speed tws = speedArray[n2];
            SecondsDurationImpl allowancePerTws = new SecondsDurationImpl(0.0);
            for (ORCPerformanceCurveLeg leg : this.course.getLegs()) {
                allowancePerTws = allowancePerTws.plus((Duration)((Map)allowancesPerLeg.get(leg)).get(tws));
            }
            result.put(tws, (Duration)allowancePerTws);
            ++n2;
        }
        return result;
    }

    private Map<Speed, Duration> createAllowancePerLeg(ORCPerformanceCurveLeg leg, ORCCertificate certificate, ORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        Map twaAllowances = certificate.getVelocityPredictionPerTrueWindSpeedAndAngle();
        Map beatAngles = certificate.getBeatAngles();
        Map beatVMGPredictionPerTrueWindSpeed = certificate.getBeatVMGPredictions();
        Map beatAllowancePerTrueWindSpeed = certificate.getBeatAllowances();
        Map runAngles = certificate.getRunAngles();
        Map runVMGPredictionPerTrueWindSpeed = certificate.getRunVMGPredictions();
        Map runAllowancePerTrueWindSpeed = certificate.getRunAllowances();
        HashMap<Speed, Duration> result = new HashMap<Speed, Duration>();
        switch (leg.getType()) {
            case TWA: {
                Bearing absoluteLegTwa = leg.getTwa((AverageWindOnLegCache)cache).abs();
                Speed[] speedArray = certificate.getTrueWindSpeeds();
                int n = speedArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Speed tws = speedArray[n2];
                    if (absoluteLegTwa.compareTo((Object)((Bearing)beatAngles.get(tws))) <= 0) {
                        result.put(tws, ((Duration)beatAllowancePerTrueWindSpeed.get(tws)).times(leg.getLength().getNauticalMiles()).times(Math.cos(absoluteLegTwa.getRadians())));
                    } else if (absoluteLegTwa.compareTo((Object)((Bearing)runAngles.get(tws))) >= 0) {
                        result.put(tws, ((Duration)runAllowancePerTrueWindSpeed.get(tws)).times(leg.getLength().getNauticalMiles()).times(Math.cos(Math.PI - absoluteLegTwa.getRadians())));
                    } else {
                        result.put(tws, this.getLagrangeSpeedPredictionForTrueWindSpeedAndAngle(twaAllowances, beatAngles, beatVMGPredictionPerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, tws, absoluteLegTwa).getDuration(leg.getLength()));
                    }
                    ++n2;
                }
                break;
            }
            case CIRCULAR_RANDOM: {
                Speed[] speedArray = certificate.getTrueWindSpeeds();
                int n = speedArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Speed tws = speedArray[n3];
                    result.put(tws, ((Speed)certificate.getCircularRandomSpeedPredictions().get(tws)).getDuration(leg.getLength()));
                    ++n3;
                }
                break;
            }
            case LONG_DISTANCE: {
                Speed[] speedArray = certificate.getTrueWindSpeeds();
                int n = speedArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Speed tws = speedArray[n4];
                    result.put(tws, ((Speed)certificate.getLongDistanceSpeedPredictions().get(tws)).getDuration(leg.getLength()));
                    ++n4;
                }
                break;
            }
            case WINDWARD_LEEWARD: 
            case WINDWARD_LEEWARD_REAL_LIVE: {
                Speed[] speedArray = certificate.getTrueWindSpeeds();
                int n = speedArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Speed tws = speedArray[n5];
                    result.put(tws, ((Speed)certificate.getWindwardLeewardSpeedPrediction().get(tws)).getDuration(leg.getLength()));
                    ++n5;
                }
                break;
            }
            case NON_SPINNAKER: {
                Speed[] speedArray = certificate.getTrueWindSpeeds();
                int n = speedArray.length;
                int n6 = 0;
                while (n6 < n) {
                    Speed tws = speedArray[n6];
                    result.put(tws, ((Speed)certificate.getNonSpinnakerSpeedPredictions().get(tws)).getDuration(leg.getLength()));
                    ++n6;
                }
                break;
            }
        }
        return result;
    }

    private double[][] createPolarsPerTrueWindSpeed(Speed trueWindSpeed, Map<Speed, Map<Bearing, Speed>> reachingSpeedPredictionsPerTrueWindSpeedAndAngle, Map<Speed, Bearing> beatAngles, Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed, Map<Speed, Bearing> runAngles, Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed, Bearing[] trueWindAngles) {
        ArrayList<Double> resultWindAngles = new ArrayList<Double>();
        ArrayList<Double> resultSpeedsOverGroundInKnots = new ArrayList<Double>();
        Bearing beatAngle = beatAngles.get(trueWindSpeed);
        Bearing runAngle = runAngles.get(trueWindSpeed);
        double TWO = 2.0;
        DegreeBearingImpl TWO_DEGREES = new DegreeBearingImpl(2.0);
        DegreeBearingImpl MINUS_TWO_DEGREES = new DegreeBearingImpl(-2.0);
        resultWindAngles.add(beatAngle.add((Bearing)MINUS_TWO_DEGREES).getDegrees());
        resultSpeedsOverGroundInKnots.add(beatVMGPredictionPerTrueWindSpeed.get(trueWindSpeed).getKnots() / Math.cos(beatAngle.add((Bearing)MINUS_TWO_DEGREES).getRadians()));
        resultWindAngles.add(beatAngle.getDegrees());
        resultSpeedsOverGroundInKnots.add(beatVMGPredictionPerTrueWindSpeed.get(trueWindSpeed).getKnots() / Math.cos(beatAngle.getRadians()));
        Bearing[] bearingArray = trueWindAngles;
        int n = trueWindAngles.length;
        int n2 = 0;
        while (n2 < n) {
            Bearing twa = bearingArray[n2];
            if (twa.compareTo((Object)beatAngle) > 0 && twa.compareTo((Object)runAngle) < 0) {
                resultWindAngles.add(twa.getDegrees());
                resultSpeedsOverGroundInKnots.add(reachingSpeedPredictionsPerTrueWindSpeedAndAngle.get(trueWindSpeed).get(twa).getKnots());
            }
            ++n2;
        }
        resultWindAngles.add(runAngle.getDegrees());
        resultSpeedsOverGroundInKnots.add(runVMGPredictionPerTrueWindSpeed.get(trueWindSpeed).getKnots() / Math.cos(Math.PI - runAngle.getRadians()));
        resultWindAngles.add(runAngle.add((Bearing)TWO_DEGREES).getDegrees());
        resultSpeedsOverGroundInKnots.add(runVMGPredictionPerTrueWindSpeed.get(trueWindSpeed).getKnots() / Math.cos(Math.PI - runAngle.add((Bearing)TWO_DEGREES).getRadians()));
        return new double[][]{resultWindAngles.stream().mapToDouble(d -> d).toArray(), resultSpeedsOverGroundInKnots.stream().mapToDouble(d -> d).toArray()};
    }

    @Override
    public Duration getAllowancePerCourse(Speed trueWindSpeed) throws ArgumentOutsideDomainException {
        return new KnotSpeedImpl(this.functionImpliedWindInKnotsToAverageSpeedInKnotsForCourse.value(trueWindSpeed.getKnots())).getDuration(this.getCourse().getTotalLength());
    }

    @Override
    public Speed getImpliedWind(Duration durationToCompleteCourse) throws MaxIterationsExceededException, FunctionEvaluationException {
        Speed result;
        Speed averageSpeedOnCourse = this.getCourse().getTotalLength().inTime(durationToCompleteCourse);
        double[] predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed = Arrays.stream(this.trueWindSpeeds).mapToDouble(tws -> this.functionImpliedWindInKnotsToAverageSpeedInKnotsForCourse.value(tws.getKnots())).toArray();
        if (averageSpeedOnCourse.getKnots() >= predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed[predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed.length - 1]) {
            result = this.trueWindSpeeds[this.trueWindSpeeds.length - 1];
        } else if (averageSpeedOnCourse.equals(Speed.NULL) || averageSpeedOnCourse.getKnots() <= predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed[0]) {
            result = this.trueWindSpeeds[0];
        } else {
            int i = 1;
            while (i < predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed.length && averageSpeedOnCourse.getKnots() >= predictedSpeedsInKnotsForTotalCourseByTrueWindSpeed[i - 1]) {
                ++i;
            }
            --i;
            Constant averageSpeedInKnots = new Constant(averageSpeedOnCourse.getKnots());
            NewtonRaphsonSolver newtonSolver = new NewtonRaphsonSolver(1.0E-10);
            UnivariateDifferentiableFunction targetZeroFunction = FunctionUtils.add((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{this.functionImpliedWindInKnotsToAverageSpeedInKnotsForCourse, FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{averageSpeedInKnots, new Constant(-1.0)})});
            double impliedWindSpeedInKnots = newtonSolver.solve(1000, (UnivariateFunction)targetZeroFunction, 12.0);
            result = new KnotSpeedImpl(impliedWindSpeedInKnots);
        }
        return result;
    }

    @Override
    public Duration getCalculatedTime(ORCPerformanceCurve referenceBoat, Duration sailedDurationPerNauticalMile) throws MaxIterationsExceededException, FunctionEvaluationException {
        return referenceBoat.getAllowancePerCourse(this.getImpliedWind(sailedDurationPerNauticalMile));
    }

    @Override
    public ORCPerformanceCurveCourse getCourse() {
        return this.course;
    }

    public Speed getLagrangeSpeedPredictionForTrueWindSpeedAndAngle(Map<Speed, Map<Bearing, Speed>> twaAllowances, Map<Speed, Bearing> beatAngles, Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed, Map<Speed, Bearing> runAngles, Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed, Speed trueWindSpeed, Bearing trueWindAngle) throws FunctionEvaluationException, IllegalArgumentException {
        return this.getLagrangeSpeedPredictionForTrueWindSpeedAndAngle(twaAllowances, beatAngles, beatVMGPredictionPerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, trueWindSpeed, trueWindAngle, this.trueWindAngles);
    }

    public Speed getLagrangeSpeedPredictionForTrueWindSpeedAndAngle(Map<Speed, Map<Bearing, Speed>> twaAllowances, Map<Speed, Bearing> beatAngles, Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed, Map<Speed, Bearing> runAngles, Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed, Speed trueWindSpeed, Bearing trueWindAngle, Bearing[] trueWindAngles) throws FunctionEvaluationException, IllegalArgumentException {
        KnotSpeedImpl result;
        double[][] polarPoints = this.createPolarsPerTrueWindSpeed(trueWindSpeed, twaAllowances, beatAngles, beatVMGPredictionPerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, trueWindAngles);
        double[] twaPolarPoints = polarPoints[0];
        double[] speedsOverGroundInKnotsPolarPoints = polarPoints[1];
        int i = -1;
        int j = 0;
        while (j < twaPolarPoints.length) {
            if (trueWindAngle.getDegrees() < twaPolarPoints[j]) {
                i = j;
                break;
            }
            ++j;
        }
        if (i >= 0) {
            int upperBound = Math.min(i + 1, twaPolarPoints.length - 1);
            int lowerBound = Math.max(i - 2, 0);
            double[] xn = new double[upperBound - lowerBound + 1];
            double[] yn = new double[upperBound - lowerBound + 1];
            i = lowerBound;
            while (i <= upperBound) {
                xn[i - lowerBound] = twaPolarPoints[i];
                yn[i - lowerBound] = speedsOverGroundInKnotsPolarPoints[i];
                ++i;
            }
            result = new KnotSpeedImpl(new PolynomialFunctionLagrangeForm(xn, yn).value(trueWindAngle.getDegrees()));
        } else {
            result = null;
        }
        return result;
    }

    private LinkedHashMap<Speed, Duration> getAllowancesPerTrueWindSpeedsForCourse() throws ArgumentOutsideDomainException {
        LinkedHashMap<Speed, Duration> result = new LinkedHashMap<Speed, Duration>();
        Speed[] speedArray = this.trueWindSpeeds;
        int n = this.trueWindSpeeds.length;
        int n2 = 0;
        while (n2 < n) {
            Speed tws = speedArray[n2];
            result.put(tws, this.getAllowancePerCourse(tws));
            ++n2;
        }
        return result;
    }

    public String toString() {
        try {
            return "ORCPerformanceCurve [Allowances " + this.allowancesToString(this.getAllowancesPerTrueWindSpeedsForCourse()) + "]";
        }
        catch (FunctionEvaluationException e) {
            logger.warning("Exception trying to compute string representation of an ORC Performance Curve object: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String allowancesToString(Map<Speed, Duration> allowancesPerTrueWindSpeedsForCourse) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Speed, Duration> e : allowancesPerTrueWindSpeedsForCourse.entrySet()) {
            result.append(e.getKey());
            result.append(':');
            Speed averageSpeed = this.getCourse().getTotalLength().inTime(e.getValue());
            result.append(averageSpeed.getDuration(ORCCertificate.NAUTICAL_MILE).asSeconds());
            result.append("s/NM, ");
            result.append(e.getValue().asSeconds());
            result.append("s total; ");
        }
        return result.substring(0, result.length() - 2);
    }
}

