/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionMapping;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public class ScoreCorrectionMappingImpl
implements ScoreCorrectionMapping {
    private final Map<String, RaceColumn> raceMappings;
    private final Map<String, Competitor> competitorMappings;
    private final RegattaScoreCorrections regattaScoreCorrections;

    public ScoreCorrectionMappingImpl(Map<String, RaceColumn> raceMappings, Map<String, Competitor> competitorMappings, RegattaScoreCorrections regattaScoreCorrections) {
        this.raceMappings = raceMappings;
        this.competitorMappings = competitorMappings;
        this.regattaScoreCorrections = regattaScoreCorrections;
    }

    @Override
    public Map<String, RaceColumn> getRaceMappings() {
        return this.raceMappings;
    }

    @Override
    public Map<String, Competitor> getCompetitorMappings() {
        return this.competitorMappings;
    }

    @Override
    public Map<RaceColumn, Map<Competitor, Util.Pair<Double, MaxPointsReason>>> getScoreCorrections() {
        HashMap<RaceColumn, Map<Competitor, Util.Pair<Double, MaxPointsReason>>> result = new HashMap<RaceColumn, Map<Competitor, Util.Pair<Double, MaxPointsReason>>>();
        for (RegattaScoreCorrections.ScoreCorrectionsForRace raceCorrection : this.regattaScoreCorrections.getScoreCorrectionsForRaces()) {
            RaceColumn raceColumn = this.getRaceMappings().get(raceCorrection.getRaceNameOrNumber());
            if (raceColumn == null) continue;
            Map competitorMapForRace = result.computeIfAbsent(raceColumn, k -> new HashMap());
            for (String sailIdOrShortName : raceCorrection.getSailIDs()) {
                Competitor competitor = this.getCompetitorMappings().get(sailIdOrShortName);
                RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace competitorCorrection = raceCorrection.getScoreCorrectionForCompetitor(sailIdOrShortName);
                if (competitor == null || competitorCorrection == null) continue;
                competitorMapForRace.put(competitor, new Util.Pair((Object)competitorCorrection.getPoints(), (Object)competitorCorrection.getMaxPointsReason()));
            }
        }
        return result;
    }

    @Override
    public boolean isComplete() {
        return !this.getRaceMappings().values().contains(null) && !this.getCompetitorMappings().values().contains(null);
    }
}

