/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.InvalidatesLeaderboardCache;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardChangeListener;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.SailNumberCanonicalizerAndMatcher;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.dto.BasicRaceDTO;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.dto.MetaLeaderboardRaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.common.tracking.BravoExtendedFix;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionMapping;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCache;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.leaderboard.caching.LiveLeaderboardUpdater;
import com.sap.sailing.domain.leaderboard.impl.AbstractSimpleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.ScoreCorrectionMappingImpl;
import com.sap.sailing.domain.leaderboard.meta.MetaLeaderboardColumn;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveByImpliedWindRankingMetric;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimingStats;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.ThreadPoolUtil;
import com.sap.sse.util.impl.FutureTaskWithTracingGet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;

public abstract class AbstractLeaderboardWithCache
implements Leaderboard {
    private static final long serialVersionUID = -5651389357061229100L;
    private static final Logger logger = Logger.getLogger(AbstractLeaderboardWithCache.class.getName());
    private final MaxPointsReason[] MAX_POINTS_REASONS_THAT_IDENTIFY_NON_FINISHED_RACES = new MaxPointsReason[]{MaxPointsReason.DNS, MaxPointsReason.DNF, MaxPointsReason.DNC};
    private transient LiveLeaderboardUpdater liveLeaderboardUpdater;
    protected static final ExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
    private transient LeaderboardDTOCache leaderboardDTOCache;
    private transient Map<Util.Pair<TrackedRace, Competitor>, RunnableFuture<RaceDetails>> raceDetailsAtEndOfTrackingCache = new HashMap<Util.Pair<TrackedRace, Competitor>, RunnableFuture<RaceDetails>>();
    private String displayName;
    private transient Set<LeaderboardChangeListener> leaderboardChangeListeners;
    private transient TimingStats timingStats;
    private transient Set<CacheInvalidationListener> cacheInvalidationListeners;

    protected AbstractLeaderboardWithCache() {
        this.initTransientFields();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.raceDetailsAtEndOfTrackingCache = new HashMap<Util.Pair<TrackedRace, Competitor>, RunnableFuture<RaceDetails>>();
        this.cacheInvalidationListeners = new HashSet<CacheInvalidationListener>();
        this.leaderboardChangeListeners = new HashSet<LeaderboardChangeListener>();
        this.timingStats = this.createTimingStats();
    }

    private TimingStats createTimingStats() {
        return new TimingStats(new Duration[]{Duration.ONE_SECOND.times(5L), Duration.ONE_SECOND.times(30L), Duration.ONE_MINUTE});
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.notifyLeaderboardChangeListeners(listener -> {
            try {
                listener.displayNameChanged(oldDisplayName, displayName);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception trying to notify listener " + listener + " about the display name of leaderboard " + this.getName() + " changing from " + oldDisplayName + " to " + displayName, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        if (!Util.contains(this.getTrackedRaces(), (Object)trackedRace)) {
            Set<CacheInvalidationListener> set = this.cacheInvalidationListeners;
            synchronized (set) {
                Iterator<CacheInvalidationListener> cacheInvalidationListenerIter = this.cacheInvalidationListeners.iterator();
                while (cacheInvalidationListenerIter.hasNext()) {
                    CacheInvalidationListener cacheInvalidationListener = cacheInvalidationListenerIter.next();
                    if (cacheInvalidationListener.getTrackedRace() != trackedRace) continue;
                    cacheInvalidationListener.removeFromTrackedRace();
                    cacheInvalidationListenerIter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLeaderboardChangeListeners(Consumer<LeaderboardChangeListener> notifier) {
        HashSet<LeaderboardChangeListener> workingListeners;
        Set<LeaderboardChangeListener> set = this.leaderboardChangeListeners;
        synchronized (set) {
            workingListeners = new HashSet<LeaderboardChangeListener>(this.leaderboardChangeListeners);
        }
        for (LeaderboardChangeListener listener : workingListeners) {
            try {
                notifier.accept(listener);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception trying to notify listener " + listener + " about a change in leaderboard " + this.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeaderboardChangeListener(LeaderboardChangeListener listener) {
        Set<LeaderboardChangeListener> set = this.leaderboardChangeListeners;
        synchronized (set) {
            this.leaderboardChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLeaderboardChangeListener(LeaderboardChangeListener listener) {
        Set<LeaderboardChangeListener> set = this.leaderboardChangeListeners;
        synchronized (set) {
            this.leaderboardChangeListeners.remove(listener);
        }
    }

    @Override
    public LeaderboardDTO getLeaderboardDTO(TimePoint timePoint, Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, TrackedRegattaRegistry trackedRegattaRegistry, DomainFactory baseDomainFactory, boolean fillTotalPointsUncorrected) throws NoWindException, InterruptedException, ExecutionException {
        LeaderboardDTO result = null;
        if (timePoint == null) {
            TimePoint nowMinusDelay = this.getNowMinusDelay();
            TimePoint timePointOfLatestModification = this.getTimePointOfLatestModification();
            if (fillTotalPointsUncorrected || timePointOfLatestModification != null && !nowMinusDelay.before(timePointOfLatestModification)) {
                timePoint = timePointOfLatestModification;
            } else {
                timePoint = null;
                result = this.getLiveLeaderboard(namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, trackedRegattaRegistry, baseDomainFactory);
            }
        }
        if (timePoint != null) {
            result = fillTotalPointsUncorrected ? this.computeDTO(timePoint, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, false, trackedRegattaRegistry, baseDomainFactory, fillTotalPointsUncorrected) : this.getLeaderboardDTOCache().getLeaderboardByName(timePoint, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, baseDomainFactory, trackedRegattaRegistry);
        }
        return result;
    }

    private LeaderboardDTO getLiveLeaderboard(Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, TrackedRegattaRegistry trackedRegattaRegistry, DomainFactory baseDomainFactory) throws NoWindException, ExecutionException {
        LiveLeaderboardUpdater liveLeaderboardUpdater = this.getLiveLeaderboardUpdater(trackedRegattaRegistry, baseDomainFactory);
        return liveLeaderboardUpdater.getLiveLeaderboard(namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiveLeaderboardUpdater getLiveLeaderboardUpdater(TrackedRegattaRegistry trackedRegattaRegistry, DomainFactory baseDomainFactory) {
        LiveLeaderboardUpdater result = this.liveLeaderboardUpdater;
        if (result == null) {
            AbstractLeaderboardWithCache abstractLeaderboardWithCache = this;
            synchronized (abstractLeaderboardWithCache) {
                result = this.liveLeaderboardUpdater;
                if (result == null) {
                    result = this.liveLeaderboardUpdater = new LiveLeaderboardUpdater(this, trackedRegattaRegistry, baseDomainFactory);
                }
            }
        }
        return result;
    }

    @Override
    public LeaderboardDTO computeDTO(TimePoint timePoint, Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, boolean waitForLatestAnalyses, TrackedRegattaRegistry trackedRegattaRegistry, DomainFactory baseDomainFactory, boolean fillTotalPointsUncorrected) throws NoWindException {
        return (LeaderboardDTO)this.callWithCPUMeterWithException(() -> {
            ShardingContext.checkConstraint(ShardingType.LEADERBOARDNAME, this.getName());
            TimePoint startOfRequestHandling = MillisecondsTimePoint.now();
            LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePoint);
            BoatClass boatClass = this.getBoatClass();
            LeaderboardDTO result = new LeaderboardDTO(this.getName(), timePoint.asDate(), this.getScoreCorrection().getTimePointOfLastCorrectionsValidity() == null ? null : this.getScoreCorrection().getTimePointOfLastCorrectionsValidity().asDate(), this.getScoreCorrection() == null ? null : this.getScoreCorrection().getComment(), this.getScoringScheme() == null ? null : this.getScoringScheme().getType(), this.getScoringScheme().isHigherBetter(), () -> UUID.randomUUID().toString(), addOverallDetails, boatClass == null ? null : new BoatClassDTO(boatClass.getName(), boatClass.getHullLength(), boatClass.getHullBeam()));
            result.type = this.getLeaderboardType();
            result.competitors = new ArrayList();
            result.displayName = this.getDisplayName();
            result.competitorDisplayNames = new HashMap();
            boolean isLeaderboardThatHasRegattaLike = this instanceof LeaderboardThatHasRegattaLike;
            if (isLeaderboardThatHasRegattaLike) {
                LeaderboardThatHasRegattaLike regattaLikeLeaderboard = (LeaderboardThatHasRegattaLike)((Object)this);
                result.canBoatsOfCompetitorsChangePerRace = regattaLikeLeaderboard.getRegattaLike().canBoatsOfCompetitorsChangePerRace();
            } else {
                result.canBoatsOfCompetitorsChangePerRace = false;
            }
            for (Competitor suppressedCompetitor : this.getSuppressedCompetitors()) {
                result.setSuppressed(baseDomainFactory.convertToCompetitorDTO(suppressedCompetitor), true);
            }
            HashMap competitorsFromBestToWorstTasks = new HashMap();
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                boolean isMetaLeaderboardColumn = raceColumn instanceof MetaLeaderboardColumn;
                RaceColumnDTO raceColumnDTO = result.createEmptyRaceColumn(raceColumn.getName(), raceColumn.isMedalRace(), raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getRegatta().getName() : null, raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getSeries().getName() : null, isMetaLeaderboardColumn, raceColumn.isOneAlwaysStaysOne());
                if (isMetaLeaderboardColumn && raceColumnDTO instanceof MetaLeaderboardRaceColumnDTO) {
                    this.calculateRacesMetadata((MetaLeaderboardColumn)raceColumn, (MetaLeaderboardRaceColumnDTO)raceColumnDTO, baseDomainFactory);
                }
                for (Fleet fleet : raceColumn.getFleets()) {
                    RegattaNameAndRaceName raceIdentifier = null;
                    Object race = null;
                    TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                    FleetDTO fleetDTO = baseDomainFactory.convertToFleetDTO(fleet);
                    if (trackedRace != null) {
                        raceIdentifier = new RegattaNameAndRaceName(trackedRace.getTrackedRegatta().getRegatta().getName(), trackedRace.getRace().getName());
                        race = baseDomainFactory.createRaceDTO(trackedRegattaRegistry, false, (RegattaAndRaceIdentifier)raceIdentifier, trackedRace);
                    }
                    result.addRace(raceColumn.getName(), raceColumn.getExplicitFactor(), this.getScoringScheme().getScoreFactor(raceColumn), raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getRegatta().getName() : null, raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getSeries().getName() : null, fleetDTO, raceColumn.isMedalRace(), (RegattaAndRaceIdentifier)raceIdentifier, (RaceDTO)race, isMetaLeaderboardColumn, raceColumn.isOneAlwaysStaysOne());
                }
                Future future = executor.submit(this.cpuMeterCallable(() -> baseDomainFactory.getCompetitorDTOList(this.getCompetitorsFromBestToWorst(raceColumn, timePoint, cache)), CPUMeteringType.COMPETITORS_FROM_BEST_TO_WORST.name()));
                competitorsFromBestToWorstTasks.put(raceColumn, future);
            }
            for (Map.Entry entry : competitorsFromBestToWorstTasks.entrySet()) {
                try {
                    result.setCompetitorsFromBestToWorst(((RaceColumn)entry.getKey()).getName(), (List)((Future)entry.getValue()).get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    logger.log(Level.SEVERE, String.valueOf(AbstractSimpleLeaderboardImpl.class.getName()) + ".computeDTO(" + this.getName() + ", " + timePoint + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ", addOverallDetails=" + addOverallDetails + "): exception during computing competitor ordering for race column " + ((RaceColumn)entry.getKey()).getName(), e);
                }
            }
            result.setDelayToLiveInMillisForLatestRace(this.getDelayToLiveInMillis());
            result.rows = new HashMap();
            result.hasCarriedPoints = this.hasCarriedPoints();
            result.discardThresholds = (int[])(this.getResultDiscardingRule() instanceof ThresholdBasedResultDiscardingRule ? ((ThresholdBasedResultDiscardingRule)this.getResultDiscardingRule()).getDiscardIndexResultsStartingWithHowManyRaces() : null);
            HashMap<Leg, LinkedHashMap<Competitor, Integer>> hashMap = new HashMap<Leg, LinkedHashMap<Competitor, Integer>>();
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                if (namesOfRaceColumnsForWhichToLoadLegDetails == null || !namesOfRaceColumnsForWhichToLoadLegDetails.contains(raceColumn.getName())) continue;
                for (Fleet fleet : raceColumn.getFleets()) {
                    TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                    if (trackedRace == null) continue;
                    trackedRace.getRace().getCourse().lockForRead();
                    try {
                        for (TrackedLeg trackedLeg : trackedRace.getTrackedLegs()) {
                            hashMap.put(trackedLeg.getLeg(), trackedLeg.getRanks(timePoint, cache));
                        }
                    }
                    finally {
                        trackedRace.getRace().getCourse().unlockAfterRead();
                    }
                }
            }
            ConcurrentHashMap rankingInfoCache = new ConcurrentHashMap();
            ConcurrentHashMap<Util.Pair, Util.Pair> futuresForCompetitorAndColumnName = new ConcurrentHashMap<Util.Pair, Util.Pair>();
            for (Competitor competitor : this.getCompetitorsFromBestToWorst(timePoint, cache)) {
                CompetitorDTO competitorDTO = baseDomainFactory.convertToCompetitorDTO(competitor);
                LeaderboardRowDTO row = new LeaderboardRowDTO();
                row.competitor = competitorDTO;
                row.fieldsByRaceColumnName = new HashMap();
                row.carriedPoints = this.hasCarriedPoints(competitor) ? Double.valueOf(this.getCarriedPoints(competitor)) : null;
                row.netPoints = this.getNetPoints(competitor, timePoint);
                if (addOverallDetails) {
                    this.addOverallDetailsToRow(timePoint, competitor, row);
                }
                result.competitors.add(competitorDTO);
                Set<RaceColumn> discardedRaceColumns = this.getResultDiscardingRule().getDiscardedRaceColumns(competitor, this, this.getRaceColumns(), timePoint, this.getScoringScheme());
                for (RaceColumn raceColumn : this.getRaceColumns()) {
                    if (!result.canBoatsOfCompetitorsChangePerRace && row.boat == null) {
                        Boat boatOfCompetitor = this.getBoatOfCompetitor(competitor, raceColumn);
                        row.boat = boatOfCompetitor == null ? null : baseDomainFactory.convertToBoatDTO(boatOfCompetitor);
                    }
                    boolean computeLegDetails = namesOfRaceColumnsForWhichToLoadLegDetails != null && namesOfRaceColumnsForWhichToLoadLegDetails.contains(raceColumn.getName());
                    Future<LeaderboardEntryDTO> future = executor.submit(() -> {
                        RankingMetric.RankingInfo rankingInfo = computeLegDetails ? rankingInfoCache.computeIfAbsent(new Util.Pair((Object)raceColumn, (Object)competitor), raceColumnAndCompetitor -> {
                            TrackedRace trackedRace = ((RaceColumn)raceColumnAndCompetitor.getA()).getTrackedRace((Competitor)raceColumnAndCompetitor.getB());
                            return trackedRace == null ? null : trackedRace.getRankingMetric().getRankingInfo(timePoint, cache);
                        }) : null;
                        Leaderboard.Entry entry = this.getEntry(competitor, raceColumn, timePoint, discardedRaceColumns, cache);
                        return this.getLeaderboardEntryDTO(entry, raceColumn, competitor, timePoint, computeLegDetails, rankingInfo, waitForLatestAnalyses, legRanksCache, baseDomainFactory, fillTotalPointsUncorrected, cache);
                    });
                    futuresForCompetitorAndColumnName.put(new Util.Pair((Object)competitor, (Object)raceColumn.getName()), new Util.Pair((Object)row, future));
                }
                if (addOverallDetails) {
                    row.totalScoredRaces = this.getTotalRaces(competitor, row, timePoint);
                }
                result.rows.put(competitorDTO, row);
                String displayName = this.getDisplayName(competitor);
                if (displayName != null) {
                    result.competitorDisplayNames.put(competitorDTO, displayName);
                }
                if (!isLeaderboardThatHasRegattaLike) continue;
                LeaderboardThatHasRegattaLike regattaLikeLeaderboard = (LeaderboardThatHasRegattaLike)((Object)this);
                Duration regattaLevelTimeOnDistanceAllowancePerNauticalMile = regattaLikeLeaderboard.getRegattaLike().getTimeOnDistanceAllowancePerNauticalMile(competitor, Optional.empty());
                Double regattaLevelTimeOnTimeFactor = regattaLikeLeaderboard.getRegattaLike().getTimeOnTimeFactor(competitor, Optional.empty());
                row.effectiveTimeOnDistanceAllowancePerNauticalMile = regattaLevelTimeOnDistanceAllowancePerNauticalMile;
                row.effectiveTimeOnTimeFactor = regattaLevelTimeOnTimeFactor;
            }
            for (Map.Entry entry : futuresForCompetitorAndColumnName.entrySet()) {
                try {
                    LeaderboardRowDTO rowForCompetitor = (LeaderboardRowDTO)((Util.Pair)entry.getValue()).getA();
                    String columnName = (String)((Util.Pair)entry.getKey()).getB();
                    Future future = (Future)((Util.Pair)entry.getValue()).getB();
                    rowForCompetitor.fieldsByRaceColumnName.put(columnName, (LeaderboardEntryDTO)future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Competitor competitor = (Competitor)((Util.Pair)entry.getKey()).getA();
                    logger.log(Level.SEVERE, String.valueOf(AbstractSimpleLeaderboardImpl.class.getName()) + ".computeDTO(" + this.getName() + ", " + timePoint + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ", addOverallDetails=" + addOverallDetails + "): exception during computing leaderboard entry for competitor " + competitor.getName() + " in race column " + entry.getKey() + ". Leaving empty.", e);
                }
            }
            Duration duration = startOfRequestHandling.until(MillisecondsTimePoint.now());
            logger.info("computeLeaderboardByName(" + this.getName() + ", " + timePoint + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ", addOverallDetails=" + addOverallDetails + ") took " + duration);
            this.updateStats(startOfRequestHandling, duration);
            return result;
        }, CPUMeteringType.LEADERBOARD_COMPUTE_DTO.name());
    }

    private void updateStats(TimePoint startOfRequestHandling, Duration computeDuration) {
        try {
            this.timingStats.recordTiming(startOfRequestHandling, computeDuration);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception trying to update leaderboard compute time stats", e);
        }
    }

    @Override
    public Map<Duration, Util.Pair<Duration, Integer>> getComputationTimeStatistics() {
        return this.timingStats.getAverageDurationsAndNumberOfRequests();
    }

    private Integer getTotalRaces(Competitor competitor, LeaderboardRowDTO row, TimePoint timePoint) {
        int amount = 0;
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            LeaderboardEntryDTO entry = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(raceColumn.getName());
            if (entry == null || entry.netPoints == null || !entry.reasonForMaxPoints.equals((Object)MaxPointsReason.NONE) && Util.contains(Arrays.asList(this.MAX_POINTS_REASONS_THAT_IDENTIFY_NON_FINISHED_RACES), (Object)entry.reasonForMaxPoints)) continue;
            if (raceColumn instanceof MetaLeaderboardColumn) {
                Leaderboard leaderBoardForMeta = ((MetaLeaderboardColumn)raceColumn).getLeaderboard();
                for (RaceColumn subRace : leaderBoardForMeta.getRaceColumns()) {
                    Double netPointsForSubRace = leaderBoardForMeta.getNetPoints(competitor, subRace, timePoint);
                    MaxPointsReason subMaxPointsReason = leaderBoardForMeta.getMaxPointsReason(competitor, subRace, timePoint);
                    if (netPointsForSubRace == null || !subMaxPointsReason.equals((Object)MaxPointsReason.NONE) && Util.contains(Arrays.asList(this.MAX_POINTS_REASONS_THAT_IDENTIFY_NON_FINISHED_RACES), (Object)subMaxPointsReason)) continue;
                    ++amount;
                }
                continue;
            }
            ++amount;
        }
        return amount;
    }

    private LeaderboardEntryDTO getLeaderboardEntryDTO(Leaderboard.Entry entry, RaceColumn raceColumn, Competitor competitor, TimePoint timePoint, boolean addLegDetails, RankingMetric.RankingInfo rankingInfo, boolean waitForLatestAnalyses, Map<Leg, LinkedHashMap<Competitor, Integer>> legRanksCache, DomainFactory baseDomainFactory, boolean fillTotalPointsUncorrected, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NotEnoughDataHasBeenAddedException {
        Fleet fleet;
        LeaderboardEntryDTO entryDTO;
        block17: {
            GPSFixTrack<Competitor, GPSFixMoving> track;
            entryDTO = new LeaderboardEntryDTO();
            TrackedRace trackedRace = raceColumn.getTrackedRace(competitor);
            entryDTO.race = trackedRace == null ? null : trackedRace.getRaceIdentifier();
            Boat boat = this.getBoatOfCompetitor(competitor, raceColumn);
            entryDTO.boat = boat == null ? null : baseDomainFactory.convertToBoatDTO(boat);
            entryDTO.totalPoints = entry.getTotalPoints();
            if (fillTotalPointsUncorrected) {
                entryDTO.totalPointsUncorrected = entry.getTotalPointsUncorrected();
            }
            entryDTO.incrementalScoreCorrectionInPoints = entry.getIncrementalScoreCorrectionInPoints();
            entryDTO.totalPointsCorrected = entry.isTotalPointsCorrected();
            entryDTO.netPoints = entry.getNetPoints();
            entryDTO.reasonForMaxPoints = entry.getMaxPointsReason();
            entryDTO.discarded = entry.isDiscarded();
            GPSFixTrack<Competitor, GPSFixMoving> gPSFixTrack = track = trackedRace == null ? null : trackedRace.getTrack(competitor);
            if (trackedRace != null) {
                long timeDifferenceInMs;
                Date timePointOfLastPositionFixAtOrBeforeQueryTimePoint = this.getTimePointOfLastFixAtOrBefore(competitor, trackedRace, timePoint);
                if (track != null) {
                    entryDTO.averageSamplingInterval = track.getAverageIntervalBetweenRawFixes();
                    entryDTO.currentSpeedAndCourseOverGround = track.getEstimatedSpeed(timePoint);
                }
                entryDTO.timeSinceLastPositionFixInSeconds = timePointOfLastPositionFixAtOrBeforeQueryTimePoint != null ? Double.valueOf((timeDifferenceInMs = timePoint.asMillis() - timePointOfLastPositionFixAtOrBeforeQueryTimePoint.getTime()) == 0L ? 0.0 : (double)timeDifferenceInMs / 1000.0) : null;
                Distance averageRideHeight = trackedRace.getAverageRideHeight(competitor, timePoint);
                Double d = entryDTO.averageRideHeightInMeters = averageRideHeight == null ? null : Double.valueOf(averageRideHeight.getMeters());
            }
            if (addLegDetails && trackedRace != null) {
                try {
                    TimePoint startOfRace;
                    RaceDetails raceDetails = this.getRaceDetails(trackedRace, competitor, timePoint, waitForLatestAnalyses, legRanksCache, rankingInfo, cache);
                    entryDTO.legDetails = raceDetails.getLegDetails();
                    entryDTO.windwardDistanceToCompetitorFarthestAheadInMeters = raceDetails.getWindwardDistanceToCompetitorFarthestAhead() == null ? null : Double.valueOf(raceDetails.getWindwardDistanceToCompetitorFarthestAhead().getMeters());
                    entryDTO.gapToLeaderInOwnTime = trackedRace.getRankingMetric().getGapToLeaderInOwnTime(rankingInfo, competitor, cache);
                    entryDTO.averageAbsoluteCrossTrackErrorInMeters = raceDetails.getAverageAbsoluteCrossTrackError() == null ? null : Double.valueOf(raceDetails.getAverageAbsoluteCrossTrackError().getMeters());
                    entryDTO.averageSignedCrossTrackErrorInMeters = raceDetails.getAverageSignedCrossTrackError() == null ? null : Double.valueOf(raceDetails.getAverageSignedCrossTrackError().getMeters());
                    entryDTO.timeSailedSinceRaceStart = raceDetails.getTimeSailedSinceRaceStart();
                    entryDTO.calculatedTime = raceDetails.getCorrectedTime();
                    if (trackedRace != null && trackedRace.getRankingMetric() instanceof ORCPerformanceCurveByImpliedWindRankingMetric) {
                        entryDTO.impliedWind = ((ORCPerformanceCurveByImpliedWindRankingMetric)trackedRace.getRankingMetric()).getImpliedWind(competitor, timePoint, cache);
                    }
                    entryDTO.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead = raceDetails.getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead();
                    entryDTO.gapToLeaderInOwnTime = raceDetails.getGapToLeaderInOwnTime();
                    entryDTO.percentTargetBoatSpeed = raceDetails.getPercentTargetBoatSpeed();
                    try {
                        BravoFixTrack sensorTrack = (BravoFixTrack)trackedRace.getSensorTrack(competitor, "BravoFixTrack");
                        if (sensorTrack != null) {
                            BravoFix bravoFix = (BravoFix)sensorTrack.getFirstFixAtOrAfter(timePoint);
                            entryDTO.heel = bravoFix == null ? null : bravoFix.getHeel();
                            Bearing bearing = entryDTO.pitch = bravoFix == null ? null : bravoFix.getPitch();
                            if (sensorTrack.hasExtendedFixes() && bravoFix instanceof BravoExtendedFix) {
                                BravoExtendedFix fix = (BravoExtendedFix)bravoFix;
                                entryDTO.setExpeditionAWA(fix.getExpeditionAWA());
                                entryDTO.setExpeditionAWS(fix.getExpeditionAWS());
                                entryDTO.setExpeditionTWA(fix.getExpeditionTWA());
                                entryDTO.setExpeditionTWS(fix.getExpeditionTWS());
                                entryDTO.setExpeditionTWD(fix.getExpeditionTWD());
                                entryDTO.setExpeditionBoatSpeed(fix.getExpeditionBSP());
                                entryDTO.setExpeditionTargBoatSpeed(fix.getExpeditionBSP_TR());
                                entryDTO.setExpeditionSOG(fix.getExpeditionSOG());
                                entryDTO.setExpeditionCOG(fix.getExpeditionCOG());
                                entryDTO.setExpeditionForestayLoad(fix.getExpeditionForestayLoad());
                                entryDTO.setExpeditionRake(fix.getExpeditionRake());
                                entryDTO.setExpeditionHeading(fix.getExpeditionHDG());
                                entryDTO.setExpeditionHeel(fix.getExpeditionHeel());
                                entryDTO.setExpeditionTargetHeel(fix.getExpeditionTG_Heell());
                                entryDTO.setExpeditionTimeToGunInSeconds(fix.getExpeditionTmToGunInSeconds());
                                entryDTO.setExpeditionTimeToBurnToLineInSeconds(fix.getExpeditionTmToBurnInSeconds());
                                entryDTO.setExpeditionDistanceBelowLineInMeters(fix.getExpeditionBelowLnInMeters());
                                entryDTO.setExpeditionCourseDetail(fix.getExpeditionCourse());
                                entryDTO.setExpeditionBaro(fix.getExpeditionBARO());
                                entryDTO.setExpeditionLoadP(fix.getExpeditionLoadP());
                                entryDTO.setExpeditionLoadS(fix.getExpeditionLoadS());
                                entryDTO.setExpeditionJibCarPort(fix.getExpeditionJibCarPort());
                                entryDTO.setExpeditionJibCarStbd(fix.getExpeditionJibCarStbd());
                                entryDTO.setExpeditionMastButt(fix.getExpeditionMastButt());
                                entryDTO.setExpeditionRateOfTurn(fix.getExpeditionRateOfTurn());
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "There was an error determining expedition or extended data", e);
                    }
                    if ((startOfRace = trackedRace.getStartOfRace()) == null) break block17;
                    Waypoint startWaypoint = trackedRace.getRace().getCourse().getFirstWaypoint();
                    NavigableSet<MarkPassing> competitorMarkPassings = trackedRace.getMarkPassings(competitor);
                    trackedRace.lockForRead(competitorMarkPassings);
                    try {
                        MarkPassing firstMarkPassing;
                        if (competitorMarkPassings.isEmpty() || (firstMarkPassing = competitorMarkPassings.iterator().next()).getWaypoint() != startWaypoint) break block17;
                        Distance distanceToStartLineFiveSecondsBeforeStartOfRace = trackedRace.getDistanceToStartLine(competitor, 5000L);
                        entryDTO.distanceToStartLineFiveSecondsBeforeStartInMeters = distanceToStartLineFiveSecondsBeforeStartOfRace == null ? null : Double.valueOf(distanceToStartLineFiveSecondsBeforeStartOfRace.getMeters());
                        Speed speedFiveSecondsBeforeStartOfRace = trackedRace.getSpeed(competitor, 5000L);
                        entryDTO.speedOverGroundFiveSecondsBeforeStartInKnots = speedFiveSecondsBeforeStartOfRace == null ? null : Double.valueOf(speedFiveSecondsBeforeStartOfRace.getKnots());
                        Distance distanceToStartLineAtStartOfRace = trackedRace.getDistanceToStartLine(competitor, startOfRace);
                        entryDTO.distanceToStartLineAtStartOfRaceInMeters = distanceToStartLineAtStartOfRace == null ? null : Double.valueOf(distanceToStartLineAtStartOfRace.getMeters());
                        SpeedWithBearing speedAtStartTime = track == null ? null : track.getEstimatedSpeed(startOfRace);
                        entryDTO.speedOverGroundAtStartOfRaceInKnots = speedAtStartTime == null ? null : Double.valueOf(speedAtStartTime.getKnots());
                        TimePoint competitorStartTime = firstMarkPassing.getTimePoint();
                        entryDTO.timeBetweenRaceStartAndCompetitorStartInSeconds = startOfRace.until(competitorStartTime).asSeconds();
                        SpeedWithBearing competitorSpeedWhenPassingStart = track == null ? null : track.getEstimatedSpeed(competitorStartTime);
                        entryDTO.speedOverGroundAtPassingStartWaypointInKnots = competitorSpeedWhenPassingStart == null ? null : Double.valueOf(competitorSpeedWhenPassingStart.getKnots());
                        try {
                            entryDTO.startTack = trackedRace.getTack(competitor, competitorStartTime);
                        }
                        catch (NoWindException nwe) {
                            entryDTO.startTack = null;
                        }
                        Distance distanceFromStarboardSideOfStartLineWhenPassingStart = trackedRace.getDistanceFromStarboardSideOfStartLineWhenPassingStart(competitor);
                        entryDTO.distanceToStarboardSideOfStartLineInMeters = distanceFromStarboardSideOfStartLineWhenPassingStart == null ? null : Double.valueOf(distanceFromStarboardSideOfStartLineWhenPassingStart.getMeters());
                    }
                    finally {
                        trackedRace.unlockAfterRead(competitorMarkPassings);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException | FunctionEvaluationException | MaxIterationsExceededException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        entryDTO.fleet = (fleet = entry.getFleet()) == null ? null : baseDomainFactory.convertToFleetDTO(fleet);
        return entryDTO;
    }

    private Boat getBoatOfCompetitor(Competitor competitor, RaceColumn raceColumn) {
        Boat boat = competitor.hasBoat() ? ((CompetitorWithBoat)competitor).getBoat() : this.getBoatOfCompetitor(competitor, raceColumn, raceColumn.getFleetOfCompetitor(competitor));
        return boat;
    }

    private void calculateRacesMetadata(MetaLeaderboardColumn metaLeaderboardColumn, MetaLeaderboardRaceColumnDTO columnDTO, DomainFactory baseDomainFactory) {
        for (RaceColumn raceColumn : metaLeaderboardColumn.getLeaderboard().getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace == null) continue;
                String regattaName = trackedRace.getTrackedRegatta().getRegatta().getName();
                String raceName = trackedRace.getRace().getName();
                RegattaNameAndRaceName raceIdentifier = new RegattaNameAndRaceName(regattaName, raceName);
                columnDTO.addRace(new BasicRaceDTO((RegattaAndRaceIdentifier)raceIdentifier, baseDomainFactory.createTrackedRaceDTO(trackedRace)));
            }
        }
    }

    private void addOverallDetailsToRow(TimePoint timePoint, Competitor competitor, LeaderboardRowDTO row) throws NoWindException {
        HashMap<TrackedLeg, LegType> legTypeCache;
        Duration totalTimeSailedDownwind;
        Util.Pair<GPSFixMoving, Speed> maximumSpeedOverGround = this.getMaximumSpeedOverGround(competitor, timePoint);
        if (maximumSpeedOverGround != null && maximumSpeedOverGround.getB() != null) {
            row.maximumSpeedOverGroundInKnots = ((Speed)maximumSpeedOverGround.getB()).getKnots();
            row.whenMaximumSpeedOverGroundWasAchieved = ((GPSFixMoving)maximumSpeedOverGround.getA()).getTimePoint().asDate();
        }
        row.totalTimeSailedDownwindInSeconds = (totalTimeSailedDownwind = this.getTotalTimeSailedInLegType(competitor, LegType.DOWNWIND, timePoint, legTypeCache = new HashMap<TrackedLeg, LegType>())) == null ? null : Double.valueOf(totalTimeSailedDownwind.asSeconds());
        Duration totalTimeSailedUpwind = this.getTotalTimeSailedInLegType(competitor, LegType.UPWIND, timePoint, legTypeCache);
        row.totalTimeSailedUpwindInSeconds = totalTimeSailedUpwind == null ? null : Double.valueOf(totalTimeSailedUpwind.asSeconds());
        Duration totalTimeSailedReaching = this.getTotalTimeSailedInLegType(competitor, LegType.REACHING, timePoint, legTypeCache);
        row.totalTimeSailedReachingInSeconds = totalTimeSailedReaching == null ? null : Double.valueOf(totalTimeSailedReaching.asSeconds());
        Duration totalTimeSailed = this.getTotalTimeSailed(competitor, timePoint);
        row.totalTimeSailedInSeconds = totalTimeSailed == null ? null : Double.valueOf(totalTimeSailed.asSeconds());
        Distance totalDistanceTraveled = this.getTotalDistanceTraveled(competitor, timePoint);
        row.totalDistanceTraveledInMeters = totalDistanceTraveled == null ? null : Double.valueOf(totalDistanceTraveled.getMeters());
        Distance totalDistanceFoiled = this.getTotalDistanceFoiled(competitor, timePoint);
        row.totalDistanceFoiledInMeters = totalDistanceFoiled == null ? null : Double.valueOf(totalDistanceFoiled.getMeters());
        Duration totalDurationFoiled = this.getTotalDurationFoiled(competitor, timePoint);
        row.totalDurationFoiledInSeconds = totalDurationFoiled == null ? null : Double.valueOf(totalDurationFoiled.asSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LeaderboardDTOCache getLeaderboardDTOCache() {
        LeaderboardDTOCache result = this.leaderboardDTOCache;
        if (result == null) {
            AbstractLeaderboardWithCache abstractLeaderboardWithCache = this;
            synchronized (abstractLeaderboardWithCache) {
                result = this.leaderboardDTOCache;
                if (result == null) {
                    result = this.leaderboardDTOCache = new LeaderboardDTOCache(false, this);
                }
            }
        }
        return result;
    }

    private RaceDetails getRaceDetails(TrackedRace trackedRace, Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalyses, Map<Leg, LinkedHashMap<Competitor, Integer>> legRanksCache, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws InterruptedException, ExecutionException, MaxIterationsExceededException, FunctionEvaluationException, NotEnoughDataHasBeenAddedException {
        RaceDetails raceDetails = trackedRace.getEndOfTracking() != null && trackedRace.getEndOfTracking().compareTo((Object)timePoint) < 0 ? this.getRaceDetailsForEndOfTrackingFromCacheOrCalculateAndCache(trackedRace, competitor, legRanksCache, rankingInfo, cache) : this.calculateRaceDetails(trackedRace, competitor, timePoint, waitForLatestAnalyses, legRanksCache, cache, rankingInfo);
        return raceDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaceDetails getRaceDetailsForEndOfTrackingFromCacheOrCalculateAndCache(final TrackedRace trackedRace, final Competitor competitor, final Map<Leg, LinkedHashMap<Competitor, Integer>> legRanksCache, RankingMetric.RankingInfo rankingInfo, final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws InterruptedException, ExecutionException {
        boolean needToRunRaceDetails;
        FutureTaskWithTracingGet raceDetails;
        Util.Pair key = new Util.Pair((Object)trackedRace, (Object)competitor);
        Map<Util.Pair<TrackedRace, Competitor>, RunnableFuture<RaceDetails>> map = this.raceDetailsAtEndOfTrackingCache;
        synchronized (map) {
            raceDetails = this.raceDetailsAtEndOfTrackingCache.get(key);
            if (raceDetails == null) {
                needToRunRaceDetails = true;
                raceDetails = new FutureTaskWithTracingGet("RaceDetails for " + trackedRace, (Callable)new Callable<RaceDetails>(){

                    @Override
                    public RaceDetails call() throws Exception {
                        TimePoint end = trackedRace.getEndOfRace();
                        if (end == null) {
                            end = trackedRace.getEndOfTracking();
                        }
                        return AbstractLeaderboardWithCache.this.calculateRaceDetails(trackedRace, competitor, end, false, legRanksCache, cache, trackedRace.getRankingMetric().getRankingInfo(end, cache));
                    }
                });
                this.raceDetailsAtEndOfTrackingCache.put((Util.Pair<TrackedRace, Competitor>)key, (RunnableFuture<RaceDetails>)raceDetails);
                CacheInvalidationListener cacheInvalidationListener = new CacheInvalidationListener(trackedRace, competitor);
                trackedRace.addListener(cacheInvalidationListener);
                this.cacheInvalidationListeners.add(cacheInvalidationListener);
            } else {
                needToRunRaceDetails = false;
            }
        }
        if (needToRunRaceDetails) {
            raceDetails.run();
        }
        return (RaceDetails)raceDetails.get();
    }

    private RaceDetails calculateRaceDetails(TrackedRace trackedRace, Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalyses, Map<Leg, LinkedHashMap<Competitor, Integer>> legRanksCache, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache, RankingMetric.RankingInfo rankingInfo) throws MaxIterationsExceededException, FunctionEvaluationException, NotEnoughDataHasBeenAddedException {
        ArrayList<LegEntryDTO> legDetails = new ArrayList<LegEntryDTO>();
        Course course = trackedRace.getRace().getCourse();
        course.lockForRead();
        try {
            for (Leg leg : course.getLegs()) {
                TrackedLegOfCompetitor trackedLeg = trackedRace.getTrackedLeg(competitor, leg);
                LegEntryDTO legEntry = trackedLeg != null && trackedLeg.hasStartedLeg(timePoint) ? this.createLegEntry(trackedLeg, timePoint, waitForLatestAnalyses, legRanksCache, rankingInfo, cache) : null;
                legDetails.add(legEntry);
            }
            Distance windwardDistanceToCompetitorFarthestAhead = trackedRace == null ? null : trackedRace.getWindwardDistanceToCompetitorFarthestAhead(competitor, timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, cache);
            Distance averageAbsoluteCrossTrackError = trackedRace == null ? null : trackedRace.getAverageAbsoluteCrossTrackError(competitor, timePoint, waitForLatestAnalyses, cache);
            Distance averageSignedCrossTrackError = trackedRace == null ? null : trackedRace.getAverageSignedCrossTrackError(competitor, timePoint, waitForLatestAnalyses, cache);
            RankingMetric.CompetitorRankingInfo competitorRankingInfo = rankingInfo.getCompetitorRankingInfo().apply(competitor);
            RaceDetails raceDetails = new RaceDetails(legDetails, windwardDistanceToCompetitorFarthestAhead, averageAbsoluteCrossTrackError, averageSignedCrossTrackError, trackedRace.getRankingMetric().getGapToLeaderInOwnTime(rankingInfo, competitor, cache), trackedRace.getPercentTargetBoatSpeed(competitor, timePoint, cache), trackedRace.getTimeSailedSinceRaceStart(competitor, timePoint), competitorRankingInfo == null ? null : competitorRankingInfo.getCorrectedTime(), competitorRankingInfo == null ? null : competitorRankingInfo.getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead());
            return raceDetails;
        }
        finally {
            course.unlockAfterRead();
        }
    }

    private LegEntryDTO createLegEntry(TrackedLegOfCompetitor trackedLeg, TimePoint timePoint, boolean waitForLatestAnalyses, Map<Leg, LinkedHashMap<Competitor, Integer>> legRanksCache, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        LegEntryDTO result;
        Duration time = trackedLeg.getTime(timePoint);
        if (trackedLeg == null || time == null) {
            result = null;
        } else {
            Iterable<Maneuver> maneuvers;
            LinkedHashMap<Competitor, Integer> legRanks;
            Duration gapAtEndOfPreviousLeg;
            Double speedOverGroundInKnots;
            result = new LegEntryDTO();
            try {
                result.legType = trackedLeg.getTrackedLeg().getLegType(timePoint);
            }
            catch (NoWindException nwe) {
                result.legType = null;
            }
            Speed averageSpeedOverGround = trackedLeg.getAverageSpeedOverGround(timePoint);
            result.averageSpeedOverGroundInKnots = averageSpeedOverGround == null ? null : Double.valueOf(averageSpeedOverGround.getKnots());
            boolean hasFinishedLeg = trackedLeg.hasFinishedLeg(timePoint);
            Distance currentOrAverageAbsoluteCrossTrackError = hasFinishedLeg ? trackedLeg.getAverageAbsoluteCrossTrackError(timePoint, waitForLatestAnalyses) : trackedLeg.getAbsoluteCrossTrackError(timePoint);
            result.currentOrAverageAbsoluteCrossTrackErrorInMeters = currentOrAverageAbsoluteCrossTrackError == null ? null : Double.valueOf(currentOrAverageAbsoluteCrossTrackError.getMeters());
            Distance currentOrAverageSignedCrossTrackError = hasFinishedLeg ? trackedLeg.getAverageSignedCrossTrackError(timePoint, waitForLatestAnalyses) : trackedLeg.getSignedCrossTrackError(timePoint);
            Double d = result.currentOrAverageSignedCrossTrackErrorInMeters = currentOrAverageSignedCrossTrackError == null ? null : Double.valueOf(currentOrAverageSignedCrossTrackError.getMeters());
            if (hasFinishedLeg) {
                speedOverGroundInKnots = averageSpeedOverGround == null ? null : Double.valueOf(averageSpeedOverGround.getKnots());
                Distance averageRideHeight = trackedLeg.getAverageRideHeight(timePoint);
                result.currentRideHeightInMeters = averageRideHeight == null ? null : Double.valueOf(averageRideHeight.getMeters());
            } else {
                SpeedWithBearing speedOverGround = trackedLeg.getSpeedOverGround(timePoint);
                speedOverGroundInKnots = speedOverGround == null ? null : Double.valueOf(speedOverGround.getKnots());
                Distance rideHeight = trackedLeg.getRideHeight(timePoint);
                result.currentRideHeightInMeters = rideHeight == null ? null : Double.valueOf(rideHeight.getMeters());
            }
            Bearing heel = trackedLeg.getHeel(timePoint);
            result.currentHeelInDegrees = heel == null ? null : Double.valueOf(heel.getDegrees());
            Bearing pitch = trackedLeg.getPitch(timePoint);
            result.currentPitchInDegrees = pitch == null ? null : Double.valueOf(pitch.getDegrees());
            Distance distanceFoiled = trackedLeg.getDistanceFoiled(timePoint);
            result.currentDistanceFoiledInMeters = distanceFoiled == null ? null : Double.valueOf(distanceFoiled.getMeters());
            Duration durationFoiled = trackedLeg.getDurationFoiled(timePoint);
            result.currentDurationFoiledInSeconds = durationFoiled == null ? null : Double.valueOf(durationFoiled.asSeconds());
            result.currentSpeedOverGroundInKnots = speedOverGroundInKnots == null ? null : speedOverGroundInKnots;
            Distance distanceTraveled = trackedLeg.getDistanceTraveled(timePoint);
            result.distanceTraveledInMeters = distanceTraveled == null ? null : Double.valueOf(distanceTraveled.getMeters());
            Distance distanceTraveledConsideringGateStart = trackedLeg.getDistanceTraveledConsideringGateStart(timePoint);
            result.distanceTraveledIncludingGateStartInMeters = distanceTraveledConsideringGateStart == null ? null : Double.valueOf(distanceTraveledConsideringGateStart.getMeters());
            Duration estimatedTimeToNextMarkInSeconds = trackedLeg.getEstimatedTimeToNextMark(timePoint, WindPositionMode.EXACT, cache);
            result.estimatedTimeToNextWaypointInSeconds = estimatedTimeToNextMarkInSeconds == null ? null : Double.valueOf(estimatedTimeToNextMarkInSeconds.asSeconds());
            result.timeInMilliseconds = time.asMillis();
            result.finished = hasFinishedLeg;
            TimePoint legFinishTime = trackedLeg.getFinishTime();
            result.correctedTotalTime = trackedLeg.hasStartedLeg(timePoint) ? trackedLeg.getTrackedLeg().getTrackedRace().getRankingMetric().getCorrectedTime(trackedLeg.getCompetitor(), hasFinishedLeg && legFinishTime != null ? legFinishTime : timePoint, cache) : null;
            Duration gapToLeaderInOwnTime = trackedLeg.getTrackedLeg().getTrackedRace().getRankingMetric().getLegGapToLegLeaderInOwnTime(trackedLeg, timePoint, rankingInfo, cache);
            Double d2 = result.gapToLeaderInSeconds = gapToLeaderInOwnTime == null ? null : Double.valueOf(gapToLeaderInOwnTime.asSeconds());
            if (result.gapToLeaderInSeconds != null && (gapAtEndOfPreviousLeg = this.getGapAtEndOfPreviousLeg(trackedLeg, rankingInfo, cache)) != null) {
                result.gapChangeSinceLegStartInSeconds = result.gapToLeaderInSeconds - gapAtEndOfPreviousLeg.asSeconds();
            }
            result.rank = (legRanks = legRanksCache.get(trackedLeg.getLeg())) != null ? legRanks.get(trackedLeg.getCompetitor()).intValue() : trackedLeg.getRank(timePoint, cache);
            result.started = trackedLeg.hasStartedLeg(timePoint);
            Object velocityMadeGood = hasFinishedLeg ? trackedLeg.getAverageVelocityMadeGood(timePoint) : trackedLeg.getVelocityMadeGood(timePoint, WindPositionMode.EXACT, cache);
            result.velocityMadeGoodInKnots = velocityMadeGood == null ? null : Double.valueOf(velocityMadeGood.getKnots());
            Distance windwardDistanceToGo = trackedLeg.getWindwardDistanceToGo(timePoint, WindPositionMode.LEG_MIDDLE);
            result.windwardDistanceToGoInMeters = windwardDistanceToGo == null ? null : Double.valueOf(windwardDistanceToGo.getMeters());
            TimePoint startOfRace = trackedLeg.getTrackedLeg().getTrackedRace().getStartOfRace();
            if (startOfRace != null && trackedLeg.hasStartedLeg(timePoint) && (maneuvers = trackedLeg.getTrackedLeg().getTrackedRace().getManeuvers(trackedLeg.getCompetitor(), startOfRace, timePoint, waitForLatestAnalyses)) != null) {
                result.numberOfManeuvers = new HashMap();
                result.numberOfManeuvers.put(ManeuverType.TACK, 0);
                result.numberOfManeuvers.put(ManeuverType.JIBE, 0);
                result.numberOfManeuvers.put(ManeuverType.PENALTY_CIRCLE, 0);
                HashMap<ManeuverType, Double> totalManeuverLossInMeters = new HashMap<ManeuverType, Double>();
                totalManeuverLossInMeters.put(ManeuverType.TACK, 0.0);
                totalManeuverLossInMeters.put(ManeuverType.JIBE, 0.0);
                totalManeuverLossInMeters.put(ManeuverType.PENALTY_CIRCLE, 0.0);
                TimePoint startOfLeg = trackedLeg.getStartTime();
                for (Maneuver maneuver : maneuvers) {
                    switch (maneuver.getType()) {
                        case TACK: 
                        case JIBE: 
                        case PENALTY_CIRCLE: {
                            if (maneuver.getTimePoint().before(startOfLeg) || legFinishTime != null && !legFinishTime.after(timePoint) && !maneuver.getTimePoint().before(legFinishTime) || maneuver.getManeuverLoss() == null) break;
                            result.numberOfManeuvers.put(maneuver.getType(), (Integer)result.numberOfManeuvers.get(maneuver.getType()) + 1);
                            totalManeuverLossInMeters.put(maneuver.getType(), (Double)totalManeuverLossInMeters.get(maneuver.getType()) + maneuver.getManeuverLoss().getProjectedDistanceLost().getMeters());
                        }
                    }
                    if (!maneuver.isMarkPassing() || maneuver.getMarkPassing().getWaypoint() != trackedLeg.getLeg().getFrom()) continue;
                    result.sideToWhichMarkAtLegStartWasRounded = maneuver.getToSide();
                }
                result.averageManeuverLossInMeters = new HashMap();
                ManeuverType[] maneuverTypeArray = new ManeuverType[]{ManeuverType.TACK, ManeuverType.JIBE, ManeuverType.PENALTY_CIRCLE};
                int n = maneuverTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ManeuverType maneuverType = maneuverTypeArray[n2];
                    if ((Integer)result.numberOfManeuvers.get(maneuverType) != 0) {
                        result.averageManeuverLossInMeters.put(maneuverType, (Double)totalManeuverLossInMeters.get(maneuverType) / (double)((Integer)result.numberOfManeuvers.get(maneuverType)).intValue());
                    }
                    ++n2;
                }
            }
            BiFunction<BiFunction, BiFunction, Double> extractDoubleValue = (currentValueExtractor, averageValueExtractor) -> hasFinishedLeg ? (Double)averageValueExtractor.apply(trackedLeg, timePoint) : (Double)currentValueExtractor.apply(trackedLeg, timePoint);
            result.setExpeditionAWA(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionAWA, TrackedLegOfCompetitor::getAverageExpeditionAWA));
            result.setExpeditionAWS(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionAWS, TrackedLegOfCompetitor::getAverageExpeditionAWS));
            result.setExpeditionTWA(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTWA, TrackedLegOfCompetitor::getAverageExpeditionTWA));
            result.setExpeditionTWS(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTWS, TrackedLegOfCompetitor::getAverageExpeditionTWS));
            result.setExpeditionTWD(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTWD, TrackedLegOfCompetitor::getAverageExpeditionTWD));
            result.setExpeditionTargTWA(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTargTWA, TrackedLegOfCompetitor::getAverageExpeditionTargTWA));
            result.setExpeditionBoatSpeed(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionBoatSpeed, TrackedLegOfCompetitor::getAverageExpeditionBoatSpeed));
            result.setExpeditionTargBoatSpeed(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTargBoatSpeed, TrackedLegOfCompetitor::getAverageExpeditionTargBoatSpeed));
            result.setExpeditionSOG(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionSOG, TrackedLegOfCompetitor::getAverageExpeditionSOG));
            result.setExpeditionCOG(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionCOG, TrackedLegOfCompetitor::getAverageExpeditionCOG));
            result.setExpeditionForestayLoad(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionForestayLoad, TrackedLegOfCompetitor::getAverageExpeditionForestayLoad));
            result.setExpeditionRake(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionRake, TrackedLegOfCompetitor::getAverageExpeditionRake));
            result.setExpeditionCourseDetail(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionCourseDetail, TrackedLegOfCompetitor::getAverageExpeditionCourseDetail));
            result.setExpeditionHeading(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionHeading, TrackedLegOfCompetitor::getAverageExpeditionHeading));
            result.setExpeditionVMG(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionVMG, TrackedLegOfCompetitor::getAverageExpeditionVMG));
            result.setExpeditionVMGTargVMGDelta(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionVMGTargVMGDelta, TrackedLegOfCompetitor::getAverageExpeditionVMGTargVMGDelta));
            result.setExpeditionRateOfTurn(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionRateOfTurn, TrackedLegOfCompetitor::getAverageExpeditionRateOfTurn));
            result.setExpeditionRudderAngle(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionRudderAngle, TrackedLegOfCompetitor::getAverageExpeditionRudderAngle));
            result.setExpeditionTargetHeel(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTargetHeel, TrackedLegOfCompetitor::getAverageExpeditionTargetHeel));
            result.setExpeditionTimeToPortLayline(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToPortLayline, TrackedLegOfCompetitor::getAverageExpeditionTimeToPortLayline));
            result.setExpeditionTimeToStbLayline(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToStbLayline, TrackedLegOfCompetitor::getAverageExpeditionTimeToStbLayline));
            result.setExpeditionDistToPortLayline(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionDistToPortLayline, TrackedLegOfCompetitor::getAverageExpeditionDistToPortLayline));
            result.setExpeditionDistToStbLayline(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionDistToStbLayline, TrackedLegOfCompetitor::getAverageExpeditionDistToStbLayline));
            result.setExpeditionTimeToGunInSeconds(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToGunInSeconds, TrackedLegOfCompetitor::getAverageExpeditionTimeToGunInSeconds));
            result.setExpeditionTimeToCommitteeBoat(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToCommitteeBoat, TrackedLegOfCompetitor::getAverageExpeditionTimeToCommitteeBoat));
            result.setExpeditionTimeToPin(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToPin, TrackedLegOfCompetitor::getAverageExpeditionTimeToPin));
            result.setExpeditionTimeToBurnToLineInSeconds(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToBurnToLineInSeconds, TrackedLegOfCompetitor::getAverageExpeditionTimeToBurnToLineInSeconds));
            result.setExpeditionTimeToBurnToCommitteeBoat(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToBurnToCommitteeBoat, TrackedLegOfCompetitor::getAverageExpeditionTimeToBurnToCommitteeBoat));
            result.setExpeditionTimeToBurnToPin(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionTimeToBurnToPin, TrackedLegOfCompetitor::getAverageExpeditionTimeToBurnToPin));
            result.setExpeditionDistanceToCommitteeBoat(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionDistanceToCommitteeBoat, TrackedLegOfCompetitor::getAverageExpeditionDistanceToCommitteeBoat));
            result.setExpeditionDistanceToPinDetail(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionDistanceToPinDetail, TrackedLegOfCompetitor::getAverageExpeditionDistanceToPinDetail));
            result.setExpeditionDistanceBelowLineInMeters(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionDistanceBelowLineInMeters, TrackedLegOfCompetitor::getAverageExpeditionDistanceBelowLineInMeters));
            result.setExpeditionLineSquareForWindDirection(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionLineSquareForWindDirection, TrackedLegOfCompetitor::getAverageExpeditionLineSquareForWindDirection));
            result.setExpeditionBaroIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionBaroIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionBaroIfAvailable));
            result.setExpeditionLoadSIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionLoadSIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionLoadSIfAvailable));
            result.setExpeditionLoadPIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionLoadPIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionLoadPIfAvailable));
            result.setExpeditionJibCarPortIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionJibCarPortIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionJibCarPortIfAvailable));
            result.setExpeditionJibCarStbdIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionJibCarStbdIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionJibCarStbdIfAvailable));
            result.setExpeditionMastButtIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionMastButtIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionMastButtIfAvailable));
            result.setExpeditionKickerTensionIfAvailable(extractDoubleValue.apply(TrackedLegOfCompetitor::getExpeditionKickerTensionIfAvailable, TrackedLegOfCompetitor::getAverageExpeditionKickerTensionIfAvailable));
        }
        return result;
    }

    private Duration getGapAtEndOfPreviousLeg(TrackedLegOfCompetitor trackedLeg, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        Course course = trackedLeg.getTrackedLeg().getTrackedRace().getRace().getCourse();
        TimePoint timePoint = trackedLeg.getStartTime();
        if (course.getFirstWaypoint() == trackedLeg.getLeg().getFrom()) {
            result = Duration.NULL;
        } else {
            TrackedLegOfCompetitor tloc = trackedLeg.getTrackedLeg().getTrackedRace().getTrackedLegFinishingAt(trackedLeg.getLeg().getFrom()).getTrackedLeg(trackedLeg.getCompetitor());
            result = trackedLeg.getTrackedLeg().getTrackedRace().getRankingMetric().getLegGapToLegLeaderInOwnTime(tloc, timePoint, rankingInfo, cache);
        }
        return result;
    }

    @Override
    public int getTotalRankOfCompetitor(Competitor competitor, TimePoint timePoint) {
        return Util.indexOf(this.getCompetitorsFromBestToWorst(timePoint), (Object)competitor) + 1;
    }

    protected void regattaLogEventAdded(RegattaLogEvent event) {
        this.invalidateCacheIfEventSaysSo((AbstractLogEvent<?>)event);
    }

    protected void raceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        this.invalidateCacheIfEventSaysSo((AbstractLogEvent<?>)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCacheIfEventSaysSo(AbstractLogEvent<?> event) {
        if (event instanceof InvalidatesLeaderboardCache) {
            if (this.leaderboardDTOCache != null) {
                this.leaderboardDTOCache.invalidate(this);
            }
            Map<Util.Pair<TrackedRace, Competitor>, RunnableFuture<RaceDetails>> map = this.raceDetailsAtEndOfTrackingCache;
            synchronized (map) {
                this.raceDetailsAtEndOfTrackingCache.clear();
            }
        }
    }

    private Date getTimePointOfLastFixAtOrBefore(Competitor competitor, TrackedRace trackedRace, TimePoint atOrBefore) {
        GPSFixMoving lastFix;
        assert (trackedRace != null);
        GPSFixTrack<Competitor, GPSFixMoving> track = trackedRace.getTrack(competitor);
        Date timePointOfLastPositionFix = track == null ? null : ((lastFix = (GPSFixMoving)track.getLastFixAtOrBefore(atOrBefore)) == null ? null : lastFix.getTimePoint().asDate());
        return timePointOfLastPositionFix;
    }

    @Override
    public Duration getTotalTimeSailedInLegType(Competitor competitor, LegType legType, TimePoint timePoint) throws NoWindException {
        return this.getTotalTimeSailedInLegType(competitor, legType, timePoint, new HashMap<TrackedLeg, LegType>());
    }

    /*
     * Loose catch block
     */
    private Duration getTotalTimeSailedInLegType(Competitor competitor, LegType legType, TimePoint timePoint, Map<TrackedLeg, LegType> legTypeCache) throws NoWindException {
        Duration result = null;
        block7: for (TrackedRace trackedRace : this.getTrackedRaces()) {
            if (!Util.contains(trackedRace.getRace().getCompetitors(), (Object)competitor)) continue;
            trackedRace.getRace().getCourse().lockForRead();
            try {
                for (Leg leg : trackedRace.getRace().getCourse().getLegs()) {
                    TrackedLegOfCompetitor trackedLegOfCompetitor = trackedRace.getTrackedLeg(competitor, leg);
                    if (!trackedLegOfCompetitor.hasStartedLeg(timePoint)) continue;
                    try {
                        TrackedLeg trackedLeg = trackedRace.getTrackedLeg(leg);
                        LegType trackedLegType = legTypeCache.get(trackedLeg);
                        if (trackedLegType == null) {
                            TimePoint startTime = trackedLegOfCompetitor.getStartTime();
                            TimePoint finishTime = trackedLegOfCompetitor.getFinishTime();
                            if (finishTime == null) {
                                finishTime = timePoint;
                            }
                            trackedLegType = trackedLeg.getLegType(startTime.plus(startTime.until(finishTime).divide(2L)));
                            legTypeCache.put(trackedLeg, trackedLegType);
                        }
                        if (legType != trackedLegType) continue;
                        Duration timeSpentInLegOfType = trackedLegOfCompetitor.getTime(timePoint);
                        if (timeSpentInLegOfType != null) {
                            if (result == null) {
                                result = timeSpentInLegOfType;
                                continue;
                            }
                            result = result.plus(timeSpentInLegOfType);
                            continue;
                        }
                        result = null;
                    }
                    catch (NoWindException nwe) {
                        result = null;
                        trackedRace.getRace().getCourse().unlockAfterRead();
                    }
                    break block7;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                trackedRace.getRace().getCourse().unlockAfterRead();
            }
        }
        return result;
    }

    @Override
    public Duration getTotalTimeSailed(Competitor competitor, TimePoint timePoint) {
        Duration result = null;
        for (TrackedRace trackedRace : this.getTrackedRaces()) {
            Duration timeSpent;
            if (!Util.contains(trackedRace.getRace().getCompetitors(), (Object)competitor) || (timeSpent = trackedRace.getTimeSailedSinceRaceStart(competitor, timePoint)) == null) continue;
            result = result == null ? timeSpent : result.plus(timeSpent);
        }
        return result;
    }

    @Override
    public Distance getTotalDistanceTraveled(Competitor competitor, TimePoint timePoint) {
        return this.getTotals(competitor, timePoint, Distance::add, TrackedRace::getDistanceTraveled);
    }

    @Override
    public Distance getTotalDistanceFoiled(Competitor competitor, TimePoint timePoint) {
        return this.getTotals(competitor, timePoint, Distance::add, TrackedRace::getDistanceFoiled);
    }

    @Override
    public Duration getTotalDurationFoiled(Competitor competitor, TimePoint timePoint) {
        return this.getTotals(competitor, timePoint, Duration::plus, TrackedRace::getDurationFoiled);
    }

    private <T> T getTotals(Competitor competitor, TimePoint timePoint, BiFunction<T, T, T> adder, ValueFromRaceGetter<T> valueGetter) {
        Object result = null;
        for (TrackedRace trackedRace : this.getTrackedRaces()) {
            TimePoint startOfRace;
            if (!Util.contains(trackedRace.getRace().getCompetitors(), (Object)competitor) || (startOfRace = trackedRace.getStartOfRace()) == null || startOfRace.after(timePoint)) continue;
            T distanceSailedInRace = valueGetter.get(trackedRace, competitor, timePoint);
            if (distanceSailedInRace != null) {
                if (result == null) {
                    result = distanceSailedInRace;
                    continue;
                }
                result = adder.apply(result, distanceSailedInRace);
                continue;
            }
            return null;
        }
        return result;
    }

    @Override
    public Iterable<Competitor> getAllCompetitors() {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered().getB();
    }

    @Override
    public void destroy() {
        for (CacheInvalidationListener cacheInvalidationListener : this.cacheInvalidationListeners) {
            cacheInvalidationListener.removeFromTrackedRace();
        }
    }

    @Override
    public boolean hasScores(Competitor competitor, TimePoint timePoint) {
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            if (this.getTotalPoints(competitor, raceColumn, timePoint) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ScoreCorrectionMapping mapRegattaScoreCorrections(RegattaScoreCorrections regattaScoreCorrections, Map<String, RaceColumn> raceNumberOrNameToRaceColumnMap, Map<String, Competitor> sailIdToCompetitorMap, boolean allowRaceDefaultsByOrder, boolean allowPartialImport) {
        SailNumberCanonicalizerAndMatcher sailNumberCanonicalizer = new SailNumberCanonicalizerAndMatcher();
        Map competitorsByTheirCanonicalizedSailNumber = sailNumberCanonicalizer.canonicalizeLeaderboardSailIDs(this.getAllCompetitors());
        HashMap<String, RaceColumn> raceMappings = new HashMap<String, RaceColumn>(raceNumberOrNameToRaceColumnMap);
        HashMap<String, Competitor> competitorMappings = new HashMap<String, Competitor>(sailIdToCompetitorMap);
        Iterator<RaceColumn> raceColumnIterator = this.getRaceColumns().iterator();
        for (RegattaScoreCorrections.ScoreCorrectionsForRace raceCorrection : regattaScoreCorrections.getScoreCorrectionsForRaces()) {
            RaceColumn currentRaceColumn = raceColumnIterator.hasNext() ? raceColumnIterator.next() : null;
            raceMappings.putIfAbsent(raceCorrection.getRaceNameOrNumber(), allowRaceDefaultsByOrder ? currentRaceColumn : null);
            for (String sailIdOrShortName : raceCorrection.getSailIDs()) {
                competitorMappings.putIfAbsent(sailIdOrShortName, (Competitor)competitorsByTheirCanonicalizedSailNumber.get(sailNumberCanonicalizer.canonicalizeSailID(sailIdOrShortName, null)));
            }
        }
        return new ScoreCorrectionMappingImpl(raceMappings, competitorMappings, regattaScoreCorrections);
    }

    private class CacheInvalidationListener
    extends AbstractRaceChangeListener {
        private final TrackedRace trackedRace;
        private final Competitor competitor;

        public CacheInvalidationListener(TrackedRace trackedRace, Competitor competitor) {
            this.trackedRace = trackedRace;
            this.competitor = competitor;
        }

        public TrackedRace getTrackedRace() {
            return this.trackedRace;
        }

        public void removeFromTrackedRace() {
            this.trackedRace.removeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidateCacheAndRemoveThisListenerFromTrackedRace() {
            Map map = AbstractLeaderboardWithCache.this.raceDetailsAtEndOfTrackingCache;
            synchronized (map) {
                AbstractLeaderboardWithCache.this.raceDetailsAtEndOfTrackingCache.remove(new Util.Pair((Object)this.trackedRace, (Object)this.competitor));
                this.removeFromTrackedRace();
            }
        }

        @Override
        protected void defaultAction() {
            this.invalidateCacheAndRemoveThisListenerFromTrackedRace();
        }
    }

    private static class RaceDetails {
        private final List<LegEntryDTO> legDetails;
        private final Distance windwardDistanceToCompetitorFarthestAhead;
        private final Distance averageAbsoluteCrossTrackError;
        private final Distance averageSignedCrossTrackError;
        private final Duration gapToLeaderInOwnTime;
        private final Double percentTargetBoatSpeed;
        private final Duration timeSailedSinceRaceStart;
        private final Duration correctedTime;
        private final Duration correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;

        public RaceDetails(List<LegEntryDTO> legDetails, Distance windwardDistanceToCompetitorFarthestAhead, Distance averageAbsoluteCrossTrackError, Distance averageSignedCrossTrackError, Duration gapToLeaderInOwnTime, Double percentTargetBoatSpeed, Duration timeSailedSinceRaceStart, Duration correctedTime, Duration correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead) {
            this.legDetails = legDetails;
            this.windwardDistanceToCompetitorFarthestAhead = windwardDistanceToCompetitorFarthestAhead;
            this.averageAbsoluteCrossTrackError = averageAbsoluteCrossTrackError;
            this.averageSignedCrossTrackError = averageSignedCrossTrackError;
            this.gapToLeaderInOwnTime = gapToLeaderInOwnTime;
            this.percentTargetBoatSpeed = percentTargetBoatSpeed;
            this.correctedTime = correctedTime;
            this.timeSailedSinceRaceStart = timeSailedSinceRaceStart;
            this.correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead = correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;
        }

        public List<LegEntryDTO> getLegDetails() {
            return this.legDetails;
        }

        public Distance getWindwardDistanceToCompetitorFarthestAhead() {
            return this.windwardDistanceToCompetitorFarthestAhead;
        }

        public Distance getAverageAbsoluteCrossTrackError() {
            return this.averageAbsoluteCrossTrackError;
        }

        public Distance getAverageSignedCrossTrackError() {
            return this.averageSignedCrossTrackError;
        }

        public Duration getGapToLeaderInOwnTime() {
            return this.gapToLeaderInOwnTime;
        }

        public Duration getTimeSailedSinceRaceStart() {
            return this.timeSailedSinceRaceStart;
        }

        public Duration getCorrectedTime() {
            return this.correctedTime;
        }

        public Duration getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead() {
            return this.correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;
        }

        public Double getPercentTargetBoatSpeed() {
            return this.percentTargetBoatSpeed;
        }
    }

    @FunctionalInterface
    private static interface ValueFromRaceGetter<T> {
        public T get(TrackedRace var1, Competitor var2, TimePoint var3);
    }
}

