/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AdditionalScoringInformationFinder;
import com.sap.sailing.domain.abstractlog.race.scoring.AdditionalScoringInformationType;
import com.sap.sailing.domain.abstractlog.race.scoring.RaceLogAdditionalScoringInformationEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.HighPointFirstGetsFixedScore;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;

public abstract class AbstractHighPointFirstGetsFixedOr8AndLastBreaksTie
extends HighPointFirstGetsFixedScore {
    private static final long serialVersionUID = 1L;
    private final double SCORE_FOR_WINNER_IF_OVERWRITTEN = 8.0;
    private static final int MIN_RACES_REQUIRED_TO_BE_SCORED = 3;

    public AbstractHighPointFirstGetsFixedOr8AndLastBreaksTie(double maxPoints) {
        super(maxPoints);
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double o1Highest = this.getHighestScore(o1Scores);
        Double o2Highest = this.getHighestScore(o2Scores);
        return o2Highest.compareTo(o1Highest);
    }

    private double getHighestScore(List<Util.Pair<RaceColumn, Double>> scores) {
        double highestScore = 0.0;
        for (Util.Pair<RaceColumn, Double> score : scores) {
            double scoreScaledByFactor = this.getScoreScaledByFactor((RaceColumn)score.getA(), (Double)score.getB());
            if (!(scoreScaledByFactor > highestScore)) continue;
            highestScore = scoreScaledByFactor;
        }
        return highestScore;
    }

    @Override
    public int compareByNumberOfRacesScored(int competitor1NumberOfRacesScored, int competitor2NumberOfRacesScored) {
        int result = competitor1NumberOfRacesScored >= 3 ? (competitor2NumberOfRacesScored >= 3 ? 0 : -1) : (competitor2NumberOfRacesScored >= 3 ? 1 : 0);
        return result;
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        Double effectiveScore = super.getScoreForRank(leaderboard, raceColumn, competitor, rank, numberOfCompetitorsInRaceFetcher, numberOfCompetitorsInLeaderboardFetcher, timePoint);
        return this.checkForOverwrittenScore(raceColumn, rank, effectiveScore);
    }

    private Double checkForOverwrittenScore(RaceColumn raceColumn, int rank, Double effectiveScore) {
        Double result = effectiveScore;
        for (Fleet fleet : raceColumn.getFleets()) {
            RaceLog raceLog = raceColumn.getRaceLog(fleet);
            AdditionalScoringInformationFinder finder = new AdditionalScoringInformationFinder(raceLog);
            RaceLogAdditionalScoringInformationEvent event = finder.analyze(AdditionalScoringInformationType.MAX_POINTS_DECREASE_MAX_SCORE);
            if (event == null) continue;
            result = rank == 0 ? null : Double.valueOf(Math.max(this.getMinimumScoreFromRank(), 8.0 - (double)rank + 1.0));
        }
        return result;
    }
}

