/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.caching;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardCacheManager;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardCache;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.util.impl.FutureTaskWithTracingGet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;

public class LeaderboardDTOCache
implements LeaderboardCache {
    private static final Logger logger = Logger.getLogger(LeaderboardDTOCache.class.getName());
    private final Map<Util.Triple<TimePoint, Collection<String>, Boolean>, FutureTask<LeaderboardDTO>> leaderboardCache;
    private final NamedReentrantReadWriteLock leaderboardCacheLock;
    private int leaderboardByNameCacheHitCount;
    private int leaderboardByNameCacheMissCount;
    private final boolean waitForLatestAnalyses;
    private final LeaderboardCacheManager leaderboardCacheManager;
    private final Leaderboard leaderboard;

    public LeaderboardDTOCache(boolean waitForLatestAnalyses, Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
        this.waitForLatestAnalyses = waitForLatestAnalyses;
        this.leaderboardCache = new LinkedHashMap<Util.Triple<TimePoint, Collection<String>, Boolean>, FutureTask<LeaderboardDTO>>(16, 0.75f){
            private static final long serialVersionUID = 7287916997229815039L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Util.Triple<TimePoint, Collection<String>, Boolean>, FutureTask<LeaderboardDTO>> e) {
                return this.size() > 10;
            }
        };
        this.leaderboardCacheLock = new NamedReentrantReadWriteLock("leaderboardCacheLock for " + leaderboard.getName(), false);
        this.leaderboardCacheManager = new LeaderboardCacheManager(this);
    }

    @Override
    public void invalidate(Leaderboard leaderboard) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
        try {
            this.leaderboardCache.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
        }
    }

    @Override
    public void add(Leaderboard leaderboard) {
    }

    public LeaderboardDTO getLeaderboardByName(TimePoint timePoint, final Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, final boolean addOverallDetails, final DomainFactory baseDomainFactory, final TrackedRegattaRegistry trackedRegattaRegistry) throws NoWindException, InterruptedException, ExecutionException {
        TimePoint adjustedTimePoint;
        long startOfRequestHandling = System.currentTimeMillis();
        TimePoint timePointOfLastModification = this.leaderboard.getTimePointOfLatestModification();
        if (timePointOfLastModification != null && timePoint.after(timePointOfLastModification)) {
            adjustedTimePoint = timePointOfLastModification;
            logger.fine("Adjusted time point in getLeaderboardByName from " + timePoint + " to " + adjustedTimePoint);
        } else {
            adjustedTimePoint = timePoint;
        }
        Util.Triple key = new Util.Triple((Object)adjustedTimePoint, namesOfRaceColumnsForWhichToLoadLegDetails, (Object)addOverallDetails);
        FutureTaskWithTracingGet future = null;
        boolean cacheHit = false;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
        try {
            future = this.leaderboardCache.get(key);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
        }
        if (future == null) {
            future = new FutureTaskWithTracingGet(String.valueOf(LeaderboardDTOCache.class.getName()) + " for leaderboard " + this.leaderboard.getName(), (Callable)new Callable<LeaderboardDTO>(){

                @Override
                public LeaderboardDTO call() throws Exception {
                    LeaderboardDTO result = LeaderboardDTOCache.this.leaderboard.computeDTO(adjustedTimePoint, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, LeaderboardDTOCache.this.waitForLatestAnalyses, trackedRegattaRegistry, baseDomainFactory, false);
                    return result;
                }
            });
            this.leaderboardCacheManager.add(this.leaderboard);
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
            try {
                this.leaderboardCache.put((Util.Triple<TimePoint, Collection<String>, Boolean>)key, (FutureTask<LeaderboardDTO>)future);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardCacheLock);
            }
            future.run();
        } else {
            cacheHit = true;
        }
        if (cacheHit) {
            ++this.leaderboardByNameCacheHitCount;
            logger.info("Cache hit in getLeaderboardByName(" + this.leaderboard.getName() + ", " + adjustedTimePoint + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ")");
        } else {
            ++this.leaderboardByNameCacheMissCount;
        }
        logger.info("getLeaderboardByName cache hit vs. miss: " + this.leaderboardByNameCacheHitCount + "/" + this.leaderboardByNameCacheMissCount);
        LeaderboardDTO result = (LeaderboardDTO)future.get();
        logger.fine("getLeaderboardByName(" + this.leaderboard.getName() + ", " + adjustedTimePoint + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ") took " + (System.currentTimeMillis() - startOfRequestHandling) + "ms");
        return result;
    }
}

