/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class DouglasPeucker<ItemType, FixType extends GPSFix> {
    private final GPSFixTrack<ItemType, FixType> track;
    private final ScheduledExecutorService executor;

    public DouglasPeucker(GPSFixTrack<ItemType, FixType> track) {
        this.track = track;
        this.executor = null;
    }

    public DouglasPeucker(GPSFixTrack<ItemType, FixType> track, ScheduledExecutorService executor) {
        this.track = track;
        this.executor = executor;
    }

    private Util.Pair<GPSFix, Distance> getFixWithGreatestCrossTrackErrorInInterval(TimePoint from, TimePoint to) {
        Distance.NullDistance maxDistance = Distance.NULL;
        GPSFix firstFixAtOrAfter = (GPSFix)this.track.getFirstFixAtOrAfter(from);
        Util.Pair result = null;
        if (firstFixAtOrAfter != null) {
            Position fromPosition = firstFixAtOrAfter.getPosition();
            GPSFix toFix = (GPSFix)this.track.getLastFixAtOrBefore(to);
            if (toFix != null) {
                Bearing bearing = fromPosition.getBearingGreatCircle(toFix.getPosition());
                this.track.lockForRead();
                try {
                    Iterator fixIter = this.track.getFixesIterator(from, false);
                    if (this.executor != null) {
                        result = this.getFixWithGreatestCrossTrackErrorUsingExecutor(to, (Distance)maxDistance, fromPosition, bearing, fixIter);
                    } else {
                        GPSFix fixFurthestAway = null;
                        while (fixIter.hasNext()) {
                            GPSFix fix = (GPSFix)fixIter.next();
                            if (fix.getTimePoint().compareTo((Object)to) > 0) break;
                            Distance crossTrackError = fix.getPosition().absoluteCrossTrackError(fromPosition, bearing);
                            if (crossTrackError.compareTo((Object)maxDistance) <= 0) continue;
                            maxDistance = crossTrackError;
                            fixFurthestAway = fix;
                        }
                        result = new Util.Pair(fixFurthestAway, (Object)maxDistance);
                    }
                }
                finally {
                    this.track.unlockAfterRead();
                }
            }
        }
        return result;
    }

    private Util.Pair<GPSFix, Distance> getFixWithGreatestCrossTrackErrorUsingExecutor(TimePoint to, Distance maxDistance, Position fromPosition, Bearing bearing, Iterator<FixType> fixIter) {
        GPSFix fixFurthestAway = null;
        HashSet<Future<Util.Pair>> crossTrackErrorFutures = new HashSet<Future<Util.Pair>>();
        while (fixIter.hasNext()) {
            GPSFix gPSFix = (GPSFix)fixIter.next();
            if (gPSFix.getTimePoint().compareTo((Object)to) > 0) break;
            Future<Util.Pair> crossTrackErrorFuture = this.executor.submit(() -> new Util.Pair((Object)fix, (Object)fix.getPosition().absoluteCrossTrackError(fromPosition, bearing)));
            crossTrackErrorFutures.add(crossTrackErrorFuture);
        }
        for (Future future : crossTrackErrorFutures) {
            Util.Pair fixAndCrossTrackError;
            try {
                fixAndCrossTrackError = (Util.Pair)future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (((Distance)fixAndCrossTrackError.getB()).compareTo((Object)maxDistance) <= 0) continue;
            maxDistance = (Distance)fixAndCrossTrackError.getB();
            fixFurthestAway = (GPSFix)fixAndCrossTrackError.getA();
        }
        Util.Pair result = new Util.Pair(fixFurthestAway, (Object)maxDistance);
        return result;
    }

    public List<FixType> approximate(Distance maxDistance, TimePoint from, TimePoint to) {
        List<FixType> resultWithoutFirstFix = this.approximateWithoutFirst(maxDistance, from, to);
        ArrayList<GPSFix> result = new ArrayList<GPSFix>(resultWithoutFirstFix.size() + 1);
        GPSFix firstFixAtOrAfter = (GPSFix)this.track.getFirstFixAtOrAfter(from);
        if (firstFixAtOrAfter != null) {
            result.add(firstFixAtOrAfter);
        }
        for (GPSFix f : resultWithoutFirstFix) {
            result.add(f);
        }
        return result;
    }

    private List<FixType> approximateWithoutFirst(Distance maxDistance, TimePoint from, TimePoint to) {
        List<Object> result;
        Util.Pair<GPSFix, Distance> fixAndDistance = this.getFixWithGreatestCrossTrackErrorInInterval(from, to);
        if (fixAndDistance == null || ((Distance)fixAndDistance.getB()).compareTo((Object)maxDistance) < 0) {
            GPSFix lastFixAtOrBefore = (GPSFix)this.track.getLastFixAtOrBefore(to);
            result = lastFixAtOrBefore == null || lastFixAtOrBefore.getTimePoint().compareTo((Object)from) < 0 ? Collections.emptyList() : Collections.singletonList(lastFixAtOrBefore);
        } else {
            List<FixType> left = this.approximateWithoutFirst(maxDistance, from, ((GPSFix)fixAndDistance.getA()).getTimePoint());
            List<FixType> right = this.approximateWithoutFirst(maxDistance, ((GPSFix)fixAndDistance.getA()).getTimePoint(), to);
            result = new ArrayList(left.size() + right.size());
            for (GPSFix fixFromLeft : left) {
                result.add(fixFromLeft);
            }
            for (GPSFix fixFromRight : right) {
                result.add(fixFromRight);
            }
        }
        return result;
    }
}

