/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.swisstimingadapter.Competitor;
import com.sap.sailing.domain.swisstimingadapter.CrewMember;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapter;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.impl.CompetitorWithID;
import com.sap.sailing.domain.swisstimingadapter.impl.CrewMemberImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.DomainFactoryImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.StartListImpl;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Crew;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.Person;
import com.sap.sailing.xrr.schema.RaceResult;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sailing.xrr.schema.Team;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SwissTimingAdapterImpl
implements SwissTimingAdapter {
    private final SwissTimingFactory swissTimingFactory = SwissTimingFactory.INSTANCE;
    private final DomainFactory swissTimingDomainFactory;
    private final long DEFAULT_SWISSTIMING_LIVE_DELAY_IN_MILLISECONDS = 6000L;

    public SwissTimingAdapterImpl(com.sap.sailing.domain.base.DomainFactory baseDomainFactory) {
        this.swissTimingDomainFactory = new DomainFactoryImpl(baseDomainFactory);
    }

    @Override
    public DomainFactory getSwissTimingDomainFactory() {
        return this.swissTimingDomainFactory;
    }

    @Override
    public SwissTimingFactory getSwissTimingFactory() {
        return this.swissTimingFactory;
    }

    @Override
    public RaceHandle addSwissTimingRace(TrackerManager trackerManager, RegattaIdentifier regattaToAddTo, String raceID, String raceName, String raceDescription, BoatClass boatClass, String hostname, int port, StartList startList, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, long timeoutInMilliseconds, boolean useInternalMarkPassingAlgorithm, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, String updateURL, String updateUsername, String updatePassword, String eventName, String manage2SailEventUrl) throws Exception {
        return trackerManager.addRace(regattaToAddTo, this.swissTimingDomainFactory.createTrackingConnectivityParameters(hostname, port, raceID, raceName, raceDescription, boatClass, startList, 6000L, this.swissTimingFactory, this.swissTimingDomainFactory, raceLogStore, regattaLogStore, useInternalMarkPassingAlgorithm, trackWind, correctWindDirectionByMagneticDeclination, updateURL, updateUsername, updatePassword, eventName, manage2SailEventUrl), timeoutInMilliseconds);
    }

    @Override
    public StartList readStartListForRace(String raceId, RegattaResults regattaResults) {
        StartListImpl result = null;
        ArrayList<Competitor> competitors = new ArrayList<Competitor>();
        HashMap<String, Person> persons = new HashMap<String, Person>();
        HashMap<String, Boat> boats = new HashMap<String, Boat>();
        HashMap<String, Team> teams = new HashMap<String, Team>();
        for (Object o : regattaResults.getPersonOrBoatOrTeam()) {
            if (o instanceof Person) {
                Person p = (Person)o;
                persons.put(p.getPersonID(), p);
                continue;
            }
            if (o instanceof Boat) {
                Boat b = (Boat)o;
                boats.put(b.getBoatID(), b);
                continue;
            }
            if (!(o instanceof Team)) continue;
            Team t = (Team)o;
            teams.put(t.getTeamID(), t);
        }
        for (Object o : regattaResults.getPersonOrBoatOrTeam()) {
            if (!(o instanceof Event)) continue;
            Event event = (Event)o;
            for (Object eventO : event.getRaceOrDivisionOrRegattaSeriesResult()) {
                if (!(eventO instanceof Division)) continue;
                Division division = (Division)eventO;
                for (Object seriesResultOrRaceResultOrTRResult : division.getSeriesResultOrRaceResultOrTRResult()) {
                    Boat boat;
                    Team team;
                    RaceResult raceResult;
                    if (!(seriesResultOrRaceResultOrTRResult instanceof RaceResult) || !(raceResult = (RaceResult)seriesResultOrRaceResultOrTRResult).getRaceID().equals(raceId) || (team = (Team)teams.get(raceResult.getTeamID())) == null || (boat = (Boat)boats.get(team.getBoatID())) == null) continue;
                    ArrayList<CrewMember> crew = new ArrayList<CrewMember>();
                    for (Crew crewMember : team.getCrew()) {
                        Person person = (Person)persons.get(crewMember.getPersonID());
                        crew.add(new CrewMemberImpl(String.valueOf(person.getGivenName()) + " " + person.getFamilyName(), person.getNOC() == null ? null : person.getNOC().name(), crewMember.getPosition().name()));
                    }
                    String nationality = team.getNOC() == null ? null : team.getNOC().name();
                    CompetitorWithID competitor = new CompetitorWithID(team.getTeamID(), boat.getSailNumber(), nationality, team.getTeamName(), crew);
                    competitors.add(competitor);
                }
            }
        }
        if (!competitors.isEmpty()) {
            result = new StartListImpl(raceId, competitors);
        }
        return result;
    }

    @Override
    public RegattaResults readRegattaEntryListFromXrrUrl(String xrrEntryListUrl) throws IOException, JAXBException, SAXException, ParserConfigurationException {
        URL regattaEntryListUrl = new URL(xrrEntryListUrl);
        URLConnection regattaEntryListConn = HttpUrlConnectionHelper.redirectConnection((URL)regattaEntryListUrl);
        RegattaResults regattaResults = ParserFactory.INSTANCE.createParser((InputStream)regattaEntryListConn.getContent(), xrrEntryListUrl).parse();
        return regattaResults;
    }
}

