/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.Arrays;
import smile.math.Histogram;
import smile.math.Math;
import smile.sort.QuickSort;

public class GroupKFold {
    public final int k;
    public final int[][] train;
    public final int[][] test;

    public GroupKFold(int n, int k, int[] groups) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0) {
            throw new IllegalArgumentException("Invalid number of folds: " + k);
        }
        if (groups.length != n) {
            throw new IllegalArgumentException("Groups array must be of size n, but length is " + groups.length);
        }
        int[] uniqueGroups = Math.unique((int[])groups);
        int numGroups = uniqueGroups.length;
        if (k > numGroups) {
            throw new IllegalArgumentException("Number of splits mustn't be greater than number of groups");
        }
        Arrays.sort(uniqueGroups);
        for (int i = 0; i < numGroups; ++i) {
            if (uniqueGroups[i] == i) continue;
            throw new IllegalArgumentException("Invalid encoding of groups, all group indices between [0, numGroups) have to exist");
        }
        this.k = k;
        this.train = new int[k][];
        this.test = new int[k][];
        TestFolds testFolds = this.calculateTestFolds(groups, numGroups);
        for (int i = 0; i < k; ++i) {
            this.train[i] = new int[n - testFolds.numTestSamplesPerFold[i]];
            this.test[i] = new int[testFolds.numTestSamplesPerFold[i]];
            int trainIndex = 0;
            int testIndex = 0;
            for (int j = 0; j < n; ++j) {
                if (testFolds.groupToTestFoldIndex[groups[j]] == i) {
                    this.test[i][testIndex++] = j;
                    continue;
                }
                this.train[i][trainIndex++] = j;
            }
        }
    }

    private TestFolds calculateTestFolds(int[] groups, int numGroups) {
        int[] numSamplesPerGroup = Arrays.stream(Histogram.histogram((int[])groups, (int)numGroups)[2]).mapToInt(x -> (int)x).toArray();
        int[] toOriginalGroupIndex = QuickSort.sort((int[])numSamplesPerGroup);
        int[] numTestSamplesPerFold = new int[this.k];
        int[] groupToTestFoldIndex = new int[numGroups];
        for (int i = numGroups - 1; i >= 0; --i) {
            int smallestFoldIndex;
            int n = smallestFoldIndex = Math.whichMin((int[])numTestSamplesPerFold);
            numTestSamplesPerFold[n] = numTestSamplesPerFold[n] + numSamplesPerGroup[i];
            groupToTestFoldIndex[toOriginalGroupIndex[i]] = smallestFoldIndex;
        }
        return new TestFolds(numTestSamplesPerFold, groupToTestFoldIndex);
    }

    private class TestFolds {
        private final int[] numTestSamplesPerFold;
        private final int[] groupToTestFoldIndex;

        private TestFolds(int[] numTestSamplesPerFold, int[] groupToTestFoldIndex) {
            this.numTestSamplesPerFold = numTestSamplesPerFold;
            this.groupToTestFoldIndex = groupToTestFoldIndex;
        }
    }
}

