/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.classification.ClassifierTrainer;
import smile.classification.OnlineClassifier;
import smile.classification.PlattScaling;
import smile.classification.SVM;
import smile.classification.SoftClassifier;
import smile.math.DoubleArrayList;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;
import smile.util.MulticoreExecutor;

public class SVM<T>
implements OnlineClassifier<T>,
SoftClassifier<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SVM.class);
    private static final double TAU = 1.0E-12;
    private LASVM svm;
    private List<LASVM> svms;
    private MercerKernel<T> kernel;
    private int p;
    private int k;
    private Multiclass strategy = Multiclass.ONE_VS_ONE;
    private double[] wi;
    private double tol = 0.001;

    public SVM(MercerKernel<T> kernel, double C) {
        this(kernel, C, C);
    }

    public SVM(MercerKernel<T> kernel, double Cp, double Cn) {
        if (Cp < 0.0) {
            throw new IllegalArgumentException("Invalid postive instance soft margin penalty: " + Cp);
        }
        if (Cn < 0.0) {
            throw new IllegalArgumentException("Invalid negative instance soft margin penalty: " + Cn);
        }
        this.kernel = kernel;
        this.k = 2;
        this.svm = new LASVM(Cp, Cn);
    }

    public SVM(MercerKernel<T> kernel, double C, int k, Multiclass strategy) {
        if (C < 0.0) {
            throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
        }
        if (k < 3) {
            throw new IllegalArgumentException("Invalid number of classes: " + k);
        }
        this.kernel = kernel;
        this.k = k;
        this.strategy = strategy;
        if (strategy == Multiclass.ONE_VS_ALL) {
            this.svms = new ArrayList<LASVM>(k);
            for (int i = 0; i < k; ++i) {
                this.svms.add(new LASVM(C, C));
            }
        } else {
            this.svms = new ArrayList<LASVM>(k * (k - 1) / 2);
            for (int i = 0; i < k; ++i) {
                for (int j = i + 1; j < k; ++j) {
                    this.svms.add(new LASVM(C, C));
                }
            }
        }
    }

    public SVM(MercerKernel<T> kernel, double C, double[] weight, Multiclass strategy) {
        int i;
        if (C < 0.0) {
            throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
        }
        if (weight.length < 3) {
            throw new IllegalArgumentException("Invalid number of classes: " + weight.length);
        }
        for (i = 0; i < weight.length; ++i) {
            if (!(weight[i] <= 0.0)) continue;
            throw new IllegalArgumentException("Invalid class weight: " + weight[i]);
        }
        this.kernel = kernel;
        this.k = weight.length;
        this.strategy = strategy;
        this.wi = weight;
        if (strategy == Multiclass.ONE_VS_ALL) {
            this.svms = new ArrayList<LASVM>(this.k);
            for (i = 0; i < this.k; ++i) {
                this.svms.add(new LASVM(C, C));
            }
        } else {
            this.svms = new ArrayList<LASVM>(this.k * (this.k - 1) / 2);
            for (i = 0; i < this.k; ++i) {
                for (int j = i + 1; j < this.k; ++j) {
                    this.svms.add(new LASVM(weight[i] * C, weight[j] * C));
                }
            }
        }
    }

    public SVM<T> setTolerance(double tol) {
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance of convergence test:" + tol);
        }
        this.tol = tol;
        return this;
    }

    public List<SupportVector> getSupportVectors() {
        if (this.svm == null || this.svm.sv == null) {
            throw new UnsupportedOperationException("getSupportVectors is only applicable to binary nonlinear SVM");
        }
        int n = this.svm.sv.size();
        ArrayList<SupportVector> sv = new ArrayList<SupportVector>(n);
        for (int i = 0; i < n; ++i) {
            LASVM.SupportVector v = (LASVM.SupportVector)this.svm.sv.get(i);
            sv.add(new SupportVector(v.x, v.y, v.alpha));
        }
        return sv;
    }

    @Override
    public void learn(T x, int y) {
        this.learn(x, y, 1.0);
    }

    public void learn(T x, int y, double weight) {
        if (y < 0 || y >= this.k) {
            throw new IllegalArgumentException("Invalid label");
        }
        if (weight <= 0.0) {
            throw new IllegalArgumentException("Invalid instance weight: " + weight);
        }
        if (this.k == 2) {
            if (y == 1) {
                this.svm.process(x, 1, weight);
            } else {
                this.svm.process(x, -1, weight);
            }
        } else if (this.strategy == Multiclass.ONE_VS_ALL) {
            if (this.wi != null) {
                weight *= this.wi[y];
            }
            for (int i = 0; i < this.k; ++i) {
                if (y == i) {
                    this.svms.get(i).process(x, 1, weight);
                    continue;
                }
                this.svms.get(i).process(x, -1, weight);
            }
        } else {
            int m = 0;
            for (int i = 0; i < this.k; ++i) {
                int j = i + 1;
                while (j < this.k) {
                    if (y == i) {
                        this.svms.get(m).process(x, 1, weight);
                    } else if (y == j) {
                        this.svms.get(m).process(x, -1, weight);
                    }
                    ++j;
                    ++m;
                }
            }
        }
    }

    public void learn(T[] x, int[] y) {
        this.learn(x, y, null);
    }

    public void learn(T[] x, int[] y, double[] weight) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (weight != null && x.length != weight.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and instance weight don't match: %d != %d", x.length, weight.length));
        }
        int miny = Math.min((int[])y);
        if (miny < 0) {
            throw new IllegalArgumentException("Negative class label:" + miny);
        }
        int maxy = Math.max((int[])y);
        if (maxy >= this.k) {
            throw new IllegalArgumentException("Invalid class label:" + maxy);
        }
        if (this.k == 2) {
            int[] yi = new int[y.length];
            for (int i = 0; i < y.length; ++i) {
                yi[i] = y[i] == 1 ? 1 : -1;
            }
            if (weight == null) {
                this.svm.learn(x, yi);
            } else {
                this.svm.learn(x, yi, weight);
            }
        } else if (this.strategy == Multiclass.ONE_VS_ALL) {
            ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>(this.k);
            for (int i = 0; i < this.k; ++i) {
                int[] yi = new int[y.length];
                double[] w = this.wi == null ? weight : new double[y.length];
                for (int l = 0; l < y.length; ++l) {
                    yi[l] = y[l] == i ? 1 : -1;
                    if (this.wi == null) continue;
                    w[l] = this.wi[y[l]];
                    if (weight == null) continue;
                    int n = l;
                    w[n] = w[n] * weight[l];
                }
                tasks.add(new TrainingTask(this.svms.get(i), x, yi, w));
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>(this.k * (this.k - 1) / 2);
            int m = 0;
            for (int i = 0; i < this.k; ++i) {
                int j = i + 1;
                while (j < this.k) {
                    int n = 0;
                    for (int l = 0; l < y.length; ++l) {
                        if (y[l] != i && y[l] != j) continue;
                        ++n;
                    }
                    Object[] xij = (Object[])Array.newInstance(x.getClass().getComponentType(), n);
                    int[] yij = new int[n];
                    double[] wij = weight == null ? null : new double[n];
                    int q = 0;
                    for (int l = 0; l < y.length; ++l) {
                        if (y[l] == i) {
                            xij[q] = x[l];
                            yij[q] = 1;
                            if (weight != null) {
                                wij[q] = weight[l];
                            }
                            ++q;
                            continue;
                        }
                        if (y[l] != j) continue;
                        xij[q] = x[l];
                        yij[q] = -1;
                        if (weight != null) {
                            wij[q] = weight[l];
                        }
                        ++q;
                    }
                    tasks.add(new TrainingTask(this.svms.get(m), xij, yij, wij));
                    ++j;
                    ++m;
                }
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                logger.error("Failed to train SVM on multi-core", (Throwable)e);
            }
        }
    }

    public void finish() {
        if (this.k == 2) {
            this.svm.finish();
        } else {
            ArrayList<ProcessTask> tasks = new ArrayList<ProcessTask>(this.svms.size());
            for (LASVM s : this.svms) {
                tasks.add(new ProcessTask(s));
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                logger.error("Failed to train SVM on multi-core", (Throwable)e);
            }
        }
    }

    public boolean hasPlattScaling() {
        return this.svm.platt != null;
    }

    public void trainPlattScaling(T[] x, int[] y) {
        if (this.k == 2) {
            this.svm.trainPlattScaling(x, y);
        } else if (this.strategy == Multiclass.ONE_VS_ALL) {
            ArrayList<PlattScalingTask> tasks = new ArrayList<PlattScalingTask>(this.svms.size());
            for (int m = 0; m < this.svms.size(); ++m) {
                LASVM s = this.svms.get(m);
                int l = y.length;
                int[] yi = new int[l];
                for (int i = 0; i < l; ++i) {
                    yi[i] = y[i] == m ? 1 : -1;
                }
                tasks.add(new PlattScalingTask(s, x, yi));
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                logger.error("Failed to train Platt Scaling on multi-core", (Throwable)e);
            }
        } else {
            ArrayList<PlattScalingTask> tasks = new ArrayList<PlattScalingTask>(this.svms.size());
            int m = 0;
            for (int i = 0; i < this.k; ++i) {
                int j = i + 1;
                while (j < this.k) {
                    LASVM s = this.svms.get(m);
                    int l = y.length;
                    int[] yi = new int[l];
                    for (int p = 0; p < l; ++p) {
                        yi[p] = y[p] == i ? 1 : -1;
                    }
                    tasks.add(new PlattScalingTask(s, x, yi));
                    ++j;
                    ++m;
                }
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                logger.error("Failed to train Platt Scaling on multi-core", (Throwable)e);
            }
        }
    }

    @Override
    public int predict(T x) {
        if (this.k == 2) {
            if (this.svm.predict(x) > 0.0) {
                return 1;
            }
            return 0;
        }
        if (this.strategy == Multiclass.ONE_VS_ALL) {
            int label = 0;
            double maxf = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.svms.size(); ++i) {
                double f = this.svms.get(i).predict(x);
                if (!(f > maxf)) continue;
                label = i;
                maxf = f;
            }
            return label;
        }
        int[] count = new int[this.k];
        int m = 0;
        for (int i = 0; i < this.k; ++i) {
            int j = i + 1;
            while (j < this.k) {
                double f = this.svms.get(m).predict(x);
                if (f > 0.0) {
                    int n = i;
                    count[n] = count[n] + 1;
                } else {
                    int n = j;
                    count[n] = count[n] + 1;
                }
                ++j;
                ++m;
            }
        }
        int max = 0;
        int label = 0;
        for (int i = 0; i < this.k; ++i) {
            if (count[i] <= max) continue;
            max = count[i];
            label = i;
        }
        return label;
    }

    private double posterior(LASVM svm, double y) {
        double minProb = 1.0E-7;
        double maxProb = 0.9999999;
        return Math.min((double)Math.max((double)svm.platt.predict(y), (double)1.0E-7), (double)0.9999999);
    }

    @Override
    public int predict(T x, double[] prob) {
        if (this.k == 2) {
            if (this.svm.platt == null) {
                throw new UnsupportedOperationException("PlattScaling was not trained yet. Please call SVM.trainPlattScaling() first.");
            }
            double y = this.svm.predict(x);
            prob[1] = this.posterior(this.svm, y);
            prob[0] = 1.0 - prob[1];
            if (y > 0.0) {
                return 1;
            }
            return 0;
        }
        if (this.strategy == Multiclass.ONE_VS_ALL) {
            int label = 0;
            double maxf = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.svms.size(); ++i) {
                LASVM svm = this.svms.get(i);
                if (svm.platt == null) {
                    throw new UnsupportedOperationException("PlattScaling was not trained yet. Please call SVM.trainPlattScaling() first.");
                }
                double f = svm.predict(x);
                prob[i] = this.posterior(svm, f);
                if (!(f > maxf)) continue;
                label = i;
                maxf = f;
            }
            Math.unitize1((double[])prob);
            return label;
        }
        int[] count = new int[this.k];
        double[][] r = new double[this.k][this.k];
        int m = 0;
        for (int i = 0; i < this.k; ++i) {
            int j = i + 1;
            while (j < this.k) {
                LASVM svm = this.svms.get(m);
                if (svm.platt == null) {
                    throw new UnsupportedOperationException("PlattScaling was not trained yet. Please call SVM.trainPlattScaling() first.");
                }
                double f = svm.predict(x);
                r[i][j] = this.posterior(svm, f);
                r[j][i] = 1.0 - r[i][j];
                if (f > 0.0) {
                    int n = i;
                    count[n] = count[n] + 1;
                } else {
                    int n = j;
                    count[n] = count[n] + 1;
                }
                ++j;
                ++m;
            }
        }
        PlattScaling.multiclass(this.k, r, prob);
        int max = 0;
        int label = 0;
        for (int i = 0; i < this.k; ++i) {
            if (count[i] <= max) continue;
            max = count[i];
            label = i;
        }
        return label;
    }

    class PlattScalingTask
    implements Callable<LASVM> {
        LASVM svm;
        T[] x;
        int[] y;

        PlattScalingTask(LASVM svm, T[] x, int[] y) {
            this.svm = svm;
            this.x = x;
            this.y = y;
        }

        @Override
        public LASVM call() {
            this.svm.trainPlattScaling(this.x, this.y);
            return this.svm;
        }
    }

    class ProcessTask
    implements Callable<LASVM> {
        LASVM svm;

        ProcessTask(LASVM svm) {
            this.svm = svm;
        }

        @Override
        public LASVM call() {
            this.svm.finish();
            return this.svm;
        }
    }

    class TrainingTask
    implements Callable<LASVM> {
        LASVM svm;
        T[] x;
        int[] y;
        double[] weight;

        TrainingTask(LASVM svm, T[] x, int[] y, double[] weight) {
            this.svm = svm;
            this.x = x;
            this.y = y;
            this.weight = weight;
        }

        @Override
        public LASVM call() {
            this.svm.learn(this.x, this.y, this.weight);
            return this.svm;
        }
    }

    public class SupportVector
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public T x;
        public int y;
        public double alpha;

        public SupportVector(T x, int y, double alpha) {
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }

    final class LASVM
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double Cp = 1.0;
        private double Cn = 1.0;
        List<smile.classification.SVM$LASVM.SupportVector> sv = new ArrayList<smile.classification.SVM$LASVM.SupportVector>();
        double[] w;
        double b = 0.0;
        int nsv = 0;
        int nbsv = 0;
        PlattScaling platt;
        transient boolean minmaxflag = false;
        transient smile.classification.SVM$LASVM.SupportVector svmin = null;
        transient smile.classification.SVM$LASVM.SupportVector svmax = null;
        transient double gmin = Double.MAX_VALUE;
        transient double gmax = -1.7976931348623157E308;

        LASVM(double Cp, double Cn) {
            this.Cp = Cp;
            this.Cn = Cn;
        }

        void learn(T[] x, int[] y) {
            this.learn(x, y, null);
        }

        /*
         * WARNING - void declaration
         */
        void learn(T[] x, int[] y, double[] weight) {
            if (SVM.this.p == 0 && SVM.this.kernel instanceof LinearKernel) {
                Object[] x0;
                if (x instanceof double[][]) {
                    x0 = (double[])x[0];
                    SVM.this.p = x0.length;
                } else if (x instanceof float[][]) {
                    x0 = (float[])x[0];
                    SVM.this.p = x0.length;
                } else {
                    throw new UnsupportedOperationException("Unsupported data type for linear kernel.");
                }
            }
            int c1 = 0;
            int c2 = 0;
            for (SupportVector supportVector : this.sv) {
                if (supportVector == null) continue;
                if (supportVector.y > 0) {
                    ++c1;
                    continue;
                }
                if (supportVector.y >= 0) continue;
                ++c2;
            }
            int n = x.length;
            if (c1 < 5 || c2 < 5) {
                void var7_11;
                boolean bl = false;
                while (var7_11 < n) {
                    if (y[var7_11] == 1 && c1 < 5) {
                        if (weight == null) {
                            this.process(x[var7_11], y[var7_11]);
                        } else {
                            this.process(x[var7_11], y[var7_11], weight[var7_11]);
                        }
                        ++c1;
                    }
                    if (y[var7_11] == -1 && c2 < 5) {
                        if (weight == null) {
                            this.process(x[var7_11], y[var7_11]);
                        } else {
                            this.process(x[var7_11], y[var7_11], weight[var7_11]);
                        }
                        ++c2;
                    }
                    if (c1 >= 5 && c2 >= 5) break;
                    ++var7_11;
                }
            }
            int[] nArray = Math.permutate((int)n);
            for (int i = 0; i < n; ++i) {
                if (weight == null) {
                    this.process(x[nArray[i]], y[nArray[i]]);
                } else {
                    this.process(x[nArray[i]], y[nArray[i]], weight[nArray[i]]);
                }
                do {
                    this.reprocess(SVM.this.tol);
                    this.minmax();
                } while (this.gmax - this.gmin > 1000.0);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        double predict(T x) {
            double f = this.b;
            if (SVM.this.kernel instanceof LinearKernel && this.w != null) {
                if (x instanceof double[]) {
                    f += Math.dot((double[])this.w, (double[])((double[])x));
                    return f;
                } else {
                    if (!(x instanceof SparseArray)) throw new UnsupportedOperationException("Unsupported data type for linear kernel");
                    for (SparseArray.Entry entry : (SparseArray)x) {
                        f += this.w[entry.i] * entry.x;
                    }
                }
                return f;
            } else {
                for (SupportVector supportVector : this.sv) {
                    if (supportVector == null) continue;
                    f += supportVector.alpha * SVM.this.kernel.k(supportVector.x, x);
                }
            }
            return f;
        }

        void minmax() {
            if (!this.minmaxflag) {
                this.gmin = Double.MAX_VALUE;
                this.gmax = -1.7976931348623157E308;
                for (SupportVector supportVector : this.sv) {
                    if (supportVector == null) continue;
                    double gi = supportVector.g;
                    double ai = supportVector.alpha;
                    if (gi < this.gmin && ai > supportVector.cmin) {
                        this.svmin = supportVector;
                        this.gmin = gi;
                    }
                    if (!(gi > this.gmax) || !(ai < supportVector.cmax)) continue;
                    this.svmax = supportVector;
                    this.gmax = gi;
                }
                this.minmaxflag = true;
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        boolean smo(SupportVector v1, SupportVector v2, double epsgr) {
            double ostep;
            double step;
            double curv;
            if (v1 == null || v2 == null) {
                double gain;
                double mu;
                double k;
                double Z;
                SupportVector v;
                int i;
                double best;
                double gm;
                double km;
                if (v1 == null && v2 == null) {
                    this.minmax();
                    if (this.gmax > -this.gmin) {
                        v2 = this.svmax;
                    } else {
                        v1 = this.svmin;
                    }
                }
                if (v2 == null) {
                    if (v1.kcache == null) {
                        v1.kcache = new DoubleArrayList(this.sv.size());
                        for (SupportVector supportVector : this.sv) {
                            if (supportVector != null) {
                                v1.kcache.add(SVM.this.kernel.k(v1.x, supportVector.x));
                                continue;
                            }
                            v1.kcache.add(0.0);
                        }
                    }
                    km = v1.k;
                    gm = v1.g;
                    best = 0.0;
                    for (i = 0; i < this.sv.size(); ++i) {
                        v = (SupportVector)this.sv.get(i);
                        if (v == null) continue;
                        Z = v.g - gm;
                        k = v1.kcache.get(i);
                        double curv2 = km + v.k - 2.0 * k;
                        if (curv2 <= 0.0) {
                            curv2 = 1.0E-12;
                        }
                        if (!((mu = Z / curv2) > 0.0 && v.alpha < v.cmax) && (!(mu < 0.0) || !(v.alpha > v.cmin)) || !((gain = Z * mu) > best)) continue;
                        best = gain;
                        v2 = v;
                    }
                } else {
                    if (v2.kcache == null) {
                        v2.kcache = new DoubleArrayList(this.sv.size());
                        for (SupportVector supportVector : this.sv) {
                            if (supportVector != null) {
                                v2.kcache.add(SVM.this.kernel.k(v2.x, supportVector.x));
                                continue;
                            }
                            v2.kcache.add(0.0);
                        }
                    }
                    km = v2.k;
                    gm = v2.g;
                    best = 0.0;
                    for (i = 0; i < this.sv.size(); ++i) {
                        v = (SupportVector)this.sv.get(i);
                        if (v == null) continue;
                        Z = gm - v.g;
                        k = v2.kcache.get(i);
                        double curv2 = km + v.k - 2.0 * k;
                        if (curv2 <= 0.0) {
                            curv2 = 1.0E-12;
                        }
                        if (!((mu = Z / curv2) > 0.0 && v.alpha > v.cmin) && (!(mu < 0.0) || !(v.alpha < v.cmax)) || !((gain = Z * mu) > best)) continue;
                        best = gain;
                        v1 = v;
                    }
                }
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.kcache == null) {
                v1.kcache = new DoubleArrayList(this.sv.size());
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        v1.kcache.add(SVM.this.kernel.k(v1.x, supportVector.x));
                        continue;
                    }
                    v1.kcache.add(0.0);
                }
            }
            if (v2.kcache == null) {
                v2.kcache = new DoubleArrayList(this.sv.size());
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        v2.kcache.add(SVM.this.kernel.k(v2.x, supportVector.x));
                        continue;
                    }
                    v2.kcache.add(0.0);
                }
            }
            if ((curv = v1.k + v2.k - 2.0 * SVM.this.kernel.k(v1.x, v2.x)) <= 0.0) {
                curv = 1.0E-12;
            }
            if ((step = (v2.g - v1.g) / curv) >= 0.0) {
                ostep = v1.alpha - v1.cmin;
                if (ostep < step) {
                    step = ostep;
                }
                if ((ostep = v2.cmax - v2.alpha) < step) {
                    step = ostep;
                }
            } else {
                ostep = v2.cmin - v2.alpha;
                if (ostep > step) {
                    step = ostep;
                }
                if ((ostep = v1.alpha - v1.cmax) > step) {
                    step = ostep;
                }
            }
            v1.alpha -= step;
            v2.alpha += step;
            for (int i = 0; i < this.sv.size(); ++i) {
                SupportVector v = (SupportVector)this.sv.get(i);
                if (v == null) continue;
                v.g -= step * (v2.kcache.get(i) - v1.kcache.get(i));
            }
            this.minmaxflag = false;
            this.minmax();
            this.b = (this.gmax + this.gmin) / 2.0;
            return !(this.gmax - this.gmin < epsgr);
        }

        boolean process(T x, int y) {
            return this.process(x, y, 1.0);
        }

        /*
         * WARNING - void declaration
         */
        boolean process(T x, int y, double weight) {
            SupportVector v1;
            void var9_9;
            if (y != 1 && y != -1) {
                throw new IllegalArgumentException("Invalid label: " + y);
            }
            if (weight <= 0.0) {
                throw new IllegalArgumentException("Invalid instance weight: " + weight);
            }
            double g = y;
            DoubleArrayList kcache = new DoubleArrayList(this.sv.size() + 1);
            if (!this.sv.isEmpty()) {
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        if (supportVector.x == x) {
                            return true;
                        }
                        double k = SVM.this.kernel.k(supportVector.x, x);
                        g -= supportVector.alpha * k;
                        kcache.add(k);
                        continue;
                    }
                    kcache.add(0.0);
                }
                this.minmax();
                if (this.gmin < this.gmax && (y > 0 && g < this.gmin || y < 0 && g > this.gmax)) {
                    return false;
                }
            }
            SupportVector v = new SupportVector();
            v.x = x;
            v.y = y;
            v.alpha = 0.0;
            v.g = g;
            v.k = SVM.this.kernel.k(x, x);
            v.kcache = kcache;
            if (y > 0) {
                v.cmin = 0.0;
                v.cmax = weight * this.Cp;
            } else {
                v.cmin = -weight * this.Cn;
                v.cmax = 0.0;
            }
            int n = this.sv.size();
            while (var9_9 < this.sv.size()) {
                if (this.sv.get((int)var9_9) == null) {
                    this.sv.set((int)var9_9, (smile.classification.SVM$LASVM.SupportVector)v);
                    kcache.set((int)var9_9, v.k);
                    for (int j = 0; j < this.sv.size(); ++j) {
                        v1 = (SupportVector)this.sv.get(j);
                        if (v1 == null || v1.kcache == null) continue;
                        v1.kcache.set((int)var9_9, kcache.get(j));
                    }
                    break;
                }
                ++var9_9;
            }
            if (var9_9 >= this.sv.size()) {
                for (int j = 0; j < this.sv.size(); ++j) {
                    v1 = (SupportVector)this.sv.get(j);
                    if (v1 == null || v1.kcache == null) continue;
                    v1.kcache.add(kcache.get(j));
                }
                v.kcache.add(v.k);
                this.sv.add((smile.classification.SVM$LASVM.SupportVector)v);
            }
            if (y > 0) {
                this.smo(null, v, 0.0);
            } else {
                this.smo(v, null, 0.0);
            }
            this.minmaxflag = false;
            return true;
        }

        boolean reprocess(double epsgr) {
            boolean status = this.smo(null, null, epsgr);
            this.evict();
            return status;
        }

        void finish() {
            this.finish(SVM.this.tol);
        }

        void finish(double epsgr) {
            this.finish(epsgr, Integer.MAX_VALUE);
        }

        void finish(double epsgr, int maxIter) {
            logger.info("SVM is finalizing the training by reprocess.");
            for (int count = 1; this.smo(null, null, epsgr) && count <= maxIter; ++count) {
                if (count % 1000 != 0) continue;
                logger.info("finishing {} reprocess iterations.", (Object)count);
            }
            logger.info("SVM finished the reprocess.");
            Iterator<smile.classification.SVM$LASVM.SupportVector> iter = this.sv.iterator();
            while (iter.hasNext()) {
                SupportVector v = (SupportVector)iter.next();
                if (v == null) {
                    iter.remove();
                    continue;
                }
                if (v.alpha != 0.0 || !(v.g >= this.gmax && 0.0 >= v.cmax) && (!(v.g <= this.gmin) || !(0.0 <= v.cmin))) continue;
                iter.remove();
            }
            this.cleanup();
            if (SVM.this.kernel instanceof LinearKernel) {
                if (SVM.this.p == 0 && !this.sv.isEmpty()) {
                    Object x = ((SupportVector)this.sv.get((int)0)).x;
                    if (x instanceof double[]) {
                        double[] dArray = (double[])x;
                        SVM.this.p = dArray.length;
                    } else if (x instanceof float[]) {
                        float[] fArray = (float[])x;
                        SVM.this.p = fArray.length;
                    } else {
                        throw new UnsupportedOperationException("Unsupported data type for linear kernel.");
                    }
                }
                this.w = new double[SVM.this.p];
                for (SupportVector supportVector : this.sv) {
                    int i;
                    Object[] x;
                    if (supportVector.x instanceof double[]) {
                        x = (double[])supportVector.x;
                        for (i = 0; i < this.w.length; ++i) {
                            int n = i;
                            this.w[n] = this.w[n] + supportVector.alpha * x[i];
                        }
                        continue;
                    }
                    if (supportVector.x instanceof int[]) {
                        x = (int[])supportVector.x;
                        for (i = 0; i < x.length; ++i) {
                            double d = x[i];
                            this.w[d] = this.w[d] + supportVector.alpha;
                        }
                        continue;
                    }
                    if (!(supportVector.x instanceof SparseArray)) continue;
                    for (SparseArray.Entry e : (SparseArray)supportVector.x) {
                        int n = e.i;
                        this.w[n] = this.w[n] + supportVector.alpha * e.x;
                    }
                }
            }
        }

        void trainPlattScaling(T[] x, int[] y) {
            int l = y.length;
            double[] scores = new double[l];
            for (int i = 0; i < l; ++i) {
                scores[i] = this.predict(x[i]);
            }
            this.platt = new PlattScaling(scores, y);
        }

        void evict() {
            this.minmax();
            for (int i = 0; i < this.sv.size(); ++i) {
                SupportVector v = (SupportVector)this.sv.get(i);
                if (v == null || v.alpha != 0.0 || !(v.g >= this.gmax && 0.0 >= v.cmax) && (!(v.g <= this.gmin) || !(0.0 <= v.cmin))) continue;
                this.sv.set(i, null);
            }
        }

        void cleanup() {
            this.nsv = 0;
            this.nbsv = 0;
            for (SupportVector supportVector : this.sv) {
                if (supportVector == null) continue;
                ++this.nsv;
                supportVector.kcache = null;
                if (supportVector.alpha != supportVector.cmin && supportVector.alpha != supportVector.cmax) continue;
                ++this.nbsv;
            }
            logger.info("{} support vectors, {} bounded\n", (Object)this.nsv, (Object)this.nbsv);
        }

        class SupportVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            T x;
            int y;
            double alpha;
            double g;
            double cmin;
            double cmax;
            double k;
            DoubleArrayList kcache;

            SupportVector() {
            }
        }
    }

    public static class Trainer<T>
    extends ClassifierTrainer<T> {
        private MercerKernel<T> kernel;
        private int k;
        private double[] weight;
        private double Cp = 1.0;
        private double Cn = 1.0;
        private Multiclass strategy = Multiclass.ONE_VS_ONE;
        private double tol = 0.001;
        private int epochs = 2;

        public Trainer(MercerKernel<T> kernel, double C) {
            if (C < 0.0) {
                throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
            }
            this.kernel = kernel;
            this.Cp = C;
            this.Cn = C;
            this.k = 2;
        }

        public Trainer(MercerKernel<T> kernel, double Cp, double Cn) {
            if (Cp < 0.0) {
                throw new IllegalArgumentException("Invalid postive instance soft margin penalty: " + Cp);
            }
            if (Cn < 0.0) {
                throw new IllegalArgumentException("Invalid negative instance soft margin penalty: " + Cn);
            }
            this.kernel = kernel;
            this.Cp = Cp;
            this.Cn = Cn;
            this.k = 2;
        }

        public Trainer(MercerKernel<T> kernel, double C, int k, Multiclass strategy) {
            if (C < 0.0) {
                throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
            }
            if (k < 3) {
                throw new IllegalArgumentException("Invalid number of classes: " + k);
            }
            this.kernel = kernel;
            this.Cp = C;
            this.Cn = C;
            this.k = k;
            this.strategy = strategy;
        }

        public Trainer(MercerKernel<T> kernel, double C, double[] weight, Multiclass strategy) {
            if (C < 0.0) {
                throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
            }
            if (weight.length < 3) {
                throw new IllegalArgumentException("Invalid number of classes: " + weight.length);
            }
            this.kernel = kernel;
            this.Cp = C;
            this.Cn = C;
            this.k = weight.length;
            this.weight = weight;
            this.strategy = strategy;
        }

        public Trainer<T> setTolerance(double tol) {
            if (tol <= 0.0) {
                throw new IllegalArgumentException("Invalid tolerance of convergence test:" + tol);
            }
            this.tol = tol;
            return this;
        }

        public Trainer<T> setNumEpochs(int epochs) {
            if (epochs < 1) {
                throw new IllegalArgumentException("Invalid numer of epochs of stochastic learning:" + epochs);
            }
            this.epochs = epochs;
            return this;
        }

        @Override
        public SVM<T> train(T[] x, int[] y) {
            return this.train(x, y, null);
        }

        public SVM<T> train(T[] x, int[] y, double[] weight) {
            SVM<T> svm = null;
            svm = this.k == 2 ? new SVM<T>(this.kernel, this.Cp, this.Cn) : (this.weight == null ? new SVM<T>(this.kernel, this.Cp, this.k, this.strategy) : new SVM<T>(this.kernel, this.Cp, this.weight, this.strategy));
            svm.setTolerance(this.tol);
            for (int i = 1; i <= this.epochs; ++i) {
                svm.learn(x, y, weight);
            }
            svm.finish();
            return svm;
        }
    }

    public static enum Multiclass {
        ONE_VS_ONE,
        ONE_VS_ALL;

    }
}

