/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.Serializable;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DeviceAndSessionIdentifierWithGPSFixesSerializer<D extends DeviceIdentifier, F extends GPSFix>
implements JsonSerializer<Util.Triple<D, Serializable, List<F>>> {
    private final JsonSerializer<DeviceIdentifier> deviceSerializer;
    private final JsonSerializer<F> fixSerializer;

    public DeviceAndSessionIdentifierWithGPSFixesSerializer(JsonSerializer<DeviceIdentifier> deviceSerializer, JsonSerializer<F> fixSerializer) {
        this.deviceSerializer = deviceSerializer;
        this.fixSerializer = fixSerializer;
    }

    public JSONObject serialize(Util.Triple<D, Serializable, List<F>> data) {
        JSONObject result = new JSONObject();
        JSONObject deviceIdJson = this.deviceSerializer.serialize((Object)((DeviceIdentifier)data.getA()));
        JSONArray fixesJson = new JSONArray();
        for (GPSFix fix : (List)data.getC()) {
            fixesJson.add((Object)this.fixSerializer.serialize((Object)fix));
        }
        result.put((Object)"device", (Object)deviceIdJson);
        if (data.getB() != null) {
            result.put((Object)"sessionId", (Object)((Serializable)data.getB()).toString());
        }
        result.put((Object)"fixes", (Object)fixesJson);
        return result;
    }
}

