/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.metering.CPUMeter;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CPUMeterJsonSerializer
implements JsonSerializer<CPUMeter> {
    private static final String CPU_USER_MILLIS = "cpuUserMillis";
    private static final String CPU_SYSTEM_MILLIS = "cpuSystemMillis";
    private static final String CPU_TOTAL_MILLIS = "cpuTotalMillis";
    private static final String CPU_KEY = "key";
    private static final String CPU_BY_KEY = "byKey";
    private static final String CPU_TOTALS = "totals";

    public JSONObject serialize(CPUMeter cpuMeter) {
        JSONObject result = new JSONObject();
        JSONArray byKey = new JSONArray();
        result.put((Object)CPU_BY_KEY, (Object)byKey);
        for (Map.Entry e : cpuMeter.getTotalCPUTimesInUserModeByKey().entrySet()) {
            JSONObject usage = new JSONObject();
            byKey.add((Object)usage);
            usage.put((Object)CPU_KEY, e.getKey());
            this.putUserSystemAndTotal(usage, (Duration)e.getValue(), cpuMeter.getTotalCPUTimeInSystemMode((String)e.getKey()), cpuMeter.getTotalCPUTime((String)e.getKey()));
        }
        JSONObject totals = new JSONObject();
        result.put((Object)CPU_TOTALS, (Object)totals);
        this.putUserSystemAndTotal(totals, cpuMeter.getTotalCPUTimeInUserMode(), cpuMeter.getTotalCPUTimeInSystemMode(), cpuMeter.getTotalCPUTime());
        return result;
    }

    private void putUserSystemAndTotal(JSONObject into, Duration totalCPUTimeInUserMode, Duration totalCPUTimeInSystemMode, Duration totalCPUTime) {
        into.put((Object)CPU_USER_MILLIS, (Object)totalCPUTimeInUserMode.asMillis());
        into.put((Object)CPU_SYSTEM_MILLIS, (Object)totalCPUTimeInSystemMode.asMillis());
        into.put((Object)CPU_TOTAL_MILLIS, (Object)totalCPUTime.asMillis());
    }
}

