/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.util;

import com.sap.sailing.gwt.ui.simulator.util.LineSegment;

public class LineSegment {
    private static final double EPSILON = 1.0E-5;
    private Point p1;
    private Point p2;

    public LineSegment(Point p1, Point p2) {
        this.setP1(p1);
        this.setP2(p2);
    }

    public LineSegment(double x1, double y1, double x2, double y2) {
        Point p1 = new Point(this, x1, y1);
        Point p2 = new Point(this, x2, y2);
        this.setP1(p1);
        this.setP2(p2);
    }

    public IntersectionType getIntersectionType(LineSegment ls) {
        Point p = this.p1;
        Point r = this.p2.subtract(this.p1);
        Point q = ls.p1;
        Point s = ls.p2.subtract(ls.p1);
        double rCrossS = r.cross(s);
        if (rCrossS <= 1.0E-5 && rCrossS >= -1.0E-5) {
            return IntersectionType.PARALLEL_DONT_INTERSECT;
        }
        Point qMinusp = q.subtract(p);
        double t = qMinusp.cross(s) / rCrossS;
        double u = qMinusp.cross(r) / rCrossS;
        if (0.0 <= u && u <= 1.0 && 0.0 <= t && t <= 1.0) {
            Point intersectionPoint = p.add(r.scalarMult(t));
            return IntersectionType.INTERSECT;
        }
        return IntersectionType.DONT_INTERSECT;
    }

    public Point intersect(LineSegment ls) {
        Point p = this.p1;
        Point r = this.p2.subtract(this.p1);
        Point q = ls.p1;
        Point s = ls.p2.subtract(ls.p1);
        double rCrossS = r.cross(s);
        if (rCrossS <= 1.0E-5 && rCrossS >= -1.0E-5) {
            return null;
        }
        Point qMinusp = q.subtract(p);
        double t = qMinusp.cross(s) / rCrossS;
        double u = qMinusp.cross(r) / rCrossS;
        if (0.0 <= u && u <= 1.0 && 0.0 <= t && t <= 1.0) {
            Point intersectionPoint = p.add(r.scalarMult(t));
            return intersectionPoint;
        }
        return null;
    }

    public Point getP1() {
        return this.p1;
    }

    public void setP1(Point p1) {
        this.p1 = p1;
    }

    public Point getP2() {
        return this.p2;
    }

    public void setP2(Point p2) {
        this.p2 = p2;
    }
}

