/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;

public class SwissTimingConfigurationWithSecurityDTO
implements IsSerializable,
SecuredDTO {
    private static final long serialVersionUID = 8896994399042048620L;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private String name;
    private String jsonUrl;
    private String hostname;
    private Integer port;
    private String creatorName;
    private String updateURL;
    private String updateUsername;
    private String updatePassword;

    public SwissTimingConfigurationWithSecurityDTO() {
    }

    public SwissTimingConfigurationWithSecurityDTO(String name, String jsonUrl, String hostname, Integer port, String updateURL, String updateUsername, String updatePassword, String creatorName) {
        this.name = name;
        this.jsonUrl = jsonUrl;
        this.hostname = hostname;
        this.port = port;
        this.updateURL = updateURL;
        this.updateUsername = updateUsername;
        this.updatePassword = updatePassword;
        this.creatorName = creatorName;
    }

    public SwissTimingConfigurationWithSecurityDTO(SwissTimingConfigurationWithSecurityDTO dto, String hostname, Integer port, String eventName) {
        this.name = eventName;
        this.jsonUrl = dto.getJsonUrl();
        this.hostname = hostname;
        this.port = port;
        this.updateURL = dto.getUpdateURL();
        this.updateUsername = dto.getUpdateUsername();
        this.updatePassword = dto.getUpdatePassword();
        this.creatorName = dto.getCreatorName();
    }

    public String getName() {
        return this.name;
    }

    public String getJsonUrl() {
        return this.jsonUrl;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public String getUpdateUsername() {
        return this.updateUsername;
    }

    public String getUpdatePassword() {
        return this.updatePassword;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public void setAccessControlList(AccessControlListDTO createAccessControlListDTO) {
        this.securityInformation.setAccessControlList(createAccessControlListDTO);
    }

    public void setOwnership(OwnershipDTO createOwnershipDTO) {
        this.securityInformation.setOwnership(createOwnershipDTO);
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.SWISS_TIMING_ACCOUNT;
    }

    private TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return this.creatorName == null ? new TypeRelativeObjectIdentifier(new String[]{this.jsonUrl}) : new TypeRelativeObjectIdentifier(new String[]{this.jsonUrl, this.creatorName});
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }
}

