/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.impl.AllEventsOfTypeFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCCertificateAssignmentFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCImpliedWindSourceFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.RegattaLogORCCertificateAssignmentFinder;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbortingFlagFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.MarkPassingDataFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TrackingTimesFinder;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogTrackingStateAnalyzer;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMarkMappingFinder;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.PairingListLeaderboardAdapter;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RacingProcedureConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.configuration.impl.ESSConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.GateStartConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.LeagueConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.RRS26ConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.RacingProcedureConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.RacingProcedureWithConfigurableStartModeFlagConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.RegattaConfigurationImpl;
import com.sap.sailing.domain.base.configuration.impl.SWCStartConfigurationImpl;
import com.sap.sailing.domain.base.configuration.procedures.ConfigurableStartModeFlagRacingProcedureConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.ESSConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.GateStartConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.LeagueConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.RRS26Configuration;
import com.sap.sailing.domain.base.configuration.procedures.SWCStartConfiguration;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.LegIdentifier;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.PathType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceFetcher;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaFetcher;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorAndBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.FullLeaderboardDTO;
import com.sap.sailing.domain.common.dto.IncrementalLeaderboardDTO;
import com.sap.sailing.domain.common.dto.IncrementalOrFullLeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.domain.common.dto.PairingListTemplateDTO;
import com.sap.sailing.domain.common.dto.PersonDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTOFactory;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.RaceLogTrackingInfoDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceDTO;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.PreciseCompactGPSFixMovingImpl;
import com.sap.sailing.domain.common.windfinder.SpotBase;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.ControlPointTemplate;
import com.sap.sailing.domain.coursetemplate.ControlPointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationRequestAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationResponseAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationVisitor;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkRolePair;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.PositioningVisitor;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.impl.CommonMarkPropertiesImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointTemplateImpl;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.datatypes.BatteryLevel;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsLatLong;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.MetaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.leaderboard.meta.MetaLeaderboardColumn;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.orc.ORCPublicCertificateDatabase;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.RaceStateOfSameDayHelper;
import com.sap.sailing.domain.racelogtracking.DeviceIdentifierStringSerializationHandler;
import com.sap.sailing.domain.racelogtracking.DeviceMapping;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapterFactory;
import com.sap.sailing.domain.racelogtracking.impl.DeviceMappingImpl;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.shared.tracking.LineDetails;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapter;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapterFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.persistence.SwissTimingAdapterPersistence;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayRace;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayService;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayServiceFactory;
import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tractracadapter.RaceRecord;
import com.sap.sailing.domain.tractracadapter.TracTracAdapter;
import com.sap.sailing.domain.tractracadapter.TracTracAdapterFactory;
import com.sap.sailing.domain.tractracadapter.persistence.PersistenceFactory;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinder.WindFinderTrackerFactory;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRace;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapterFactory;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.gwt.common.client.EventWindFinderUtil;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.gwt.ui.client.SailingService;
import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.gwt.ui.server.DelegatingServletContext;
import com.sap.sailing.gwt.ui.server.IncrementalLeaderboardDTOCloner;
import com.sap.sailing.gwt.ui.server.PlaceHolderDeviceIdentifierStringSerializationHandler;
import com.sap.sailing.gwt.ui.server.QuickRanksLiveCache;
import com.sap.sailing.gwt.ui.server.SailingServiceImpl;
import com.sap.sailing.gwt.ui.shared.BearingWithConfidenceDTO;
import com.sap.sailing.gwt.ui.shared.CompactBoatPositionsDTO;
import com.sap.sailing.gwt.ui.shared.CompactRaceMapDataDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorProviderDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorRaceDataDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorsRaceDataDTO;
import com.sap.sailing.gwt.ui.shared.ControlPointDTO;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.EventBaseDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegTypeIterable;
import com.sap.sailing.gwt.ui.shared.GateDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDataAccessWindowWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDeviceWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupBaseDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.LegInfoDTO;
import com.sap.sailing.gwt.ui.shared.ManeuverDTO;
import com.sap.sailing.gwt.ui.shared.ManeuverLossDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.MarkPassingTimesDTO;
import com.sap.sailing.gwt.ui.shared.PathDTO;
import com.sap.sailing.gwt.ui.shared.QRCodeEvent;
import com.sap.sailing.gwt.ui.shared.QuickRankDTO;
import com.sap.sailing.gwt.ui.shared.QuickRanksDTO;
import com.sap.sailing.gwt.ui.shared.RaceCourseDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupSeriesDTO;
import com.sap.sailing.gwt.ui.shared.RaceInfoDTO;
import com.sap.sailing.gwt.ui.shared.RaceLogDTO;
import com.sap.sailing.gwt.ui.shared.RaceLogEventDTO;
import com.sap.sailing.gwt.ui.shared.RaceMapDataDTO;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.RaceboardDataDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.RegattaLogDTO;
import com.sap.sailing.gwt.ui.shared.RegattaLogEventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaOverviewEntryDTO;
import com.sap.sailing.gwt.ui.shared.RegattaScoreCorrectionDTO;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sailing.gwt.ui.shared.ScoreCorrectionProviderDTO;
import com.sap.sailing.gwt.ui.shared.SerializationDummy;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sailing.gwt.ui.shared.ServerConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.SidelineDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorResultsDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.SliceRacePreperationDTO;
import com.sap.sailing.gwt.ui.shared.SpeedWithBearingDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingArchiveConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingEventRecordDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingReplayRaceDTO;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.TracTracRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.TrackingConnectorInfoDTO;
import com.sap.sailing.gwt.ui.shared.UrlDTO;
import com.sap.sailing.gwt.ui.shared.VenueDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.CommonMarkPropertiesDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.ControlPointWithMarkConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.CourseConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.CourseTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPairWithConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPropertiesDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkRoleDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.RepeatablePartDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.WaypointTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.WaypointWithMarkConfigurationDTO;
import com.sap.sailing.manage2sail.EventResultDescriptor;
import com.sap.sailing.manage2sail.Manage2SailEventResultsParserImpl;
import com.sap.sailing.manage2sail.RaceResultDescriptor;
import com.sap.sailing.manage2sail.RegattaResultDescriptor;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.ORCCertificateJsonDeserializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.SimulationService;
import com.sap.sailing.server.security.SailingViewerRole;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.SimulationResults;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PolarDiagramGPS;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sailing.util.RegattaUtil;
import com.sap.sailing.xrr.structureimport.SeriesParameters;
import com.sap.sailing.xrr.structureimport.StructureImporter;
import com.sap.sailing.xrr.structureimport.buildstructure.SetRacenumberFromSeries;
import com.sap.sailing.xrr.structureimport.buildstructure.SetRacenumberStrategy;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Base64Utils;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.RepeatablePartImpl;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.ImageResizingTaskDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.gwt.server.ResultCachingProxiedRemoteServiceServlet;
import com.sap.sse.gwt.shared.replication.ReplicaDTO;
import com.sap.sse.gwt.shared.replication.ReplicationMasterDTO;
import com.sap.sse.gwt.shared.replication.ReplicationStateDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.pairinglist.PairingList;
import com.sap.sse.pairinglist.PairingListTemplate;
import com.sap.sse.pairinglist.impl.PairingListTemplateImpl;
import com.sap.sse.qrcode.QRCodeGenerationUtil;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.ui.server.SecurityDTOFactory;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import com.sap.sse.security.ui.shared.EssentialSecuredDTO;
import com.sap.sse.security.util.RemoteServerUtil;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.MediaUtils;
import com.sap.sse.shared.media.VideoDescriptor;
import com.sap.sse.shared.media.impl.ImageDescriptorImpl;
import com.sap.sse.shared.media.impl.VideoDescriptorImpl;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SailingServiceImpl
extends ResultCachingProxiedRemoteServiceServlet
implements SailingService,
RaceFetcher,
RegattaFetcher {
    protected static final Logger logger = Logger.getLogger(SailingServiceImpl.class.getName());
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private static final long serialVersionUID = 9031688830194537489L;
    private final FullyInitializedReplicableTracker<RacingEventService> racingEventServiceTracker;
    private final ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;
    private final ServiceTracker<ScoreCorrectionProvider, ScoreCorrectionProvider> scoreCorrectionProviderServiceTracker;
    private final ServiceTracker<WindFinderTrackerFactory, WindFinderTrackerFactory> windFinderTrackerFactoryServiceTracker;
    private final MongoObjectFactory mongoObjectFactory;
    protected final ServiceTracker<ExpeditionTrackerFactory, ExpeditionTrackerFactory> expeditionConnectorTracker;
    protected final SwissTimingAdapterPersistence swissTimingAdapterPersistence;
    private final ServiceTracker<SwissTimingAdapterFactory, SwissTimingAdapterFactory> swissTimingAdapterTracker;
    private final ServiceTracker<TracTracAdapterFactory, TracTracAdapterFactory> tractracAdapterTracker;
    private final ServiceTracker<IgtimiConnectionFactory, IgtimiConnectionFactory> igtimiConnectionFactoryTracker;
    private final ServiceTracker<RiotServer, RiotServer> riotServerTracker;
    private final ServiceTracker<RaceLogTrackingAdapterFactory, RaceLogTrackingAdapterFactory> raceLogTrackingAdapterTracker;
    private final ServiceTracker<YellowBrickTrackingAdapterFactory, YellowBrickTrackingAdapterFactory> yellowBrickTrackingAdapterTracker;
    private final ServiceTracker<DeviceIdentifierStringSerializationHandler, DeviceIdentifierStringSerializationHandler> deviceIdentifierStringSerializationHandlerTracker;
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private final FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker;
    private final ServiceTracker<AIAgent, AIAgent> aiAgentTracker;
    protected final com.sap.sailing.domain.tractracadapter.persistence.MongoObjectFactory tractracMongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;
    protected final SwissTimingFactory swissTimingFactory;
    protected final com.sap.sailing.domain.tractracadapter.persistence.DomainObjectFactory tractracDomainObjectFactory;
    protected final Executor executor;
    protected final DomainFactory baseDomainFactory;
    private static final int LEADERBOARD_BY_NAME_RESULTS_CACHE_BY_ID_SIZE = 100;
    private static final int LEADERBOARD_DIFFERENCE_CACHE_SIZE = 50;
    protected static final String MAILTYPE_PROPERTY = "com.sap.sailing.domain.tracking.MailInvitationType";
    protected ResourceBundleStringMessages serverStringMessages;
    private final LinkedHashMap<String, LeaderboardDTO> leaderboardByNameResultsCacheById;
    private int leaderboardDifferenceCacheByIdPairHits;
    private int leaderboardDifferenceCacheByIdPairMisses;
    private final LinkedHashMap<Util.Pair<String, String>, IncrementalLeaderboardDTO> leaderboardDifferenceCacheByIdPair;
    private final SwissTimingReplayService swissTimingReplayService;
    private final QuickRanksLiveCache quickRanksLiveCache;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$DetailType;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$RankingMetrics;

    public SailingServiceImpl() {
        BundleContext context = Activator.getDefault();
        Activator activator = Activator.getInstance();
        this.quickRanksLiveCache = new QuickRanksLiveCache(this);
        this.replicationServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ReplicationService.class);
        this.racingEventServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, RacingEventService.class);
        this.aiAgentTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, AIAgent.class);
        this.sharedSailingDataTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SharedSailingData.class);
        this.windFinderTrackerFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, WindFinderTrackerFactory.class);
        this.swissTimingAdapterTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SwissTimingAdapterFactory.class);
        this.tractracAdapterTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, TracTracAdapterFactory.class);
        this.raceLogTrackingAdapterTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, RaceLogTrackingAdapterFactory.class);
        this.yellowBrickTrackingAdapterTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, YellowBrickTrackingAdapterFactory.class);
        this.deviceIdentifierStringSerializationHandlerTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, DeviceIdentifierStringSerializationHandler.class);
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        this.igtimiConnectionFactoryTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, IgtimiConnectionFactory.class);
        this.riotServerTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, RiotServer.class);
        this.baseDomainFactory = this.getService().getBaseDomainFactory();
        this.mongoObjectFactory = this.getService().getMongoObjectFactory();
        this.domainObjectFactory = this.getService().getDomainObjectFactory();
        this.swissTimingAdapterPersistence = SwissTimingAdapterPersistence.INSTANCE;
        this.swissTimingReplayService = ((SwissTimingReplayServiceFactory)ServiceTrackerFactory.createAndOpen((BundleContext)context, SwissTimingReplayServiceFactory.class).getService()).createSwissTimingReplayService(this.getSwissTimingAdapter().getSwissTimingDomainFactory(), (RaceLogResolver)this.getService());
        this.expeditionConnectorTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ExpeditionTrackerFactory.class);
        this.scoreCorrectionProviderServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ScoreCorrectionProvider.class);
        this.tractracDomainObjectFactory = PersistenceFactory.INSTANCE.createDomainObjectFactory(this.mongoObjectFactory.getDatabase(), this.getTracTracAdapter().getTracTracDomainFactory());
        this.tractracMongoObjectFactory = com.sap.sailing.domain.tractracadapter.persistence.MongoObjectFactory.INSTANCE;
        this.swissTimingFactory = SwissTimingFactory.INSTANCE;
        this.leaderboardDifferenceCacheByIdPair = new /* Unavailable Anonymous Inner Class!! */;
        this.leaderboardByNameResultsCacheById = new /* Unavailable Anonymous Inner Class!! */;
        this.executor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
        this.serverStringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClass().getClassLoader(), StandardCharsets.UTF_8.name());
        if (context != null) {
            activator.setSailingService(this);
        }
    }

    public void stop() {
        this.quickRanksLiveCache.stop();
    }

    protected SwissTimingAdapterFactory getSwissTimingAdapterFactory() {
        return (SwissTimingAdapterFactory)this.swissTimingAdapterTracker.getService();
    }

    protected SwissTimingAdapter getSwissTimingAdapter() {
        return this.getSwissTimingAdapterFactory().getOrCreateSwissTimingAdapter(this.baseDomainFactory);
    }

    protected TracTracAdapterFactory getTracTracAdapterFactory() {
        return (TracTracAdapterFactory)this.tractracAdapterTracker.getService();
    }

    protected TracTracAdapter getTracTracAdapter() {
        return this.getTracTracAdapterFactory().getOrCreateTracTracAdapter(this.baseDomainFactory);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public Iterable<String> getScoreCorrectionProviderNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ScoreCorrectionProvider scoreCorrectionProvider : this.getAllScoreCorrectionProviders()) {
            result.add(scoreCorrectionProvider.getName());
        }
        return result;
    }

    public ScoreCorrectionProviderDTO getScoreCorrectionsOfProvider(String providerName) throws Exception {
        ScoreCorrectionProviderDTO result = null;
        for (ScoreCorrectionProvider scoreCorrectionProvider : this.getAllScoreCorrectionProviders()) {
            if (!scoreCorrectionProvider.getName().equals(providerName)) continue;
            result = this.convertScoreCorrectionProviderDTO(scoreCorrectionProvider);
            break;
        }
        return result;
    }

    private Iterable<ScoreCorrectionProvider> getAllScoreCorrectionProviders() {
        ScoreCorrectionProvider[] services = (ScoreCorrectionProvider[])this.scoreCorrectionProviderServiceTracker.getServices((Object[])new ScoreCorrectionProvider[0]);
        ArrayList<ScoreCorrectionProvider> result = new ArrayList<ScoreCorrectionProvider>();
        if (services != null) {
            ScoreCorrectionProvider[] scoreCorrectionProviderArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreCorrectionProvider service = scoreCorrectionProviderArray[n2];
                result.add(service);
                ++n2;
            }
        }
        return result;
    }

    private ScoreCorrectionProviderDTO convertScoreCorrectionProviderDTO(ScoreCorrectionProvider scoreCorrectionProvider) throws Exception {
        HashMap hasResultsForBoatClassFromDateByEventName = new HashMap();
        for (Map.Entry e : scoreCorrectionProvider.getHasResultsForBoatClassFromDateByEventName().entrySet()) {
            HashSet<Util.Pair> set = new HashSet<Util.Pair>();
            for (Util.Pair p : (Set)e.getValue()) {
                set.add(new Util.Pair((Object)((String)p.getA()), (Object)((TimePoint)p.getB()).asDate()));
            }
            hasResultsForBoatClassFromDateByEventName.put((String)e.getKey(), set);
        }
        return new ScoreCorrectionProviderDTO(scoreCorrectionProvider.getName(), hasResultsForBoatClassFromDateByEventName);
    }

    public Iterable<String> getCompetitorProviderNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (CompetitorProvider competitorProvider : this.getAllCompetitorProviders()) {
            result.add(competitorProvider.getName());
        }
        return result;
    }

    private Iterable<CompetitorProvider> getAllCompetitorProviders() {
        return this.getService().getAllCompetitorProviders();
    }

    public CompetitorProviderDTO getCompetitorProviderDTOByName(String providerName) throws Exception {
        for (CompetitorProvider competitorProvider : this.getAllCompetitorProviders()) {
            if (!competitorProvider.getName().equals(providerName)) continue;
            return new CompetitorProviderDTO(competitorProvider.getName(), new HashMap(competitorProvider.getHasCompetitorsForRegattasInEvent()));
        }
        return null;
    }

    public Util.Pair<List<CompetitorDescriptor>, String> getCompetitorDescriptorsAndHint(String competitorProviderName, String eventName, String regattaName, String localeForHint) throws Exception {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        for (CompetitorProvider cp : this.getAllCompetitorProviders()) {
            if (!cp.getName().equals(competitorProviderName)) continue;
            ArrayList result = new ArrayList();
            Util.addAll((Iterable)cp.getCompetitorDescriptors(eventName, regattaName), result);
            return new Util.Pair(result, (Object)cp.getHint(ResourceBundleStringMessages.Util.getLocaleFor((String)localeForHint)));
        }
        return new Util.Pair(Collections.emptyList(), null);
    }

    public SerializationDummy serializationDummy(PersonDTO dummy, CountryCode ccDummy, PreciseCompactGPSFixMovingImpl.PreciseCompactPosition preciseCompactPosition, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier, SecondsDurationImpl secondsDuration, KnotSpeedImpl knotSpeedImpl, KilometersPerHourSpeedImpl kmhSpeedImpl, HasPermissions hasPermissions, IgtimiDeviceWithSecurityDTO igtimiDeviceWithSecurityDTO) {
        return null;
    }

    public IncrementalOrFullLeaderboardDTO getLeaderboardByName(String leaderboardName, Date date, Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, String previousLeaderboardId, boolean fillTotalPointsUncorrected) throws NoWindException, InterruptedException, ExecutionException, IllegalArgumentException {
        Leaderboard leaderBoard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderBoard);
        if (leaderBoard instanceof RegattaLeaderboard) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderBoard).getRegatta());
        }
        return this.getLeaderBoardByNameInternal(leaderboardName, date, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, previousLeaderboardId, fillTotalPointsUncorrected);
    }

    public List<CourseAreaDTO> getCourseAreas(String leaderboardName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        ArrayList<CourseAreaDTO> result = new ArrayList<CourseAreaDTO>();
        for (CourseArea courseArea : leaderboard.getCourseAreas()) {
            result.add(this.convertToCourseAreaDTO(courseArea));
        }
        return result;
    }

    public List<CourseAreaDTO> getCourseAreaForEventOfLeaderboard(String leaderboardName) {
        ArrayList<CourseAreaDTO> result = new ArrayList<CourseAreaDTO>();
        for (EventDTO event : this.getEventsForLeaderboard(leaderboardName)) {
            Util.addAll((Iterable)event.getVenue().getCourseAreas(), result);
        }
        return result;
    }

    public IncrementalOrFullLeaderboardDTO getLeaderboardForRace(RegattaAndRaceIdentifier race, String leaderboardName, Date date, Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, String previousLeaderboardId, boolean fillTotalPointsUncorrected) throws NoWindException, InterruptedException, ExecutionException, IllegalArgumentException {
        IncrementalOrFullLeaderboardDTO result;
        DynamicTrackedRace trackedRace = this.getService().getExistingTrackedRace(race);
        if (trackedRace == null) {
            result = null;
        } else {
            Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
            if (leaderboard.getRaceColumnAndFleet((TrackedRace)trackedRace) == null) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
            }
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            result = this.getLeaderBoardByNameInternal(leaderboardName, date, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, previousLeaderboardId, fillTotalPointsUncorrected);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IncrementalOrFullLeaderboardDTO getLeaderBoardByNameInternal(String leaderboardName, Date date, Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, String previousLeaderboardId, boolean fillTotalPointsUncorrected) throws NoWindException, InterruptedException, ExecutionException {
        try {
            long startOfRequestHandling = System.currentTimeMillis();
            FullLeaderboardDTO result = null;
            Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
            if (leaderboard != null) {
                IncrementalLeaderboardDTO cachedDiff;
                MillisecondsTimePoint timePoint = date == null ? null : new MillisecondsTimePoint(date);
                LeaderboardDTO leaderboardDTO = leaderboard.getLeaderboardDTO((TimePoint)timePoint, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, (TrackedRegattaRegistry)this.getService(), this.baseDomainFactory, fillTotalPointsUncorrected);
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)leaderboardDTO);
                LeaderboardDTO previousLeaderboardDTO = null;
                LinkedHashMap linkedHashMap = this.leaderboardByNameResultsCacheById;
                synchronized (linkedHashMap) {
                    this.leaderboardByNameResultsCacheById.put(leaderboardDTO.getId(), leaderboardDTO);
                    if (previousLeaderboardId != null) {
                        previousLeaderboardDTO = (LeaderboardDTO)this.leaderboardByNameResultsCacheById.get(previousLeaderboardId);
                    }
                }
                boolean storeLeaderboardForTesting = false;
                if (previousLeaderboardId != null) {
                    LinkedHashMap linkedHashMap2 = this.leaderboardDifferenceCacheByIdPair;
                    synchronized (linkedHashMap2) {
                        cachedDiff = (IncrementalLeaderboardDTO)this.leaderboardDifferenceCacheByIdPair.get(new Util.Pair((Object)previousLeaderboardId, (Object)leaderboardDTO.getId()));
                    }
                    if (cachedDiff == null) {
                        ++this.leaderboardDifferenceCacheByIdPairMisses;
                    } else {
                        ++this.leaderboardDifferenceCacheByIdPairHits;
                    }
                } else {
                    cachedDiff = null;
                }
                if (previousLeaderboardDTO == null) {
                    result = new FullLeaderboardDTO(leaderboardDTO);
                } else {
                    IncrementalLeaderboardDTO incrementalResult;
                    if (cachedDiff == null) {
                        IncrementalLeaderboardDTO preResult = new IncrementalLeaderboardDTOCloner().clone(leaderboardDTO).strip(previousLeaderboardDTO);
                        LinkedHashMap linkedHashMap3 = this.leaderboardDifferenceCacheByIdPair;
                        synchronized (linkedHashMap3) {
                            this.leaderboardDifferenceCacheByIdPair.put(new Util.Pair((Object)previousLeaderboardId, (Object)leaderboardDTO.getId()), preResult);
                        }
                        incrementalResult = preResult;
                    } else {
                        incrementalResult = cachedDiff;
                    }
                    incrementalResult.setCurrentServerTime(new Date());
                    result = incrementalResult;
                }
                logger.fine("getLeaderboardByName(" + leaderboardName + ", " + date + ", " + namesOfRaceColumnsForWhichToLoadLegDetails + ", addOverallDetails=" + addOverallDetails + ") took " + (System.currentTimeMillis() - startOfRequestHandling) + "ms; diff cache hits/misses " + this.leaderboardDifferenceCacheByIdPairHits + "/" + this.leaderboardDifferenceCacheByIdPairMisses);
            }
            return result;
        }
        catch (NoWindException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception during SailingService.getLeaderboardByName", e);
            throw new RuntimeException(e);
        }
    }

    public List<RegattaDTO> getRegattas() {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getService().getAllRegattas(), arg_0 -> this.convertToRegattaDTO(arg_0));
    }

    public RegattaDTO getRegattaByName(String regattaName) {
        RegattaDTO result = null;
        if (regattaName != null && !regattaName.isEmpty()) {
            Regatta regatta = this.getService().getRegatta(new RegattaName(regattaName));
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            if (regatta != null) {
                result = this.convertToRegattaDTO(regatta);
            }
        }
        return result;
    }

    protected MarkDTO convertToMarkDTO(Mark mark, Position position) {
        MarkDTO markDTO = position != null ? new MarkDTO(mark.getId().toString(), mark.getName(), mark.getShortName(), position.getLatDeg(), position.getLngDeg()) : new MarkDTO(mark.getId().toString(), mark.getName(), mark.getShortName());
        markDTO.color = mark.getColor();
        markDTO.shape = mark.getShape();
        markDTO.pattern = mark.getPattern();
        markDTO.type = mark.getType();
        return markDTO;
    }

    protected RegattaDTO convertToRegattaDTO(Regatta regatta) {
        RegattaDTO regattaDTO = new RegattaDTO(regatta.getName(), regatta.getScoringScheme().getType());
        regattaDTO.races = this.convertToRaceDTOs(regatta);
        regattaDTO.series = this.convertToSeriesDTOs(regatta);
        regattaDTO.startDate = regatta.getStartDate() != null ? regatta.getStartDate().asDate() : null;
        regattaDTO.endDate = regatta.getEndDate() != null ? regatta.getEndDate().asDate() : null;
        BoatClass boatClass = regatta.getBoatClass();
        if (boatClass != null) {
            regattaDTO.boatClass = this.convertToBoatClassDTO(boatClass);
        }
        regattaDTO.courseAreas = new ArrayList();
        Util.addAll((Iterable)Util.map((Iterable)regatta.getCourseAreas(), arg_0 -> this.convertToCourseAreaDTO(arg_0)), (Collection)regattaDTO.courseAreas);
        regattaDTO.buoyZoneRadiusInHullLengths = regatta.getBuoyZoneRadiusInHullLengths();
        regattaDTO.useStartTimeInference = regatta.useStartTimeInference();
        regattaDTO.controlTrackingFromStartAndFinishTimes = regatta.isControlTrackingFromStartAndFinishTimes();
        regattaDTO.autoRestartTrackingUponCompetitorSetChange = regatta.isAutoRestartTrackingUponCompetitorSetChange();
        regattaDTO.canBoatsOfCompetitorsChangePerRace = regatta.canBoatsOfCompetitorsChangePerRace();
        regattaDTO.competitorRegistrationType = regatta.getCompetitorRegistrationType();
        regattaDTO.configuration = this.convertToRegattaConfigurationDTO(regatta.getRegattaConfiguration());
        regattaDTO.rankingMetricType = regatta.getRankingMetricType();
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)regattaDTO);
        regattaDTO.registrationLinkSecret = regatta.getRegistrationLinkSecret();
        return regattaDTO;
    }

    private BoatClassDTO convertToBoatClassDTO(BoatClass boatClass) {
        return boatClass == null ? null : new BoatClassDTO(boatClass.getName(), boatClass.getHullLength(), boatClass.getHullBeam());
    }

    private List<SeriesDTO> convertToSeriesDTOs(Regatta regatta) {
        ArrayList<SeriesDTO> result = new ArrayList<SeriesDTO>();
        for (Series series : regatta.getSeries()) {
            SeriesDTO seriesDTO = this.convertToSeriesDTO(series);
            result.add(seriesDTO);
        }
        return result;
    }

    private SeriesDTO convertToSeriesDTO(Series series) {
        ArrayList<FleetDTO> fleets = new ArrayList<FleetDTO>();
        for (Fleet fleet : series.getFleets()) {
            fleets.add(this.baseDomainFactory.convertToFleetDTO(fleet));
        }
        List raceColumns = this.convertToRaceColumnDTOs(series.getRaceColumns());
        SeriesDTO result = new SeriesDTO(series.getName(), fleets, raceColumns, series.isMedal(), series.isFleetsCanRunInParallel(), series.getResultDiscardingRule() == null ? null : series.getResultDiscardingRule().getDiscardIndexResultsStartingWithHowManyRaces(), series.isStartsWithZeroScore(), series.isFirstColumnNonDiscardableCarryForward(), series.hasSplitFleetContiguousScoring(), series.hasCrossFleetMergedRanking(), series.getMaximumNumberOfDiscards(), series.isOneAlwaysStaysOne());
        return result;
    }

    protected void fillRaceColumnDTO(RaceColumn raceColumn, RaceColumnDTO raceColumnDTO) {
        raceColumnDTO.setMedalRace(raceColumn.isMedalRace());
        raceColumnDTO.setExplicitFactor(raceColumn.getExplicitFactor());
    }

    private List<RaceColumnDTO> convertToRaceColumnDTOs(Iterable<? extends RaceColumn> raceColumns) {
        ArrayList<RaceColumnDTO> raceColumnDTOs = new ArrayList<RaceColumnDTO>();
        RaceColumnDTOFactory columnFactory = RaceColumnDTOFactory.INSTANCE;
        for (RaceColumn raceColumn : raceColumns) {
            RaceColumnDTO raceColumnDTO = columnFactory.createRaceColumnDTO(raceColumn.getName(), raceColumn.isMedalRace(), raceColumn.getExplicitFactor(), raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getRegatta().getName() : null, raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getSeries().getName() : null, raceColumn instanceof MetaLeaderboardColumn, raceColumn.isOneAlwaysStaysOne());
            raceColumnDTOs.add(raceColumnDTO);
        }
        return raceColumnDTOs;
    }

    private RaceInfoDTO createRaceInfoDTO(String seriesName, RaceColumn raceColumn, Fleet fleet, RaceLog raceLog, ReadonlyRaceState state) {
        RaceInfoDTO raceInfoDTO = new RaceInfoDTO();
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        boolean bl = raceInfoDTO.isTracked = trackedRace != null;
        if (raceLog != null) {
            Wind wind;
            TimePoint protestEndTime;
            CourseBase lastCourse;
            AbortingFlagFinder abortingFlagFinder;
            RaceLogFlagEvent abortingFlagEvent;
            TimePoint startTime = state.getStartTime();
            if (startTime != null) {
                raceInfoDTO.startTime = startTime.asDate();
            }
            raceInfoDTO.lastStatus = state.getStatus();
            raceLog.lockForRead();
            try {
                if (!Util.isEmpty((Iterable)raceLog.getRawFixes())) {
                    raceInfoDTO.lastUpdateTime = Util.stream((Iterable)raceLog.getRawFixes()).sorted((rle1, rle2) -> rle2.getTimePoint().compareTo((Object)rle1.getTimePoint())).findFirst().map(rle -> rle.getTimePoint().asDate()).orElse(null);
                }
            }
            finally {
                raceLog.unlockAfterRead();
            }
            TimePoint finishingTime = state.getFinishingTime();
            raceInfoDTO.finishingTime = finishingTime != null ? finishingTime.asDate() : null;
            TimePoint finishedTime = state.getFinishedTime();
            if (finishedTime != null) {
                raceInfoDTO.finishedTime = finishedTime.asDate();
            } else {
                raceInfoDTO.finishedTime = null;
                if (raceInfoDTO.isTracked) {
                    TimePoint endOfRace = trackedRace.getEndOfRace();
                    raceInfoDTO.finishedTime = endOfRace != null ? endOfRace.asDate() : null;
                }
            }
            TimePoint now = MillisecondsTimePoint.now();
            if (startTime != null) {
                FlagPoleState activeFlagState = state.getRacingProcedure().getActiveFlags(startTime, now);
                List activeFlags = activeFlagState.getCurrentState();
                FlagPoleState previousFlagState = activeFlagState.getPreviousState(state.getRacingProcedure(), startTime);
                List previousFlags = previousFlagState.getCurrentState();
                FlagPole mostInterestingFlagPole = FlagPoleState.getMostInterestingFlagPole((List)previousFlags, (List)activeFlags);
                if (mostInterestingFlagPole != null) {
                    raceInfoDTO.lastUpperFlag = mostInterestingFlagPole.getUpperFlag();
                    raceInfoDTO.lastLowerFlag = mostInterestingFlagPole.getLowerFlag();
                    raceInfoDTO.lastFlagsAreDisplayed = mostInterestingFlagPole.isDisplayed();
                    raceInfoDTO.lastFlagsDisplayedStateChanged = previousFlagState.hasPoleChanged(mostInterestingFlagPole);
                }
            }
            if ((abortingFlagEvent = (RaceLogFlagEvent)(abortingFlagFinder = new AbortingFlagFinder(raceLog)).analyze()) != null) {
                raceInfoDTO.isRaceAbortedInPassBefore = true;
                raceInfoDTO.abortingTimeInPassBefore = abortingFlagEvent.getLogicalTimePoint().asDate();
                if (raceInfoDTO.lastStatus.isAbortingFlagFromPreviousPassValid()) {
                    raceInfoDTO.lastUpperFlag = abortingFlagEvent.getUpperFlag();
                    raceInfoDTO.lastLowerFlag = abortingFlagEvent.getLowerFlag();
                    raceInfoDTO.lastFlagsAreDisplayed = abortingFlagEvent.isDisplayed();
                    raceInfoDTO.lastFlagsDisplayedStateChanged = true;
                }
            }
            if ((lastCourse = state.getCourseDesign()) != null) {
                raceInfoDTO.lastCourseDesign = this.convertToRaceCourseDTO(lastCourse, (MarkPositionFinder)new TrackedRaceMarkPositionFinder(this, trackedRace), now);
                raceInfoDTO.lastCourseName = lastCourse.getName();
            }
            if (raceInfoDTO.lastStatus.equals((Object)RaceLogRaceStatus.FINISHED) && state.getProtestTime() != null && (protestEndTime = state.getProtestTime().to()) != null) {
                TimePoint protestStartTime = state.getProtestTime().from();
                raceInfoDTO.protestStartTime = protestStartTime == null ? null : protestStartTime.asDate();
                raceInfoDTO.protestFinishTime = protestEndTime.asDate();
                raceInfoDTO.lastUpperFlag = Flags.BRAVO;
                raceInfoDTO.lastLowerFlag = Flags.NONE;
                raceInfoDTO.lastFlagsAreDisplayed = !protestEndTime.before(now);
                raceInfoDTO.lastFlagsDisplayedStateChanged = true;
            }
            if ((wind = state.getWindFix()) != null) {
                raceInfoDTO.lastWind = this.createWindDTOFromAlreadyAveraged(wind, now);
            }
            this.fillStartProcedureSpecifics(raceInfoDTO, state);
        }
        raceInfoDTO.seriesName = seriesName;
        raceInfoDTO.raceName = raceColumn.getName();
        raceInfoDTO.fleetName = fleet.getName();
        raceInfoDTO.fleetOrdering = fleet.getOrdering();
        raceInfoDTO.raceIdentifier = raceColumn.getRaceIdentifier(fleet);
        return raceInfoDTO;
    }

    /*
     * Exception decompiling
     */
    private void fillStartProcedureSpecifics(RaceInfoDTO raceInfoDTO, ReadonlyRaceState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<RaceWithCompetitorsAndBoatsDTO> convertToRaceDTOs(Regatta regatta) {
        ArrayList<RaceWithCompetitorsAndBoatsDTO> result = new ArrayList<RaceWithCompetitorsAndBoatsDTO>();
        for (RaceDefinition r : regatta.getAllRaces()) {
            RankingMetrics rankingMetricType;
            RegattaNameAndRaceName raceIdentifier = new RegattaNameAndRaceName(regatta.getName(), r.getName());
            DynamicTrackedRace trackedRace = this.getService().getExistingTrackedRace((RegattaAndRaceIdentifier)raceIdentifier);
            TrackedRaceDTO trackedRaceDTO = null;
            if (trackedRace != null) {
                trackedRaceDTO = this.getBaseDomainFactory().createTrackedRaceDTO((TrackedRace)trackedRace);
                rankingMetricType = trackedRace.getRankingMetric().getType();
            } else {
                rankingMetricType = null;
            }
            Map competitorAndBoatDTOs = this.baseDomainFactory.convertToCompetitorAndBoatDTOs(r.getCompetitorsAndTheirBoats());
            RaceWithCompetitorsAndBoatsDTO raceDTO = new RaceWithCompetitorsAndBoatsDTO((RegattaAndRaceIdentifier)raceIdentifier, competitorAndBoatDTOs, trackedRaceDTO, this.getService().isRaceBeingTracked(regatta, r), rankingMetricType);
            if (trackedRace != null) {
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)raceDTO);
                this.getBaseDomainFactory().updateRaceDTOWithTrackedRaceData((TrackedRace)trackedRace, (RaceDTO)raceDTO);
            }
            raceDTO.boatClass = regatta.getBoatClass() == null ? null : regatta.getBoatClass().getName();
            result.add(raceDTO);
        }
        return result;
    }

    private List<CompetitorDTO> convertToCompetitorDTOs(Iterable<? extends Competitor> iterable) {
        ArrayList<CompetitorDTO> result = new ArrayList<CompetitorDTO>();
        for (Competitor competitor : iterable) {
            CompetitorDTO competitorDTO = this.convertToCompetitorDTO(competitor);
            result.add(competitorDTO);
        }
        return result;
    }

    protected CompetitorDTO convertToCompetitorDTO(Competitor competitor) {
        CompetitorDTO competitorDTO = this.baseDomainFactory.convertToCompetitorDTO(competitor);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorDTO);
        this.clearNonPublicFieldsIfCurrentUserHasNoReadPermission(competitor, competitorDTO);
        return competitorDTO;
    }

    private void clearNonPublicFieldsIfCurrentUserHasNoReadPermission(Competitor competitor, CompetitorDTO competitorDTO) {
        if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)competitor)) {
            competitorDTO.clearNonPublicFields();
        }
    }

    protected CompetitorWithBoatDTO convertToCompetitorWithBoatDTO(CompetitorWithBoat competitor) {
        CompetitorWithBoatDTO competitorDTO = this.baseDomainFactory.convertToCompetitorWithBoatDTO(competitor);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorDTO);
        this.clearNonPublicFieldsIfCurrentUserHasNoReadPermission((Competitor)competitor, (CompetitorDTO)competitorDTO);
        BoatDTO boatDTO = competitorDTO.getBoat();
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)boatDTO);
        return competitorDTO;
    }

    private List<CompetitorAndBoatDTO> convertToCompetitorAndBoatDTOs(Map<? extends Competitor, ? extends Boat> competitorsAndTheirBoats) {
        ArrayList<CompetitorAndBoatDTO> result = new ArrayList<CompetitorAndBoatDTO>();
        for (Map.Entry<? extends Competitor, ? extends Boat> c : competitorsAndTheirBoats.entrySet()) {
            CompetitorAndBoatDTO competitorAndBoatDTO = this.baseDomainFactory.convertToCompetitorAndBoatDTO(c.getKey(), c.getValue());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorAndBoatDTO.getCompetitor());
            this.clearNonPublicFieldsIfCurrentUserHasNoReadPermission(c.getKey(), competitorAndBoatDTO.getCompetitor());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorAndBoatDTO.getBoat());
            result.add(competitorAndBoatDTO);
        }
        return result;
    }

    protected List<CompetitorWithBoatDTO> convertToCompetitorWithBoatDTOs(Iterable<? extends CompetitorWithBoat> iterable) {
        ArrayList<CompetitorWithBoatDTO> result = new ArrayList<CompetitorWithBoatDTO>();
        for (CompetitorWithBoat competitorWithBoat : iterable) {
            CompetitorWithBoatDTO competitorDTO = this.baseDomainFactory.convertToCompetitorWithBoatDTO(competitorWithBoat);
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorDTO);
            this.clearNonPublicFieldsIfCurrentUserHasNoReadPermission((Competitor)competitorWithBoat, (CompetitorDTO)competitorDTO);
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorDTO.getBoat());
            result.add(competitorDTO);
        }
        return result;
    }

    private List<BoatDTO> convertToBoatDTOs(Iterable<? extends Boat> iterable) {
        ArrayList<BoatDTO> result = new ArrayList<BoatDTO>();
        for (Boat boat : iterable) {
            BoatDTO boatDTO = this.baseDomainFactory.convertToBoatDTO(boat);
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)boatDTO);
            result.add(boatDTO);
        }
        return result;
    }

    protected BoatDTO convertToBoatDTO(Boat boat) {
        BoatDTO boatDTO = this.baseDomainFactory.convertToBoatDTO(boat);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)boatDTO);
        return boatDTO;
    }

    public Util.Pair<String, List<TracTracRaceRecordDTO>> listTracTracRacesInEvent(String eventJsonURL, boolean listHiddenRaces) throws MalformedURLException, IOException, java.text.ParseException, ParseException, URISyntaxException {
        Util.Pair raceRecords = this.getTracTracAdapter().getTracTracRaceRecords(new URL(eventJsonURL), false);
        ArrayList<TracTracRaceRecordDTO> result = new ArrayList<TracTracRaceRecordDTO>();
        for (RaceRecord raceRecord : (List)raceRecords.getB()) {
            if (!listHiddenRaces && raceRecord.getRaceVisibility().equals("HIDDEN")) continue;
            result.add(new TracTracRaceRecordDTO(raceRecord.getID(), raceRecord.getEventName(), raceRecord.getName(), raceRecord.getTrackingStartTime().asDate(), raceRecord.getTrackingEndTime().asDate(), raceRecord.getRaceStartTime() == null ? null : raceRecord.getRaceStartTime().asDate(), raceRecord.getBoatClassNames(), raceRecord.getRaceStatus(), raceRecord.getRaceVisibility(), raceRecord.getJsonURL().toString(), this.hasRememberedRegatta((Serializable)((Object)raceRecord.getID()))));
        }
        return new Util.Pair((Object)((String)raceRecords.getA()), result);
    }

    private boolean hasRememberedRegatta(Serializable raceID) {
        return this.getService().getRememberedRegattaForRace(raceID) != null;
    }

    public List<TracTracConfigurationWithSecurityDTO> getPreviousTracTracConfigurations() throws Exception {
        Iterable configs = this.tractracDomainObjectFactory.getTracTracConfigurations();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(configs, ttConfig -> {
            TracTracConfigurationWithSecurityDTO config = new TracTracConfigurationWithSecurityDTO(ttConfig.getName(), ttConfig.getJSONURL().toString(), ttConfig.getLiveDataURI() == null ? null : ttConfig.getLiveDataURI().toString(), ttConfig.getStoredDataURI() == null ? null : ttConfig.getStoredDataURI().toString(), ttConfig.getUpdateURI() == null ? null : ttConfig.getUpdateURI().toString(), ttConfig.getTracTracUsername(), null, ttConfig.getCreatorName());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)config);
            return config;
        });
    }

    private RaceDefinition getRaceByName(Regatta regatta, String raceName) {
        if (regatta != null) {
            return regatta.getRaceByName(raceName);
        }
        return null;
    }

    public WindInfoForRaceDTO getRawWindFixes(RegattaAndRaceIdentifier raceIdentifier, Collection<WindSource> windSources) {
        WindInfoForRaceDTO result = null;
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace != null) {
            HashMap<WindSource, WindTrackInfoDTO> windTrackInfoDTOs;
            result = new WindInfoForRaceDTO();
            result.raceIsKnownToStartUpwind = trackedRace.raceIsKnownToStartUpwind();
            result.windTrackInfoByWindSource = windTrackInfoDTOs = new HashMap<WindSource, WindTrackInfoDTO>();
            ArrayList<Object> windSourcesToDeliver = new ArrayList<Object>();
            if (windSources != null) {
                windSourcesToDeliver.addAll(windSources);
            } else {
                windSourcesToDeliver.add(new WindSourceImpl(WindSourceType.WEB));
            }
            for (WindSource windSource : windSourcesToDeliver) {
                if (windSource.getType() != WindSourceType.WEB) continue;
                WindTrackInfoDTO windTrackInfoDTO = new WindTrackInfoDTO();
                windTrackInfoDTO.windFixes = new ArrayList();
                WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
                windTrackInfoDTO.resolutionOutsideOfWhichNoFixWillBeReturned = windTrack.getResolutionOutsideOfWhichNoFixWillBeReturned();
                windTrack.lockForRead();
                try {
                    for (Wind wind : windTrack.getRawFixes()) {
                        if (wind == null) continue;
                        WindDTO windDTO = this.createWindDTO(wind, windTrack);
                        windTrackInfoDTO.windFixes.add(windDTO);
                    }
                }
                finally {
                    windTrack.unlockAfterRead();
                }
                windTrackInfoDTOs.put(windSource, windTrackInfoDTO);
            }
        }
        return result;
    }

    protected WindDTO createWindDTO(Wind wind, WindTrack windTrack) {
        WindDTO windDTO = new WindDTO();
        windDTO.trueWindBearingDeg = wind.getBearing().getDegrees();
        windDTO.trueWindFromDeg = wind.getBearing().reverse().getDegrees();
        windDTO.trueWindSpeedInKnots = wind.getKnots();
        windDTO.trueWindSpeedInMetersPerSecond = wind.getMetersPerSecond();
        if (wind.getPosition() != null) {
            windDTO.position = wind.getPosition();
        }
        if (wind.getTimePoint() != null) {
            windDTO.measureTimepoint = wind.getTimePoint().asMillis();
            Wind estimatedWind = windTrack.getAveragedWind(wind.getPosition(), wind.getTimePoint());
            if (estimatedWind != null) {
                windDTO.dampenedTrueWindBearingDeg = estimatedWind.getBearing().getDegrees();
                windDTO.dampenedTrueWindFromDeg = estimatedWind.getBearing().reverse().getDegrees();
                windDTO.dampenedTrueWindSpeedInKnots = estimatedWind.getKnots();
                windDTO.dampenedTrueWindSpeedInMetersPerSecond = estimatedWind.getMetersPerSecond();
            }
        }
        return windDTO;
    }

    public WindDTO createWindDTOFromAlreadyAveraged(Wind wind, TimePoint requestTimepoint) {
        WindDTO windDTO;
        if (wind == null) {
            windDTO = null;
        } else {
            windDTO = new WindDTO();
            windDTO.requestTimepoint = requestTimepoint.asMillis();
            windDTO.trueWindBearingDeg = wind.getBearing().getDegrees();
            windDTO.trueWindFromDeg = wind.getBearing().reverse().getDegrees();
            windDTO.trueWindSpeedInKnots = wind.getKnots();
            windDTO.trueWindSpeedInMetersPerSecond = wind.getMetersPerSecond();
            windDTO.dampenedTrueWindBearingDeg = wind.getBearing().getDegrees();
            windDTO.dampenedTrueWindFromDeg = wind.getBearing().reverse().getDegrees();
            windDTO.dampenedTrueWindSpeedInKnots = wind.getKnots();
            windDTO.dampenedTrueWindSpeedInMetersPerSecond = wind.getMetersPerSecond();
            if (wind.getPosition() != null) {
                windDTO.position = wind.getPosition();
            }
            if (wind.getTimePoint() != null) {
                windDTO.measureTimepoint = wind.getTimePoint().asMillis();
            }
        }
        return windDTO;
    }

    public WindInfoForRaceDTO getAveragedWindInfo(RegattaAndRaceIdentifier raceIdentifier, Date from, long millisecondsStepWidth, int numberOfFixes, Collection<String> windSourceTypeNames, boolean onlyUpToNewestEvent, boolean includeCombinedWindForAllLegMiddles) throws NoWindException {
        assert (from != null);
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        WindInfoForRaceDTO result = this.getAveragedWindInfo((TimePoint)new MillisecondsTimePoint(from), millisecondsStepWidth, numberOfFixes, windSourceTypeNames, trackedRace, onlyUpToNewestEvent, includeCombinedWindForAllLegMiddles);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private WindInfoForRaceDTO getAveragedWindInfo(TimePoint from, long millisecondsStepWidth, int numberOfFixes, Collection<String> windSourceTypeNames, TrackedRace trackedRace, boolean onlyUpToNewestEvent, boolean includeCombinedWindForAllLegMiddles) {
        WindInfoForRaceDTO result = null;
        if (trackedRace != null) {
            HashMap<WindSource, WindTrackInfoDTO> windTrackInfoDTOs;
            TimePoint newestEvent = trackedRace.getTimePointOfNewestEvent();
            result = new WindInfoForRaceDTO();
            result.raceIsKnownToStartUpwind = trackedRace.raceIsKnownToStartUpwind();
            ArrayList<WindSource> windSourcesToExclude = new ArrayList<WindSource>();
            for (WindSource windSourceToExclude : trackedRace.getWindSourcesToExclude()) {
                windSourcesToExclude.add(windSourceToExclude);
            }
            result.windSourcesToExclude = windSourcesToExclude;
            result.windTrackInfoByWindSource = windTrackInfoDTOs = new HashMap<WindSource, WindTrackInfoDTO>();
            ArrayList<Object> windSourcesToDeliver = new ArrayList<Object>();
            WindSourceImpl combinedWindSource = new WindSourceImpl(WindSourceType.COMBINED);
            if (windSourceTypeNames == null) {
                Util.addAll((Iterable)trackedRace.getWindSources(), windSourcesToDeliver);
                windSourcesToDeliver.add(combinedWindSource);
            } else {
                for (String string : windSourceTypeNames) {
                    for (WindSource windSource : trackedRace.getWindSources(WindSourceType.valueOf((String)string))) {
                        windSourcesToDeliver.add(windSource);
                    }
                }
            }
            for (WindSource windSource : windSourcesToDeliver) {
                WindTrackInfoDTO windTrackInfoDTO = this.createWindTrackInfoDTO(from, millisecondsStepWidth, numberOfFixes, trackedRace, onlyUpToNewestEvent, newestEvent, windSource, at -> null);
                windTrackInfoDTOs.put(windSource, windTrackInfoDTO);
            }
            if (includeCombinedWindForAllLegMiddles) {
                boolean bl = false;
                for (TrackedLeg trackedLeg : trackedRace.getTrackedLegs()) {
                    void var15_19;
                    WindTrackInfoDTO windTrackInfoForLegMiddle = this.createWindTrackInfoDTO(from, millisecondsStepWidth, numberOfFixes, trackedRace, onlyUpToNewestEvent, newestEvent, (WindSource)combinedWindSource, (PositionAtTimeProvider)new /* Unavailable Anonymous Inner Class!! */);
                    result.addWindOnLegMiddle((int)var15_19, windTrackInfoForLegMiddle);
                    ++var15_19;
                }
            }
        }
        return result;
    }

    private WindTrackInfoDTO createWindTrackInfoDTO(TimePoint from, long millisecondsStepWidth, int numberOfFixes, TrackedRace trackedRace, boolean onlyUpToNewestEvent, TimePoint newestEvent, WindSource windSource, PositionAtTimeProvider positionProvider) {
        WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
        WindTrackInfoDTO windTrackInfoDTO = new WindTrackInfoDTO();
        windTrackInfoDTO.resolutionOutsideOfWhichNoFixWillBeReturned = windTrack.getResolutionOutsideOfWhichNoFixWillBeReturned();
        windTrackInfoDTO.windFixes = new ArrayList();
        windTrackInfoDTO.dampeningIntervalInMilliseconds = windTrack.getMillisecondsOverWhichToAverageWind();
        TimePoint timePoint = from;
        Double minWindConfidence = 2.0;
        Double maxWindConfidence = -1.0;
        int i = 0;
        while (i < numberOfFixes && (!onlyUpToNewestEvent || newestEvent != null && timePoint.before(newestEvent))) {
            WindWithConfidence averagedWindWithConfidence = windTrack.getAveragedWindWithConfidence(positionProvider.getPosition(timePoint), timePoint);
            if (averagedWindWithConfidence != null) {
                if (logger.getLevel() != null && logger.getLevel().equals(Level.FINEST)) {
                    logger.finest("Found averaged wind: " + averagedWindWithConfidence);
                }
                double confidence = averagedWindWithConfidence.getConfidence();
                WindDTO windDTO = this.createWindDTOFromAlreadyAveraged((Wind)averagedWindWithConfidence.getObject(), timePoint);
                windDTO.confidence = confidence;
                windTrackInfoDTO.windFixes.add(windDTO);
                if (confidence < minWindConfidence) {
                    minWindConfidence = confidence;
                }
                if (confidence > maxWindConfidence) {
                    maxWindConfidence = confidence;
                }
            } else if (logger.getLevel() != null && logger.getLevel().equals(Level.FINEST)) {
                logger.finest("Did NOT find any averaged wind for timepoint " + timePoint + " and tracked race " + trackedRace.getRaceIdentifier().getRaceName());
            }
            timePoint = new MillisecondsTimePoint(timePoint.asMillis() + millisecondsStepWidth);
            ++i;
        }
        windTrackInfoDTO.minWindConfidence = minWindConfidence;
        windTrackInfoDTO.maxWindConfidence = maxWindConfidence;
        return windTrackInfoDTO;
    }

    public WindInfoForRaceDTO getAveragedWindInfo(RegattaAndRaceIdentifier raceIdentifier, Date from, Date to, long resolutionInMilliseconds, Collection<String> windSourceTypeNames, boolean onlyUpToNewestEvent) {
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        WindInfoForRaceDTO result = null;
        if (trackedRace != null) {
            MillisecondsTimePoint toTimePoint;
            MillisecondsTimePoint fromTimePoint;
            Object object = from == null ? (trackedRace.getStartOfTracking() == null ? trackedRace.getStartOfRace() : trackedRace.getStartOfTracking()) : (fromTimePoint = new MillisecondsTimePoint(from));
            Object object2 = to == null ? (trackedRace.getEndOfRace() == null ? (trackedRace.getEndOfTracking() == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : trackedRace.getEndOfTracking()) : trackedRace.getEndOfRace()) : (toTimePoint = new MillisecondsTimePoint(to));
            if (fromTimePoint != null && toTimePoint != null) {
                int numberOfFixes = Math.min(10000, (int)((toTimePoint.asMillis() - fromTimePoint.asMillis()) / resolutionInMilliseconds));
                result = this.getAveragedWindInfo((TimePoint)fromTimePoint, resolutionInMilliseconds, numberOfFixes, windSourceTypeNames, trackedRace, onlyUpToNewestEvent, false);
            }
        }
        return result;
    }

    public boolean getPolarResults(RegattaAndRaceIdentifier raceIdentifier) {
        boolean result;
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        PolarDataService polarData = this.getService().getPolarDataService();
        if (trackedRace == null || polarData == null) {
            result = false;
        } else {
            PolarDiagramGPS polarDiagram;
            BoatClass boatClass = trackedRace.getRace().getBoatClass();
            try {
                polarDiagram = new PolarDiagramGPS(boatClass, polarData);
            }
            catch (SparseSimulationDataException e) {
                polarDiagram = null;
            }
            result = polarDiagram != null;
        }
        return result;
    }

    public BearingWithConfidenceDTO getManeuverAngle(BoatClassDTO boatClassDto, ManeuverType maneuverType, Speed windSpeed) throws NotEnoughDataHasBeenAddedException, UnauthorizedException {
        BearingWithConfidenceDTO result = null;
        if (boatClassDto != null && maneuverType != null && (maneuverType == ManeuverType.TACK || maneuverType == ManeuverType.JIBE) && windSpeed != null) {
            BoatClass boatClass = this.baseDomainFactory.getBoatClass(boatClassDto.getName());
            PolarDataService polarDataService = this.getService().getPolarDataService();
            result = new BearingWithConfidenceDTO(polarDataService.getManeuverAngle(boatClass, maneuverType, windSpeed));
        }
        return result;
    }

    public SimulatorResultsDTO getSimulatorResults(LegIdentifier legIdentifier) {
        DynamicTrackedRace trackedRace = this.getService().getTrackedRace(legIdentifier.getRaceIdentifier());
        if (trackedRace == null) {
            throw new IllegalArgumentException("Race for leg " + legIdentifier + " not found!");
        }
        SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.SIMULATOR));
        SimulatorResultsDTO result = null;
        SimulationService simulationService = this.getService().getSimulationService();
        if (simulationService == null) {
            return result;
        }
        SimulationResults simulationResults = simulationService.getSimulationResults(legIdentifier);
        if (simulationResults == null) {
            return result;
        }
        Map paths = simulationResults.getPaths();
        if (paths != null) {
            int noOfPaths = paths.size();
            PathDTO[] pathDTOs = new PathDTO[noOfPaths];
            int index = noOfPaths - 1;
            for (Map.Entry entry : paths.entrySet()) {
                pathDTOs[index] = new PathDTO((PathType)entry.getKey());
                ArrayList<SimulatorWindDTO> wList = new ArrayList<SimulatorWindDTO>();
                for (TimedPositionWithSpeed p : ((Path)entry.getValue()).getPathPoints()) {
                    wList.add(this.createSimulatorWindDTO(p));
                }
                pathDTOs[index].setPoints(wList);
                pathDTOs[index].setAlgorithmTimedOut(((Path)entry.getValue()).getAlgorithmTimedOut());
                pathDTOs[index].setMixedLeg(((Path)entry.getValue()).getMixedLeg());
                --index;
            }
            RaceMapDataDTO rcDTO = new RaceMapDataDTO();
            rcDTO.coursePositions = new CoursePositionsDTO();
            rcDTO.coursePositions.waypointPositions = new ArrayList();
            rcDTO.coursePositions.waypointPositions.add(simulationResults.getStartPosition());
            rcDTO.coursePositions.waypointPositions.add(simulationResults.getEndPosition());
            result = new SimulatorResultsDTO(simulationResults.getVersion().asMillis(), legIdentifier.getOneBasedLegIndex(), simulationResults.getStartTime(), simulationResults.getTimeStep(), simulationResults.getLegDuration(), rcDTO, pathDTOs, null, null);
        }
        return result;
    }

    private SimulatorWindDTO createSimulatorWindDTO(TimedPositionWithSpeed timedPositionWithSpeed) {
        Position position = timedPositionWithSpeed.getPosition();
        SpeedWithBearing speedWithBearing = timedPositionWithSpeed.getSpeed();
        TimePoint timePoint = timedPositionWithSpeed.getTimePoint();
        SimulatorWindDTO result = new SimulatorWindDTO();
        if (speedWithBearing == null) {
            result.trueWindBearingDeg = 0.0;
            result.trueWindSpeedInKnots = 0.0;
        } else {
            result.trueWindBearingDeg = speedWithBearing.getBearing().getDegrees();
            result.trueWindSpeedInKnots = speedWithBearing.getKnots();
        }
        if (position != null) {
            result.position = position;
        }
        if (timePoint != null) {
            result.timepoint = timePoint;
        }
        return result;
    }

    public Map<CompetitorDTO, BoatDTO> getCompetitorBoats(RegattaAndRaceIdentifier raceIdentifier) {
        Map result = null;
        DynamicTrackedRace trackedRace = this.getService().getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace != null) {
            result = this.baseDomainFactory.convertToCompetitorAndBoatDTOs(trackedRace.getRace().getCompetitorsAndTheirBoats());
        }
        return result;
    }

    public RaceboardDataDTO getRaceboardData(String regattaName, String raceName, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, UUID eventId) {
        RaceDefinition race;
        RaceboardDataDTO result = new RaceboardDataDTO(null, false, false, Collections.emptyList(), Collections.emptyList(), null, null);
        RaceWithCompetitorsAndBoatsDTO raceDTO = null;
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta != null && (race = regatta.getRaceByName(raceName)) != null) {
            RegattaNameAndRaceName raceIdentifier = new RegattaNameAndRaceName(regatta.getName(), race.getName());
            DynamicTrackedRace trackedRace = this.getService().getExistingTrackedRace((RegattaAndRaceIdentifier)raceIdentifier);
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            if (trackedRace != null) {
                boolean isValidEvent;
                Event event;
                Map competitorsAndBoats = this.baseDomainFactory.convertToCompetitorAndBoatDTOs(race.getCompetitorsAndTheirBoats());
                TrackedRaceDTO trackedRaceDTO = this.getBaseDomainFactory().createTrackedRaceDTO((TrackedRace)trackedRace);
                raceDTO = new RaceWithCompetitorsAndBoatsDTO((RegattaAndRaceIdentifier)raceIdentifier, competitorsAndBoats, trackedRaceDTO, this.getService().isRaceBeingTracked(regatta, race), trackedRace.getRankingMetric().getType());
                if (trackedRace != null) {
                    this.getBaseDomainFactory().updateRaceDTOWithTrackedRaceData((TrackedRace)trackedRace, (RaceDTO)raceDTO);
                }
                raceDTO.boatClass = regatta.getBoatClass() == null ? null : regatta.getBoatClass().getName();
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)raceDTO);
                Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
                LeaderboardGroup leaderboardGroup = this.getLeaderboardGroupByIdOrName(leaderboardGroupId, leaderboardGroupName);
                Event event2 = event = eventId != null ? this.getService().getEvent((Serializable)eventId) : null;
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) {
                    event = null;
                }
                boolean isValidLeaderboardGroup = false;
                if (leaderboardGroup != null) {
                    for (Leaderboard leaderboardInGroup : leaderboardGroup.getLeaderboards()) {
                        if (!leaderboardInGroup.getName().equals(leaderboard.getName())) continue;
                        isValidLeaderboardGroup = true;
                        break;
                    }
                }
                boolean bl = isValidEvent = event != null;
                if (event != null && leaderboardGroup != null) {
                    isValidEvent = false;
                    for (LeaderboardGroup leaderboardGroupInEvent : event.getLeaderboardGroups()) {
                        if (!leaderboardGroupInEvent.getId().equals(leaderboardGroup.getId())) continue;
                        isValidEvent = true;
                        break;
                    }
                }
                Iterable detailTypesForCompetitorChart = this.determineDetailTypesForCompetitorChart(leaderboardGroupName, leaderboardGroupId, raceDTO.getRaceIdentifier());
                Iterable availableDetailTypesForLeaderboard = this.getAvailableDetailTypesForLeaderboard(leaderboardName, raceDTO.getRaceIdentifier());
                StrippedLeaderboardDTO leaderboardDTO = this.createStrippedLeaderboardDTO(leaderboard, false, false);
                TrackingConnectorInfo trackingConnectorInfo = trackedRace.getTrackingConnectorInfo();
                TrackingConnectorInfoDTO trackingConnectorInfoDTO = trackingConnectorInfo == null ? null : new TrackingConnectorInfoDTO(trackingConnectorInfo);
                result = new RaceboardDataDTO(raceDTO, isValidLeaderboardGroup, isValidEvent, detailTypesForCompetitorChart, availableDetailTypesForLeaderboard, leaderboardDTO, trackingConnectorInfoDTO);
            }
        }
        return result;
    }

    private LeaderboardGroup getLeaderboardGroupByIdOrName(UUID leaderboardGroupId, String leaderboardGroupName) {
        LeaderboardGroup leaderboardGroup = leaderboardGroupId != null ? this.getService().getLeaderboardGroupByID(leaderboardGroupId) : (leaderboardGroupName != null ? this.getService().getLeaderboardGroupByName(leaderboardGroupName) : null);
        return leaderboardGroup;
    }

    public CompactRaceMapDataDTO getRaceMapData(RegattaAndRaceIdentifier raceIdentifier, Date date, Map<String, Date> fromPerCompetitorIdAsString, Map<String, Date> toPerCompetitorIdAsString, boolean extrapolate, LegIdentifier simulationLegIdentifier, byte[] md5OfIdsAsStringOfCompetitorParticipatingInRaceInAlphanumericOrderOfTheirID, Date timeToGetTheEstimatedDurationFor, boolean estimatedDurationRequired, DetailType detailType, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId) throws NoWindException {
        HashSet<String> raceCompetitorIdsAsStrings;
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace == null || Arrays.equals(md5OfIdsAsStringOfCompetitorParticipatingInRaceInAlphanumericOrderOfTheirID, trackedRace.getRace().getCompetitorMD5())) {
            raceCompetitorIdsAsStrings = null;
        } else {
            raceCompetitorIdsAsStrings = new HashSet<String>();
            for (Competitor c : trackedRace.getRace().getCompetitors()) {
                raceCompetitorIdsAsStrings.add(c.getId().toString());
            }
        }
        Duration estimatedDuration = estimatedDurationRequired ? this.getEstimationForTargetTime(timeToGetTheEstimatedDurationFor, trackedRace) : null;
        Map boatPositions = this.getBoatPositionsInternal(raceIdentifier, fromPerCompetitorIdAsString, toPerCompetitorIdAsString, extrapolate, detailType, leaderboardName, leaderboardGroupName, leaderboardGroupId);
        CoursePositionsDTO coursePositions = this.getCoursePositions(raceIdentifier, date);
        List courseSidelines = this.getCourseSidelines(raceIdentifier, date);
        QuickRanksDTO quickRanks = this.getQuickRanksWithoutSecuritychecks(raceIdentifier, date);
        long simulationResultVersion = 0L;
        if (simulationLegIdentifier != null) {
            SimulationService simulationService = this.getService().getSimulationService();
            simulationResultVersion = simulationService.getSimulationResultsVersion(simulationLegIdentifier);
        }
        return new CompactRaceMapDataDTO(boatPositions, coursePositions, courseSidelines, quickRanks, simulationResultVersion, raceCompetitorIdsAsStrings, estimatedDuration);
    }

    private Duration getEstimationForTargetTime(Date time, TrackedRace trackedRace) {
        Duration estimatedDuration = null;
        if (trackedRace != null) {
            try {
                estimatedDuration = trackedRace.getEstimatedTimeToComplete((TimePoint)new MillisecondsTimePoint(time)).getExpectedDuration();
            }
            catch (NoWindException | NotEnoughDataHasBeenAddedException e) {
                logger.log(Level.WARNING, "Problem computing the estimated race duration for " + trackedRace.getRace().getName() + " / " + trackedRace.getTrackedRegatta().getRegatta().getName() + ": " + e.getMessage(), e);
            }
        }
        return estimatedDuration;
    }

    public CompactBoatPositionsDTO getBoatPositions(RegattaAndRaceIdentifier raceIdentifier, Map<String, Date> fromPerCompetitorIdAsString, Map<String, Date> toPerCompetitorIdAsString, boolean extrapolate, DetailType detailType, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId) throws NoWindException {
        return new CompactBoatPositionsDTO(this.getBoatPositionsInternal(raceIdentifier, fromPerCompetitorIdAsString, toPerCompetitorIdAsString, extrapolate, detailType, leaderboardName, leaderboardGroupName, leaderboardGroupId));
    }

    private Map<CompetitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable> getBoatPositionsInternal(RegattaAndRaceIdentifier raceIdentifier, Map<String, Date> fromPerCompetitorIdAsString, Map<String, Date> toPerCompetitorIdAsString, boolean extrapolate, DetailType detailType, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId) throws NoWindException {
        DetailType effectiveDetailTypeAfterPermissionCheck;
        HashMap<CompetitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable> result = new HashMap<CompetitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable>();
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        Object object = detailType == null ? null : (effectiveDetailTypeAfterPermissionCheck = detailType.getPremiumAction() == null || this.getSecurityService().hasCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)this.getLeaderboard(leaderboardName), new HasPermissions.Action[]{detailType.getPremiumAction()}) ? detailType : null);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                if (!fromPerCompetitorIdAsString.containsKey(competitor.getId().toString())) continue;
                CompetitorDTO competitorDTO = this.baseDomainFactory.convertToCompetitorDTO(competitor);
                GPSFixTrack track = trackedRace.getTrack(competitor);
                MillisecondsTimePoint fromTimePoint = new MillisecondsTimePoint(fromPerCompetitorIdAsString.get(competitorDTO.getIdAsString()));
                MillisecondsTimePoint toTimePointExcluding = new MillisecondsTimePoint(toPerCompetitorIdAsString.get(competitorDTO.getIdAsString()));
                result.put(competitorDTO, new GPSFixDTOWithSpeedWindTackAndLegTypeIterable(competitor, this, trackedRace, effectiveDetailTypeAfterPermissionCheck, track, (TimePoint)fromTimePoint, (TimePoint)toTimePointExcluding, extrapolate, leaderboardName, leaderboardGroupName, leaderboardGroupId));
            }
        }
        return result;
    }

    public SpeedWithBearingDTO createSpeedWithBearingDTO(SpeedWithBearing speedWithBearing) {
        return new SpeedWithBearingDTO(speedWithBearing.getKnots(), speedWithBearing.getBearing().getDegrees());
    }

    public GPSFixDTOWithSpeedWindTackAndLegType createGPSFixDTO(GPSFix fix, SpeedWithBearing speedWithBearing, Bearing optionalTrueHeading, WindDTO windDTO, Tack tack, LegType legType, boolean extrapolated, Double detailValue) {
        return new GPSFixDTOWithSpeedWindTackAndLegType(fix.getTimePoint().asDate(), fix.getPosition() == null ? null : fix.getPosition(), speedWithBearing == null ? null : this.createSpeedWithBearingDTO(speedWithBearing), optionalTrueHeading, windDTO, tack, legType, extrapolated, detailValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaceTimesInfoDTO getRaceTimesInfo(RegattaAndRaceIdentifier raceIdentifier) {
        RaceTimesInfoDTO raceTimesInfo = null;
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            Iterable markPassingsTimes;
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            raceTimesInfo = new RaceTimesInfoDTO(raceIdentifier);
            ArrayList<LegInfoDTO> legInfos = new ArrayList<LegInfoDTO>();
            raceTimesInfo.setLegInfos(legInfos);
            ArrayList<MarkPassingTimesDTO> markPassingTimesDTOs = new ArrayList<MarkPassingTimesDTO>();
            raceTimesInfo.setMarkPassingTimes(markPassingTimesDTOs);
            raceTimesInfo.startOfRace = trackedRace.getStartOfRace() == null ? null : trackedRace.getStartOfRace().asDate();
            raceTimesInfo.startOfTracking = trackedRace.getStartOfTracking() == null ? null : trackedRace.getStartOfTracking().asDate();
            raceTimesInfo.newestTrackingEvent = trackedRace.getTimePointOfNewestEvent() == null ? null : trackedRace.getTimePointOfNewestEvent().asDate();
            raceTimesInfo.endOfTracking = trackedRace.getEndOfTracking() == null ? null : trackedRace.getEndOfTracking().asDate();
            raceTimesInfo.endOfRace = trackedRace.getEndOfRace() == null ? null : trackedRace.getEndOfRace().asDate();
            raceTimesInfo.raceFinishingTime = trackedRace.getFinishingTime() == null ? null : trackedRace.getFinishingTime().asDate();
            raceTimesInfo.raceFinishedTime = trackedRace.getFinishedTime() == null ? null : trackedRace.getFinishedTime().asDate();
            raceTimesInfo.delayToLiveInMs = trackedRace.getDelayToLiveInMillis();
            Iterable iterable = markPassingsTimes = trackedRace.getMarkPassingsTimes();
            synchronized (iterable) {
                int numberOfWaypoints = Util.size((Iterable)markPassingsTimes);
                int wayPointNumber = 1;
                for (Util.Pair markPassingTimes : markPassingsTimes) {
                    String name = "M" + (wayPointNumber - 1);
                    if (wayPointNumber == numberOfWaypoints) {
                        name = "F";
                    }
                    MarkPassingTimesDTO markPassingTimesDTO = new MarkPassingTimesDTO(name);
                    Util.Pair timesPair = (Util.Pair)markPassingTimes.getB();
                    TimePoint firstPassingTime = (TimePoint)timesPair.getA();
                    TimePoint lastPassingTime = (TimePoint)timesPair.getB();
                    markPassingTimesDTO.firstPassingDate = firstPassingTime == null ? null : firstPassingTime.asDate();
                    markPassingTimesDTO.lastPassingDate = lastPassingTime == null ? null : lastPassingTime.asDate();
                    markPassingTimesDTOs.add(markPassingTimesDTO);
                    ++wayPointNumber;
                }
            }
            trackedRace.getRace().getCourse().lockForRead();
            try {
                Iterable trackedLegs = trackedRace.getTrackedLegs();
                int legNumber = 1;
                for (TrackedLeg trackedLeg : trackedLegs) {
                    LegInfoDTO legInfoDTO = new LegInfoDTO(legNumber);
                    legInfoDTO.setName("L" + legNumber);
                    try {
                        MarkPassingTimesDTO markPassingTimesDTO = (MarkPassingTimesDTO)markPassingTimesDTOs.get(legNumber - 1);
                        if (markPassingTimesDTO.firstPassingDate != null) {
                            MillisecondsTimePoint p = new MillisecondsTimePoint(markPassingTimesDTO.firstPassingDate);
                            legInfoDTO.legType = trackedLeg.getLegType((TimePoint)p);
                            legInfoDTO.legBearingInDegrees = trackedLeg.getLegBearing((TimePoint)p).getDegrees();
                        }
                    }
                    catch (NoWindException noWindException) {
                        // empty catch block
                    }
                    legInfos.add(legInfoDTO);
                    ++legNumber;
                }
            }
            finally {
                trackedRace.getRace().getCourse().unlockAfterRead();
            }
        }
        if (raceTimesInfo != null) {
            raceTimesInfo.currentServerTime = new Date();
        }
        return raceTimesInfo;
    }

    public List<RaceTimesInfoDTO> getRaceTimesInfos(Collection<RegattaAndRaceIdentifier> raceIdentifiers) {
        ArrayList<RaceTimesInfoDTO> raceTimesInfos = new ArrayList<RaceTimesInfoDTO>();
        for (RegattaAndRaceIdentifier raceIdentifier : raceIdentifiers) {
            RaceTimesInfoDTO raceTimesInfo;
            TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
            if (trackedRace != null && !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace) || (raceTimesInfo = this.getRaceTimesInfo(raceIdentifier)) == null) continue;
            raceTimesInfos.add(raceTimesInfo);
        }
        return raceTimesInfos;
    }

    private List<SidelineDTO> getCourseSidelines(RegattaAndRaceIdentifier raceIdentifier, Date date) {
        ArrayList<SidelineDTO> result = new ArrayList<SidelineDTO>();
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            Object dateAsTimePoint = date == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : new MillisecondsTimePoint(date);
            for (Sideline sideline : trackedRace.getCourseSidelines()) {
                ArrayList<MarkDTO> markDTOs = new ArrayList<MarkDTO>();
                for (Mark mark : sideline.getMarks()) {
                    GPSFixTrack track = trackedRace.getOrCreateTrack(mark);
                    Position positionAtDate = track.getEstimatedPosition(dateAsTimePoint, false);
                    if (positionAtDate == null) continue;
                    markDTOs.add(this.convertToMarkDTO(mark, positionAtDate));
                }
                result.add(new SidelineDTO(sideline.getName(), markDTOs));
            }
        }
        return result;
    }

    public CoursePositionsDTO getCoursePositions(RegattaAndRaceIdentifier raceIdentifier, Date date) {
        CoursePositionsDTO result = new CoursePositionsDTO();
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            LineDetails markPositionDTOsAndLineAdvantage;
            Waypoint lastWaypoint;
            LineDetails markPositionDTOsAndLineAdvantage2;
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            Object dateAsTimePoint = date == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : new MillisecondsTimePoint(date);
            result.totalLegsCount = trackedRace.getRace().getCourse().getLegs().size();
            result.currentLegNumber = trackedRace.getLastLegStarted(dateAsTimePoint);
            result.marks = new HashSet();
            result.course = this.convertToRaceCourseDTO((CourseBase)trackedRace.getRace().getCourse(), (MarkPositionFinder)new TrackedRaceMarkPositionFinder(this, trackedRace), dateAsTimePoint);
            result.waypointPositions = new ArrayList();
            HashSet<Mark> marks = new HashSet<Mark>();
            Course course = trackedRace.getRace().getCourse();
            for (Waypoint waypoint : course.getWaypoints()) {
                Position waypointPosition = trackedRace.getApproximatePosition(waypoint, dateAsTimePoint);
                if (waypointPosition != null) {
                    result.waypointPositions.add(waypointPosition);
                }
                for (Mark b : waypoint.getMarks()) {
                    marks.add(b);
                }
            }
            for (WaypointDTO waypointDTO : result.course.waypoints) {
                for (MarkDTO markDTO : waypointDTO.controlPoint.getMarks()) {
                    if (markDTO.position == null) continue;
                    result.marks.add(markDTO);
                }
            }
            Waypoint firstWaypoint = course.getFirstWaypoint();
            if (firstWaypoint != null && Util.size((Iterable)firstWaypoint.getMarks()) == 2 && (markPositionDTOsAndLineAdvantage2 = trackedRace.getStartLine(dateAsTimePoint)) != null) {
                result.startLineLengthInMeters = markPositionDTOsAndLineAdvantage2.getLength().getMeters();
                Bearing angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind = markPositionDTOsAndLineAdvantage2.getAngleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind();
                result.startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind = angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind == null ? null : Double.valueOf(angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind.getDegrees());
                result.startLineAdvantageousSide = markPositionDTOsAndLineAdvantage2.getAdvantageousSideWhileApproachingLine();
                Distance advantage = markPositionDTOsAndLineAdvantage2.getAdvantage();
                Double d = result.startLineAdvantageInMeters = advantage == null ? null : Double.valueOf(advantage.getMeters());
            }
            if ((lastWaypoint = course.getLastWaypoint()) != null && Util.size((Iterable)lastWaypoint.getMarks()) == 2 && (markPositionDTOsAndLineAdvantage = trackedRace.getFinishLine(dateAsTimePoint)) != null) {
                result.finishLineLengthInMeters = markPositionDTOsAndLineAdvantage.getLength().getMeters();
                Bearing angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind = markPositionDTOsAndLineAdvantage.getAngleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind();
                result.finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind = angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind == null ? null : Double.valueOf(angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind.getDegrees());
                result.finishLineAdvantageousSide = markPositionDTOsAndLineAdvantage.getAdvantageousSideWhileApproachingLine();
                Distance advantage = markPositionDTOsAndLineAdvantage.getAdvantage();
                result.finishLineAdvantageInMeters = advantage == null ? null : Double.valueOf(advantage.getMeters());
            }
        }
        return result;
    }

    public RaceCourseDTO getRaceCourse(RegattaAndRaceIdentifier raceIdentifier, Date date) {
        ArrayList<WaypointDTO> waypointDTOs = new ArrayList<WaypointDTO>();
        HashMap<Serializable, ControlPointDTO> controlPointCache = new HashMap<Serializable, ControlPointDTO>();
        MillisecondsTimePoint dateAsTimePoint = new MillisecondsTimePoint(date);
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        ArrayList<MarkDTO> allMarks = new ArrayList<MarkDTO>();
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            for (Mark mark : trackedRace.getMarks()) {
                Position pos = trackedRace.getOrCreateTrack(mark).getEstimatedPosition((TimePoint)dateAsTimePoint, false);
                allMarks.add(this.convertToMarkDTO(mark, pos));
            }
            Course course = trackedRace.getRace().getCourse();
            for (Waypoint waypoint : course.getWaypoints()) {
                ControlPointDTO controlPointDTO = (ControlPointDTO)controlPointCache.get(waypoint.getControlPoint().getId());
                if (controlPointDTO == null) {
                    controlPointDTO = this.convertToControlPointDTO(waypoint.getControlPoint(), (MarkPositionFinder)new TrackedRaceMarkPositionFinder(this, trackedRace), (TimePoint)dateAsTimePoint);
                    controlPointCache.put(waypoint.getControlPoint().getId(), controlPointDTO);
                }
                WaypointDTO waypointDTO = new WaypointDTO(waypoint.getName(), controlPointDTO, waypoint.getPassingInstructions());
                waypointDTOs.add(waypointDTO);
            }
        }
        return new RaceCourseDTO(waypointDTOs, allMarks);
    }

    private ControlPointDTO convertToControlPointDTO(ControlPoint controlPoint, MarkPositionFinder positionFinder, TimePoint timePoint) {
        MarkDTO result;
        if (controlPoint instanceof ControlPointWithTwoMarks) {
            Mark left = ((ControlPointWithTwoMarks)controlPoint).getLeft();
            Position leftPos = positionFinder.find(left, timePoint);
            Mark right = ((ControlPointWithTwoMarks)controlPoint).getRight();
            Position rightPos = positionFinder.find(right, timePoint);
            result = new GateDTO(controlPoint.getId().toString(), controlPoint.getName(), this.convertToMarkDTO(left, leftPos), this.convertToMarkDTO(right, rightPos), controlPoint.getShortName());
        } else {
            Mark mark = (Mark)controlPoint.getMarks().iterator().next();
            Position position = positionFinder.find(mark, timePoint);
            result = this.convertToMarkDTO(mark, position);
        }
        return result;
    }

    protected ControlPoint getOrCreateControlPoint(ControlPointDTO dto) {
        String idAsString = dto.getIdAsString();
        if (idAsString == null) {
            idAsString = UUID.randomUUID().toString();
        }
        if (dto instanceof GateDTO) {
            GateDTO gateDTO = (GateDTO)dto;
            Mark left = (Mark)this.getOrCreateControlPoint((ControlPointDTO)gateDTO.getLeft());
            Mark right = (Mark)this.getOrCreateControlPoint((ControlPointDTO)gateDTO.getRight());
            return this.baseDomainFactory.getOrCreateControlPointWithTwoMarks(idAsString, gateDTO.getName(), left, right, gateDTO.getShortName());
        }
        MarkDTO markDTO = (MarkDTO)dto;
        return this.baseDomainFactory.getOrCreateMark(idAsString, dto.getName(), markDTO.getShortName(), markDTO.type, markDTO.color, markDTO.shape, markDTO.pattern);
    }

    public QuickRanksDTO computeQuickRanks(RegattaAndRaceIdentifier raceIdentifier, TimePoint timePoint) throws NoWindException {
        ArrayList<QuickRankDTO> result = new ArrayList<QuickRankDTO>();
        DynamicTrackedRace trackedRace = this.getService().getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            TimePoint actualTimePoint = timePoint == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : timePoint;
            RaceDefinition race = trackedRace.getRace();
            int oneBasedRank = 1;
            Iterable competitorsFromBestToWorst = trackedRace.getCompetitorsFromBestToWorst(actualTimePoint);
            for (Competitor competitor : competitorsFromBestToWorst) {
                TrackedLegOfCompetitor trackedLeg = trackedRace.getTrackedLeg(competitor, actualTimePoint);
                if (trackedLeg != null || !trackedRace.getMarkPassings(competitor).isEmpty()) {
                    int legNumberOneBased = trackedLeg == null ? 0 : race.getCourse().getLegs().indexOf(trackedLeg.getLeg()) + 1;
                    Boat boatOfCompetitor = trackedRace.getBoatOfCompetitor(competitor);
                    QuickRankDTO quickRankDTO = new QuickRankDTO(this.baseDomainFactory.convertToCompetitorAndBoatDTO(competitor, boatOfCompetitor).getCompetitor(), oneBasedRank, legNumberOneBased);
                    result.add(quickRankDTO);
                }
                ++oneBasedRank;
            }
        }
        return new QuickRanksDTO(result);
    }

    private QuickRanksDTO getQuickRanksWithoutSecuritychecks(RegattaAndRaceIdentifier raceIdentifier, Date date) throws NoWindException {
        QuickRanksDTO result = date == null ? this.quickRanksLiveCache.get(raceIdentifier) : this.computeQuickRanks(raceIdentifier, (TimePoint)new MillisecondsTimePoint(date));
        return result;
    }

    public WindInfoForRaceDTO getWindSourcesInfo(RegattaAndRaceIdentifier raceIdentifier) {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)raceIdentifier);
        WindInfoForRaceDTO result = null;
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            HashMap<Object, WindTrackInfoDTO> windTrackInfoDTOs;
            result = new WindInfoForRaceDTO();
            result.raceIsKnownToStartUpwind = trackedRace.raceIsKnownToStartUpwind();
            ArrayList<WindSource> windSourcesToExclude = new ArrayList<WindSource>();
            for (WindSource windSourceToExclude : trackedRace.getWindSourcesToExclude()) {
                windSourcesToExclude.add(windSourceToExclude);
            }
            result.windSourcesToExclude = windSourcesToExclude;
            result.windTrackInfoByWindSource = windTrackInfoDTOs = new HashMap<Object, WindTrackInfoDTO>();
            for (WindSource windSource : trackedRace.getWindSources()) {
                windTrackInfoDTOs.put(windSource, new WindTrackInfoDTO());
            }
            windTrackInfoDTOs.put(new WindSourceImpl(WindSourceType.COMBINED), new WindTrackInfoDTO());
        }
        return result;
    }

    protected RacingEventService getService() {
        try {
            return (RacingEventService)this.racingEventServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected AIAgent getAIAgent() {
        return (AIAgent)this.aiAgentTracker.getService();
    }

    protected SharedSailingData getSharedSailingData() {
        try {
            return (SharedSailingData)this.sharedSailingDataTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected ReplicationService getReplicationService() {
        try {
            return (ReplicationService)this.replicationServiceTracker.waitForService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getLeaderboardNames() {
        return this.getLeaderboardNamesFilteredForCurrentUser();
    }

    private ArrayList<String> getLeaderboardNamesFilteredForCurrentUser() {
        ArrayList<String> result = new ArrayList<String>();
        this.getSecurityService().filterObjectsWithPermissionForCurrentUser((HasPermissions.Action)HasPermissions.DefaultActions.READ, this.getService().getLeaderboards().values(), l -> {
            boolean bl = result.add(l.getName());
        });
        return result;
    }

    public List<StrippedLeaderboardDTO> getLeaderboardsWithSecurity() {
        Map leaderboards = this.getService().getLeaderboards();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(leaderboards.values(), leaderboard -> this.createStrippedLeaderboardDTO(leaderboard, false, false));
    }

    public StrippedLeaderboardDTO getLeaderboardWithSecurity(String leaderboardName) {
        Leaderboard leaderboard = this.getLeaderboardAndCheckReadPermission(leaderboardName);
        StrippedLeaderboardDTO result = leaderboard != null ? this.createStrippedLeaderboardDTO(leaderboard, false, false) : null;
        return result;
    }

    private Leaderboard getLeaderboardAndCheckReadPermission(String leaderboardName) {
        Map leaderboards = this.getService().getLeaderboards();
        Leaderboard leaderboard = (Leaderboard)leaderboards.get(leaderboardName);
        if (leaderboard != null) {
            if (leaderboard instanceof RegattaLeaderboard) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderboard).getRegatta());
            }
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        }
        return leaderboard;
    }

    public StrippedLeaderboardDTO getLeaderboard(String leaderboardName) {
        Leaderboard leaderboard = this.getLeaderboardAndCheckReadPermission(leaderboardName);
        StrippedLeaderboardDTO result = leaderboard != null ? this.createStrippedLeaderboardDTO(leaderboard, false, false) : null;
        return result;
    }

    protected StrippedLeaderboardDTO createStrippedLeaderboardDTO(Leaderboard leaderboard, boolean withGeoLocationData, boolean withStatisticalData) {
        StrippedLeaderboardDTO leaderboardDTO = new StrippedLeaderboardDTO(leaderboard.getName(), this.convertToBoatClassDTO(leaderboard.getBoatClass()));
        this.fillLeaderboardData(leaderboard, withGeoLocationData, withStatisticalData, leaderboardDTO);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)leaderboardDTO);
        return leaderboardDTO;
    }

    private void fillLeaderboardData(Leaderboard leaderboard, boolean withGeoLocationData, boolean withStatisticalData, StrippedLeaderboardDTO leaderboardDTO) {
        leaderboardDTO.displayName = leaderboard.getDisplayName();
        leaderboardDTO.competitorDisplayNames = new HashMap();
        leaderboardDTO.competitorsCount = Util.size((Iterable)leaderboard.getCompetitors());
        leaderboardDTO.boatClassName = leaderboard.getBoatClass() == null ? null : leaderboard.getBoatClass().getName();
        leaderboardDTO.type = leaderboard.getLeaderboardType();
        if (leaderboard instanceof RegattaLeaderboard) {
            RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
            Regatta regatta = regattaLeaderboard.getRegatta();
            leaderboardDTO.regattaName = regatta.getName();
            leaderboardDTO.scoringScheme = regatta.getScoringScheme().getType();
            leaderboardDTO.canBoatsOfCompetitorsChangePerRace = regatta.canBoatsOfCompetitorsChangePerRace();
            if (leaderboard instanceof RegattaLeaderboardWithOtherTieBreakingLeaderboard) {
                leaderboardDTO.setOtherTieBreakingLeaderboardName(((RegattaLeaderboardWithOtherTieBreakingLeaderboard)leaderboard).getOtherTieBreakingLeaderboard().getName());
            }
        } else {
            leaderboardDTO.scoringScheme = leaderboard.getScoringScheme().getType();
            leaderboardDTO.canBoatsOfCompetitorsChangePerRace = false;
        }
        leaderboardDTO.courseAreas = new ArrayList();
        Util.addAll((Iterable)Util.map((Iterable)leaderboard.getCourseAreas(), arg_0 -> this.convertToCourseAreaDTO(arg_0)), (Collection)leaderboardDTO.courseAreas);
        leaderboardDTO.setDelayToLiveInMillisForLatestRace(leaderboard.getDelayToLiveInMillis());
        leaderboardDTO.hasCarriedPoints = leaderboard.hasCarriedPoints();
        leaderboardDTO.discardThresholds = (int[])(leaderboard.getResultDiscardingRule() instanceof ThresholdBasedResultDiscardingRule ? ((ThresholdBasedResultDiscardingRule)leaderboard.getResultDiscardingRule()).getDiscardIndexResultsStartingWithHowManyRaces() : null);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                boolean competitorRegistrationsExist;
                boolean raceLogTrackerExists;
                RaceLogTrackingState raceLogTrackingState;
                RaceDTO raceDTO = null;
                RegattaNameAndRaceName raceIdentifier = null;
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace != null) {
                    raceIdentifier = new RegattaNameAndRaceName(trackedRace.getTrackedRegatta().getRegatta().getName(), trackedRace.getRace().getName());
                    raceDTO = this.baseDomainFactory.createRaceDTO((TrackedRegattaRegistry)this.getService(), withGeoLocationData, (RegattaAndRaceIdentifier)raceIdentifier, trackedRace);
                    if (withStatisticalData) {
                        Iterable mediaTracksForRace = this.getService().getMediaTracksForRace((RegattaAndRaceIdentifier)raceIdentifier);
                        raceDTO.trackedRaceStatistics = this.baseDomainFactory.createTrackedRaceStatisticsDTO(trackedRace, leaderboard, raceColumn, fleet, mediaTracksForRace);
                    }
                }
                FleetDTO fleetDTO = this.baseDomainFactory.convertToFleetDTO(fleet);
                RaceColumnDTO raceColumnDTO = leaderboardDTO.addRace(raceColumn.getName(), raceColumn.getExplicitFactor(), leaderboard.getScoringScheme().getScoreFactor(raceColumn), raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getRegatta().getName() : null, raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getSeries().getName() : null, fleetDTO, raceColumn.isMedalRace(), (RegattaAndRaceIdentifier)raceIdentifier, raceDTO, raceColumn instanceof MetaLeaderboardColumn, raceColumn.isOneAlwaysStaysOne());
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                RaceLogTrackingState raceLogTrackingState2 = raceLogTrackingState = raceLog == null ? RaceLogTrackingState.NOT_A_RACELOG_TRACKED_RACE : (RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog).analyze();
                boolean bl = raceLog == null ? false : (raceLogTrackerExists = this.getService().getRaceTrackerById((Object)raceLog.getId()) != null);
                boolean bl2 = raceLog == null ? false : (competitorRegistrationsExist = !Util.isEmpty(raceColumn.getAllCompetitorsAndTheirBoats(fleet).keySet()));
                boolean courseExist = raceLog == null ? false : !Util.isEmpty((Iterable)raceColumn.getCourseMarks(fleet));
                RaceLogTrackingInfoDTO raceLogTrackingInfo = new RaceLogTrackingInfoDTO(raceLogTrackerExists, competitorRegistrationsExist, courseExist, raceLogTrackingState);
                raceColumnDTO.setRaceLogTrackingInfo(fleetDTO, raceLogTrackingInfo);
            }
        }
    }

    public Map<String, RegattaAndRaceIdentifier> getRegattaAndRaceNameOfTrackedRaceConnectedToLeaderboardColumn(String leaderboardName, String raceColumnName) {
        RaceColumn raceColumn;
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        HashMap<String, RegattaAndRaceIdentifier> result = new HashMap<String, RegattaAndRaceIdentifier>();
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace != null) {
                    result.put(fleet.getName(), trackedRace.getRaceIdentifier());
                    continue;
                }
                result.put(fleet.getName(), null);
            }
        }
        return result;
    }

    public List<SwissTimingConfigurationWithSecurityDTO> getPreviousSwissTimingConfigurations() {
        Iterable configs = this.swissTimingAdapterPersistence.getSwissTimingConfigurations();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(configs, stConfig -> {
            SwissTimingConfigurationWithSecurityDTO config = new SwissTimingConfigurationWithSecurityDTO(stConfig.getName(), stConfig.getJsonURL(), stConfig.getHostname(), stConfig.getPort(), stConfig.getUpdateURL(), stConfig.getUpdateUsername(), stConfig.getUpdatePassword(), stConfig.getCreatorName());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)config);
            return config;
        });
    }

    public SwissTimingEventRecordDTO getRacesOfSwissTimingEvent(String eventJsonURL) throws UnknownHostException, IOException, InterruptedException, java.text.ParseException, URISyntaxException {
        SwissTimingEventRecordDTO result = null;
        ArrayList<SwissTimingRaceRecordDTO> swissTimingRaces = new ArrayList<SwissTimingRaceRecordDTO>();
        Manage2SailEventResultsParserImpl parser = new Manage2SailEventResultsParserImpl();
        URL url = new URL(eventJsonURL);
        EventResultDescriptor eventResult = parser.getEventResult(url);
        if (eventResult != null) {
            for (RegattaResultDescriptor regattaResult : eventResult.getRegattaResults()) {
                for (RaceResultDescriptor race : regattaResult.getRaceResults()) {
                    if (race.isTracked() == null || !race.isTracked().booleanValue()) continue;
                    SwissTimingRaceRecordDTO swissTimingRaceRecordDTO = new SwissTimingRaceRecordDTO(race.getId(), race.getName(), regattaResult.getName(), race.getSeriesName(), race.getFleetName(), race.getStatus(), race.getStartTime(), regattaResult.getXrrEntriesUrl() != null ? regattaResult.getXrrEntriesUrl().toExternalForm() : null, this.hasRememberedRegatta((Serializable)((Object)race.getId())));
                    swissTimingRaceRecordDTO.boatClass = regattaResult.getIsafId() != null && !regattaResult.getIsafId().isEmpty() ? regattaResult.getIsafId() : regattaResult.getClassName();
                    swissTimingRaceRecordDTO.gender = regattaResult.getCompetitorGenderType().name();
                    swissTimingRaces.add(swissTimingRaceRecordDTO);
                }
            }
            result = new SwissTimingEventRecordDTO(eventResult.getId(), eventResult.getName(), eventResult.getTrackingDataHost(), eventResult.getTrackingDataPort(), swissTimingRaces);
        }
        return result;
    }

    protected RaceLogStore getRaceLogStore() {
        return MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(this.mongoObjectFactory, this.domainObjectFactory);
    }

    protected RegattaLogStore getRegattaLogStore() {
        return MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(this.mongoObjectFactory, this.domainObjectFactory);
    }

    protected MarkPassingRaceFingerprintRegistry getMarkPassingRaceFingerprintRegistry() {
        return this.getService();
    }

    protected SwissTimingReplayService getSwissTimingReplayService() {
        return this.swissTimingReplayService;
    }

    public List<SwissTimingReplayRaceDTO> listSwissTiminigReplayRaces(String swissTimingUrl) {
        List replayRaces = this.getSwissTimingReplayService().listReplayRaces(swissTimingUrl);
        ArrayList<SwissTimingReplayRaceDTO> result = new ArrayList<SwissTimingReplayRaceDTO>(replayRaces.size());
        for (SwissTimingReplayRace replayRace : replayRaces) {
            result.add(new SwissTimingReplayRaceDTO(replayRace.getFlightNumber(), replayRace.getRaceId(), replayRace.getRsc(), replayRace.getName(), replayRace.getBoatClass(), replayRace.getStartTime(), replayRace.getLink(), this.hasRememberedRegatta((Serializable)((Object)replayRace.getRaceId())), swissTimingUrl));
        }
        return result;
    }

    public void replaySwissTimingRace(RegattaIdentifier regattaIdentifier, Iterable<SwissTimingReplayRaceDTO> replayRaceDTOs, boolean trackWind, boolean correctWindByDeclination, boolean useInternalMarkPassingAlgorithm) {
        logger.info("replaySwissTimingRace for regatta " + regattaIdentifier + " for races " + replayRaceDTOs);
        for (SwissTimingReplayRaceDTO replayRaceDTO : replayRaceDTOs) {
            try {
                String boatClassName;
                if (regattaIdentifier == null) {
                    boatClassName = replayRaceDTO.boat_class;
                    String[] stringArray = new String[]{"Man", "Woman", "Men", "Women", "M", "W"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String genderIndicator = stringArray[n2];
                        Pattern p = Pattern.compile("(( - )|-| )" + genderIndicator + "$");
                        Matcher m = p.matcher(boatClassName.trim());
                        if (m.find()) {
                            boatClassName = boatClassName.trim().substring(0, m.start(1));
                            break;
                        }
                        ++n2;
                    }
                } else {
                    boatClassName = null;
                }
                this.getSwissTimingReplayService().loadRaceData(regattaIdentifier, replayRaceDTO.link, replayRaceDTO.swissTimingUrl, replayRaceDTO.getName(), replayRaceDTO.race_id, boatClassName, (TrackerManager)this.getService(), (TrackedRegattaRegistry)this.getService(), useInternalMarkPassingAlgorithm, this.getRaceLogStore(), this.getRegattaLogStore(), this.getMarkPassingRaceFingerprintRegistry());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error trying to load SwissTimingReplay race " + replayRaceDTO, e);
            }
        }
    }

    private Competitor getCompetitorByIdAsString(Iterable<Competitor> competitors, String idAsString) {
        for (Competitor c : competitors) {
            if (!c.getId().toString().equals(idAsString)) continue;
            return c;
        }
        return null;
    }

    public CompetitorsRaceDataDTO getCompetitorsRaceData(RegattaAndRaceIdentifier race, List<CompetitorDTO> competitors, Date from, Date to, long stepSizeInMillis, DetailType detailType, String leaderboardGroupName, UUID leaderboardGroupId, String leaderboardName) throws NoWindException, NotFoundException {
        CompetitorsRaceDataDTO result = null;
        TrackedRace trackedRace = this.getExistingTrackedRace(race);
        if (trackedRace != null) {
            Leaderboard leaderboard;
            if (detailType.getPremiumAction() != null && (leaderboard = this.getLeaderboardByName(leaderboardName)).getPermissionType().supports(detailType.getPremiumAction())) {
                this.getSecurityService().checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)leaderboard, new HasPermissions.Action[]{detailType.getPremiumAction()});
            }
            TimePoint newestEvent = trackedRace.getTimePointOfNewestEvent();
            TimePoint startTime = from == null ? trackedRace.getStartOfTracking() : new MillisecondsTimePoint(from);
            TimePoint endTime = to == null || to.after(newestEvent.asDate()) ? newestEvent : new MillisecondsTimePoint(to);
            long adjustedStepSizeInMillis = (long)Math.max((double)stepSizeInMillis, (double)startTime.until(endTime).divide(10000L).asMillis());
            result = new CompetitorsRaceDataDTO(detailType, startTime == null ? null : startTime.asDate(), endTime == null ? null : endTime.asDate());
            int MAX_CACHE_SIZE = 10000;
            ConcurrentHashMap cachesByTimePoint = new ConcurrentHashMap();
            HashMap resultFutures = new HashMap();
            for (CompetitorDTO competitorDTO : competitors) {
                FutureTask future = new FutureTask(new /* Unavailable Anonymous Inner Class!! */);
                resultFutures.put(competitorDTO, future);
                this.executor.execute(future);
            }
            for (Map.Entry entry : resultFutures.entrySet()) {
                CompetitorRaceDataDTO competitorData;
                try {
                    competitorData = (CompetitorRaceDataDTO)((FutureTask)entry.getValue()).get();
                }
                catch (InterruptedException e1) {
                    competitorData = null;
                    logger.log(Level.SEVERE, "Exception while trying to compute competitor data " + detailType + " for competitor " + ((CompetitorDTO)entry.getKey()).getName(), e1);
                }
                catch (ExecutionException e1) {
                    competitorData = null;
                    logger.log(Level.SEVERE, "Exception while trying to compute competitor data " + detailType + " for competitor " + ((CompetitorDTO)entry.getKey()).getName(), e1);
                }
                result.setCompetitorData((CompetitorDTO)entry.getKey(), competitorData);
            }
        }
        return result;
    }

    public Double getCompetitorRaceDataEntry(DetailType detailType, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint, String leaderboardGroupName, UUID leaderboardGroupId, String leaderboardName, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NoWindException, NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException {
        return this.getService().getCompetitorRaceDataEntry(detailType, trackedRace, competitor, timePoint, this.getLeaderboardGroupByIdOrName(leaderboardGroupId, leaderboardGroupName), leaderboardName, cache);
    }

    /*
     * Exception decompiling
     */
    public List<Util.Triple<String, List<CompetitorDTO>, List<Double>>> getLeaderboardDataEntriesForAllRaceColumns(String leaderboardName, Date date, DetailType detailType) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Util.Pair<String, String>> getLeaderboardsNamesOfMetaLeaderboard(String metaLeaderboardName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(metaLeaderboardName);
        if (leaderboard == null) {
            throw new IllegalArgumentException("Couldn't find leaderboard named " + metaLeaderboardName);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard instanceof RegattaLeaderboard) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderboard).getRegatta());
        }
        if (!(leaderboard instanceof MetaLeaderboard)) {
            throw new IllegalArgumentException("The leaderboard " + metaLeaderboardName + " is not a metaleaderboard");
        }
        MetaLeaderboard metaLeaderboard = (MetaLeaderboard)leaderboard;
        LeaderboardGroup groupOrNull = null;
        for (LeaderboardGroup lg : this.getService().getLeaderboardGroups().values()) {
            if (!metaLeaderboard.equals(lg.getOverallLeaderboard()) || !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)lg)) continue;
            groupOrNull = lg;
            break;
        }
        Iterable leaderBoards = groupOrNull != null ? HomeServiceUtil.getLeaderboardsForSeriesInOrderWithReadPermissions(groupOrNull, (RacingEventService)this.getService()) : metaLeaderboard.getLeaderboards();
        ArrayList<Util.Pair<String, String>> result = new ArrayList<Util.Pair<String, String>>();
        for (Leaderboard containedLeaderboard : leaderBoards) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)containedLeaderboard)) continue;
            if (containedLeaderboard instanceof RegattaLeaderboard) {
                Regatta regatta = ((RegattaLeaderboard)containedLeaderboard).getRegatta();
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta)) continue;
                result.add((Util.Pair<String, String>)new Util.Pair((Object)containedLeaderboard.getName(), (Object)(containedLeaderboard.getDisplayName() != null ? containedLeaderboard.getDisplayName() : containedLeaderboard.getName())));
                continue;
            }
            result.add((Util.Pair<String, String>)new Util.Pair((Object)containedLeaderboard.getName(), (Object)(containedLeaderboard.getDisplayName() != null ? containedLeaderboard.getDisplayName() : containedLeaderboard.getName())));
        }
        return result;
    }

    public Map<CompetitorDTO, List<GPSFixDTOWithSpeedWindTackAndLegType>> getDouglasPoints(RegattaAndRaceIdentifier raceIdentifier, Map<CompetitorDTO, TimeRange> competitorTimeRanges, double meters) throws NoWindException {
        HashMap<CompetitorDTO, List<GPSFixDTOWithSpeedWindTackAndLegType>> result = new HashMap<CompetitorDTO, List<GPSFixDTOWithSpeedWindTackAndLegType>>();
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace != null) {
            MeterDistance maxDistance = new MeterDistance(meters);
            for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                CompetitorDTO competitorDTO = this.baseDomainFactory.convertToCompetitorDTO(competitor);
                if (!competitorTimeRanges.containsKey(competitorDTO)) continue;
                GPSFixTrack gpsFixTrack = trackedRace.getTrack(competitor);
                TimeRange timeRange = competitorTimeRanges.get(competitorDTO);
                Iterable gpsFixApproximation = trackedRace.approximate(competitor, (Distance)maxDistance, timeRange.from(), timeRange.to());
                ArrayList<GPSFixDTOWithSpeedWindTackAndLegType> gpsFixDouglasList = new ArrayList<GPSFixDTOWithSpeedWindTackAndLegType>();
                GPSFix fix = null;
                for (GPSFix next : gpsFixApproximation) {
                    if (fix != null) {
                        Bearing bearing = fix.getPosition().getBearingGreatCircle(next.getPosition());
                        Speed speed = fix.getPosition().getDistance(next.getPosition()).inTime(next.getTimePoint().asMillis() - fix.getTimePoint().asMillis());
                        KnotSpeedWithBearingImpl speedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), bearing);
                        gpsFixDouglasList.add(this.createDouglasPeuckerGPSFixDTO(trackedRace, competitor, fix, (SpeedWithBearing)speedWithBearing));
                    }
                    fix = next;
                }
                if (fix != null) {
                    SpeedWithBearing speedWithBearing = gpsFixTrack.getEstimatedSpeed(fix.getTimePoint());
                    gpsFixDouglasList.add(this.createDouglasPeuckerGPSFixDTO(trackedRace, competitor, fix, speedWithBearing));
                }
                result.put(competitorDTO, gpsFixDouglasList);
            }
        }
        return result;
    }

    private GPSFixDTOWithSpeedWindTackAndLegType createDouglasPeuckerGPSFixDTO(TrackedRace trackedRace, Competitor competitor, GPSFix fix, SpeedWithBearing speedWithBearing) throws NoWindException {
        Tack tack;
        try {
            tack = trackedRace.getTack(competitor, fix.getTimePoint());
        }
        catch (NoWindException nwe) {
            tack = null;
        }
        TrackedLegOfCompetitor trackedLegOfCompetitor = trackedRace.getTrackedLeg(competitor, fix.getTimePoint());
        LegType legType = trackedLegOfCompetitor == null ? null : trackedRace.getTrackedLeg(trackedLegOfCompetitor.getLeg()).getLegType(fix.getTimePoint());
        Wind wind = trackedRace.getWind(fix.getPosition(), fix.getTimePoint());
        WindDTO windDTO = this.createWindDTOFromAlreadyAveraged(wind, fix.getTimePoint());
        GPSFixDTOWithSpeedWindTackAndLegType fixDTO = this.createGPSFixDTO(fix, speedWithBearing, null, windDTO, tack, legType, false, null);
        return fixDTO;
    }

    public Map<CompetitorDTO, List<ManeuverDTO>> getManeuvers(RegattaAndRaceIdentifier raceIdentifier, Map<CompetitorDTO, TimeRange> competitorTimeRanges) throws NoWindException {
        HashMap<CompetitorDTO, List<ManeuverDTO>> result = new HashMap<CompetitorDTO, List<ManeuverDTO>>();
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace != null) {
            HashMap<CompetitorDTO, FutureTask<List>> futures = new HashMap<CompetitorDTO, FutureTask<List>>();
            for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                CompetitorDTO competitorDTO = this.baseDomainFactory.convertToCompetitorDTO(competitor);
                if (!competitorTimeRanges.containsKey(competitorDTO)) continue;
                TimeRange timeRange = competitorTimeRanges.get(competitorDTO);
                TimePoint from = timeRange.from();
                TimePoint to = timeRange.to();
                FutureTask<List> future = new FutureTask<List>(() -> {
                    Iterable maneuvers = trackedRace.getManeuvers(competitor, from, to, false);
                    if (maneuvers == null) {
                        maneuvers = trackedRace.getManeuvers(competitor, from, to, true);
                    }
                    return this.createManeuverDTOsForCompetitor(maneuvers, trackedRace, competitor);
                });
                this.executor.execute(future);
                futures.put(competitorDTO, future);
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    result.put((CompetitorDTO)entry.getKey(), (List)((Future)entry.getValue()).get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    private List<ManeuverDTO> createManeuverDTOsForCompetitor(Iterable<Maneuver> maneuvers, TrackedRace trackedRace, Competitor competitor) {
        ArrayList<ManeuverDTO> result = new ArrayList<ManeuverDTO>();
        for (Maneuver maneuver : maneuvers) {
            ManeuverType type = maneuver.getType();
            Tack newTack = maneuver.getNewTack();
            Position position = maneuver.getPosition();
            Date timepoint = maneuver.getTimePoint().asDate();
            Date timePointBefore = maneuver.getManeuverBoundaries().getTimePointBefore().asDate();
            SpeedWithBearingDTO speedBefore = this.createSpeedWithBearingDTO(maneuver.getSpeedWithBearingBefore());
            SpeedWithBearingDTO speedAfter = this.createSpeedWithBearingDTO(maneuver.getSpeedWithBearingAfter());
            double directionChangeInDegrees = maneuver.getDirectionChangeInDegrees();
            double maxTurningRateInDegreesPerSecond = maneuver.getMaxTurningRateInDegreesPerSecond();
            double averageTurningRateInDegreesPerSecond = maneuver.getAvgTurningRateInDegreesPerSecond();
            double lowestSpeedInKnots = maneuver.getLowestSpeed().getKnots();
            Date markPassingTimePoint = maneuver.isMarkPassing() ? maneuver.getMarkPassing().getTimePoint().asDate() : null;
            NauticalSide markPassingSide = maneuver.isMarkPassing() ? maneuver.getToSide() : null;
            SpeedWithBearing speedWithBearingBeforeManeuverLoss = maneuver.getManeuverLoss() == null ? null : maneuver.getManeuverLoss().getSpeedWithBearingBefore();
            Double middleManeuverAngle = maneuver.getManeuverLoss() == null ? null : Double.valueOf(maneuver.getManeuverLoss().getMiddleManeuverAngle().getDegrees());
            ManeuverLossDTO maneuverLoss = maneuver.getManeuverLoss() == null ? null : new ManeuverLossDTO(maneuver.getManeuverLoss().getManeuverStartPosition(), maneuver.getManeuverLoss().getManeuverEndPosition(), speedWithBearingBeforeManeuverLoss, middleManeuverAngle, maneuver.getManeuverLoss().getManeuverDuration(), maneuver.getManeuverLoss().getProjectedDistanceLost());
            result.add(new ManeuverDTO(type, newTack, position, timepoint, timePointBefore, speedBefore, speedAfter, directionChangeInDegrees, maxTurningRateInDegreesPerSecond, averageTurningRateInDegreesPerSecond, lowestSpeedInKnots, markPassingTimePoint, markPassingSide, maneuverLoss));
        }
        return result;
    }

    public RaceDefinition getRace(RegattaAndRaceIdentifier raceIdentifier) {
        Regatta regatta = this.getService().getRegattaByName(raceIdentifier.getRegattaName());
        RaceDefinition race = this.getRaceByName(regatta, raceIdentifier.getRaceName());
        return race;
    }

    public DynamicTrackedRace getTrackedRace(RegattaAndRaceIdentifier regattaNameAndRaceName) {
        Regatta regatta = this.getService().getRegattaByName(regattaNameAndRaceName.getRegattaName());
        RaceDefinition race = this.getRaceByName(regatta, regattaNameAndRaceName.getRaceName());
        DynamicTrackedRace trackedRace = this.getService().getOrCreateTrackedRegatta(regatta).getExistingTrackedRace(race);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        }
        return trackedRace;
    }

    public TrackedRace getExistingTrackedRace(RegattaAndRaceIdentifier regattaNameAndRaceName) {
        DynamicTrackedRace existingTrackedRace = this.getService().getExistingTrackedRace(regattaNameAndRaceName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)existingTrackedRace);
        return existingTrackedRace;
    }

    public Regatta getRegatta(RegattaName regattaName) {
        Regatta regattaByName = this.getService().getRegattaByName(regattaName.getRegattaName());
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regattaByName);
        return regattaByName;
    }

    public ServletContext getServletContext() {
        return new DelegatingServletContext(super.getServletContext());
    }

    protected void checkPermutationStrongName() throws SecurityException {
    }

    public List<LeaderboardGroupDTO> getLeaderboardGroups(boolean withGeoLocationData) {
        Map leaderboardGroups = this.getService().getLeaderboardGroups();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(leaderboardGroups.values(), leaderboardGroup -> this.convertToLeaderboardGroupDTO(leaderboardGroup, withGeoLocationData, false));
    }

    public LeaderboardGroupDTO getLeaderboardGroupByName(String groupName, boolean withGeoLocationData) {
        LeaderboardGroup leaderboardGroupByName = this.getService().getLeaderboardGroupByName(groupName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroupByName);
        return leaderboardGroupByName == null ? null : this.convertToLeaderboardGroupDTO(leaderboardGroupByName, withGeoLocationData, false);
    }

    public LeaderboardGroupDTO getLeaderboardGroupById(UUID groupId) {
        LeaderboardGroup leaderboardGroupById = this.getService().getLeaderboardGroupByID(groupId);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroupById);
        return leaderboardGroupById == null ? null : this.convertToLeaderboardGroupDTO(leaderboardGroupById, false, false);
    }

    public LeaderboardGroupDTO getLeaderboardGroupByUuidOrName(UUID groupUuid, String groupName) {
        LeaderboardGroup leaderboardGroup = this.getLeaderboardGroupByIdOrName(groupUuid, groupName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup);
        return leaderboardGroup == null ? null : this.convertToLeaderboardGroupDTO(leaderboardGroup, false, false);
    }

    protected LeaderboardGroupDTO convertToLeaderboardGroupDTO(LeaderboardGroup leaderboardGroup, boolean withGeoLocationData, boolean withStatisticalData) {
        LeaderboardGroupDTO groupDTO = new LeaderboardGroupDTO(leaderboardGroup.getId(), leaderboardGroup.getName(), leaderboardGroup.getDisplayName(), leaderboardGroup.getDescription());
        groupDTO.displayLeaderboardsInReverseOrder = leaderboardGroup.isDisplayGroupsInReverseOrder();
        for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
            try {
                groupDTO.leaderboards.add(this.createStrippedLeaderboardDTO(leaderboard, withGeoLocationData, withStatisticalData));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Caught exception while reading data for leaderboard " + leaderboard.getName(), e);
            }
        }
        Leaderboard overallLeaderboard = leaderboardGroup.getOverallLeaderboard();
        if (overallLeaderboard != null) {
            if (overallLeaderboard.getResultDiscardingRule() instanceof ThresholdBasedResultDiscardingRule) {
                groupDTO.setOverallLeaderboardDiscardThresholds(((ThresholdBasedResultDiscardingRule)overallLeaderboard.getResultDiscardingRule()).getDiscardIndexResultsStartingWithHowManyRaces());
            }
            groupDTO.setOverallLeaderboardScoringSchemeType(overallLeaderboard.getScoringScheme().getType());
        }
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)groupDTO);
        return groupDTO;
    }

    public ReplicationStateDTO getReplicaInfo() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.READ_REPLICATOR);
        ReplicationService service = this.getReplicationService();
        HashSet<ReplicaDTO> replicaDTOs = new HashSet<ReplicaDTO>();
        for (ReplicaDescriptor replicaDescriptor : service.getReplicaInfo()) {
            Map statistics = service.getStatistics(replicaDescriptor);
            HashMap<String, Integer> replicationCountByOperationClassName = new HashMap<String, Integer>();
            for (Map.Entry e : statistics.entrySet()) {
                replicationCountByOperationClassName.put(((Class)e.getKey()).getName(), (Integer)e.getValue());
            }
            replicaDTOs.add(new ReplicaDTO(replicaDescriptor.getIpAddress().getHostAddress(), replicaDescriptor.getRegistrationTime().asDate(), replicaDescriptor.getUuid().toString(), replicaDescriptor.getReplicableIdsAsStrings(), replicaDescriptor.getAdditionalInformation(), replicationCountByOperationClassName, service.getAverageNumberOfOperationsPerMessage(replicaDescriptor), service.getNumberOfMessagesSent(replicaDescriptor), service.getNumberOfBytesSent(replicaDescriptor), service.getAverageNumberOfBytesPerMessage(replicaDescriptor)));
        }
        ReplicationMasterDescriptor replicatingFromMaster = service.getReplicatingFromMaster();
        ReplicationMasterDTO master = replicatingFromMaster == null ? null : new ReplicationMasterDTO(replicatingFromMaster.getHostname(), replicatingFromMaster.getServletPort(), replicatingFromMaster.getMessagingHostname(), replicatingFromMaster.getMessagingPort(), replicatingFromMaster.getExchangeName(), (String[])StreamSupport.stream(replicatingFromMaster.getReplicables().spliterator(), false).map(r -> r.getId()).toArray(String[]::new));
        return new ReplicationStateDTO(master, replicaDTOs, service.getServerIdentifier().toString());
    }

    public String[] getReplicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica() {
        return new String[]{this.getService().getId().toString()};
    }

    public void startReplicatingFromMaster(String messagingHost, String masterHostName, String exchangeName, int servletPort, int messagingPort, String usernameOrNull, String passwordOrNull) throws Exception {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.START_REPLICATION);
        ReplicationService replicationService = this.getReplicationService();
        replicationService.setReplicationStarting(true);
        try {
            replicationService.startToReplicateFrom(replicationService.createReplicationMasterDescriptor(messagingHost, masterHostName, exchangeName, servletPort, messagingPort, replicationService.getServerIdentifier().toString(), RemoteServerUtil.resolveBearerTokenForRemoteServer((String)masterHostName, (int)servletPort, (String)usernameOrNull, (String)passwordOrNull), replicationService.getAllReplicables()));
        }
        finally {
            replicationService.setReplicationStarting(false);
        }
    }

    public List<EventDTO> getEvents() throws MalformedURLException {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getService().getAllEvents(), event -> {
            EventDTO eventDTO = this.convertToEventDTO(event, false);
            try {
                eventDTO.setBaseURL(this.getEventBaseURLFromEventOrRequest(event));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            eventDTO.setIsOnRemoteServer(false);
            return eventDTO;
        });
    }

    private URL getRequestBaseURL() throws MalformedURLException {
        URL url = new URL(this.getThreadLocalRequest().getRequestURL().toString());
        URL baseURL = this.getBaseURL(url);
        return baseURL;
    }

    private URL getBaseURL(URL url) throws MalformedURLException {
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
    }

    protected RemoteSailingServerReferenceDTO createRemoteSailingServerReferenceDTO(RemoteSailingServerReference serverRef, Util.Pair<Iterable<EventBase>, Exception> eventsOrException) {
        RemoteSailingServerReferenceDTO sailingServerDTO;
        Iterable events = (Iterable)eventsOrException.getA();
        if (events == null) {
            Object eventDTOs = null;
            Exception exception = (Exception)eventsOrException.getB();
            sailingServerDTO = new RemoteSailingServerReferenceDTO(serverRef.getName(), serverRef.getURL().toExternalForm(), serverRef.isInclude(), exception == null ? null : exception.getMessage());
        } else {
            Iterable eventDTOs = this.convertToEventDTOs(events);
            ArrayList selectedEventIds = new ArrayList(serverRef.getSelectedEventIds());
            sailingServerDTO = new RemoteSailingServerReferenceDTO(serverRef.getName(), serverRef.getURL().toExternalForm(), serverRef.isInclude(), selectedEventIds, eventDTOs);
        }
        return sailingServerDTO;
    }

    private Iterable<EventBaseDTO> convertToEventDTOs(Iterable<EventBase> events) {
        ArrayList<EventBaseDTO> result = new ArrayList<EventBaseDTO>();
        for (EventBase event : events) {
            EventBaseDTO eventDTO = this.convertToEventDTO(event);
            result.add(eventDTO);
        }
        return result;
    }

    public Util.Pair<Integer, Integer> resolveImageDimensions(String imageUrlAsString) throws Exception {
        Util.Pair imageDimensions;
        if (imageUrlAsString != null && !imageUrlAsString.isEmpty()) {
            URL imageURL = new URL(imageUrlAsString);
            imageDimensions = MediaUtils.getImageDimensions((URL)imageURL);
        } else {
            imageDimensions = null;
        }
        return imageDimensions;
    }

    protected String getEventBaseURLFromEventOrRequest(Event event) throws MalformedURLException {
        return event.getBaseURL() == null ? this.getRequestBaseURL().toString() : event.getBaseURL().toString();
    }

    private EventBaseDTO convertToEventDTO(EventBase event) {
        EventBaseDTO eventDTO;
        if (event == null) {
            eventDTO = null;
        } else {
            ArrayList<LeaderboardGroupBaseDTO> lgDTOs = new ArrayList<LeaderboardGroupBaseDTO>();
            if (event.getLeaderboardGroups() != null) {
                for (LeaderboardGroupBase lgBase : event.getLeaderboardGroups()) {
                    lgDTOs.add(this.convertToLeaderboardGroupBaseDTO(lgBase));
                }
            }
            eventDTO = new EventBaseDTO(event.getName(), lgDTOs);
            this.copyEventBaseFieldsToDTO(event, eventDTO);
        }
        return eventDTO;
    }

    private LeaderboardGroupBaseDTO convertToLeaderboardGroupBaseDTO(LeaderboardGroupBase leaderboardGroupBase) {
        return new LeaderboardGroupBaseDTO(leaderboardGroupBase.getId(), leaderboardGroupBase.getName(), leaderboardGroupBase.getDescription(), leaderboardGroupBase.getDisplayName(), leaderboardGroupBase.hasOverallLeaderboard());
    }

    private void copyEventBaseFieldsToDTO(EventBase event, EventBaseDTO eventDTO) {
        eventDTO.setVenue(new VenueDTO(event.getVenue() != null ? event.getVenue().getName() : null));
        eventDTO.startDate = event.getStartDate() != null ? event.getStartDate().asDate() : null;
        eventDTO.endDate = event.getStartDate() != null ? event.getEndDate().asDate() : null;
        eventDTO.isPublic = event.isPublic();
        eventDTO.id = (UUID)event.getId();
        eventDTO.setDescription(event.getDescription());
        eventDTO.setOfficialWebsiteURL(event.getOfficialWebsiteURL() != null ? event.getOfficialWebsiteURL().toString() : null);
        eventDTO.setBaseURL(event.getBaseURL() != null ? event.getBaseURL().toString() : null);
        for (Map.Entry sailorsInfoWebsiteEntry : event.getSailorsInfoWebsiteURLs().entrySet()) {
            eventDTO.setSailorsInfoWebsiteURL(sailorsInfoWebsiteEntry.getKey() == null ? null : ((Locale)sailorsInfoWebsiteEntry.getKey()).toLanguageTag(), ((URL)sailorsInfoWebsiteEntry.getValue()).toExternalForm());
        }
        for (ImageDescriptor image : event.getImages()) {
            eventDTO.addImage(this.convertToImageDTO(image));
        }
        for (VideoDescriptor video : event.getVideos()) {
            eventDTO.addVideo(this.convertToVideoDTO(video));
        }
    }

    protected List<ImageDescriptor> convertToImages(Iterable<? extends ImageDTO> images) throws MalformedURLException {
        ArrayList<ImageDescriptor> eventImages = new ArrayList<ImageDescriptor>();
        for (ImageDTO imageDTO : images) {
            try {
                eventImages.add(this.convertToImage(imageDTO));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eventImages;
    }

    protected List<VideoDescriptor> convertToVideos(Iterable<? extends VideoDTO> videos) throws MalformedURLException {
        ArrayList<VideoDescriptor> eventVideos = new ArrayList<VideoDescriptor>();
        for (VideoDTO videoDTO : videos) {
            try {
                eventVideos.add(this.convertToVideo(videoDTO));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eventVideos;
    }

    protected Map<Locale, URL> convertToLocalesAndUrls(Map<String, String> sailorsInfoWebsiteURLsByLocaleName) {
        HashMap<Locale, URL> eventURLs = new HashMap<Locale, URL>();
        for (Map.Entry<String, String> entry : sailorsInfoWebsiteURLsByLocaleName.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                eventURLs.put(this.toLocale(entry.getKey()), new URL(entry.getValue()));
            }
            catch (Exception e) {
                logger.warning("User " + SessionUtils.getPrincipal() + " provided " + entry.getValue() + " as URL which didn't parse");
            }
        }
        return eventURLs;
    }

    private ImageDescriptor convertToImage(ImageDTO image) throws MalformedURLException {
        ImageDescriptorImpl result = new ImageDescriptorImpl(new URL(image.getSourceRef()), (TimePoint)new MillisecondsTimePoint(image.getCreatedAtDate()));
        result.setCopyright(image.getCopyright());
        result.setTitle(image.getTitle());
        result.setSubtitle(image.getSubtitle());
        result.setCopyright(image.getCopyright());
        result.setSize(image.getWidthInPx(), image.getHeightInPx());
        result.setLocale(this.toLocale(image.getLocale()));
        for (String tag : image.getTags()) {
            result.addTag(tag);
        }
        return result;
    }

    private VideoDescriptor convertToVideo(VideoDTO video) throws MalformedURLException {
        MimeType mimeType = video.getMimeType();
        if (mimeType == null || mimeType == MimeType.unknown) {
            mimeType = MediaUtils.detectMimeTypeFromUrl((String)video.getSourceRef());
        }
        VideoDescriptorImpl result = new VideoDescriptorImpl(new URL(video.getSourceRef()), mimeType, (TimePoint)new MillisecondsTimePoint(video.getCreatedAtDate()));
        result.setCopyright(video.getCopyright());
        result.setTitle(video.getTitle());
        result.setSubtitle(video.getSubtitle());
        result.setCopyright(video.getCopyright());
        result.setLengthInSeconds(video.getLengthInSeconds());
        if (video.getThumbnailRef() != null && !video.getThumbnailRef().isEmpty()) {
            result.setThumbnailURL(new URL(video.getThumbnailRef()));
        }
        result.setLocale(this.toLocale(video.getLocale()));
        for (String tag : video.getTags()) {
            result.addTag(tag);
        }
        return result;
    }

    private ImageDTO convertToImageDTO(ImageDescriptor image) {
        ImageDTO result = new ImageDTO(image.getURL().toString(), image.getCreatedAtDate() != null ? image.getCreatedAtDate().asDate() : null);
        result.setCopyright(image.getCopyright());
        result.setTitle(image.getTitle());
        result.setSubtitle(image.getSubtitle());
        result.setMimeType(image.getMimeType());
        result.setSizeInPx(image.getWidthInPx(), image.getHeightInPx());
        result.setLocale(this.toLocaleName(image.getLocale()));
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : image.getTags()) {
            tags.add(tag);
        }
        result.setTags(tags);
        return result;
    }

    private VideoDTO convertToVideoDTO(VideoDescriptor video) {
        VideoDTO result = new VideoDTO(video.getURL().toString(), video.getMimeType(), video.getCreatedAtDate() != null ? video.getCreatedAtDate().asDate() : null);
        result.setCopyright(video.getCopyright());
        result.setTitle(video.getTitle());
        result.setSubtitle(video.getSubtitle());
        result.setThumbnailRef(video.getThumbnailURL() != null ? video.getThumbnailURL().toString() : null);
        result.setLengthInSeconds(video.getLengthInSeconds());
        result.setLocale(this.toLocaleName(video.getLocale()));
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : video.getTags()) {
            tags.add(tag);
        }
        result.setTags(tags);
        return result;
    }

    private Locale toLocale(String localeName) {
        if (localeName == null || localeName.isEmpty()) {
            return null;
        }
        return Locale.forLanguageTag(localeName);
    }

    private String toLocaleName(Locale locale) {
        if (locale == null) {
            return null;
        }
        return locale.toString();
    }

    protected EventDTO convertToEventDTO(Event event, boolean withStatisticalData) {
        EventDTO eventDTO = new EventDTO(event.getName());
        this.copyEventBaseFieldsToDTO((EventBase)event, (EventBaseDTO)eventDTO);
        eventDTO.getVenue().setCourseAreas(new ArrayList());
        for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
            CourseAreaDTO courseAreaDTO = this.convertToCourseAreaDTO(courseArea);
            eventDTO.getVenue().getCourseAreas().add(courseAreaDTO);
        }
        for (LeaderboardGroup lg : event.getLeaderboardGroups()) {
            eventDTO.addLeaderboardGroup(this.convertToLeaderboardGroupDTO(lg, false, withStatisticalData));
        }
        eventDTO.setWindFinderReviewedSpotsCollection(event.getWindFinderReviewedSpotsCollectionIds());
        WindFinderTrackerFactory windFinderTrackerFactory = (WindFinderTrackerFactory)this.windFinderTrackerFactoryServiceTracker.getService();
        if (windFinderTrackerFactory != null) {
            eventDTO.setAllWindFinderSpotsUsedByEvent(new EventWindFinderUtil().getWindFinderSpotsToConsider(event, windFinderTrackerFactory, false));
        }
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)eventDTO);
        return eventDTO;
    }

    private CourseAreaDTO convertToCourseAreaDTO(CourseArea courseArea) {
        CourseAreaDTO courseAreaDTO = new CourseAreaDTO(courseArea.getId(), courseArea.getName(), courseArea.getCenterPosition(), courseArea.getRadius());
        return courseAreaDTO;
    }

    public List<RaceGroupDTO> getRegattaStructureForEvent(UUID eventId) {
        ArrayList<RaceGroupDTO> raceGroups = new ArrayList<RaceGroupDTO>();
        Event event = this.getService().getEvent((Serializable)eventId);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        HashMap<Leaderboard, LeaderboardGroup> leaderboardWithLeaderboardGroups = new HashMap<Leaderboard, LeaderboardGroup>();
        for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) continue;
                leaderboardWithLeaderboardGroups.put(leaderboard, leaderboardGroup);
            }
        }
        if (event != null) {
            HashSet<Leaderboard> leaderboardsAlreadyAddedAsRaceGroup = new HashSet<Leaderboard>();
            for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
                for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
                    if (leaderboardsAlreadyAddedAsRaceGroup.contains(leaderboard) || !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard) || !Util.contains((Iterable)leaderboard.getCourseAreas(), (Object)courseArea)) continue;
                    RaceGroupDTO raceGroup = new RaceGroupDTO(leaderboard.getName());
                    raceGroup.displayName = this.getRegattaNameFromLeaderboard(leaderboard);
                    if (leaderboardWithLeaderboardGroups.containsKey(leaderboard)) {
                        raceGroup.leaderboardGroupName = ((LeaderboardGroup)leaderboardWithLeaderboardGroups.get(leaderboard)).getName();
                    }
                    if (leaderboard instanceof RegattaLeaderboard) {
                        RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                        for (Series series : regattaLeaderboard.getRegatta().getSeries()) {
                            RaceGroupSeriesDTO seriesDTO = new RaceGroupSeriesDTO(series.getName());
                            raceGroup.getSeries().add(seriesDTO);
                            for (Fleet fleet : series.getFleets()) {
                                FleetDTO fleetDTO = new FleetDTO(fleet.getName(), fleet.getOrdering(), fleet.getColor());
                                seriesDTO.getFleets().add(fleetDTO);
                            }
                            seriesDTO.getRaceColumns().addAll(this.convertToRaceColumnDTOs(series.getRaceColumns()));
                        }
                    } else {
                        RaceGroupSeriesDTO seriesDTO = new RaceGroupSeriesDTO("Default");
                        raceGroup.getSeries().add(seriesDTO);
                        FleetDTO fleetDTO = new FleetDTO("Default", 0, null);
                        seriesDTO.getFleets().add(fleetDTO);
                        seriesDTO.getRaceColumns().addAll(this.convertToRaceColumnDTOs(leaderboard.getRaceColumns()));
                    }
                    raceGroups.add(raceGroup);
                    leaderboardsAlreadyAddedAsRaceGroup.add(leaderboard);
                }
            }
        }
        return raceGroups;
    }

    private String getRegattaNameFromLeaderboard(Leaderboard leaderboard) {
        String regattaName;
        if (leaderboard.getDisplayName() != null && !leaderboard.getDisplayName().isEmpty()) {
            regattaName = leaderboard.getDisplayName();
        } else if (leaderboard instanceof RegattaLeaderboard) {
            RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
            regattaName = regattaLeaderboard.getRegatta().getName();
        } else {
            regattaName = leaderboard.getName();
        }
        return regattaName;
    }

    public RegattaScoreCorrectionDTO getScoreCorrections(String scoreCorrectionProviderName, String eventName, String boatClassName, Date timePointWhenResultPublished) throws Exception {
        RegattaScoreCorrectionDTO result = null;
        for (ScoreCorrectionProvider scp : this.getAllScoreCorrectionProviders()) {
            if (!scp.getName().equals(scoreCorrectionProviderName)) continue;
            RegattaScoreCorrections scoreCorrections = scp.getScoreCorrections(eventName, boatClassName, (TimePoint)new MillisecondsTimePoint(timePointWhenResultPublished));
            RegattaDTO regatta = this.getRegattaByName(scoreCorrections.getRegattaName());
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            result = this.createScoreCorrection(scoreCorrections);
            break;
        }
        return result;
    }

    private RegattaScoreCorrectionDTO createScoreCorrection(RegattaScoreCorrections scoreCorrections) {
        LinkedHashMap map = new LinkedHashMap();
        for (RegattaScoreCorrections.ScoreCorrectionsForRace sc4r : scoreCorrections.getScoreCorrectionsForRaces()) {
            HashMap<String, RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO> entryMap = new HashMap<String, RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO>();
            for (String sailID : sc4r.getSailIDs()) {
                entryMap.put(sailID, this.createScoreCorrectionEntryDTO(sc4r.getScoreCorrectionForCompetitor(sailID)));
            }
            map.put(sc4r.getRaceNameOrNumber(), entryMap);
        }
        return new RegattaScoreCorrectionDTO(scoreCorrections.getProvider().getName(), map);
    }

    private RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO createScoreCorrectionEntryDTO(RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace scoreCorrectionForCompetitor) {
        return new RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO(scoreCorrectionForCompetitor.getPoints(), scoreCorrectionForCompetitor.isDiscarded(), scoreCorrectionForCompetitor.getMaxPointsReason());
    }

    public List<Util.Pair<String, String>> getUrlResultProviderNamesAndOptionalSampleURL() {
        ArrayList<Util.Pair<String, String>> result = new ArrayList<Util.Pair<String, String>>();
        HashSet<String> existingNames = new HashSet<String>();
        if (this.getSecurityService().hasCurrentUserAnyPermission(SecuredDomainType.RESULT_IMPORT_URL.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.READ}))) {
            String name;
            for (ScoreCorrectionProvider scp : this.getAllScoreCorrectionProviders()) {
                if (!(scp instanceof ResultUrlProvider)) continue;
                name = scp.getName();
                existingNames.add(name);
                result.add((Util.Pair<String, String>)new Util.Pair((Object)name, (Object)((ResultUrlProvider)scp).getOptionalSampleURL()));
            }
            for (CompetitorProvider cp : this.getAllCompetitorProviders()) {
                if (!(cp instanceof ResultUrlProvider) || existingNames.contains(name = cp.getName())) continue;
                result.add((Util.Pair<String, String>)new Util.Pair((Object)name, (Object)((ResultUrlProvider)cp).getOptionalSampleURL()));
            }
        }
        return result;
    }

    protected ResultUrlProvider getUrlBasedScoreCorrectionProvider(String resultProviderName) {
        ResultUrlProvider result = null;
        for (ScoreCorrectionProvider scp : this.getAllScoreCorrectionProviders()) {
            if (!(scp instanceof ResultUrlProvider) || !scp.getName().equals(resultProviderName)) continue;
            result = (ResultUrlProvider)scp;
            break;
        }
        return result;
    }

    protected ServerInfoDTO getServerInfo() {
        ServerInfoDTO result = new ServerInfoDTO(ServerInfo.getName(), ServerInfo.getBuildVersion(), ServerInfo.getManageEventsBaseUrl());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)result);
        return result;
    }

    public ServerConfigurationDTO getServerConfiguration() {
        SailingServerConfiguration sailingServerConfiguration = this.getService().getSailingServerConfiguration();
        UserGroup serverTenant = this.getSecurityService().getServerGroup();
        StrippedUserGroupDTO serverTenantDTO = new SecurityDTOFactory().createStrippedUserGroupDTOFromUserGroup(serverTenant, new HashMap());
        ServerConfigurationDTO result = new ServerConfigurationDTO(sailingServerConfiguration.isStandaloneServer(), this.isPublicServer(), this.isSelfServiceServer(), serverTenantDTO);
        return result;
    }

    public List<RemoteSailingServerReferenceDTO> getRemoteSailingServerReferences() {
        ArrayList<RemoteSailingServerReferenceDTO> result = new ArrayList<RemoteSailingServerReferenceDTO>();
        for (Map.Entry remoteSailingServerRefAndItsCachedEvent : this.getService().getPublicEventsOfAllSailingServers().entrySet()) {
            RemoteSailingServerReferenceDTO dto = this.createRemoteSailingServerReferenceDTO((RemoteSailingServerReference)remoteSailingServerRefAndItsCachedEvent.getKey(), (Util.Pair)remoteSailingServerRefAndItsCachedEvent.getValue());
            result.add(dto);
        }
        return result;
    }

    public List<UrlDTO> getResultImportUrls(String resultProviderName) {
        ArrayList<UrlDTO> result = new ArrayList<UrlDTO>();
        SecurityService securityService = this.getSecurityService();
        Iterable allUrlsReadableBySubject = this.getService().getResultImportUrls(resultProviderName);
        for (URL url : allUrlsReadableBySubject) {
            UrlDTO urlDTO = new UrlDTO(resultProviderName, url.toString());
            SecurityDTOUtil.addSecurityInformation((SecurityService)securityService, (SecuredDTO)urlDTO);
            result.add(urlDTO);
        }
        return result;
    }

    public String validateResultImportUrl(String resultProviderName, UrlDTO urlDTO) {
        if (urlDTO == null || urlDTO.getUrl() == null || urlDTO.getUrl().isEmpty()) {
            return this.serverStringMessages.get(this.getClientLocale(), "pleaseEnterNonEmptyUrl");
        }
        Optional resultUrlProvider = this.getService().getUrlBasedScoreCorrectionProvider(resultProviderName);
        if (!resultUrlProvider.isPresent()) {
            return this.serverStringMessages.get(this.getClientLocale(), "scoreCorrectionProviderNotFound");
        }
        String errorMessage = null;
        try {
            ((ResultUrlProvider)resultUrlProvider.get()).resolveUrl(urlDTO.getUrl());
        }
        catch (MalformedURLException e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    public List<String> getOverallLeaderboardNamesContaining(String leaderboardName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new IllegalArgumentException("Couldn't find leaderboard named " + leaderboardName);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry leaderboardEntry : this.getService().getLeaderboards().entrySet()) {
            MetaLeaderboard metaLeaderboard;
            if (!(leaderboardEntry.getValue() instanceof MetaLeaderboard) || !Util.contains((Iterable)(metaLeaderboard = (MetaLeaderboard)leaderboardEntry.getValue()).getLeaderboards(), (Object)leaderboard) || !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) continue;
            result.add((String)leaderboardEntry.getKey());
        }
        return result;
    }

    public List<SwissTimingArchiveConfigurationWithSecurityDTO> getPreviousSwissTimingArchiveConfigurations() {
        Iterable configs = this.swissTimingAdapterPersistence.getSwissTimingArchiveConfigurations();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(configs, stArchiveConfig -> {
            SwissTimingArchiveConfigurationWithSecurityDTO config = new SwissTimingArchiveConfigurationWithSecurityDTO(stArchiveConfig.getJsonURL(), stArchiveConfig.getCreatorName());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)config);
            return config;
        });
    }

    protected DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    private List<RegattaOverviewEntryDTO> getRaceStateEntriesForLeaderboard(String leaderboardName, boolean showOnlyCurrentlyRunningRaces, boolean showOnlyRacesOfSameDay, Duration clientTimeZoneOffset, List<String> visibleRegattas) throws NoWindException, InterruptedException, ExecutionException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        return this.getRaceStateEntriesForLeaderboard(leaderboard, showOnlyCurrentlyRunningRaces, showOnlyRacesOfSameDay, clientTimeZoneOffset, visibleRegattas);
    }

    private List<RegattaOverviewEntryDTO> getRaceStateEntriesForLeaderboard(Leaderboard leaderboard, boolean showOnlyCurrentlyRunningRaces, boolean showOnlyRacesOfSameDay, Duration clientTimeZoneOffset, List<String> visibleRegattas) throws NoWindException, InterruptedException, ExecutionException {
        ArrayList<RegattaOverviewEntryDTO> result = new ArrayList<RegattaOverviewEntryDTO>();
        Calendar dayToCheck = Calendar.getInstance();
        dayToCheck.setTime(new Date());
        if (leaderboard != null) {
            if (visibleRegattas != null && !visibleRegattas.contains(leaderboard.getName())) {
                return result;
            }
            String regattaName = this.getRegattaNameFromLeaderboard(leaderboard);
            if (leaderboard instanceof RegattaLeaderboard) {
                RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                Regatta regatta = regattaLeaderboard.getRegatta();
                BoatClass boatClass2 = regatta.getBoatClass();
                Distance buyZoneRadius = RegattaUtil.getCalculatedRegattaBuoyZoneRadius((Regatta)regatta, (BoatClass)boatClass2);
                for (Series series : regatta.getSeries()) {
                    HashMap entriesPerFleet = new HashMap();
                    for (RaceColumn raceColumn : series.getRaceColumns()) {
                        this.getRegattaOverviewEntries(showOnlyRacesOfSameDay, clientTimeZoneOffset, dayToCheck, leaderboard, boatClass2.getName(), regattaName, buyZoneRadius, series.getName(), raceColumn, entriesPerFleet);
                    }
                    result.addAll(this.getRegattaOverviewEntriesToBeShown(showOnlyCurrentlyRunningRaces, entriesPerFleet));
                }
            } else if (leaderboard instanceof FlexibleLeaderboard) {
                BoatClass boatClass = null;
                Iterator boatClass2 = leaderboard.getTrackedRaces().iterator();
                if (boatClass2.hasNext()) {
                    TrackedRace trackedRace = (TrackedRace)boatClass2.next();
                    boatClass = trackedRace.getRace().getBoatClass();
                }
                Distance buyZoneRadius = RegattaUtil.getCalculatedRegattaBuoyZoneRadius(null, boatClass);
                HashMap entriesPerFleet = new HashMap();
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    this.getRegattaOverviewEntries(showOnlyRacesOfSameDay, clientTimeZoneOffset, dayToCheck, leaderboard, boatClass == null ? "" : boatClass.getName(), regattaName, buyZoneRadius, "Default", raceColumn, entriesPerFleet);
                }
                result.addAll(this.getRegattaOverviewEntriesToBeShown(showOnlyCurrentlyRunningRaces, entriesPerFleet));
            }
        }
        return result;
    }

    private SeriesParameters getSeriesParameters(SeriesDTO seriesDTO) {
        SeriesParameters series = new SeriesParameters(seriesDTO.isFirstColumnIsNonDiscardableCarryForward(), seriesDTO.hasSplitFleetContiguousScoring(), seriesDTO.hasCrossFleetMergedRanking().booleanValue(), seriesDTO.isStartsWithZeroScore().booleanValue(), seriesDTO.getDiscardThresholds(), seriesDTO.getMaximumNumberOfDiscards(), seriesDTO.isOneAlwaysStaysOne());
        return series;
    }

    protected LinkedHashMap<String, SeriesCreationParametersDTO> getSeriesCreationParameters(RegattaDTO regattaDTO) {
        LinkedHashMap<String, SeriesCreationParametersDTO> seriesCreationParams = new LinkedHashMap<String, SeriesCreationParametersDTO>();
        for (SeriesDTO series : regattaDTO.series) {
            SeriesParameters seriesParameters = this.getSeriesParameters(series);
            seriesCreationParams.put(series.getName(), new SeriesCreationParametersDTO(series.getFleets(), false, true, seriesParameters.isStartswithZeroScore(), seriesParameters.isFirstColumnIsNonDiscardableCarryForward(), seriesParameters.getDiscardingThresholds(), seriesParameters.isHasSplitFleetContiguousScoring(), seriesParameters.isHasCrossFleetMergedRanking(), seriesParameters.getMaximumNumberOfDiscards(), seriesParameters.isOneAlwaysStaysOne()));
        }
        return seriesCreationParams;
    }

    public Iterable<RegattaDTO> getManage2SailRegattas(String manage2SailJsonUrl) throws MalformedURLException, URISyntaxException {
        StructureImporter structureImporter = new StructureImporter((SetRacenumberStrategy)new SetRacenumberFromSeries(), this.baseDomainFactory);
        String manage2SailJsonUrlWithAccessToken = com.sap.sailing.manage2sail.Activator.getInstance().addAccessTokenToManage2SailUrl(new URL(manage2SailJsonUrl)).toString();
        Iterable parsedEvent = structureImporter.parseEvent(manage2SailJsonUrlWithAccessToken);
        ArrayList<RegattaDTO> regattaDTOs = new ArrayList<RegattaDTO>();
        Iterable regattas = structureImporter.getRegattas(parsedEvent);
        for (Regatta regatta : regattas) {
            regattaDTOs.add(this.convertToRegattaDTO(regatta));
        }
        return regattaDTOs;
    }

    private Util.Triple<String, String, String> getLeaderboardSlotKey(RegattaOverviewEntryDTO entry) {
        return new Util.Triple((Object)entry.leaderboardName, (Object)entry.raceInfo.raceName, (Object)entry.raceInfo.fleetName);
    }

    public List<RegattaOverviewEntryDTO> getRaceStateEntriesForRaceGroup(UUID eventId, List<UUID> visibleCourseAreaIds, List<String> visibleRegattas, boolean showOnlyCurrentlyRunningRaces, boolean showOnlyRacesOfSameDay, Duration clientTimeZoneOffset) throws NoWindException, InterruptedException, ExecutionException {
        Calendar dayToCheck = Calendar.getInstance();
        dayToCheck.setTime(new Date());
        Event event = this.getService().getEvent((Serializable)eventId);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        HashMap<Util.Triple, RegattaOverviewEntryDTO> entriesByRaceIdentifier = new HashMap<Util.Triple, RegattaOverviewEntryDTO>();
        if (event != null) {
            for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
                if (!visibleCourseAreaIds.contains(courseArea.getId())) continue;
                for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
                    if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard) || !Util.contains((Iterable)leaderboard.getCourseAreas(), (Object)courseArea)) continue;
                    for (RegattaOverviewEntryDTO entry : this.getRaceStateEntriesForLeaderboard(leaderboard.getName(), showOnlyCurrentlyRunningRaces, showOnlyRacesOfSameDay, clientTimeZoneOffset, visibleRegattas)) {
                        if (entriesByRaceIdentifier.containsKey(this.getLeaderboardSlotKey(entry)) || entry.courseAreaIdAsString != null && !visibleCourseAreaIds.contains(UUID.fromString(entry.courseAreaIdAsString))) continue;
                        entriesByRaceIdentifier.put(this.getLeaderboardSlotKey(entry), entry);
                    }
                }
            }
        }
        return new ArrayList<RegattaOverviewEntryDTO>(entriesByRaceIdentifier.values());
    }

    private void getRegattaOverviewEntries(boolean showOnlyRacesOfSameDay, Duration clientTimeZoneOffset, Calendar dayToCheck, Leaderboard leaderboard, String boatClassName, String regattaName, Distance buyZoneRadius, String seriesName, RaceColumn raceColumn, Map<String, List<RegattaOverviewEntryDTO>> entriesPerFleet) {
        if (!raceColumn.isCarryForward()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                RegattaOverviewEntryDTO entry = this.createRegattaOverviewEntryDTO(leaderboard, boatClassName, regattaName, buyZoneRadius, seriesName, raceColumn, fleet, showOnlyRacesOfSameDay, clientTimeZoneOffset, dayToCheck);
                if (entry == null) continue;
                this.addRegattaOverviewEntryToEntriesPerFleet(entriesPerFleet, fleet, entry);
            }
        }
    }

    private List<RegattaOverviewEntryDTO> getRegattaOverviewEntriesToBeShown(boolean showOnlyCurrentlyRunningRaces, Map<String, List<RegattaOverviewEntryDTO>> entriesPerFleet) {
        ArrayList<RegattaOverviewEntryDTO> result = new ArrayList<RegattaOverviewEntryDTO>();
        for (List<RegattaOverviewEntryDTO> entryList : entriesPerFleet.values()) {
            result.addAll(entryList);
            if (!showOnlyCurrentlyRunningRaces) continue;
            ArrayList<RegattaOverviewEntryDTO> finishedEntries = new ArrayList<RegattaOverviewEntryDTO>();
            for (RegattaOverviewEntryDTO entry : entryList) {
                if (RaceLogRaceStatus.isActive((RaceLogRaceStatus)entry.raceInfo.lastStatus)) continue;
                if (entry.raceInfo.lastStatus.equals((Object)RaceLogRaceStatus.FINISHED)) {
                    finishedEntries.add(entry);
                    continue;
                }
                if (!entry.raceInfo.lastStatus.equals((Object)RaceLogRaceStatus.UNSCHEDULED) || entry.raceInfo.isRaceAbortedInPassBefore) continue;
                result.remove(entry);
            }
            if (finishedEntries.isEmpty()) continue;
            int indexOfLastElement = finishedEntries.size() - 1;
            finishedEntries.remove(indexOfLastElement);
            result.removeAll(finishedEntries);
        }
        return result;
    }

    private void addRegattaOverviewEntryToEntriesPerFleet(Map<String, List<RegattaOverviewEntryDTO>> entriesPerFleet, Fleet fleet, RegattaOverviewEntryDTO entry) {
        if (!entriesPerFleet.containsKey(fleet.getName())) {
            entriesPerFleet.put(fleet.getName(), new ArrayList());
        }
        entriesPerFleet.get(fleet.getName()).add(entry);
    }

    private RegattaOverviewEntryDTO createRegattaOverviewEntryDTO(Leaderboard leaderboard, String boatClassName, String regattaName, Distance buyZoneRadius, String seriesName, RaceColumn raceColumn, Fleet fleet, boolean showOnlyRacesOfSameDay, Duration clientTimeZoneOffset, Calendar dayToCheck) {
        UUID courseAreaIdFromRaceLog;
        RegattaOverviewEntryDTO entry = new RegattaOverviewEntryDTO();
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        ReadonlyRaceState state = raceLog != null ? ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.getService(), (RaceLog)raceLog) : null;
        if (state != null && (courseAreaIdFromRaceLog = state.getCourseAreaId()) != null) {
            CourseArea courseAreaFromRaceLog = this.getBaseDomainFactory().getExistingCourseAreaById((Serializable)courseAreaIdFromRaceLog);
            entry.courseAreaName = courseAreaFromRaceLog.getName();
            entry.courseAreaIdAsString = courseAreaFromRaceLog.getId().toString();
        } else if (Util.size((Iterable)leaderboard.getCourseAreas()) == 1) {
            CourseArea defaultCourseArea = (CourseArea)leaderboard.getCourseAreas().iterator().next();
            entry.courseAreaName = defaultCourseArea.getName();
            entry.courseAreaIdAsString = defaultCourseArea.getId().toString();
        }
        entry.boatClassName = boatClassName;
        entry.regattaDisplayName = regattaName;
        entry.leaderboardName = leaderboard.getName();
        entry.raceInfo = this.createRaceInfoDTO(seriesName, raceColumn, fleet, raceLog, state);
        entry.currentServerTime = new Date();
        entry.buyZoneRadius = buyZoneRadius;
        if (showOnlyRacesOfSameDay && !RaceStateOfSameDayHelper.isRaceStateOfSameDay((Date)entry.raceInfo.startTime, (Date)entry.raceInfo.finishedTime, (Date)entry.raceInfo.abortingTimeInPassBefore, (Calendar)dayToCheck, (Duration)clientTimeZoneOffset)) {
            entry = null;
        }
        return entry;
    }

    public void stopReplicatingFromMaster() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.START_REPLICATION);
        try {
            this.getReplicationService().stopToReplicateFromMaster();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception trying to stop replicating from master", e);
            throw new RuntimeException(e);
        }
    }

    public void stopAllReplicas() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.REPLICATE);
        try {
            this.getReplicationService().stopAllReplicas();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception trying to stop all replicas from receiving updates from this master", e);
            throw new RuntimeException(e);
        }
    }

    public void stopSingleReplicaInstance(String identifier) {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.REPLICATE);
        UUID uuid = UUID.fromString(identifier);
        try {
            this.getReplicationService().unregisterReplica(uuid);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception trying to unregister replica with UUID " + uuid, e);
            throw new RuntimeException(e);
        }
    }

    public void reloadRaceLog(String leaderboardName, RaceColumnDTO raceColumnDTO, FleetDTO fleet) throws NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        this.getService().reloadRaceLog(leaderboardName, raceColumnDTO.getName(), fleet.getName());
    }

    public RaceLogDTO getRaceLog(String leaderboardName, RaceColumnDTO raceColumnDTO, FleetDTO fleet) {
        Leaderboard lb = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)lb);
        if (lb instanceof RegattaLeaderboard) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)lb).getRegatta());
        }
        RaceLogDTO result = null;
        RaceLog raceLog = this.getService().getRaceLog(leaderboardName, raceColumnDTO.getName(), fleet.getName());
        if (raceLog != null) {
            ArrayList<RaceLogEventDTO> entries = new ArrayList<RaceLogEventDTO>();
            result = new RaceLogDTO(leaderboardName, raceColumnDTO.getName(), fleet.getName(), Integer.valueOf(raceLog.getCurrentPassId()), entries);
            raceLog.lockForRead();
            try {
                for (RaceLogEvent raceLogEvent : raceLog.getRawFixes()) {
                    RaceLogEventDTO entry = new RaceLogEventDTO(raceLogEvent.getPassId(), raceLogEvent.getAuthor().getName(), Integer.valueOf(raceLogEvent.getAuthor().getPriority()), raceLogEvent.getCreatedAt() != null ? raceLogEvent.getCreatedAt().asDate() : null, raceLogEvent.getLogicalTimePoint() != null ? raceLogEvent.getLogicalTimePoint().asDate() : null, raceLogEvent.getClass().getSimpleName(), raceLogEvent.getShortInfo());
                    entries.add(entry);
                }
            }
            finally {
                raceLog.unlockAfterRead();
            }
        }
        return result;
    }

    public RegattaLogDTO getRegattaLog(String leaderboardName) throws DoesNotHaveRegattaLogException {
        RegattaLogDTO result = null;
        Leaderboard l = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)l);
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        if (regattaLog != null) {
            ArrayList<RegattaLogEventDTO> entries = new ArrayList<RegattaLogEventDTO>();
            result = new RegattaLogDTO(leaderboardName, entries);
            regattaLog.lockForRead();
            try {
                for (RegattaLogEvent raceLogEvent : regattaLog.getRawFixes()) {
                    RegattaLogEventDTO entry = new RegattaLogEventDTO(raceLogEvent.getAuthor().getName(), Integer.valueOf(raceLogEvent.getAuthor().getPriority()), raceLogEvent.getCreatedAt() != null ? raceLogEvent.getCreatedAt().asDate() : null, raceLogEvent.getLogicalTimePoint() != null ? raceLogEvent.getLogicalTimePoint().asDate() : null, raceLogEvent.getClass().getSimpleName(), raceLogEvent.getShortInfo());
                    entries.add(entry);
                }
            }
            finally {
                regattaLog.unlockAfterRead();
            }
        }
        return result;
    }

    public Map<String, String> getLeaderboardGroupNamesAndIdsAsStringsFromRemoteServer(String url, String username, String password) {
        String token = RemoteServerUtil.resolveBearerTokenForRemoteServer((String)url, (String)username, (String)password);
        String path = "/sailingserver/api/v1/leaderboardgroups/identifiable";
        String query = null;
        URL serverAddress = null;
        InputStream inputStream = null;
        URLConnection connection = null;
        try {
            URL base = RemoteServerUtil.createBaseUrl((String)url);
            serverAddress = RemoteServerUtil.createRemoteServerUrl((URL)base, (String)"/sailingserver/api/v1/leaderboardgroups/identifiable", query);
            connection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)serverAddress, (Duration)Duration.ONE_MINUTE, (String)token);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
            JSONParser parser = new JSONParser();
            JSONArray array = (JSONArray)parser.parse((Reader)in);
            LinkedHashMap<String, String> leaderboardGroupsMap = new LinkedHashMap<String, String>();
            for (JSONObject next : array) {
                leaderboardGroupsMap.put((String)next.get((Object)"id"), (String)next.get((Object)"name"));
            }
            ArrayList entries = new ArrayList(leaderboardGroupsMap.entrySet());
            leaderboardGroupsMap.clear();
            entries.stream().sorted(Comparator.comparing(Map.Entry::getValue, Comparator.naturalOrder())).forEachOrdered(e -> {
                String string = leaderboardGroupsMap.put((String)e.getKey(), (String)e.getValue());
            });
            LinkedHashMap<String, String> linkedHashMap = leaderboardGroupsMap;
            return linkedHashMap;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e3) {
                logger.log(Level.WARNING, "Exception while trying to close the remote stream for leaderboard groups", e3);
            }
        }
    }

    public Iterable<CompetitorDTO> getCompetitors(boolean ignoreCompetitorsWithBoat, boolean ignoreCompetitorsWithoutBoat) {
        CompetitorAndBoatStore competitorStore = this.getService().getBaseDomainFactory().getCompetitorAndBoatStore();
        HasPermissions.Action[] requiredActionsForRead = SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS;
        Iterable<Object> filteredCompetitors = !ignoreCompetitorsWithBoat && !ignoreCompetitorsWithoutBoat ? competitorStore.getAllCompetitors() : (ignoreCompetitorsWithBoat && !ignoreCompetitorsWithoutBoat ? competitorStore.getCompetitorsWithoutBoat() : (!ignoreCompetitorsWithBoat && ignoreCompetitorsWithoutBoat ? competitorStore.getCompetitorsWithBoat() : Collections.emptyList()));
        return this.getSecurityService().mapAndFilterByAnyExplicitPermissionForCurrentUser(SecuredDomainType.COMPETITOR, requiredActionsForRead, filteredCompetitors, arg_0 -> this.convertToCompetitorDTO(arg_0));
    }

    public Iterable<CompetitorDTO> getCompetitorsOfLeaderboard(String leaderboardName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        return this.convertToCompetitorDTOs(leaderboard.getAllCompetitors());
    }

    public Map<? extends CompetitorDTO, BoatDTO> getCompetitorsAndBoatsOfRace(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        Map competitorsAndBoats = this.getService().getCompetitorToBoatMappingsForRace(leaderboardName, raceColumnName, fleetName);
        return this.baseDomainFactory.convertToCompetitorAndBoatDTOs(competitorsAndBoats);
    }

    public Iterable<BoatDTO> getAllBoats() {
        HasPermissions.Action[] requiredActionsForRead = SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS;
        List result = this.getSecurityService().mapAndFilterByAnyExplicitPermissionForCurrentUser(SecuredDomainType.BOAT, requiredActionsForRead, this.getService().getBaseDomainFactory().getCompetitorAndBoatStore().getBoats(), arg_0 -> this.convertToBoatDTO(arg_0));
        return result;
    }

    public Iterable<BoatDTO> getStandaloneBoats() {
        ArrayList<BoatDTO> result = new ArrayList<BoatDTO>();
        this.getSecurityService().filterObjectsWithAnyPermissionForCurrentUser(SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS, this.getService().getBaseDomainFactory().getCompetitorAndBoatStore().getStandaloneBoats(), filteredObject -> {
            boolean bl = result.add(this.convertToBoatDTO(filteredObject));
        });
        return result;
    }

    public BoatDTO getBoatLinkedToCompetitorForRace(String leaderboardName, String raceColumnName, String fleetName, String competitorIdAsString) throws NotFoundException {
        Boat boatOfCompetitor;
        BoatDTO result = null;
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        DynamicCompetitor existingCompetitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorIdAsString);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)existingCompetitor);
        Map competitorToBoatMappingsForRace = this.getService().getCompetitorToBoatMappingsForRace(leaderboardName, raceColumnName, fleetName);
        if (existingCompetitor != null && (boatOfCompetitor = (Boat)competitorToBoatMappingsForRace.get(existingCompetitor)) != null) {
            result = this.baseDomainFactory.convertToBoatDTO(boatOfCompetitor);
        }
        return result;
    }

    public List<DeviceConfigurationWithSecurityDTO> getDeviceConfigurations() {
        ArrayList<DeviceConfigurationWithSecurityDTO> configs = new ArrayList<DeviceConfigurationWithSecurityDTO>();
        for (DeviceConfiguration config : this.getService().getAllDeviceConfigurations()) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)config)) continue;
            configs.add(this.convertToDeviceConfigurationWithSecurityDTO(config));
        }
        return configs;
    }

    private DeviceConfigurationWithSecurityDTO convertToDeviceConfigurationWithSecurityDTO(DeviceConfiguration configuration) {
        DeviceConfigurationWithSecurityDTO dto = new DeviceConfigurationWithSecurityDTO(configuration.getIdentifier());
        dto.id = configuration.getId();
        dto.name = configuration.getName();
        dto.allowedCourseAreaNames = configuration.getAllowedCourseAreaNames();
        dto.resultsMailRecipient = configuration.getResultsMailRecipient();
        dto.byNameDesignerCourseNames = configuration.getByNameCourseDesignerCourseNames();
        configuration.getEventId().ifPresent(eventId -> {
            UUID uUID = deviceConfigurationWithSecurityDTO.eventId = eventId;
        });
        configuration.getCourseAreaId().ifPresent(courseAreaId -> {
            UUID uUID = deviceConfigurationWithSecurityDTO.courseAreaId = courseAreaId;
        });
        configuration.getPriority().ifPresent(priority -> {
            Integer n = deviceConfigurationWithSecurityDTO.priority = priority;
        });
        if (configuration.getRegattaConfiguration() != null) {
            dto.regattaConfiguration = this.convertToRegattaConfigurationDTO(configuration.getRegattaConfiguration());
        }
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)dto);
        return dto;
    }

    private DeviceConfigurationDTO.RegattaConfigurationDTO convertToRegattaConfigurationDTO(RegattaConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        DeviceConfigurationDTO.RegattaConfigurationDTO dto = new DeviceConfigurationDTO.RegattaConfigurationDTO();
        dto.defaultRacingProcedureType = configuration.getDefaultRacingProcedureType();
        dto.defaultCourseDesignerMode = configuration.getDefaultCourseDesignerMode();
        dto.defaultProtestTimeDuration = configuration.getDefaultProtestTimeDuration();
        if (configuration.getRRS26Configuration() != null) {
            dto.rrs26Configuration = new DeviceConfigurationDTO.RegattaConfigurationDTO.RRS26ConfigurationDTO();
            this.copyBasicRacingProcedureProperties((RacingProcedureConfiguration)configuration.getRRS26Configuration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.rrs26Configuration);
            this.copyRacingProcedureWithConfigurableStartModeFlagProperties((ConfigurableStartModeFlagRacingProcedureConfiguration)configuration.getRRS26Configuration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO)dto.rrs26Configuration);
        }
        if (configuration.getSWCStartConfiguration() != null) {
            dto.swcStartConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.SWCStartConfigurationDTO();
            this.copyBasicRacingProcedureProperties((RacingProcedureConfiguration)configuration.getSWCStartConfiguration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.swcStartConfiguration);
            this.copyRacingProcedureWithConfigurableStartModeFlagProperties((ConfigurableStartModeFlagRacingProcedureConfiguration)configuration.getSWCStartConfiguration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO)dto.swcStartConfiguration);
        }
        if (configuration.getGateStartConfiguration() != null) {
            dto.gateStartConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.GateStartConfigurationDTO();
            this.copyBasicRacingProcedureProperties((RacingProcedureConfiguration)configuration.getGateStartConfiguration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.gateStartConfiguration);
            dto.gateStartConfiguration.hasPathfinder = configuration.getGateStartConfiguration().hasPathfinder();
            dto.gateStartConfiguration.hasAdditionalGolfDownTime = configuration.getGateStartConfiguration().hasAdditionalGolfDownTime();
        }
        if (configuration.getESSConfiguration() != null) {
            dto.essConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.ESSConfigurationDTO();
            this.copyBasicRacingProcedureProperties((RacingProcedureConfiguration)configuration.getESSConfiguration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.essConfiguration);
        }
        if (configuration.getBasicConfiguration() != null) {
            dto.basicConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO();
            this.copyBasicRacingProcedureProperties(configuration.getBasicConfiguration(), dto.basicConfiguration);
        }
        if (configuration.getLeagueConfiguration() != null) {
            dto.leagueConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.LeagueConfigurationDTO();
            this.copyBasicRacingProcedureProperties((RacingProcedureConfiguration)configuration.getLeagueConfiguration(), (DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.leagueConfiguration);
        }
        return dto;
    }

    private void copyBasicRacingProcedureProperties(RacingProcedureConfiguration configuration, DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO racingProcedureConfigurationDTO) {
        racingProcedureConfigurationDTO.classFlag = configuration.getClassFlag();
        racingProcedureConfigurationDTO.hasIndividualRecall = configuration.hasIndividualRecall();
        racingProcedureConfigurationDTO.isResultEntryEnabled = configuration.isResultEntryEnabled();
    }

    private void copyRacingProcedureWithConfigurableStartModeFlagProperties(ConfigurableStartModeFlagRacingProcedureConfiguration configuration, DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO racingProcedureConfigurationDTO) {
        racingProcedureConfigurationDTO.startModeFlags = configuration.getStartModeFlags();
    }

    protected RegattaConfiguration convertToRegattaConfiguration(DeviceConfigurationDTO.RegattaConfigurationDTO dto) {
        RRS26ConfigurationImpl config;
        if (dto == null) {
            return null;
        }
        RegattaConfigurationImpl configuration = new RegattaConfigurationImpl();
        configuration.setDefaultRacingProcedureType(dto.defaultRacingProcedureType);
        configuration.setDefaultCourseDesignerMode(dto.defaultCourseDesignerMode);
        configuration.setDefaultProtestTimeDuration(dto.defaultProtestTimeDuration);
        if (dto.rrs26Configuration != null) {
            config = new RRS26ConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.rrs26Configuration, (RacingProcedureConfigurationImpl)config);
            this.applyRacingProcedureWithConfigurableStartModeFlagConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO)dto.rrs26Configuration, (RacingProcedureWithConfigurableStartModeFlagConfigurationImpl)config);
            configuration.setRRS26Configuration((RRS26Configuration)config);
        }
        if (dto.swcStartConfiguration != null) {
            config = new SWCStartConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.swcStartConfiguration, (RacingProcedureConfigurationImpl)config);
            this.applyRacingProcedureWithConfigurableStartModeFlagConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO)dto.swcStartConfiguration, (RacingProcedureWithConfigurableStartModeFlagConfigurationImpl)config);
            configuration.setSWCStartConfiguration((SWCStartConfiguration)config);
        }
        if (dto.gateStartConfiguration != null) {
            config = new GateStartConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.gateStartConfiguration, (RacingProcedureConfigurationImpl)config);
            config.setHasPathfinder(dto.gateStartConfiguration.hasPathfinder);
            config.setHasAdditionalGolfDownTime(dto.gateStartConfiguration.hasAdditionalGolfDownTime);
            configuration.setGateStartConfiguration((GateStartConfiguration)config);
        }
        if (dto.essConfiguration != null) {
            config = new ESSConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.essConfiguration, (RacingProcedureConfigurationImpl)config);
            configuration.setESSConfiguration((ESSConfiguration)config);
        }
        if (dto.basicConfiguration != null) {
            config = new RacingProcedureConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties(dto.basicConfiguration, (RacingProcedureConfigurationImpl)config);
            configuration.setBasicConfiguration((RacingProcedureConfiguration)config);
        }
        if (dto.leagueConfiguration != null) {
            config = new LeagueConfigurationImpl();
            this.applyGeneralRacingProcedureConfigProperties((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)dto.leagueConfiguration, (RacingProcedureConfigurationImpl)config);
            configuration.setLeagueConfiguration((LeagueConfiguration)config);
        }
        return configuration;
    }

    private void applyGeneralRacingProcedureConfigProperties(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO racingProcedureConfigurationDTO, RacingProcedureConfigurationImpl config) {
        config.setClassFlag(racingProcedureConfigurationDTO.classFlag);
        config.setHasIndividualRecall(racingProcedureConfigurationDTO.hasIndividualRecall);
        config.setResultEntryEnabled(racingProcedureConfigurationDTO.isResultEntryEnabled);
    }

    private void applyRacingProcedureWithConfigurableStartModeFlagConfigProperties(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureWithConfigurableStartModeFlagConfigurationDTO racingProcedureConfigurationDTO, RacingProcedureWithConfigurableStartModeFlagConfigurationImpl config) {
        config.setStartModeFlags(racingProcedureConfigurationDTO.startModeFlags);
    }

    public Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> getTrackingTimes(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Util.Pair times = raceLog != null ? (Util.Pair)new TrackingTimesFinder(raceLog).analyze() : null;
        return times;
    }

    public Util.Triple<Date, Integer, RacingProcedureType> getStartTimeAndProcedure(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        Util.Triple result = this.getService().getStartTimeAndProcedure(leaderboardName, raceColumnName, fleetName);
        if (result == null || result.getA() == null) {
            return null;
        }
        return new Util.Triple((Object)(result.getA() == null ? null : ((TimePoint)result.getA()).asDate()), (Object)((Integer)result.getB()), (Object)((RacingProcedureType)result.getC()));
    }

    public Util.Triple<Date, Date, Integer> getFinishingAndFinishTime(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        Util.Triple result = this.getService().getFinishingAndFinishTime(leaderboardName, raceColumnName, fleetName);
        if (result == null) {
            return null;
        }
        return new Util.Triple((Object)(result.getA() == null ? null : ((TimePoint)result.getA()).asDate()), (Object)(result.getB() == null ? null : ((TimePoint)result.getB()).asDate()), (Object)((Integer)result.getC()));
    }

    public Util.Pair<String, Boolean> getIgtimiConnectionFactoryBaseUrl() {
        IgtimiConnectionFactory igtimiConnectionFactory = this.getIgtimiConnectionFactory();
        return new Util.Pair((Object)igtimiConnectionFactory.getBaseUrl().toString(), (Object)igtimiConnectionFactory.hasCredentials());
    }

    public ArrayList<IgtimiDeviceWithSecurityDTO> getAllIgtimiDevicesWithSecurity() throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HashMap remoteAddressByDeviceSerialNumber = new HashMap();
        RiotServer riotServer = this.getRiotServer();
        MultiTimeRange infiniteTimeRange = MultiTimeRange.of((TimeRange[])new TimeRange[]{TimeRange.create(null, null)});
        return new ArrayList<IgtimiDeviceWithSecurityDTO>(Util.asList((Iterable)this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(riotServer.getDevices(), device -> {
            SocketAddress remoteAddress = (SocketAddress)remoteAddressByDeviceSerialNumber.get(device.getSerialNumber());
            try {
                return this.toSecuredIgtimiDeviceDTO(device, remoteAddress == null ? null : remoteAddress.toString(), this.getPositionFromMessage((GpsLatLong)riotServer.getLastFix(device.getSerialNumber(), GpsLatLong.class, infiniteTimeRange)), this.getBatteryPercentFromMessage((BatteryLevel)riotServer.getLastFix(device.getSerialNumber(), BatteryLevel.class, infiniteTimeRange)));
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
        })));
    }

    private Position getPositionFromMessage(GpsLatLong fix) {
        return fix == null ? null : fix.getPosition();
    }

    private double getBatteryPercentFromMessage(BatteryLevel fix) {
        return fix == null ? Double.NaN : fix.getPercentage();
    }

    public ArrayList<IgtimiDataAccessWindowWithSecurityDTO> getAllIgtimiDataAccessWindowsWithSecurity() throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        return new ArrayList<IgtimiDataAccessWindowWithSecurityDTO>(Util.asList((Iterable)this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getRiotServer().getDataAccessWindows(), arg_0 -> this.toSecuredIgtimiDataAccessWindowDTO(arg_0))));
    }

    private IgtimiDeviceWithSecurityDTO toSecuredIgtimiDeviceDTO(Device igtimiDevice, String remoteAddress, Position lastKnownPosition, double lastKnownBatteryPercent) {
        long id = igtimiDevice.getId();
        String serialNumber = igtimiDevice.getSerialNumber();
        String name = igtimiDevice.getName();
        Util.Pair lastHeartBeat = igtimiDevice.getLastHeartbeat();
        IgtimiDeviceWithSecurityDTO securedDevice = new IgtimiDeviceWithSecurityDTO(id, serialNumber, name, lastHeartBeat, lastKnownPosition, lastKnownBatteryPercent);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)securedDevice);
        return securedDevice;
    }

    private IgtimiDataAccessWindowWithSecurityDTO toSecuredIgtimiDataAccessWindowDTO(DataAccessWindow daw) {
        long id = daw.getId();
        String serialNumber = daw.getDeviceSerialNumber();
        Date from = daw.getStartTime() == null ? null : daw.getStartTime().asDate();
        Date to = daw.getEndTime() == null ? null : daw.getEndTime().asDate();
        IgtimiDataAccessWindowWithSecurityDTO securedDAW = new IgtimiDataAccessWindowWithSecurityDTO(id, serialNumber, from, to);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)securedDAW);
        return securedDAW;
    }

    protected IgtimiConnectionFactory getIgtimiConnectionFactory() {
        return (IgtimiConnectionFactory)this.igtimiConnectionFactoryTracker.getService();
    }

    protected RiotServer getRiotServer() {
        return (RiotServer)this.riotServerTracker.getService();
    }

    protected RaceLogTrackingAdapterFactory getRaceLogTrackingAdapterFactory() {
        return (RaceLogTrackingAdapterFactory)this.raceLogTrackingAdapterTracker.getService();
    }

    protected RaceLogTrackingAdapter getRaceLogTrackingAdapter() {
        return this.getRaceLogTrackingAdapterFactory().getAdapter(this.getBaseDomainFactory());
    }

    protected YellowBrickTrackingAdapterFactory getYellowBrickTrackingAdapterFactory() {
        return (YellowBrickTrackingAdapterFactory)this.yellowBrickTrackingAdapterTracker.getService();
    }

    protected YellowBrickTrackingAdapter getYellowBrickTrackingAdapter() {
        return this.getYellowBrickTrackingAdapterFactory().getYellowBrickTrackingAdapter(this.getBaseDomainFactory());
    }

    protected Set<DynamicTrackedRace> getAllTrackedRaces() {
        HashSet<DynamicTrackedRace> result = new HashSet<DynamicTrackedRace>();
        Iterable allRegattas = this.getService().getAllRegattas();
        for (Regatta regatta : allRegattas) {
            DynamicTrackedRegatta trackedRegatta = this.getService().getTrackedRegatta(regatta);
            if (trackedRegatta == null) continue;
            trackedRegatta.lockTrackedRacesForRead();
            try {
                Iterable trackedRaces = trackedRegatta.getTrackedRaces();
                for (TrackedRace trackedRace : trackedRaces) {
                    result.add((DynamicTrackedRace)trackedRace);
                }
            }
            finally {
                trackedRegatta.unlockTrackedRacesAfterRead();
            }
        }
        return result;
    }

    protected RaceLog getRaceLog(Util.Triple<String, String, String> triple) throws NotFoundException {
        return this.getRaceLog((String)triple.getA(), (String)triple.getB(), (String)triple.getC());
    }

    protected RegattaLog getRegattaLogInternal(String leaderboardName) throws DoesNotHaveRegattaLogException {
        Leaderboard l = this.getService().getLeaderboardByName(leaderboardName);
        if (!(l instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        return ((HasRegattaLike)l).getRegattaLike().getRegattaLog();
    }

    protected RaceLog getRaceLog(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return raceColumn.getRaceLog(fleet);
    }

    protected Competitor getCompetitor(CompetitorDTO dto) {
        return this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(dto.getIdAsString());
    }

    protected CompetitorWithBoat getCompetitor(CompetitorWithBoatDTO dto) {
        return this.getService().getCompetitorAndBoatStore().getExistingCompetitorWithBoatByIdAsString(dto.getIdAsString());
    }

    protected Boat getBoat(BoatDTO dto) {
        return this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(dto.getIdAsString());
    }

    protected Mark convertToMark(MarkDTO dto, boolean resolve) {
        Mark existing;
        Mark result = null;
        if (resolve && (existing = this.baseDomainFactory.getExistingMarkByIdAsString(dto.getIdAsString())) != null) {
            result = existing;
        }
        if (result == null) {
            UUID id = UUID.randomUUID();
            result = this.baseDomainFactory.getOrCreateMark((Serializable)id, dto.getName(), dto.getShortName(), dto.type, dto.color, dto.shape, dto.pattern);
        }
        return result;
    }

    private MarkDTO convertToMarkDTO(LeaderboardThatHasRegattaLike leaderboard, Mark mark) {
        TimePoint now = MillisecondsTimePoint.now();
        Position lastPos = this.getService().getMarkPosition(mark, leaderboard, now);
        return this.convertToMarkDTO(mark, lastPos);
    }

    private WaypointDTO convertToWaypointDTO(Waypoint waypoint, Map<Serializable, ControlPointDTO> controlPointCache, MarkPositionFinder positionFinder, TimePoint timePoint) {
        ControlPointDTO cp = controlPointCache.get(waypoint.getControlPoint().getId());
        if (cp == null) {
            cp = this.convertToControlPointDTO(waypoint.getControlPoint(), positionFinder, timePoint);
            controlPointCache.put(waypoint.getControlPoint().getId(), cp);
        }
        return new WaypointDTO(waypoint.getName(), cp, waypoint.getPassingInstructions());
    }

    private RaceCourseDTO convertToRaceCourseDTO(CourseBase course, MarkPositionFinder positionFinder, TimePoint timePoint) {
        RaceCourseDTO result;
        if (course != null) {
            ArrayList<WaypointDTO> waypointDTOs = new ArrayList<WaypointDTO>();
            HashMap controlPointCache = new HashMap();
            for (Waypoint waypoint : course.getWaypoints()) {
                waypointDTOs.add(this.convertToWaypointDTO(waypoint, controlPointCache, positionFinder, timePoint));
            }
            result = new RaceCourseDTO(waypointDTOs);
        } else {
            result = new RaceCourseDTO(Collections.emptyList());
        }
        return result;
    }

    public RaceCourseDTO getLastCourseDefinitionInRaceLog(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        CourseBase lastPublishedCourse = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, true).analyze();
        if (lastPublishedCourse == null) {
            lastPublishedCourse = new CourseDataImpl("");
        }
        return this.convertToRaceCourseDTO(lastPublishedCourse, (MarkPositionFinder)new /* Unavailable Anonymous Inner Class!! */, MillisecondsTimePoint.now());
    }

    private TypeBasedServiceFinder<DeviceIdentifierStringSerializationHandler> getDeviceIdentifierStringSerializerHandlerFinder(boolean withFallback) {
        TypeBasedServiceFinderFactory factory = this.getService().getTypeBasedServiceFinderFactory();
        TypeBasedServiceFinder finder = factory.createServiceFinder(DeviceIdentifierStringSerializationHandler.class);
        if (withFallback) {
            finder.setFallbackService((Object)new PlaceHolderDeviceIdentifierStringSerializationHandler());
        }
        return finder;
    }

    protected DeviceIdentifier deserializeDeviceIdentifier(String type, String deviceId) throws NoCorrespondingServiceRegisteredException, TransformationException {
        DeviceIdentifierStringSerializationHandler handler = (DeviceIdentifierStringSerializationHandler)this.getDeviceIdentifierStringSerializerHandlerFinder(false).findService(type);
        return handler.deserialize((Object)deviceId, type, deviceId);
    }

    protected String serializeDeviceIdentifier(DeviceIdentifier deviceId) throws TransformationException {
        return (String)((DeviceIdentifierStringSerializationHandler)this.getDeviceIdentifierStringSerializerHandlerFinder(true).findService(deviceId.getIdentifierType())).serialize(deviceId).getB();
    }

    protected List<AbstractLog<?, ?>> getLogHierarchy(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        Leaderboard leaderboard;
        ArrayList result = new ArrayList();
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        if (raceLog != null) {
            result.add((AbstractLog<?, ?>)raceLog);
        }
        if ((leaderboard = this.getLeaderboardByName(leaderboardName)) instanceof HasRegattaLike) {
            result.add((AbstractLog<?, ?>)((HasRegattaLike)leaderboard).getRegattaLike().getRegattaLog());
        }
        return result;
    }

    public List<String> getDeserializableDeviceIdentifierTypes() {
        ArrayList<String> result = new ArrayList<String>();
        ServiceReference[] serviceReferenceArray = this.deviceIdentifierStringSerializationHandlerTracker.getServiceReferences();
        int n = serviceReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            result.add((String)reference.getProperty("type"));
            ++n2;
        }
        return result;
    }

    protected DeviceMapping<?> convertToDeviceMapping(DeviceMappingDTO dto) throws NoCorrespondingServiceRegisteredException, TransformationException {
        DeviceIdentifier device = this.convertDtoToDeviceIdentifier(dto.deviceIdentifier);
        MillisecondsTimePoint from = dto.from == null ? null : new MillisecondsTimePoint(dto.from);
        MillisecondsTimePoint to = dto.to == null ? null : new MillisecondsTimePoint(dto.to);
        TimeRangeImpl timeRange = new TimeRangeImpl((TimePoint)from, (TimePoint)to);
        if (dto.mappedTo instanceof MarkDTO) {
            Mark mark = this.convertToMark((MarkDTO)dto.mappedTo, true);
            return new DeviceMappingImpl((WithID)mark, device, (TimeRange)timeRange, dto.originalRaceLogEventIds, RegattaLogDeviceMarkMappingEventImpl.class);
        }
        if (dto.mappedTo instanceof CompetitorDTO) {
            DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(((CompetitorDTO)dto.mappedTo).getIdAsString());
            return new DeviceMappingImpl((WithID)competitor, device, (TimeRange)timeRange, dto.originalRaceLogEventIds, RegattaLogDeviceCompetitorMappingEventImpl.class);
        }
        if (dto.mappedTo instanceof BoatDTO) {
            DynamicBoat boat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(dto.mappedTo.getIdAsString());
            return new DeviceMappingImpl((WithID)boat, device, (TimeRange)timeRange, dto.originalRaceLogEventIds, RegattaLogDeviceBoatMappingEventImpl.class);
        }
        throw new RuntimeException("Can only map devices to competitors, boats or marks");
    }

    public Collection<String> getGPSFixImporterTypes() {
        return this.getRegisteredImporterTypes(GPSFixImporter.class);
    }

    public Collection<String> getSensorDataImporterTypes() {
        return this.getRegisteredImporterTypes(DoubleVectorFixImporter.class);
    }

    private <S> Collection<String> getRegisteredImporterTypes(Class<S> referenceClass) {
        HashSet<String> result = new HashSet<String>();
        for (ServiceReference reference : this.getRegisteredServiceReferences(referenceClass)) {
            result.add((String)reference.getProperty("type"));
        }
        return result;
    }

    protected <S extends DoubleVectorFixImporter> S getRegisteredImporter(Class<S> referenceClass, String type) throws NoCorrespondingServiceRegisteredException {
        for (ServiceReference reference : this.getRegisteredServiceReferences(referenceClass)) {
            DoubleVectorFixImporter importer = (DoubleVectorFixImporter)Activator.getDefault().getService(reference);
            if (importer == null || !importer.getType().equals(type)) continue;
            return (S)importer;
        }
        throw new NoCorrespondingServiceRegisteredException("No importer service found!", type, referenceClass.getName());
    }

    private <S> Collection<ServiceReference<S>> getRegisteredServiceReferences(Class<S> referenceClass) {
        try {
            return Activator.getDefault().getServiceReferences(referenceClass, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return Collections.emptyList();
        }
    }

    public ArrayList<EventDTO> getEventsForLeaderboard(String leaderboardName) {
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        Set events = service.findEventsContainingLeaderboardAndMatchingAtLeastOneCourseArea(leaderboard, service.getAllEvents());
        ArrayList<EventDTO> eventDTOs = new ArrayList<EventDTO>();
        for (Event event : events) {
            eventDTOs.add(this.convertToEventDTO(event, false));
        }
        return eventDTOs;
    }

    public Map<Integer, Date> getCompetitorRaceLogMarkPassingData(String leaderboardName, String raceColumnName, String fleetName, CompetitorDTO competitor) throws NotFoundException {
        HashMap<Integer, Date> result = new HashMap<Integer, Date>();
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceLog raceLog = this.getService().getRaceLog(leaderboardName, raceColumnName, fleetName);
        for (Util.Triple fixedEvent : (Set)new MarkPassingDataFinder(raceLog).analyze()) {
            if (!((Competitor)fixedEvent.getA()).getName().equals(competitor.getName())) continue;
            Date date = fixedEvent.getC() != null ? new Date(((TimePoint)fixedEvent.getC()).asMillis()) : null;
            result.put((Integer)fixedEvent.getB(), date);
        }
        return result;
    }

    public Map<Integer, Date> getCompetitorMarkPassings(RegattaAndRaceIdentifier race, CompetitorDTO competitorDTO, boolean waitForCalculations) {
        HashMap<Integer, Date> result = new HashMap<Integer, Date>();
        TrackedRace trackedRace = this.getExistingTrackedRace(race);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        if (trackedRace != null) {
            Competitor competitor = this.getCompetitorByIdAsString(trackedRace.getRace().getCompetitors(), competitorDTO.getIdAsString());
            NavigableSet competitorMarkPassings = trackedRace.getMarkPassings(competitor, waitForCalculations);
            Iterable waypoints = trackedRace.getRace().getCourse().getWaypoints();
            if (competitorMarkPassings != null) {
                for (MarkPassing markPassing : competitorMarkPassings) {
                    result.put(Util.indexOf((Iterable)waypoints, (Object)markPassing.getWaypoint()), markPassing.getTimePoint().asDate());
                }
            }
        }
        return result;
    }

    protected Locale getLocale(String localeInfoName) {
        return ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
    }

    public Iterable<MarkDTO> getMarksInRegattaLog(String leaderboardName) throws DoesNotHaveRegattaLogException {
        Leaderboard l = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)l);
        if (!(l instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        LeaderboardThatHasRegattaLike leaderboard = (LeaderboardThatHasRegattaLike)l;
        RegattaLog regattaLog = leaderboard.getRegattaLike().getRegattaLog();
        HashSet<MarkDTO> markDTOs = new HashSet<MarkDTO>();
        List markEvents = (List)new AllEventsOfTypeFinder((AbstractLog)regattaLog, true, RegattaLogDefineMarkEvent.class).analyze();
        for (RegattaLogEvent regattaLogEvent : markEvents) {
            RegattaLogDefineMarkEvent defineMarkEvent = (RegattaLogDefineMarkEvent)regattaLogEvent;
            markDTOs.add(this.convertToMarkDTO(leaderboard, defineMarkEvent.getMark()));
        }
        return markDTOs;
    }

    protected List<AbstractLog<?, ?>> getLogHierarchy(String leaderboardName) {
        ArrayList result;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            result = null;
        } else {
            result = new ArrayList();
            if (leaderboard instanceof HasRegattaLike) {
                result.add((AbstractLog<?, ?>)((HasRegattaLike)leaderboard).getRegattaLike().getRegattaLog());
            }
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                for (Fleet fleet : raceColumn.getFleets()) {
                    RaceLog raceLog = raceColumn.getRaceLog(fleet);
                    result.add((AbstractLog<?, ?>)raceLog);
                }
            }
        }
        return result;
    }

    public boolean doesRegattaLogContainCompetitors(String leaderboardName) throws DoesNotHaveRegattaLogException, NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        List comeptitorRegistrationEvents = (List)new AllEventsOfTypeFinder((AbstractLog)regattaLog, true, RegattaLogRegisterCompetitorEvent.class).analyze();
        return !comeptitorRegistrationEvents.isEmpty();
    }

    public Util.Pair<RegattaAndRaceIdentifier, SecuredDTO> getRaceIdentifierAndTrackedRaceSecuredDTO(String regattaLikeName, String raceColumnName, String fleetName) {
        Fleet fleet;
        RaceColumn raceColumn;
        RegattaAndRaceIdentifier result = null;
        String raceName = null;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaLikeName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null && (fleet = raceColumn.getFleetByName(fleetName)) != null) {
            TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
            if (trackedRace != null) {
                result = trackedRace.getRaceIdentifier();
                raceName = trackedRace.getRace().getName();
            }
        }
        EssentialSecuredDTO trackedRaceSecuredDTOProxy = result == null ? null : new EssentialSecuredDTO(RaceDTO.getPermissionTypeForClass(), raceName, result.getTypeRelativeObjectIdentifier());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)trackedRaceSecuredDTOProxy);
        return new Util.Pair(result, (Object)trackedRaceSecuredDTOProxy);
    }

    public Collection<CompetitorAndBoatDTO> getCompetitorRegistrationsForRace(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return this.convertToCompetitorAndBoatDTOs(raceColumn.getAllCompetitorsAndTheirBoats(fleet));
    }

    public Collection<CompetitorDTO> getCompetitorRegistrationsForLeaderboard(String leaderboardName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        return this.convertToCompetitorDTOs(leaderboard.getAllCompetitors());
    }

    public Collection<CompetitorDTO> getCompetitorRegistrationsInRegattaLog(String leaderboardName) throws DoesNotHaveRegattaLogException, NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (!(leaderboard instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        HasRegattaLike regattaLikeLeaderboard = (HasRegattaLike)leaderboard;
        return this.convertToCompetitorDTOs(regattaLikeLeaderboard.getCompetitorsRegisteredInRegattaLog());
    }

    public List<CompetitorAndBoatDTO> getCompetitorRegistrationsInRaceLog(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return this.convertToCompetitorAndBoatDTOs(raceColumn.getCompetitorsRegisteredInRacelog(fleet));
    }

    public Map<CompetitorDTO, BoatDTO> getCompetitorAndBoatRegistrationsInRaceLog(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        Map competitorsAndBoatsRegisteredInRacelog = raceColumn.getCompetitorsRegisteredInRacelog(fleet);
        return this.baseDomainFactory.convertToCompetitorAndBoatDTOs(competitorsAndBoatsRegisteredInRacelog);
    }

    public Collection<BoatDTO> getBoatRegistrationsInRegattaLog(String leaderboardName) throws DoesNotHaveRegattaLogException, NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (!(leaderboard instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        HasRegattaLike regattaLikeLeaderboard = (HasRegattaLike)leaderboard;
        return this.convertToBoatDTOs(regattaLikeLeaderboard.getBoatsRegisteredInRegattaLog());
    }

    public Collection<BoatDTO> getBoatRegistrationsForLeaderboard(String leaderboardName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        return this.convertToBoatDTOs(leaderboard.getAllBoats());
    }

    public Collection<BoatDTO> getBoatRegistrationsForRegatta(RegattaIdentifier regattaIdentifier) throws NotFoundException {
        Regatta regatta = (Regatta)regattaIdentifier.getRegatta((RegattaFetcher)this.getService());
        if (regatta == null) {
            throw new NotFoundException("Regatta " + regattaIdentifier + " not found");
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        return this.convertToBoatDTOs(regatta.getAllBoats());
    }

    public Boolean areCompetitorRegistrationsEnabledForRace(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return raceColumn.isCompetitorRegistrationInRacelogEnabled(fleet);
    }

    protected Fleet getFleetByName(RaceColumn raceColumn, String fleetName) throws NotFoundException {
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            throw new NotFoundException("fleet with name " + fleetName + " not found");
        }
        return fleet;
    }

    protected Leaderboard getLeaderboardByName(String leaderboardName) throws NotFoundException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new NotFoundException("Leaderboard with name " + leaderboardName + " not found");
        }
        return leaderboard;
    }

    protected RaceColumn getRaceColumn(String leaderboardName, String raceColumnName) throws NotFoundException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            throw new NotFoundException("raceColumn with name " + raceColumnName + " not found");
        }
        return raceColumn;
    }

    public Util.Pair<Boolean, String> checkIfMarksAreUsedInOtherRaceLogs(String leaderboardName, String raceColumnName, String fleetName, Set<MarkDTO> marksToRemove) throws NotFoundException {
        HashSet<String> markIds = new HashSet<String>();
        for (MarkDTO markDTO : marksToRemove) {
            markIds.add(markDTO.getIdAsString());
        }
        return this.getService().checkIfMarksAreUsedInOtherRaceLogs(leaderboardName, raceColumnName, fleetName, markIds);
    }

    public Iterable<MarkDTO> getMarksInTrackedRace(String leaderboardName, String raceColumnName, String fleetName) {
        Fleet fleet;
        RaceColumn raceColumn;
        ArrayList<MarkDTO> marks = new ArrayList<MarkDTO>();
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null && (fleet = raceColumn.getFleetByName(fleetName)) != null) {
            for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                marks.add(new MarkDTO(mark.getId().toString(), mark.getName(), mark.getShortName()));
            }
        }
        return marks;
    }

    protected Iterable<GPSFixDTO> convertToGPSFixDTOTrack(Track<? extends GPSFix> track) {
        ArrayList<GPSFixDTO> result = new ArrayList<GPSFixDTO>();
        track.lockForRead();
        try {
            for (GPSFix fix : track.getRawFixes()) {
                result.add(this.convertToGPSFixDTO(fix));
            }
        }
        finally {
            track.unlockAfterRead();
        }
        return result;
    }

    private GPSFixDTO convertToGPSFixDTO(GPSFix fix) {
        GPSFixDTO result = fix == null ? null : new GPSFixDTO(fix.getTimePoint().asDate(), fix.getPosition());
        return result;
    }

    public boolean canRemoveMarkFix(String leaderboardName, String raceColumnName, String fleetName, String markIdAsString, GPSFixDTO fix) {
        RaceColumn raceColumn;
        boolean result = false;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            MillisecondsTimePoint fixTimePoint = new MillisecondsTimePoint(fix.timepoint);
            RegattaLog regattaLog = raceColumn.getRegattaLog();
            RegattaLogDeviceMarkMappingFinder mappingFinder = new RegattaLogDeviceMarkMappingFinder(regattaLog);
            Fleet fleet = raceColumn.getFleetByName(fleetName);
            if (fleet != null) {
                for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                    if (mark.getId().toString().equals(markIdAsString) && (result = mappingFinder.hasMappingFor((WithID)mark, (TimePoint)fixTimePoint))) break;
                }
            }
        }
        return result;
    }

    public Map<Util.Triple<String, String, String>, Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>> getTrackingTimes(Collection<Util.Triple<String, String, String>> leaderboardRaceColumnFleetNames) {
        HashMap<Util.Triple<String, String, String>, Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>> trackingTimes = new HashMap<Util.Triple<String, String, String>, Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>>();
        for (Util.Triple<String, String, String> leaderboardRaceColumnFleetName : leaderboardRaceColumnFleetNames) {
            try {
                trackingTimes.put(leaderboardRaceColumnFleetName, (Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>)this.getTrackingTimes((String)leaderboardRaceColumnFleetName.getA(), (String)leaderboardRaceColumnFleetName.getB(), (String)leaderboardRaceColumnFleetName.getC()));
            }
            catch (Exception e) {
                trackingTimes.put(leaderboardRaceColumnFleetName, null);
            }
        }
        return trackingTimes;
    }

    public Collection<CompetitorDTO> getEliminatedCompetitors(String leaderboardName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard == null || !(leaderboard instanceof RegattaLeaderboardWithEliminations)) {
            throw new IllegalArgumentException(String.valueOf(leaderboardName) + " does not match a regatta leaderboard with eliminations");
        }
        RegattaLeaderboardWithEliminations rlwe = (RegattaLeaderboardWithEliminations)leaderboard;
        return this.convertToCompetitorDTOs((Iterable)rlwe.getEliminatedCompetitors());
    }

    /*
     * Exception decompiling
     */
    public Iterable<DetailType> determineDetailTypesForCompetitorChart(String leaderboardGroupName, UUID leaderboardGroupId, RegattaAndRaceIdentifier identifier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ExpeditionDeviceConfiguration> getExpeditionDeviceConfigurations() {
        ArrayList<ExpeditionDeviceConfiguration> result = new ArrayList<ExpeditionDeviceConfiguration>();
        ExpeditionTrackerFactory expeditionConnector = (ExpeditionTrackerFactory)this.expeditionConnectorTracker.getService();
        Subject subject = SecurityUtils.getSubject();
        if (expeditionConnector != null) {
            for (ExpeditionDeviceConfiguration config : expeditionConnector.getDeviceConfigurations()) {
                if (!subject.isPermitted(config.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)config);
                result.add(config);
            }
        }
        return result;
    }

    public PairingListTemplateDTO calculatePairingListTemplate(int flightCount, int groupCount, int competitorCount, int flightMultiplier, int tolerance) {
        PairingListTemplate template = this.getService().createPairingListTemplate(flightCount, groupCount, competitorCount, flightMultiplier, tolerance);
        return new PairingListTemplateDTO(flightCount, groupCount, competitorCount, flightMultiplier, tolerance, template.getBoatChanges(), template.getPairingListTemplate(), template.getQuality(), template.getBoatAssignmentsQuality());
    }

    public PairingListDTO getPairingListFromTemplate(String leaderboardName, int flightMultiplier, Iterable<String> selectedRaceColumnNames, PairingListTemplateDTO templateDTO) throws NotFoundException, PairingListCreationException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        ArrayList<RaceColumn> selectedRaces = new ArrayList<RaceColumn>();
        for (String raceColumnName : selectedRaceColumnNames) {
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                if (!raceColumnName.equalsIgnoreCase(raceColumn.getName())) continue;
                selectedRaces.add(raceColumn);
            }
        }
        PairingListTemplateImpl pairingListTemplate = new PairingListTemplateImpl(templateDTO.getPairingListTemplate(), templateDTO.getCompetitorCount(), templateDTO.getFlightMultiplier(), templateDTO.getBoatChangeFactor());
        PairingList pairingList = this.getService().getPairingListFromTemplate((PairingListTemplate)pairingListTemplate, leaderboardName, selectedRaces);
        ArrayList result = new ArrayList();
        for (RaceColumn raceColumn : selectedRaces) {
            ArrayList raceColumnList = new ArrayList();
            for (Fleet fleet : raceColumn.getFleets()) {
                ArrayList<Util.Pair> fleetList = new ArrayList<Util.Pair>();
                for (Util.Pair competitorAndBoatPair : pairingList.getCompetitors((Object)raceColumn, (Object)fleet)) {
                    Boat boat = (Boat)competitorAndBoatPair.getB();
                    CompetitorDTO competitorDTO = competitorAndBoatPair.getA() != null ? this.baseDomainFactory.convertToCompetitorDTO((Competitor)competitorAndBoatPair.getA()) : null;
                    BoatDTO boatDTO = boat != null ? new BoatDTO(boat.getId().toString(), boat.getName(), this.convertToBoatClassDTO(boat.getBoatClass()), boat.getSailID(), boat.getColor()) : null;
                    fleetList.add(new Util.Pair((Object)competitorDTO, boatDTO));
                }
                raceColumnList.add(fleetList);
            }
            result.add(raceColumnList);
        }
        return new PairingListDTO(result, Util.asList(selectedRaceColumnNames));
    }

    public PairingListDTO getPairingListFromRaceLogs(String leaderboardName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        ArrayList result = new ArrayList();
        ArrayList<String> raceColumnNames = new ArrayList<String>();
        PairingListLeaderboardAdapter adapter = new PairingListLeaderboardAdapter();
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            if (raceColumn.isMedalRace()) continue;
            ArrayList raceColumnList = new ArrayList();
            for (Fleet fleet : raceColumn.getFleets()) {
                ArrayList<Util.Pair> fleetList = new ArrayList<Util.Pair>();
                for (Util.Pair competitorAndBoatPair : adapter.getCompetitors(raceColumn, fleet)) {
                    Boat boat = (Boat)competitorAndBoatPair.getB();
                    fleetList.add(new Util.Pair((Object)this.baseDomainFactory.convertToCompetitorDTO((Competitor)competitorAndBoatPair.getA()), (Object)new BoatDTO(boat.getId().toString(), boat.getName(), this.convertToBoatClassDTO(boat.getBoatClass()), boat.getSailID(), boat.getColor())));
                }
                if (fleetList.size() <= 0) continue;
                raceColumnList.add(fleetList);
            }
            if (raceColumnList.size() <= 0) continue;
            result.add(raceColumnList);
            if (raceColumnNames.contains(raceColumn.getName())) continue;
            raceColumnNames.add(raceColumn.getName());
        }
        return new PairingListDTO(result, raceColumnNames);
    }

    public List<String> getRaceDisplayNamesFromLeaderboard(String leaderboardName, List<String> raceColumnNames) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        ArrayList<String> result = new ArrayList<String>();
        block3: for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            if (!raceColumn.hasTrackedRaces()) break;
            if (!raceColumnNames.contains(raceColumn.getName())) continue;
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace)) continue;
                if (trackedRace == null || trackedRace.getRaceIdentifier() == null) continue block3;
                result.add(trackedRace.getRaceIdentifier().getRaceName());
            }
        }
        if (result.size() == raceColumnNames.size() * Util.size((Iterable)((RaceColumn)Util.get((Iterable)leaderboard.getRaceColumns(), (int)0)).getFleets())) {
            return result;
        }
        result.clear();
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            block6: for (Fleet fleet : raceColumn.getFleets()) {
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                raceLog.lockForRead();
                try {
                    NavigableSet set = raceLog.getUnrevokedEvents();
                    for (RaceLogEvent raceLogEvent : set) {
                        if (!(raceLogEvent instanceof RaceLogDenoteForTrackingEvent)) continue;
                        RaceLogDenoteForTrackingEvent denoteEvent = (RaceLogDenoteForTrackingEvent)raceLogEvent;
                        result.add(denoteEvent.getRaceName());
                        continue block6;
                    }
                }
                finally {
                    raceLog.unlockAfterRead();
                }
            }
        }
        if (result.size() == raceColumnNames.size() * Util.size((Iterable)((RaceColumn)Util.get((Iterable)leaderboard.getRaceColumns(), (int)0)).getFleets())) {
            return result;
        }
        result.clear();
        int count = 1;
        while (count <= raceColumnNames.size() * Util.size((Iterable)((RaceColumn)Util.get((Iterable)leaderboard.getRaceColumns(), (int)0)).getFleets())) {
            result.add("Race " + count);
            ++count;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Iterable<DetailType> getAvailableDetailTypesForLeaderboard(String leaderboardName, RegattaAndRaceIdentifier raceIdentifierOrNull) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SpotDTO getWindFinderSpot(String spotId) throws MalformedURLException, IOException, ParseException, InterruptedException, ExecutionException {
        Spot spot;
        WindFinderTrackerFactory windFinderTrackerFactory = (WindFinderTrackerFactory)this.windFinderTrackerFactoryServiceTracker.getService();
        SpotDTO result = windFinderTrackerFactory != null ? ((spot = windFinderTrackerFactory.getSpotById(spotId, false)) != null ? new SpotDTO((SpotBase)spot) : null) : null;
        return result;
    }

    protected boolean isSmartphoneTrackingEnabled(DynamicTrackedRace trackedRace) {
        boolean result = false;
        for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
            RaceLogTrackingState raceLogTrackingState = (RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog).analyze();
            if (!raceLogTrackingState.isTracking()) continue;
            result = true;
            break;
        }
        return result;
    }

    public SliceRacePreperationDTO prepareForSlicingOfRace(RegattaAndRaceIdentifier raceIdentifier) {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)raceIdentifier);
        Leaderboard regattaLeaderboard = this.getService().getLeaderboardByName(raceIdentifier.getRegattaName());
        String prefix = null;
        int currentCount = 0;
        Pattern pattern = Pattern.compile("^([a-zA-Z_ -]+)([0-9]+)$");
        HashSet<String> alreadyUsedRaceNames = new HashSet<String>();
        for (RaceColumn column : regattaLeaderboard.getRaceColumns()) {
            alreadyUsedRaceNames.add(column.getName());
            Matcher matcher = pattern.matcher(column.getName());
            if (!matcher.matches()) continue;
            prefix = matcher.group(1);
            currentCount = Integer.parseInt(matcher.group(2));
        }
        if (prefix == null) {
            prefix = "R";
        }
        return new SliceRacePreperationDTO(String.valueOf(prefix) + ++currentCount, alreadyUsedRaceNames);
    }

    public Boolean checkIfRaceIsTracking(RegattaAndRaceIdentifier race) {
        TrackedRaceStatusEnum status;
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)race);
        boolean result = false;
        DynamicTrackedRace trackedRace = this.getService().getTrackedRace(race);
        if (trackedRace != null && ((status = trackedRace.getStatus().getStatus()) == TrackedRaceStatusEnum.LOADING || status == TrackedRaceStatusEnum.TRACKING)) {
            result = true;
        }
        return result;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ShardingType identifiedShardingType = null;
        try {
            if (req instanceof HttpServletRequest) {
                identifiedShardingType = ShardingContext.identifyAndSetShardingConstraint((String)((HttpServletRequest)req).getPathInfo());
            }
            super.service(req, res);
        }
        catch (Throwable throwable) {
            if (identifiedShardingType != null) {
                ShardingContext.clearShardingConstraint(identifiedShardingType);
            }
            throw throwable;
        }
        if (identifiedShardingType != null) {
            ShardingContext.clearShardingConstraint((ShardingType)identifiedShardingType);
        }
    }

    protected Set<ImageDTO> createImageDTOsFromURLsAndResizingTask(List<String> sourceRefs, ImageResizingTaskDTO resizingTask, List<BufferedImage> images) {
        HashSet<ImageDTO> imageDTOs = new HashSet<ImageDTO>();
        int i = 0;
        while (i < sourceRefs.size()) {
            ImageDTO imageDTO = resizingTask.cloneImageDTO();
            MediaTagConstants[] mediaTagConstantsArray = MediaTagConstants.values();
            int n = mediaTagConstantsArray.length;
            int n2 = 0;
            while (n2 < n) {
                MediaTagConstants tag = mediaTagConstantsArray[n2];
                imageDTO.getTags().remove(tag.getName());
                ++n2;
            }
            imageDTO.getTags().add(((MediaTagConstants)resizingTask.getResizingTask().get(i)).getName());
            imageDTO.setSourceRef(sourceRefs.get(i));
            imageDTO.setSizeInPx(Integer.valueOf(images.get(i).getWidth()), Integer.valueOf(images.get(i).getHeight()));
            imageDTOs.add(imageDTO);
            ++i;
        }
        return imageDTOs;
    }

    public List<TagDTO> getPrivateTags(String leaderboardName, String raceColumnName, String fleetName) {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        try {
            result.addAll(this.getService().getTaggingService().getPrivateTags(leaderboardName, raceColumnName, fleetName));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem obtaining private tags for leaderboard " + leaderboardName + ", race column " + raceColumnName + ", fleet " + fleetName, e);
        }
        return result;
    }

    public RaceTimesInfoDTO getRaceTimesInfoIncludingTags(RegattaAndRaceIdentifier raceIdentifier, TimePoint searchSince) {
        RaceTimesInfoDTO raceTimesInfo = this.getRaceTimesInfo(raceIdentifier);
        if (raceTimesInfo != null) {
            raceTimesInfo.setTags(this.getService().getTaggingService().getPublicTags(raceIdentifier, searchSince));
        }
        return raceTimesInfo;
    }

    public List<RaceTimesInfoDTO> getRaceTimesInfosIncludingTags(Collection<RegattaAndRaceIdentifier> raceIdentifiers, Map<RegattaAndRaceIdentifier, TimePoint> searchSinceMap) {
        ArrayList<RaceTimesInfoDTO> raceTimesInfos = new ArrayList<RaceTimesInfoDTO>();
        for (RegattaAndRaceIdentifier raceIdentifier : raceIdentifiers) {
            RaceTimesInfoDTO raceTimesInfo = this.getRaceTimesInfoIncludingTags(raceIdentifier, searchSinceMap.get(raceIdentifier));
            if (raceTimesInfo == null) continue;
            raceTimesInfos.add(raceTimesInfo);
        }
        return raceTimesInfos;
    }

    public MailInvitationType getMailType() {
        MailInvitationType type = MailInvitationType.valueOf((String)System.getProperty(MAILTYPE_PROPERTY, MailInvitationType.SailInsight3.name()));
        return type;
    }

    public String openRegattaRegistrationQrCode(String url) {
        String result;
        try {
            result = this.createEncodedQRCodeFromUrl(url, 600);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while generating QR code for open regatta", e);
            result = null;
        }
        return result;
    }

    public String createRaceBoardLinkQrCode(String url) {
        String result;
        try {
            result = this.createEncodedQRCodeFromUrl(url, 400);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while generating QR code for RaceBoard sharing", e);
            result = null;
        }
        return result;
    }

    public String createEncodedQRCodeFromUrl(String url, int size) throws Exception {
        DataInputStream imageIs = new DataInputStream(QRCodeGenerationUtil.create((String)url, (int)size, (String)"H"));
        byte[] targetArray = new byte[imageIs.available()];
        imageIs.readFully(targetArray);
        String result = Base64Utils.toBase64((byte[])targetArray);
        return result;
    }

    protected Boolean isSelfServiceServer() {
        AccessControlList acl;
        Set grantedActionsForNullGroup;
        AccessControlListAnnotation serverAclOrNull = this.getSecurityService().getAccessControlList(this.getServerInfo().getIdentifier());
        Boolean result = serverAclOrNull == null ? Boolean.valueOf(false) : ((grantedActionsForNullGroup = (Set)(acl = (AccessControlList)serverAclOrNull.getAnnotation()).getActionsByUserGroup().get(null)) == null ? Boolean.valueOf(false) : Boolean.valueOf(grantedActionsForNullGroup.contains(SecuredSecurityTypes.ServerActions.CREATE_OBJECT.name())));
        return result;
    }

    private Boolean isPublicServer() {
        RoleDefinition viewerRole = this.getSecurityService().getRoleDefinition(SailingViewerRole.getInstance().getId());
        UserGroup defaultServerTenant = this.getSecurityService().getServerGroup();
        Boolean result = viewerRole != null && defaultServerTenant != null ? defaultServerTenant.getRoleAssociation(viewerRole) : null;
        return result;
    }

    public BoatDTO getBoat(UUID boatId, String regattaName, String regattaRegistrationLinkSecret) {
        boolean skipSecuritychecks;
        BoatDTO result = null;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaName);
        if (leaderboard != null && leaderboard instanceof RegattaLeaderboard && ((skipSecuritychecks = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaRegistrationLinkSecret)) || this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard))) {
            for (Boat boat : leaderboard.getAllBoats()) {
                if (!skipSecuritychecks && !this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)boat) || !Util.equalsWithNull((Object)boatId, (Object)boat.getId())) continue;
                result = this.getBaseDomainFactory().convertToBoatDTO(boat);
            }
        }
        return result;
    }

    public MarkDTO getMark(UUID markId, String regattaName, String regattaRegistrationLinkSecret) {
        boolean skipSecuritychecks;
        MarkDTO result = null;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaName);
        if (leaderboard != null && leaderboard instanceof RegattaLeaderboard && ((skipSecuritychecks = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaRegistrationLinkSecret)) || this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard))) {
            block0: for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                for (Mark availableMark : raceColumn.getAvailableMarks()) {
                    if (!Util.equalsWithNull((Object)availableMark.getId(), (Object)markId)) continue;
                    result = this.convertToMarkDTO((LeaderboardThatHasRegattaLike)((RegattaLeaderboard)leaderboard), availableMark);
                    continue block0;
                }
            }
        }
        return result;
    }

    public QRCodeEvent getEvent(UUID eventId, String regattaName, String regattaRegistrationLinkSecret) {
        boolean skipSecuritychecks;
        QRCodeEvent result = null;
        Event event = this.getService().getEvent((Serializable)eventId);
        if (event != null && ((skipSecuritychecks = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaRegistrationLinkSecret)) || this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event))) {
            ImageDescriptor logoImage = event.findImageWithTag(MediaTagConstants.LOGO.getName());
            ImageDTO logo = logoImage != null ? HomeServiceUtil.convertToImageDTO((ImageDescriptor)logoImage) : null;
            String name = HomeServiceUtil.getEventDisplayName((EventBase)event);
            String location = HomeServiceUtil.getLocation((EventBase)event);
            if ((location == null || location.isEmpty()) && event.getVenue() != null) {
                location = event.getVenue().getName();
            }
            result = new QRCodeEvent(name, location, logo);
        }
        return result;
    }

    public CompetitorDTO getCompetitor(UUID competitorId, String regattaName, String regattaRegistrationLinkSecret) {
        boolean skipSecuritychecks;
        CompetitorDTO result = null;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(regattaName);
        if (leaderboard != null && leaderboard instanceof RegattaLeaderboard && ((skipSecuritychecks = this.getService().skipChecksDueToCorrectSecret(regattaName, regattaRegistrationLinkSecret)) || this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard))) {
            for (Competitor competitor : leaderboard.getAllCompetitors()) {
                if (!skipSecuritychecks && !this.getService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)competitor) || !Util.equalsWithNull((Object)competitorId, (Object)competitor.getId())) continue;
                result = this.getBaseDomainFactory().convertToCompetitorDTO(competitor);
            }
        }
        return result;
    }

    public boolean getTrackedRaceIsUsingMarkPassingCalculator(RegattaAndRaceIdentifier regattaNameAndRaceName) {
        return this.getExistingTrackedRace(regattaNameAndRaceName).isUsingMarkPassingCalculator();
    }

    public ORCPerformanceCurveLegImpl[] getLegGeometry(String leaderboardName, String raceColumnName, String fleetName, int[] zeroBasedLegIndices, ORCPerformanceCurveLegTypes[] legTypes) {
        assert (zeroBasedLegIndices.length == legTypes.length);
        ORCPerformanceCurveLegImpl[] result = null;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            TrackedRace trackedRace;
            Fleet fleet;
            this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
            RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            if (raceColumn != null && (fleet = raceColumn.getFleetByName(fleetName)) != null && (trackedRace = raceColumn.getTrackedRace(fleet)) != null) {
                result = new ORCPerformanceCurveLegImpl[zeroBasedLegIndices.length];
                LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(MillisecondsTimePoint.now());
                int i = 0;
                while (i < zeroBasedLegIndices.length) {
                    result[i] = this.getLegGeometry(zeroBasedLegIndices[i], legTypes[i], trackedRace, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                    ++i;
                }
            }
        }
        return result;
    }

    public ORCPerformanceCurveLegImpl[] getLegGeometry(RegattaAndRaceIdentifier regattaNameAndRaceName, int[] zeroBasedLegIndices, ORCPerformanceCurveLegTypes[] legTypes) {
        LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(MillisecondsTimePoint.now());
        TrackedRace trackedRace = this.getExistingTrackedRace(regattaNameAndRaceName);
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
        ORCPerformanceCurveLegImpl[] result = new ORCPerformanceCurveLegImpl[zeroBasedLegIndices.length];
        int i = 0;
        while (i < zeroBasedLegIndices.length) {
            result[i] = this.getLegGeometry(zeroBasedLegIndices[i], legTypes[i], trackedRace, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
            ++i;
        }
        return result;
    }

    private ORCPerformanceCurveLegImpl getLegGeometry(int zeroBasedLegIndex, ORCPerformanceCurveLegTypes legType, TrackedRace trackedRace, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        ORCPerformanceCurveLegImpl result;
        if (trackedRace != null) {
            Bearing twa;
            Leg leg = trackedRace.getRace().getCourse().getLeg(zeroBasedLegIndex);
            TrackedLeg trackedLeg = trackedRace.getTrackedLeg(leg);
            Distance distance = trackedLeg.getWindwardDistance(ORCPerformanceCurveLegTypes.getLegType((ORCPerformanceCurveLegTypes)legType), trackedLeg.getReferenceTimePoint(), cache);
            try {
                twa = trackedLeg.getTWA(trackedLeg.getReferenceTimePoint());
            }
            catch (NoWindException e) {
                twa = null;
            }
            result = new ORCPerformanceCurveLegImpl(distance, twa);
        } else {
            result = null;
        }
        return result;
    }

    public Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfo(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        return this.getORCPerformanceCurveLegInfo(Collections.singleton(this.getRaceLog(leaderboardName, raceColumnName, fleetName)));
    }

    private Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfo(Iterable<RaceLog> raceLogs) {
        HashMap<Integer, ORCPerformanceCurveLegImpl> result = new HashMap<Integer, ORCPerformanceCurveLegImpl>();
        for (RaceLog raceLog : raceLogs) {
            for (Map.Entry e : ((Map)new RaceLogORCLegDataAnalyzer(raceLog).analyze()).entrySet()) {
                if (((ORCPerformanceCurveLeg)e.getValue()).getType() == ORCPerformanceCurveLegTypes.TWA) {
                    result.put((Integer)e.getKey(), new ORCPerformanceCurveLegImpl(((ORCPerformanceCurveLeg)e.getValue()).getLength(), ((ORCPerformanceCurveLeg)e.getValue()).getTwa()));
                    continue;
                }
                result.put((Integer)e.getKey(), new ORCPerformanceCurveLegImpl(((ORCPerformanceCurveLeg)e.getValue()).getLength(), ((ORCPerformanceCurveLeg)e.getValue()).getType()));
            }
        }
        return result;
    }

    public Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfo(RegattaAndRaceIdentifier raceIdentifier) {
        return this.getORCPerformanceCurveLegInfo(this.getTrackedRace(raceIdentifier).getAttachedRaceLogs());
    }

    public Collection<ORCCertificate> getORCCertificates(String json) throws ParseException, JsonDeserializationException {
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(json);
        JSONArray certificates = (JSONArray)jsonObject.get((Object)"certificates");
        ORCCertificateJsonDeserializer deserializer = new ORCCertificateJsonDeserializer();
        ArrayList<ORCCertificate> result = new ArrayList<ORCCertificate>();
        for (Object o : certificates) {
            JSONObject certificateJson = (JSONObject)o;
            result.add(deserializer.deserialize(certificateJson));
        }
        return result;
    }

    public Map<String, ORCCertificate> getORCCertificateAssignmentsByBoatIdAsString(RegattaIdentifier regattaIdentifier) throws NotFoundException {
        Regatta regatta = (Regatta)regattaIdentifier.getRegatta((RegattaFetcher)this.getService());
        if (regatta == null) {
            throw new NotFoundException("Regatta named " + regattaIdentifier + " not found");
        }
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        HashMap<String, ORCCertificate> result = new HashMap<String, ORCCertificate>();
        HashMap<Serializable, Boat> boatsById = new HashMap<Serializable, Boat>();
        for (Boat boat : regatta.getAllBoats()) {
            boatsById.put(boat.getId(), boat);
        }
        for (Map.Entry entry : ((Map)new RegattaLogORCCertificateAssignmentFinder(regatta.getRegattaLog(), boatsById).analyze()).entrySet()) {
            result.put(((Boat)entry.getKey()).getId().toString(), (ORCCertificate)entry.getValue());
        }
        return result;
    }

    public Map<String, ORCCertificate> getORCCertificateAssignmentsByBoatIdAsString(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        HashMap<String, ORCCertificate> result = new HashMap<String, ORCCertificate>();
        HashMap<Serializable, Boat> boatsById = new HashMap<Serializable, Boat>();
        for (Boat boat : leaderboard.getAllBoats()) {
            boatsById.put(boat.getId(), boat);
        }
        for (Map.Entry entry : ((Map)new RaceLogORCCertificateAssignmentFinder(raceLog, boatsById).analyze()).entrySet()) {
            result.put(((Boat)entry.getKey()).getId().toString(), (ORCCertificate)entry.getValue());
        }
        return result;
    }

    public ImpliedWindSource getImpliedWindSource(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        ImpliedWindSource impliedWindSource = (ImpliedWindSource)new RaceLogORCImpliedWindSourceFinder(raceLog).analyze();
        return impliedWindSource;
    }

    public Map<BoatDTO, Set<ORCCertificate>> getSuggestedORCBoatCertificates(ArrayList<BoatDTO> boats) throws InterruptedException, ExecutionException {
        ORCPublicCertificateDatabase db = ORCPublicCertificateDatabase.INSTANCE;
        HashMap<BoatDTO, Set<ORCCertificate>> result = new HashMap<BoatDTO, Set<ORCCertificate>>();
        HashMap<BoatDTO, Future> futures = new HashMap<BoatDTO, Future>();
        for (BoatDTO boatDTO : boats) {
            futures.put(boatDTO, db.search(boatDTO.getName(), boatDTO.getSailId(), this.getService().getBaseDomainFactory().getBoatClass(boatDTO.getBoatClass().getName())));
        }
        for (Map.Entry entry : futures.entrySet()) {
            HashSet certificatesForBoat = new HashSet();
            certificatesForBoat.addAll((Collection)((Future)entry.getValue()).get());
            result.put((BoatDTO)entry.getKey(), certificatesForBoat);
        }
        return result;
    }

    public Set<ORCCertificate> searchORCBoatCertificates(CountryCode country, Integer yearOfIssuance, String referenceNumber, String yachtName, String sailNumber, String boatClassName) throws Exception {
        ORCPublicCertificateDatabase db = ORCPublicCertificateDatabase.INSTANCE;
        HashSet<ORCCertificate> result = new HashSet<ORCCertificate>();
        Iterable searchResult = db.search(country, yearOfIssuance, referenceNumber, yachtName, sailNumber, boatClassName, false);
        Util.addAll((Iterable)db.getCertificates(searchResult), result);
        result.remove(null);
        return result;
    }

    public List<MarkTemplateDTO> getMarkTemplates() {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getSharedSailingData().getAllMarkTemplates(), m -> this.convertToMarkTemplateDTO(m));
    }

    protected MarkTemplateDTO convertToMarkTemplateDTO(MarkTemplate markTemplate) {
        MarkTemplateDTO markTemplateDTO = new MarkTemplateDTO(markTemplate.getId(), markTemplate.getName(), markTemplate.getShortName() == null || markTemplate.getShortName().isEmpty() ? markTemplate.getName() : markTemplate.getShortName(), markTemplate.getColor(), markTemplate.getShape(), markTemplate.getPattern(), markTemplate.getType());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)markTemplateDTO);
        return markTemplateDTO;
    }

    protected CommonMarkProperties convertDtoToCommonMarkProperties(CommonMarkPropertiesDTO markProperties) {
        return new CommonMarkPropertiesImpl(markProperties.getName(), markProperties.getShortName(), markProperties.getColor(), markProperties.getShape(), markProperties.getPattern(), markProperties.getType());
    }

    protected DeviceIdentifier convertDtoToDeviceIdentifier(DeviceIdentifierDTO deviceIdentifier) throws NoCorrespondingServiceRegisteredException, TransformationException {
        return this.deserializeDeviceIdentifier(deviceIdentifier.deviceType, deviceIdentifier.deviceId);
    }

    public List<MarkPropertiesDTO> getMarkProperties() {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getSharedSailingData().getAllMarkProperties(), m -> this.convertToMarkPropertiesDTO(m));
    }

    protected MarkPropertiesDTO convertToMarkPropertiesDTO(MarkProperties markProperties) {
        MarkPropertiesDTO markPropertiesDto = new MarkPropertiesDTO(markProperties.getId(), markProperties.getName(), markProperties.getTags(), markProperties.getShortName(), markProperties.getColor(), markProperties.getShape(), markProperties.getPattern(), markProperties.getType(), markProperties.getPositioningInformation() == null ? null : (String)markProperties.getPositioningInformation().accept((PositioningVisitor)new /* Unavailable Anonymous Inner Class!! */));
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)markPropertiesDto);
        return markPropertiesDto;
    }

    public List<CourseTemplateDTO> getCourseTemplates() {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getSharedSailingData().getAllCourseTemplates(), m -> this.convertToCourseTemplateDTO(m));
    }

    public CourseTemplateDTO convertToCourseTemplateDTO(CourseTemplate courseTemplate) {
        Map<MarkTemplateDTO, MarkRoleDTO> convertedDefaultMarkRolesForMarkTemplates = courseTemplate.getDefaultMarkRolesForMarkTemplates().entrySet().stream().collect(Collectors.toMap(entry -> this.convertToMarkTemplateDTO((MarkTemplate)entry.getKey()), entry -> this.convertToMarkRoleDTO((MarkRole)entry.getValue())));
        Map<MarkRoleDTO, MarkTemplateDTO> convertedDefaultMarkTemplatesForMarkRoles = courseTemplate.getDefaultMarkTemplatesForMarkRoles().entrySet().stream().collect(Collectors.toMap(entry -> this.convertToMarkRoleDTO((MarkRole)entry.getKey()), entry -> this.convertToMarkTemplateDTO((MarkTemplate)entry.getValue())));
        List convertedMarkTemplates = StreamSupport.stream(courseTemplate.getMarkTemplates().spliterator(), false).map(arg_0 -> this.convertToMarkTemplateDTO(arg_0)).collect(Collectors.toList());
        List convertedWaypointTemplates = StreamSupport.stream(courseTemplate.getWaypointTemplates().spliterator(), false).map(arg_0 -> this.convertToWaypointTemplateDTO(arg_0)).collect(Collectors.toList());
        String optionalImageURL = courseTemplate.getOptionalImageURL() != null ? courseTemplate.getOptionalImageURL().toExternalForm() : null;
        CourseTemplateDTO result = new CourseTemplateDTO(courseTemplate.getId(), courseTemplate.getName(), courseTemplate.getShortName(), convertedMarkTemplates, convertedWaypointTemplates, convertedDefaultMarkRolesForMarkTemplates, convertedDefaultMarkTemplatesForMarkRoles, optionalImageURL, courseTemplate.getTags(), this.convertToRepeatablePartDTO(courseTemplate.getRepeatablePart()), courseTemplate.getDefaultNumberOfLaps());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)result);
        return result;
    }

    private RepeatablePartDTO convertToRepeatablePartDTO(RepeatablePart repeatablePart) {
        return repeatablePart != null ? new RepeatablePartDTO(repeatablePart.getZeroBasedIndexOfRepeatablePartStart(), repeatablePart.getZeroBasedIndexOfRepeatablePartEnd()) : null;
    }

    private WaypointTemplateDTO convertToWaypointTemplateDTO(WaypointTemplate waypointTemplate) {
        return new WaypointTemplateDTO(waypointTemplate.getControlPointTemplate().getName(), waypointTemplate.getControlPointTemplate().getShortName(), (Iterable)StreamSupport.stream(waypointTemplate.getControlPointTemplate().getMarkRoles().spliterator(), false).map(arg_0 -> this.convertToMarkRoleDTO(arg_0)).collect(Collectors.toList()), waypointTemplate.getPassingInstruction());
    }

    protected WaypointTemplate convertToWaypointTemplate(WaypointTemplateDTO waypointTemplate, MarkRolePair.MarkRolePairFactory markRolePairFactory) {
        ControlPointTemplate controlPointTemplate;
        List resolvedMarkRoles = waypointTemplate.getMarkRolesForControlPoint().stream().map(t -> this.getSharedSailingData().getMarkRoleById(t.getUuid())).collect(Collectors.toList());
        if (resolvedMarkRoles.size() == 1) {
            controlPointTemplate = (ControlPointTemplate)resolvedMarkRoles.get(0);
        } else if (resolvedMarkRoles.size() == 2) {
            controlPointTemplate = markRolePairFactory.create(waypointTemplate.getName(), waypointTemplate.getShortName(), (MarkRole)resolvedMarkRoles.get(0), (MarkRole)resolvedMarkRoles.get(1));
        } else {
            throw new IllegalArgumentException("Waypoints must contain one or two marks");
        }
        return new WaypointTemplateImpl(controlPointTemplate, waypointTemplate.getPassingInstruction());
    }

    protected RepeatablePart convertToRepeatablePart(RepeatablePartDTO repeatablePart) {
        return new RepeatablePartImpl(repeatablePart.getZeroBasedIndexOfRepeatablePartStart(), repeatablePart.getZeroBasedIndexOfRepeatablePartEnd());
    }

    protected MarkRoleDTO convertToMarkRoleDTO(MarkRole markRole) {
        MarkRoleDTO markRoleDTO = new MarkRoleDTO(markRole.getId(), markRole.getName(), markRole.getShortName());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)markRoleDTO);
        return markRoleDTO;
    }

    protected DeviceMappingDTO convertToDeviceMappingDTO(DeviceMapping<?> mapping) throws TransformationException {
        CompetitorDTO item;
        Map lastFixes = this.getService().getSensorFixStore().getFixLastReceived(Collections.singleton(mapping.getDevice()));
        Timed lastFix = lastFixes != null && lastFixes.containsKey(mapping.getDevice()) ? (Timed)lastFixes.get(mapping.getDevice()) : null;
        Date from = mapping.getTimeRange().from() == null || mapping.getTimeRange().from().equals(TimePoint.BeginningOfTime) ? null : mapping.getTimeRange().from().asDate();
        Date to = mapping.getTimeRange().to() == null || mapping.getTimeRange().to().equals(TimePoint.EndOfTime) ? null : mapping.getTimeRange().to().asDate();
        WithID mappedTo = mapping.getMappedTo();
        if (mappedTo == null) {
            throw new RuntimeException("Device mapping not mapped to any object");
        }
        if (mappedTo instanceof Competitor) {
            item = this.baseDomainFactory.convertToCompetitorDTO((Competitor)mapping.getMappedTo());
        } else if (mappedTo instanceof Mark) {
            item = this.convertToMarkDTO((Mark)mapping.getMappedTo(), null);
        } else if (mappedTo instanceof Boat) {
            item = this.baseDomainFactory.convertToBoatDTO((Boat)mappedTo);
        } else {
            throw new RuntimeException("Can only handle Competitor, Boat or Mark as mapped item type, but not " + mappedTo.getClass().getName());
        }
        ArrayList<UUID> originalRaceLogEventUUIDs = new ArrayList<UUID>();
        for (Serializable id : mapping.getOriginalRaceLogEventIds()) {
            if (!(id instanceof UUID)) {
                logger.log(Level.WARNING, "Got RaceLogEvent with id that was not UUID, but " + id.getClass().getName());
                throw new TransformationException("Could not send device mapping to browser: can only deal with UUIDs");
            }
            originalRaceLogEventUUIDs.add((UUID)id);
        }
        return new DeviceMappingDTO(this.convertDeviceIdentifierToDTO(mapping.getDevice()), from, to, (MappableToDevice)item, originalRaceLogEventUUIDs, lastFix == null ? null : lastFix.getTimePoint());
    }

    private <P> void addMarkConfigurationAnnotationsToDTO(MarkConfiguration<P> markConfig, MarkConfigurationDTO addTo) {
        MarkConfigurationResponseAnnotation responseAnnotation;
        if (markConfig.getAnnotationInfo() instanceof MarkConfigurationRequestAnnotation) {
            MarkConfigurationRequestAnnotation requestAnnotation = (MarkConfigurationRequestAnnotation)markConfig.getAnnotationInfo();
            addTo.setAddToMarkPropertiesInventoryRequest(requestAnnotation.isStoreToInventory());
            addTo.setCreateMarkRoleRequest(requestAnnotation.getOptionalMarkRoleCreationRequest() != null);
            if (requestAnnotation.getOptionalPositioning() != null) {
                requestAnnotation.getOptionalPositioning().accept((PositioningVisitor)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (markConfig.getAnnotationInfo() instanceof MarkConfigurationResponseAnnotation && (responseAnnotation = (MarkConfigurationResponseAnnotation)markConfig.getAnnotationInfo()).getLastKnownPosition() != null) {
            addTo.setLastKnownPosition(new GPSFixDTO(responseAnnotation.getLastKnownPosition().getTimePoint().asDate(), responseAnnotation.getLastKnownPosition().getPosition()));
            addTo.setExistingDeviceMappings(Util.mapToArrayList((Iterable)responseAnnotation.getDeviceMappings(), deviceIdAndTimeRangeAndLastGPSFix -> {
                try {
                    return new Util.Triple((Object)this.convertDeviceIdentifierToDTO((DeviceIdentifier)deviceIdAndTimeRangeAndLastGPSFix.getA()), (Object)((TimeRange)deviceIdAndTimeRangeAndLastGPSFix.getB()), (Object)new GPSFixDTO(((GPSFix)deviceIdAndTimeRangeAndLastGPSFix.getC()).getTimePoint().asDate(), ((GPSFix)deviceIdAndTimeRangeAndLastGPSFix.getC()).getPosition()));
                }
                catch (TransformationException e) {
                    throw new RuntimeException();
                }
            }));
        }
    }

    protected DeviceIdentifierDTO convertDeviceIdentifierToDTO(DeviceIdentifier deviceIdentifier) throws TransformationException {
        return new DeviceIdentifierDTO(deviceIdentifier.getIdentifierType(), this.serializeDeviceIdentifier(deviceIdentifier));
    }

    protected <P> MarkConfigurationDTO convertToMarkConfigurationDTO(MarkConfiguration<P> markConfig) {
        MarkConfigurationDTO result = (MarkConfigurationDTO)markConfig.accept((MarkConfigurationVisitor)new /* Unavailable Anonymous Inner Class!! */);
        this.addMarkConfigurationAnnotationsToDTO(markConfig, result);
        return result;
    }

    private <P> ControlPointWithMarkConfigurationDTO convertToControlPointWithMarkConfigurationDTO(ControlPointWithMarkConfiguration<P> controlPoint) {
        ControlPointWithMarkConfigurationDTO result;
        Iterable markConfigurations = Util.map((Iterable)controlPoint.getMarkConfigurations(), arg_0 -> this.convertToMarkConfigurationDTO(arg_0));
        if (Util.size((Iterable)markConfigurations) == 1) {
            result = (ControlPointWithMarkConfigurationDTO)markConfigurations.iterator().next();
        } else {
            MarkPairWithConfigurationDTO preResult = new MarkPairWithConfigurationDTO();
            preResult.setName(controlPoint.getName());
            preResult.setShortName(controlPoint.getShortName());
            Iterator markConfigs = markConfigurations.iterator();
            preResult.setLeft((MarkConfigurationDTO)markConfigs.next());
            preResult.setRight((MarkConfigurationDTO)markConfigs.next());
            result = preResult;
        }
        return result;
    }

    protected <P> WaypointWithMarkConfigurationDTO convertToWaypointWithMarkConfigurationDTO(WaypointWithMarkConfiguration<P> waypointWithMarkConfiguration) {
        WaypointWithMarkConfigurationDTO result = new WaypointWithMarkConfigurationDTO();
        result.setControlPoint(this.convertToControlPointWithMarkConfigurationDTO(waypointWithMarkConfiguration.getControlPoint()));
        result.setPassingInstruction(waypointWithMarkConfiguration.getPassingInstruction());
        return result;
    }

    protected <P> CourseConfigurationDTO convertToCourseConfigurationDTO(CourseConfiguration<P> courseConfiguration) {
        CourseConfigurationDTO result = new CourseConfigurationDTO();
        result.setAssociatedRoles(new HashMap<MarkConfigurationDTO, MarkRoleDTO>(courseConfiguration.getAssociatedRoles().entrySet().stream().collect(Collectors.toMap(e -> this.convertToMarkConfigurationDTO((MarkConfiguration)e.getKey()), e -> this.convertToMarkRoleDTO((MarkRole)e.getValue())))));
        result.setAllMarks(Util.mapToArrayList((Iterable)courseConfiguration.getAllMarks(), arg_0 -> this.convertToMarkConfigurationDTO(arg_0)));
        result.setName(courseConfiguration.getName());
        result.setShortName(courseConfiguration.getShortName());
        result.setNumberOfLaps(courseConfiguration.getNumberOfLaps());
        result.setOptionalCourseTemplate(courseConfiguration.getOptionalCourseTemplate() == null ? null : this.convertToCourseTemplateDTO(courseConfiguration.getOptionalCourseTemplate()));
        result.setOptionalImageURL(courseConfiguration.getOptionalImageURL());
        result.setOptionalRepeatablePart(courseConfiguration.getRepeatablePart());
        result.setShortName(courseConfiguration.getShortName());
        result.setWaypoints(new ArrayList(Util.asList((Iterable)Util.map((Iterable)courseConfiguration.getWaypoints(), wpWithMarkConfig -> this.convertToWaypointWithMarkConfigurationDTO(wpWithMarkConfig)))));
        return result;
    }

    public List<MarkRoleDTO> getMarkRoles() {
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getSharedSailingData().getAllMarkRoles(), m -> this.convertToMarkRoleDTO(m));
    }

    public EventDTO getEventById(UUID id, boolean withStatisticalData) throws MalformedURLException, UnauthorizedException {
        EventDTO result = null;
        Event event = this.getService().getEvent((Serializable)id);
        if (event != null) {
            if (SecurityUtils.getSubject().isPermitted(SecuredDomainType.EVENT.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, (WithQualifiedObjectIdentifier)event))) {
                result = this.convertToEventDTO(event, withStatisticalData);
                result.setBaseURL(this.getEventBaseURLFromEventOrRequest(event));
                result.setIsOnRemoteServer(false);
            } else {
                throw new UnauthorizedException("You are not permitted to view event " + id);
            }
        }
        return result;
    }

    public boolean canSliceRace(RegattaAndRaceIdentifier raceIdentifier) {
        boolean result;
        Regatta regatta = this.getService().getRegattaByName(raceIdentifier.getRegattaName());
        Leaderboard regattaLeaderboard = this.getService().getLeaderboardByName(raceIdentifier.getRegattaName());
        DynamicTrackedRace trackedRace = this.getService().getTrackedRace(raceIdentifier);
        if (trackedRace == null) {
            result = false;
        } else {
            Util.Pair raceColumnAndFleetOfRaceToSlice;
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)raceIdentifier);
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regattaLeaderboard);
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
            result = regatta == null || !(regattaLeaderboard instanceof RegattaLeaderboard) || trackedRace == null || trackedRace.getStartOfTracking() == null || !this.isSmartphoneTrackingEnabled(trackedRace) ? false : (raceColumnAndFleetOfRaceToSlice = regattaLeaderboard.getRaceColumnAndFleet((TrackedRace)trackedRace)) != null;
        }
        return result;
    }

    public Integer getAdminConsoleChangeLogSize() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CloseableHttpClient client = HttpClients.createDefault();){
                int localPort = this.getThreadLocalRequest().getLocalPort();
                URIBuilder url = new URIBuilder("http://127.0.0.1:" + localPort + "/release_notes_admin.html");
                HttpGet request = new HttpGet(url.build());
                return ((String)client.execute((HttpUriRequest)request, response -> EntityUtils.toString((HttpEntity)response.getEntity()))).length();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.log(Level.WARNING, "Unable to determine admin change log size", e);
            return 0;
        }
    }

    public List<YellowBrickConfigurationWithSecurityDTO> getPreviousYellowBrickConfigurations() {
        Iterable configs = this.getYellowBrickTrackingAdapter().getYellowBrickConfigurations();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(configs, ybConfig -> {
            YellowBrickConfigurationWithSecurityDTO config = new YellowBrickConfigurationWithSecurityDTO(ybConfig.getName(), ybConfig.getRaceUrl(), ybConfig.getUsername(), null, ybConfig.getCreatorName());
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)config);
            return config;
        });
    }

    public Util.Pair<String, List<YellowBrickRaceRecordDTO>> listYellowBrickRacesInEvent(YellowBrickConfigurationWithSecurityDTO config) throws Exception {
        YellowBrickRace raceMetadata = this.getYellowBrickTrackingAdapter().getRaceMetadata(config.getRaceUrl(), Optional.ofNullable(config.getUsername()), Optional.ofNullable(config.getPassword()));
        return new Util.Pair((Object)raceMetadata.getRaceUrl(), Collections.singletonList(new YellowBrickRaceRecordDTO(config.getName(), raceMetadata.getRaceUrl(), this.hasRememberedRegatta((Serializable)((Object)raceMetadata.getRaceId())), raceMetadata.getTimePointOfLastFix(), raceMetadata.getNumberOfCompetitors())));
    }

    public String getGoogleMapsLoaderAuthenticationParams() {
        return Activator.getInstance().getGoogleMapsLoaderAuthenticationParams();
    }

    protected IgtimiConnection createIgtimiConnection(Optional<String> optionalBearerToken) {
        return optionalBearerToken.map(bearerToken -> this.getIgtimiConnectionFactory().getOrCreateConnection(bearerToken)).orElse(this.getIgtimiConnectionFactory().getOrCreateConnection(() -> this.getSecurityService().getCurrentUser() != null ? this.getSecurityService().getAccessToken(this.getSecurityService().getCurrentUser().getName()) : null));
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType;
        }
        int[] nArray = new int[RacingProcedureType.values().length];
        try {
            nArray[RacingProcedureType.BASIC.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.ESS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.GateStart.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.LEAGUE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.RRS26.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.RRS26_3MIN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.SWC.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.SWC_4MIN.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType = nArray;
        return nArray;
    }

    static /* synthetic */ Competitor access$7(SailingServiceImpl sailingServiceImpl, Iterable iterable, String string) {
        return sailingServiceImpl.getCompetitorByIdAsString(iterable, string);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$DetailType() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$DetailType != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$DetailType;
        }
        int[] nArray = new int[DetailType.values().length];
        try {
            nArray[DetailType.AVERAGE_JIBE_LOSS_IN_METERS.ordinal()] = 65;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.AVERAGE_MANEUVER_LOSS_IN_METERS.ordinal()] = 63;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.AVERAGE_TACK_LOSS_IN_METERS.ordinal()] = 64;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_LEG_CURRENT_DISTANCE_FOILED_IN_METERS.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_LEG_CURRENT_DURATION_FOILED_IN_SECONDS.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_IN_MILLIMETERS.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_PERCENTAGE.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_DEPTH_IN_METERS.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_DRIFT_IN_DEGREES.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_FORESTAY_LOAD.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_FORESTAY_PRESSURE.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_LEEWAY_IN_DEGREES.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_MAST_ROTATION_IN_DEGREES.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_PORT_DAGGERBOARD_RAKE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_PORT_RUDDER_RAKE.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_RAKE_IN_DEGREES.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_RUDDER_IN_DEGREES.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_SET.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_STBD_DAGGERBOARD_RAKE.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_STBD_RUDDER_RAKE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_TACK_ANGLE_IN_DEGREES.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_TARGET_BOATSPEED_PERCENTAGE.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVOEXTENDED_RACE_CURRENT_TARGET_HEEL_ANGLE_IN_DEGREES.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_LEG_CURRENT_HEEL_IN_DEGREES.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_LEG_CURRENT_PITCH_IN_DEGREES.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_LEG_CURRENT_RIDE_HEIGHT_IN_METERS.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_RACE_CURRENT_RIDE_HEIGHT_IN_METERS.ordinal()] = 86;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_RACE_HEEL_IN_DEGREES.ordinal()] = 185;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.BRAVO_RACE_PITCH_IN_DEGREES.ordinal()] = 186;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_ABS_TWA.ordinal()] = 104;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_BEAT_ANGLE.ordinal()] = 103;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_COURSE_OVER_GROUND_TRUE_DEGREES.ordinal()] = 105;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_DISTANCE_TO_START_LINE.ordinal()] = 102;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_CHANGE.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.DISTANCE_TO_STARBOARD_END_OF_STARTLINE_WHEN_PASSING_START_IN_METERS.ordinal()] = 59;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.DISTANCE_TO_START_AT_RACE_START.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_AWA.ordinal()] = 140;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_AWS.ordinal()] = 141;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_BARO.ordinal()] = 179;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_BOAT_SPEED.ordinal()] = 146;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_COG.ordinal()] = 149;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_COURSE.ordinal()] = 152;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_DISTANCE_BELOW_LINE.ordinal()] = 171;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT.ordinal()] = 169;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_DISTANCE_TO_PIN.ordinal()] = 170;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_DIST_TO_PORT_LAYLINE.ordinal()] = 161;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_DIST_TO_STB_LAYLINE.ordinal()] = 162;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_FORESTAY_LOAD.ordinal()] = 150;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_HEADING.ordinal()] = 153;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_JIB_CAR_PORT.ordinal()] = 182;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_JIB_CAR_STBD.ordinal()] = 183;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION.ordinal()] = 172;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_LOAD_P.ordinal()] = 181;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_LOAD_S.ordinal()] = 180;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_MAST_BUTT.ordinal()] = 184;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_RAKE.ordinal()] = 151;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_RATE_OF_TURN.ordinal()] = 156;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_RUDDER_ANGLE.ordinal()] = 157;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_SOG.ordinal()] = 148;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TARGET_HEEL.ordinal()] = 158;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TARG_BOAT_SPEED.ordinal()] = 147;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TARG_TWA.ordinal()] = 145;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT.ordinal()] = 167;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_LINE.ordinal()] = 166;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_PIN.ordinal()] = 168;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT.ordinal()] = 164;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_GUN.ordinal()] = 163;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_PIN.ordinal()] = 165;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_PORT_LAYLINE.ordinal()] = 159;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TIME_TO_STB_LAYLINE.ordinal()] = 160;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TWA.ordinal()] = 142;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TWD.ordinal()] = 144;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_TWS.ordinal()] = 143;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_VMG.ordinal()] = 154;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_LEG_VMG_TARG_VMG_DELTA.ordinal()] = 155;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_AWA.ordinal()] = 107;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_AWS.ordinal()] = 108;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_BARO.ordinal()] = 173;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_BOAT_SPEED.ordinal()] = 113;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_COG.ordinal()] = 116;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_COURSE.ordinal()] = 119;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_DISTANCE_BELOW_LINE.ordinal()] = 138;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_DISTANCE_TO_COMMITTEE_BOAT.ordinal()] = 136;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_DISTANCE_TO_PIN.ordinal()] = 137;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_DIST_TO_PORT_LAYLINE.ordinal()] = 128;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_DIST_TO_STB_LAYLINE.ordinal()] = 129;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_FORESTAY_LOAD.ordinal()] = 117;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_HEADING.ordinal()] = 120;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_JIB_CAR_PORT.ordinal()] = 176;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_JIB_CAR_STBD.ordinal()] = 177;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_KICKER_TENSION.ordinal()] = 188;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_LINE_SQUARE_FOR_WIND_DIRECTION.ordinal()] = 139;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_LOAD_P.ordinal()] = 175;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_LOAD_S.ordinal()] = 174;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_MAST_BUTT.ordinal()] = 178;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_RAKE.ordinal()] = 118;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_RATE_OF_TURN.ordinal()] = 123;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_RUDDER_ANGLE.ordinal()] = 124;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_SOG.ordinal()] = 115;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TARGET_HEEL.ordinal()] = 125;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TARG_BOAT_SPEED.ordinal()] = 114;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TARG_TWA.ordinal()] = 112;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_BURN_TO_COMMITTEE_BOAT.ordinal()] = 134;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_BURN_TO_LINE.ordinal()] = 133;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_BURN_TO_PIN.ordinal()] = 135;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_COMMITTEE_BOAT.ordinal()] = 131;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_GUN.ordinal()] = 130;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_PIN.ordinal()] = 132;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_PORT_LAYLINE.ordinal()] = 126;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TIME_TO_STB_LAYLINE.ordinal()] = 127;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TWA.ordinal()] = 109;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TWD.ordinal()] = 111;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_TWS.ordinal()] = 110;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_VMG.ordinal()] = 121;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.EXPEDITION_RACE_VMG_TARG_VMG_DELTA.ordinal()] = 122;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.JIBE.ordinal()] = 61;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_CORRECTED_TIME_TRAVELED.ordinal()] = 70;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_CURRENT_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_CURRENT_SIGNED_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_DISTANCE_TRAVELED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_GAP_CHANGE_SINCE_LEG_START_IN_SECONDS.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_GAP_TO_LEADER_IN_SECONDS.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_GAP_TO_LEADER_IN_SECONDS_CHANGE.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_RANK_GAIN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_SIDE_TO_WHICH_MARK_AT_LEG_START_WAS_ROUNDED.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_TACKTYPE_LONGTACK_SHORTTACK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_TIME_TRAVELED.ordinal()] = 69;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_VELOCITY_MADE_GOOD_IN_KNOTS.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.NUMBER_OF_MANEUVERS.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS.ordinal()] = 74;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_RANK.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE.ordinal()] = 76;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TIME_ON_TIME_FACTOR.ordinal()] = 75;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_AVERAGE_SPEED_OVER_GROUND.ordinal()] = 78;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_DISTANCE_FOILED_IN_METERS.ordinal()] = 81;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_DISTANCE_TRAVELED.ordinal()] = 77;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_DURATION_FOILED_IN_SECONDS.ordinal()] = 80;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_SCORED_RACE_COUNT.ordinal()] = 106;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.OVERALL_TOTAL_TIME_SAILED_IN_SECONDS.ordinal()] = 79;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.PENALTY_CIRCLE.ordinal()] = 62;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.PERCENT_TARGET_BOAT_SPEED.ordinal()] = 187;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CALCULATED_TIME_AT_ESTIMATED_ARRIVAL_AT_COMPETITOR_FARTHEST_AHEAD.ordinal()] = 97;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CALCULATED_TIME_TRAVELED.ordinal()] = 95;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES.ordinal()] = 83;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_DISTANCE_FOILED_IN_METERS.ordinal()] = 87;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_DURATION_FOILED_IN_SECONDS.ordinal()] = 88;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_LEG.ordinal()] = 66;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_POSITION_LAT_DEG.ordinal()] = 84;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_POSITION_LNG_DEG.ordinal()] = 85;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS.ordinal()] = 82;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISPLAY_BOATS.ordinal()] = 68;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISPLAY_LEGS.ordinal()] = 67;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISTANCE_TO_START_FIVE_SECONDS_BEFORE_RACE_START.ordinal()] = 93;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISTANCE_TRAVELED.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_DISTANCE_TRAVELED_INCLUDING_GATE_START.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_GAP_TO_LEADER_IN_SECONDS.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_IMPLIED_WIND.ordinal()] = 96;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_NET_POINTS.ordinal()] = 89;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_RANK.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_RATIO_BETWEEN_TIME_SINCE_LAST_POSITION_FIX_AND_AVERAGE_SAMPLING_INTERVAL.ordinal()] = 92;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_SPEED_OVER_GROUND_FIVE_SECONDS_BEFORE_START.ordinal()] = 94;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_TIME_TRAVELED.ordinal()] = 98;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_TIME_TRAVELED_DOWNWIND.ordinal()] = 100;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_TIME_TRAVELED_REACHING.ordinal()] = 101;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.RACE_TIME_TRAVELED_UPWIND.ordinal()] = 99;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.REGATTA_NET_POINTS.ordinal()] = 90;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.REGATTA_NET_POINTS_SUM.ordinal()] = 91;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.REGATTA_RANK.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.SPEED_OVER_GROUND_AT_RACE_START.ordinal()] = 57;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.SPEED_OVER_GROUND_WHEN_PASSING_START.ordinal()] = 58;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.START_TACK.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.TACK.ordinal()] = 60;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.TIME_BETWEEN_RACE_START_AND_COMPETITOR_START.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.TOTAL_TIME_SAILED_DOWNWIND_IN_SECONDS.ordinal()] = 71;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.TOTAL_TIME_SAILED_REACHING_IN_SECONDS.ordinal()] = 73;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DetailType.TOTAL_TIME_SAILED_UPWIND_IN_SECONDS.ordinal()] = 72;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$DetailType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$RankingMetrics() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$RankingMetrics != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$RankingMetrics;
        }
        int[] nArray = new int[RankingMetrics.values().length];
        try {
            nArray[RankingMetrics.ONE_DESIGN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RankingMetrics.ORC_PERFORMANCE_CURVE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RankingMetrics.ORC_PERFORMANCE_CURVE_BY_IMPLIED_WIND.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RankingMetrics.ORC_PERFORMANCE_CURVE_LEADER_FOR_BASELINE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RankingMetrics.TIME_ON_TIME_AND_DISTANCE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$RankingMetrics = nArray;
        return nArray;
    }
}

