/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.masterdataimport;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MasterDataImportObjectCreationCount;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.masterdataimport.MasterDataImportPanel;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.impl.KeywordMatcher;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.controls.progressbar.CustomProgressBar;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class MasterDataImportPanel
extends VerticalPanel {
    private ListBox leaderboardgroupListBox;
    private TextBox hostBox;
    private Button importLeaderboardGroupsButton;
    private Button fetchIdsButton;
    private Map<String, String> allLeaderboardGroupsNameAndIdsMap;
    private final StringMessages stringMessages;
    private String currentHost;
    private SailingServiceWriteAsync sailingServiceWrite;
    private CheckBox overrideSwitch;
    private final AdminConsoleView.Presenter presenter;
    private CheckBox compressSwitch;
    private CheckBox exportWindSwitch;
    private CheckBox exportDeviceConfigsSwitch;
    private CheckBox exportTrackedRacesAndStartTrackingSwitch;
    private TextBox filterBox;
    private TextBox usernameBox;
    private TextBox passwordBox;

    public MasterDataImportPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.stringMessages = stringMessages;
        this.presenter = presenter;
        HorizontalPanel serverAddressPanel = new HorizontalPanel();
        serverAddressPanel.add((Widget)new Label(stringMessages.importRemoteHost()));
        this.hostBox = new TextBox();
        this.hostBox.setText("https://www.sapsailing.com/");
        this.hostBox.setWidth("300px");
        serverAddressPanel.add((Widget)this.hostBox);
        HorizontalPanel usernamePanel = new HorizontalPanel();
        usernamePanel.add((Widget)new Label(stringMessages.username()));
        this.usernameBox = new TextBox();
        this.usernameBox.setText("");
        this.usernameBox.setWidth("300px");
        usernamePanel.add((Widget)this.usernameBox);
        HorizontalPanel passwordPanel = new HorizontalPanel();
        passwordPanel.add((Widget)new Label(stringMessages.password()));
        this.passwordBox = new PasswordTextBox();
        this.passwordBox.setText("");
        this.passwordBox.setWidth("300px");
        passwordPanel.add((Widget)this.passwordBox);
        HorizontalPanel userContextInformation = new HorizontalPanel();
        userContextInformation.setWidth("350px");
        userContextInformation.add((Widget)new Label(stringMessages.keepEmptyForDefaultUserAndPassword(), true));
        this.fetchIdsButton = new Button(stringMessages.importFetchRemoteLgs());
        this.fetchIdsButton.ensureDebugId("fetchLeaderboardGroupList");
        DialogUtils.linkEnterToButton((Button)this.fetchIdsButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.usernameBox});
        DialogUtils.linkEnterToButton((Button)this.fetchIdsButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.passwordBox});
        this.add((Widget)serverAddressPanel);
        this.add((Widget)userContextInformation);
        this.add((Widget)usernamePanel);
        this.add((Widget)passwordPanel);
        this.add((Widget)this.fetchIdsButton);
        ScrollPanel scrollPanel = new ScrollPanel();
        this.add((Widget)scrollPanel);
        VerticalPanel contentPanel = new VerticalPanel();
        scrollPanel.setWidget((Widget)contentPanel);
        this.addContentToLeftPanel(contentPanel);
        this.setListeners();
    }

    private void setListeners() {
        this.fetchIdsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.hostBox.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.importLeaderboardGroupsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void importLeaderboardGroups() {
        UUID[] leaderboardGroupIds = this.createLeaderboardGroupIdsFromListBox();
        Label overallName = new Label(String.valueOf(this.stringMessages.overallProgress()) + ":");
        this.add((Widget)overallName);
        CustomProgressBar overallProgressBar = CustomProgressBar.determinate();
        overallProgressBar.ensureDebugId("overallProgressBar");
        this.add((Widget)overallProgressBar);
        Label subProgressName = new Label();
        this.add((Widget)subProgressName);
        CustomProgressBar subProgressBar = CustomProgressBar.determinate();
        this.add((Widget)subProgressBar);
        if (leaderboardGroupIds.length >= 1) {
            this.disableAllButtons();
            boolean override = this.overrideSwitch.getValue();
            boolean compress = this.compressSwitch.getValue();
            boolean exportWind = this.exportWindSwitch.getValue();
            boolean exportDeviceConfigs = this.exportDeviceConfigsSwitch.getValue();
            boolean exportTrackedRacesAndStartTracking = this.exportTrackedRacesAndStartTrackingSwitch.getValue();
            this.sailingServiceWrite.importMasterData(this.currentHost, leaderboardGroupIds, override, compress, exportWind, exportDeviceConfigs, this.usernameBox.getValue(), this.passwordBox.getValue(), exportTrackedRacesAndStartTracking, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.showErrorAlert(this.stringMessages.importSelectAtLeastOne());
        }
    }

    private void showCreationMessage(MasterDataImportObjectCreationCount creationCount) {
        int leaderboardsCreated = creationCount.getLeaderboardCount();
        int leaderboardGroupsCreated = creationCount.getLeaderboardGroupCount();
        int eventsCreated = creationCount.getEventCount();
        int regattasCreated = creationCount.getRegattaCount();
        int mediaTracksImported = creationCount.getMediaTrackCount();
        int trackedRacesImported = creationCount.getTrackedRacesCount();
        if (regattasCreated > 0) {
            this.presenter.getRegattasRefresher().reloadAndCallFillAll();
        }
        if (eventsCreated > 0) {
            this.presenter.getEventsRefresher().reloadAndCallFillAll();
        }
        if (leaderboardGroupsCreated > 0) {
            this.presenter.getLeaderboardGroupsRefresher().reloadAndCallFillAll();
        }
        if (leaderboardsCreated > 0) {
            this.presenter.getLeaderboardsRefresher().reloadAndCallFillAll();
        }
        if (mediaTracksImported > 0) {
            this.presenter.getMediaTracksRefresher().reloadAndCallFillAll();
        }
        Iterable overwrittenRegattas = creationCount.getNamesOfOverwrittenRegattaNames();
        this.showSuccessAlert(leaderboardsCreated, leaderboardGroupsCreated, eventsCreated, regattasCreated, mediaTracksImported, trackedRacesImported, overwrittenRegattas);
        this.changeButtonStateAccordingToApplicationState();
    }

    private void disableAllButtons() {
        boolean enabled = false;
        this.importLeaderboardGroupsButton.setEnabled(enabled);
        this.overrideSwitch.setEnabled(enabled);
        this.fetchIdsButton.setEnabled(enabled);
    }

    private void changeButtonStateAccordingToApplicationState() {
        if (this.leaderboardgroupListBox.getItemCount() > 0 && this.countSelectedItems() > 0) {
            this.importLeaderboardGroupsButton.setEnabled(true);
        } else {
            this.importLeaderboardGroupsButton.setEnabled(false);
        }
        this.overrideSwitch.setEnabled(true);
        this.fetchIdsButton.setEnabled(true);
    }

    private int countSelectedItems() {
        int count = 0;
        int i = 0;
        while (i < this.leaderboardgroupListBox.getItemCount()) {
            if (this.leaderboardgroupListBox.isItemSelected(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected void showSuccessAlert(int leaderboardsCreated, int leaderboardGroupsCreated, int eventsCreated, int regattasCreated, int mediaTracksImported, int trackedRacesImported, Iterable<String> overwrittenRegattas) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stringMessages.importSuccess(leaderboardGroupsCreated, leaderboardsCreated, eventsCreated, regattasCreated, mediaTracksImported, trackedRacesImported));
        if (!Util.isEmpty(overwrittenRegattas)) {
            buffer.append("\n\n" + this.stringMessages.importSuccessOverwriteInfo() + "\n");
            for (String regattaName : overwrittenRegattas) {
                buffer.append(String.valueOf(regattaName) + "\n");
            }
        }
        Notification.notify((String)buffer.toString(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
    }

    private UUID[] createLeaderboardGroupIdsFromListBox() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        int i = 0;
        while (i < this.leaderboardgroupListBox.getItemCount()) {
            if (this.leaderboardgroupListBox.isItemSelected(i)) {
                uuids.add(UUID.fromString(this.leaderboardgroupListBox.getValue(i)));
            }
            ++i;
        }
        return uuids.toArray(new UUID[uuids.size()]);
    }

    protected void fireIdRequestsAndFillLists() {
        String host = this.hostBox.getText();
        if (host != null && !host.isEmpty()) {
            this.fireLgIdRequestAndFillList(host);
        }
    }

    private void fireLgIdRequestAndFillList(String host) {
        this.currentHost = host;
        this.disableAllButtons();
        this.sailingServiceWrite.getLeaderboardGroupNamesAndIdsAsStringsFromRemoteServer(host, this.usernameBox.getValue(), this.passwordBox.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showErrorAlert(String string) {
        Notification.notify((String)string, (Notification.NotificationType)Notification.NotificationType.ERROR);
    }

    private void addContentToLeftPanel(VerticalPanel contentPanel) {
        contentPanel.add((Widget)new Label(this.stringMessages.availableLeaderboardGroups()));
        HorizontalPanel filterPanel = new HorizontalPanel();
        filterPanel.add((Widget)new Label(String.valueOf(this.stringMessages.filterName()) + ":"));
        this.filterBox = new TextBox();
        this.setFilterHandler(this.filterBox);
        filterPanel.add((Widget)this.filterBox);
        contentPanel.add((Widget)filterPanel);
        this.leaderboardgroupListBox = new ListBox();
        this.leaderboardgroupListBox.ensureDebugId("LeaderBoardGroupListBox");
        this.leaderboardgroupListBox.setMultipleSelect(true);
        this.addSelectionChangedListener();
        contentPanel.add((Widget)this.leaderboardgroupListBox);
        this.overrideSwitch = new CheckBox(this.stringMessages.importOverrideSwitchLabel());
        this.overrideSwitch.ensureDebugId("overrideExisting");
        this.overrideSwitch.setValue(Boolean.valueOf(false));
        contentPanel.add((Widget)this.overrideSwitch);
        this.compressSwitch = new CheckBox(this.stringMessages.compress());
        this.compressSwitch.setTitle(this.stringMessages.compressTooltip());
        this.compressSwitch.setValue(Boolean.valueOf(true));
        contentPanel.add((Widget)this.compressSwitch);
        this.exportWindSwitch = new CheckBox(this.stringMessages.importWind());
        this.exportWindSwitch.setTitle(this.stringMessages.importWindTooltip());
        this.exportWindSwitch.setValue(Boolean.valueOf(true));
        this.exportWindSwitch.ensureDebugId("wind");
        contentPanel.add((Widget)this.exportWindSwitch);
        this.exportDeviceConfigsSwitch = new CheckBox(this.stringMessages.importDeviceConfigurations());
        this.exportDeviceConfigsSwitch.setTitle(this.stringMessages.importDeviceConfigurationsTooltip());
        this.exportDeviceConfigsSwitch.setValue(Boolean.valueOf(false));
        contentPanel.add((Widget)this.exportDeviceConfigsSwitch);
        this.exportTrackedRacesAndStartTrackingSwitch = new CheckBox(this.stringMessages.exportTrackedRacesAndStartTracking());
        this.exportTrackedRacesAndStartTrackingSwitch.setTitle(this.stringMessages.exportTrackedRacesAndStartTrackingTooltip());
        this.exportTrackedRacesAndStartTrackingSwitch.setValue(Boolean.valueOf(true));
        contentPanel.add((Widget)this.exportTrackedRacesAndStartTrackingSwitch);
        this.importLeaderboardGroupsButton = new Button(this.stringMessages.importSelectedLeaderboardGroups());
        this.importLeaderboardGroupsButton.ensureDebugId("import");
        this.importLeaderboardGroupsButton.setEnabled(false);
        contentPanel.add((Widget)this.importLeaderboardGroupsButton);
    }

    private void addSelectionChangedListener() {
        this.leaderboardgroupListBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setFilterHandler(TextBox filterBox) {
        filterBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clearListBox() {
        int itemCount = this.leaderboardgroupListBox.getItemCount();
        int i = itemCount - 1;
        while (i >= 0) {
            this.leaderboardgroupListBox.removeItem(i);
            --i;
        }
    }

    private void filterLeaderboardGroupList() {
        this.clearListBox();
        Iterable filterTexts = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)this.filterBox.getText());
        8 matcher = new /* Unavailable Anonymous Inner Class!! */;
        Map<String, String> filteredMap = this.allLeaderboardGroupsNameAndIdsMap.entrySet().stream().filter(arg_0 -> MasterDataImportPanel.lambda$0((KeywordMatcher)matcher, filterTexts, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.fillLeaderboardGroupListBox(filteredMap);
        this.changeButtonStateAccordingToApplicationState();
    }

    private void fillLeaderboardGroupListBox(Map<String, String> leaderboardGroupsMap) {
        ArrayList<Util.Pair> list = new ArrayList<Util.Pair>();
        for (String key : leaderboardGroupsMap.keySet()) {
            list.add(new Util.Pair((Object)leaderboardGroupsMap.get(key), (Object)key));
        }
        Collections.sort(list, (a, b) -> ((String)a.getA()).compareTo((String)b.getA()));
        for (Util.Pair pair : list) {
            this.leaderboardgroupListBox.addItem((String)pair.getA(), (String)pair.getB());
        }
        this.leaderboardgroupListBox.setVisibleItemCount(list.size());
    }

    private void deleteProgressIndication(IsWidget ... widgetsToRemove) {
        Arrays.asList(widgetsToRemove).forEach(arg_0 -> ((MasterDataImportPanel)this).remove(arg_0));
    }

    static /* synthetic */ void access$0(MasterDataImportPanel masterDataImportPanel, String string) {
        masterDataImportPanel.showErrorAlert(string);
    }

    static /* synthetic */ SailingServiceWriteAsync access$1(MasterDataImportPanel masterDataImportPanel) {
        return masterDataImportPanel.sailingServiceWrite;
    }

    static /* synthetic */ StringMessages access$2(MasterDataImportPanel masterDataImportPanel) {
        return masterDataImportPanel.stringMessages;
    }

    static /* synthetic */ void access$3(MasterDataImportPanel masterDataImportPanel, IsWidget[] isWidgetArray) {
        masterDataImportPanel.deleteProgressIndication(isWidgetArray);
    }

    static /* synthetic */ void access$4(MasterDataImportPanel masterDataImportPanel) {
        masterDataImportPanel.changeButtonStateAccordingToApplicationState();
    }

    static /* synthetic */ void access$5(MasterDataImportPanel masterDataImportPanel, MasterDataImportObjectCreationCount masterDataImportObjectCreationCount) {
        masterDataImportPanel.showCreationMessage(masterDataImportObjectCreationCount);
    }

    static /* synthetic */ void access$6(MasterDataImportPanel masterDataImportPanel, Map map) {
        masterDataImportPanel.allLeaderboardGroupsNameAndIdsMap = map;
    }

    static /* synthetic */ Map access$7(MasterDataImportPanel masterDataImportPanel) {
        return masterDataImportPanel.allLeaderboardGroupsNameAndIdsMap;
    }

    static /* synthetic */ void access$8(MasterDataImportPanel masterDataImportPanel, Map map) {
        masterDataImportPanel.fillLeaderboardGroupListBox(map);
    }

    static /* synthetic */ TextBox access$9(MasterDataImportPanel masterDataImportPanel) {
        return masterDataImportPanel.filterBox;
    }

    static /* synthetic */ void access$10(MasterDataImportPanel masterDataImportPanel) {
        masterDataImportPanel.filterLeaderboardGroupList();
    }

    private static /* synthetic */ boolean lambda$0(KeywordMatcher keywordMatcher, Iterable iterable, Map.Entry entry) {
        return keywordMatcher.matches(iterable, (Object)((String)entry.getValue()));
    }
}

