/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.LatLngBounds;
import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.NonCardinalBounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.BoundsImpl;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class BoundsUtil {
    private static final double SECTOR_BOUNDARY_LIMIT_DEGREES = 1.0E-5;

    public static NonCardinalBounds getMapBounds(LatLngBounds mapBounds, Bearing mapHeading, CoordinateSystem coordinateSystem) {
        Position mapBoundsSouthWest = coordinateSystem.getPosition(mapBounds.getSouthWest());
        Position mapBoundsNorthEast = coordinateSystem.getPosition(mapBounds.getNorthEast());
        DegreePosition mapBoundsNorthWest = new DegreePosition(mapBoundsNorthEast.getLatDeg(), mapBoundsSouthWest.getLngDeg());
        DegreePosition mapBoundsSouthEast = new DegreePosition(mapBoundsSouthWest.getLatDeg(), mapBoundsNorthEast.getLngDeg());
        Distance horizontalMapBoundsSize = mapBoundsSouthWest.getDistance((Position)mapBoundsSouthEast);
        Distance verticalMapBoundsSize = mapBoundsSouthEast.getDistance(mapBoundsNorthEast);
        Distance horizontalSizeViewport = null;
        Distance verticalSizeViewport = null;
        Position viewportLowerLeft = null;
        Position[] mapBoundsCornersClockwise = new Position[]{mapBoundsSouthWest, mapBoundsNorthWest, mapBoundsNorthEast, mapBoundsSouthEast};
        while (mapHeading.getDegrees() < 0.0) {
            mapHeading = mapHeading.add((Bearing)new DegreeBearingImpl(360.0));
        }
        if (mapHeading.getDegrees() < 1.0E-5) {
            viewportLowerLeft = mapBoundsSouthWest;
            horizontalSizeViewport = horizontalMapBoundsSize;
            verticalSizeViewport = verticalMapBoundsSize;
        } else {
            Distance lengthOfMapBoundsEdgeNotHoldingLowerLeft;
            int sectorIndex = (int)((mapHeading.getDegrees() - 1.0E-5) / 90.0);
            DegreeBearingImpl heading = new DegreeBearingImpl(mapHeading.getDegrees() - (double)sectorIndex * 90.0);
            Bearing currentMapBoundsEdgeBearing = Bearing.NORTH.add((Bearing)new DegreeBearingImpl((double)sectorIndex * 90.0));
            Distance lengthOfMapBoundsEdgeHoldingLowerLeft = sectorIndex % 2 == 0 ? verticalMapBoundsSize : horizontalMapBoundsSize;
            Distance distance = lengthOfMapBoundsEdgeNotHoldingLowerLeft = sectorIndex % 2 == 0 ? horizontalMapBoundsSize : verticalMapBoundsSize;
            if (heading.getDegrees() < 89.99999) {
                double tangensHeading = Math.tan(heading.getRadians());
                Distance fromMapBoundsCornerToLowerLeftOfViewportBounds = lengthOfMapBoundsEdgeHoldingLowerLeft.scale(tangensHeading * tangensHeading).add(lengthOfMapBoundsEdgeNotHoldingLowerLeft.scale(-tangensHeading)).scale(1.0 / (tangensHeading * tangensHeading + 1.0));
                horizontalSizeViewport = fromMapBoundsCornerToLowerLeftOfViewportBounds.scale(1.0 / Math.sin(heading.getRadians()));
                verticalSizeViewport = lengthOfMapBoundsEdgeHoldingLowerLeft.add(fromMapBoundsCornerToLowerLeftOfViewportBounds.scale(-1.0)).scale(1.0 / Math.cos(heading.getRadians()));
                viewportLowerLeft = mapBoundsCornersClockwise[sectorIndex].translateGreatCircle(currentMapBoundsEdgeBearing, fromMapBoundsCornerToLowerLeftOfViewportBounds);
            } else if (heading.getDegrees() < 90.00001) {
                viewportLowerLeft = mapBoundsCornersClockwise[(sectorIndex + 1) % mapBoundsCornersClockwise.length];
                horizontalSizeViewport = lengthOfMapBoundsEdgeHoldingLowerLeft;
                verticalSizeViewport = lengthOfMapBoundsEdgeNotHoldingLowerLeft;
            }
        }
        return NonCardinalBounds.create((Position)viewportLowerLeft, (Bearing)mapHeading, (Distance)verticalSizeViewport, (Distance)horizontalSizeViewport);
    }

    public static Bounds getAsBounds(LatLngBounds latLngBounds) {
        return new BoundsImpl((Position)new DegreePosition(latLngBounds.getSouthWest().getLatitude(), latLngBounds.getSouthWest().getLongitude()), (Position)new DegreePosition(latLngBounds.getNorthEast().getLatitude(), latLngBounds.getNorthEast().getLongitude()));
    }

    public static LatLngBounds getAsLatLngBounds(Bounds bounds) {
        return LatLngBounds.newInstance((LatLng)LatLng.newInstance((double)bounds.getSouthWest().getLatDeg(), (double)bounds.getSouthWest().getLngDeg()), (LatLng)LatLng.newInstance((double)bounds.getNorthEast().getLatDeg(), (double)bounds.getNorthEast().getLngDeg()));
    }

    public static Position getAsPosition(LatLng latLngPosition) {
        return new DegreePosition(latLngPosition.getLatitude(), latLngPosition.getLongitude());
    }

    public static Bounds getAsBounds(Position position) {
        return new BoundsImpl(position, position);
    }

    public static LatLngBounds getAsBounds(LatLng position) {
        return LatLngBounds.newInstance((LatLng)position, (LatLng)position);
    }

    public static boolean contains(LatLngBounds doesOrDoesNotContain, LatLngBounds containedOrNotContained) {
        return BoundsUtil.isCrossesDateLine((LatLngBounds)doesOrDoesNotContain) == BoundsUtil.isCrossesDateLine((LatLngBounds)containedOrNotContained) && doesOrDoesNotContain.contains(containedOrNotContained.getNorthEast()) && doesOrDoesNotContain.contains(containedOrNotContained.getSouthWest());
    }

    public static boolean isCrossesDateLine(LatLngBounds latLngBounds) {
        return latLngBounds.getNorthEast().getLongitude() < latLngBounds.getSouthWest().getLongitude();
    }

    public static LatLngBounds intersect(LatLngBounds b1, LatLngBounds other) {
        double maxSouthLatDeg = Math.max(b1.getSouthWest().getLatitude(), other.getSouthWest().getLatitude());
        double minNorthLatDeg = Math.min(b1.getNorthEast().getLatitude(), other.getNorthEast().getLatitude());
        double westDeg = BoundsUtil.containsLngDeg((LatLngBounds)b1, (double)other.getSouthWest().getLongitude()) ? other.getSouthWest().getLongitude() : (BoundsUtil.containsLngDeg((LatLngBounds)other, (double)b1.getSouthWest().getLongitude()) ? b1.getSouthWest().getLongitude() : b1.getSouthWest().getLongitude());
        double eastDeg = BoundsUtil.containsLngDeg((LatLngBounds)b1, (double)other.getNorthEast().getLongitude()) ? other.getNorthEast().getLongitude() : (BoundsUtil.containsLngDeg((LatLngBounds)other, (double)b1.getNorthEast().getLongitude()) ? b1.getNorthEast().getLongitude() : b1.getSouthWest().getLongitude());
        return LatLngBounds.newInstance((LatLng)LatLng.newInstance((double)maxSouthLatDeg, (double)westDeg), (LatLng)LatLng.newInstance((double)minNorthLatDeg, (double)eastDeg));
    }

    private static boolean containsLngDeg(LatLngBounds bounds, double lngDeg) {
        return BoundsUtil.spansLngDeg((double)bounds.getSouthWest().getLongitude(), (double)bounds.getNorthEast().getLongitude(), (double)lngDeg);
    }

    private static boolean spansLngDeg(double westLngDeg, double eastLngDeg, double lngDeg) {
        return BoundsUtil.isCrossingDateLine((double)westLngDeg, (double)eastLngDeg) ? lngDeg >= westLngDeg && lngDeg <= 180.0 || lngDeg >= -180.0 && lngDeg <= eastLngDeg : westLngDeg <= lngDeg && lngDeg <= eastLngDeg;
    }

    private static boolean isCrossingDateLine(double westLngDeg, double eastLngDeg) {
        return westLngDeg > eastLngDeg;
    }
}

