/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.ExpeditionAllInOneConstants;
import com.sap.sailing.gwt.common.client.suggestion.BoatClassMasterdataSuggestOracle;
import com.sap.sailing.gwt.common.client.suggestion.RegattaSuggestOracle;
import com.sap.sailing.gwt.ui.adminconsole.ExpeditionAllInOneAfterImportHandler;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.resulthandling.ExpeditionDataImportResponse;
import com.sap.sailing.gwt.ui.adminconsole.resulthandling.ExpeditionDataImportResultsDialog;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.fileupload.FileUploadUtil;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;

public class ExpeditionAllInOneImportPanel
extends Composite {
    private static final String URL_SAILINGSERVER_EXPEDITION_FULL_IMPORT = "/../../sailingserver/expedition/import";
    private final RegattaSuggestOracle regattaOracle;
    private final Displayer<RegattaDTO> regattasDisplayer = result -> this.fillRegattas(result);

    public ExpeditionAllInOneImportPanel(StringMessages stringMessages, AdminConsoleView.Presenter presenter) {
        FormPanel formPanel = new FormPanel();
        SimpleBusyIndicator busyIndicator = new SimpleBusyIndicator();
        Button uploadButton = new Button(stringMessages.upload());
        formPanel.getElement().setAttribute("autocomplete", "off");
        uploadButton.addClickHandler(arg_0 -> ExpeditionAllInOneImportPanel.lambda$1(uploadButton, (BusyIndicator)busyIndicator, formPanel, arg_0));
        formPanel.setMethod("post");
        formPanel.setEncoding("multipart/form-data");
        formPanel.setAction(String.valueOf(GWT.getHostPageBaseURL()) + URL_SAILINGSERVER_EXPEDITION_FULL_IMPORT);
        VerticalPanel contentPanel = new VerticalPanel();
        formPanel.add((Widget)contentPanel);
        Hidden localeField = new Hidden("locale", LocaleInfo.getCurrentLocale().getLocaleName());
        contentPanel.add((Widget)localeField);
        FileUpload fileUpload = new FileUpload();
        fileUpload.setName("upload");
        contentPanel.add((Widget)fileUpload);
        FlowPanel importModePanel = new FlowPanel();
        contentPanel.add((Widget)importModePanel);
        HorizontalPanel regattaNamePanel = new HorizontalPanel();
        regattaNamePanel.setVisible(false);
        HorizontalPanel boatClassPanel = new HorizontalPanel();
        contentPanel.add((Widget)regattaNamePanel);
        RadioButton newEventImport = new RadioButton("importMode", stringMessages.createNewEvent());
        newEventImport.setFormValue(ExpeditionAllInOneConstants.ImportMode.NEW_EVENT.name());
        newEventImport.setValue(Boolean.valueOf(true));
        importModePanel.add((Widget)newEventImport);
        newEventImport.addClickHandler(event -> {
            regattaNamePanel.setVisible(false);
            boatClassPanel.setVisible(true);
        });
        RadioButton newCompetitorImport = new RadioButton("importMode", stringMessages.newExpeditionCompetitor());
        newCompetitorImport.setFormValue(ExpeditionAllInOneConstants.ImportMode.NEW_COMPETITOR.name());
        importModePanel.add((Widget)newCompetitorImport);
        newCompetitorImport.addClickHandler(event -> {
            regattaNamePanel.setVisible(true);
            boatClassPanel.setVisible(false);
        });
        RadioButton newRaceImport = new RadioButton("importMode", stringMessages.newExpeditionRace());
        newRaceImport.setFormValue(ExpeditionAllInOneConstants.ImportMode.NEW_RACE.name());
        importModePanel.add((Widget)newRaceImport);
        newRaceImport.addClickHandler(event -> {
            regattaNamePanel.setVisible(true);
            boatClassPanel.setVisible(false);
        });
        CheckBox importStartData = new CheckBox(stringMessages.importStartData());
        importStartData.setValue(Boolean.valueOf(true));
        importStartData.setName("importStartData");
        importModePanel.add((Widget)importStartData);
        regattaNamePanel.setSpacing(5);
        Label regattaNameLabel = new Label(String.valueOf(stringMessages.regattaName()) + ":");
        regattaNamePanel.add((Widget)regattaNameLabel);
        regattaNamePanel.setCellVerticalAlignment((Widget)regattaNameLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        TextBox regattaName = new TextBox();
        regattaName.setName("regattaName");
        this.regattaOracle = new RegattaSuggestOracle();
        SuggestBox regattaSuggestBox = new SuggestBox((SuggestOracle)this.regattaOracle, (ValueBoxBase)regattaName);
        regattaSuggestBox.getValueBox().getElement().getStyle().setProperty("minWidth", 30.0, Style.Unit.EM);
        regattaSuggestBox.getValueBox().getElement().setAttribute("placeholder", stringMessages.startTypingForSuggestions());
        regattaNamePanel.add((Widget)regattaSuggestBox);
        regattaNamePanel.setCellVerticalAlignment((Widget)regattaSuggestBox, HasVerticalAlignment.ALIGN_MIDDLE);
        boatClassPanel.setSpacing(5);
        contentPanel.add((Widget)boatClassPanel);
        Label boatClassLabel = new Label(String.valueOf(stringMessages.boatClass()) + ":");
        boatClassPanel.add((Widget)boatClassLabel);
        boatClassPanel.setCellVerticalAlignment((Widget)boatClassLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        SuggestBox boatClassInput = new SuggestBox((SuggestOracle)new BoatClassMasterdataSuggestOracle());
        boatClassInput.getValueBox().getElement().getStyle().setProperty("minWidth", 30.0, Style.Unit.EM);
        boatClassInput.getValueBox().getElement().setAttribute("placeholder", stringMessages.startTypingForSuggestions());
        boatClassInput.getValueBox().setName("boatClass");
        boatClassPanel.add((Widget)boatClassInput);
        boatClassPanel.setCellVerticalAlignment((Widget)boatClassInput, HasVerticalAlignment.ALIGN_MIDDLE);
        HorizontalPanel controlPanel = new HorizontalPanel();
        controlPanel.setSpacing(5);
        controlPanel.add((Widget)uploadButton);
        controlPanel.add((Widget)busyIndicator);
        contentPanel.add((Widget)controlPanel);
        Runnable validation = () -> {
            boolean regattaNameValid;
            String filename = fileUpload.getFilename();
            String boatClass = boatClassInput.getValue();
            String regattaNameValue = regattaSuggestBox.getValue();
            boolean fileValid = filename != null && !filename.trim().isEmpty();
            boolean isNewEventImport = Boolean.TRUE.equals(newEventImport.getValue());
            boolean boatClassValid = boatClass != null && !boatClass.trim().isEmpty();
            boolean bl = regattaNameValid = regattaNameValue != null && !regattaNameValue.trim().isEmpty();
            uploadButton.setEnabled(fileValid && (isNewEventImport ? boatClassValid : regattaNameValid));
        };
        fileUpload.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        formPanel.addSubmitCompleteHandler(arg_0 -> this.lambda$6(validation, (BusyIndicator)busyIndicator, presenter, stringMessages, arg_0));
        regattaSuggestBox.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        regattaSuggestBox.addKeyUpHandler(event -> validation.run());
        fileUpload.addChangeHandler(event -> validation.run());
        boatClassInput.addSelectionHandler(event -> validation.run());
        boatClassInput.addKeyUpHandler(event -> validation.run());
        validation.run();
        this.initWidget((Widget)formPanel);
    }

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public void fillRegattas(Iterable<RegattaDTO> regattas) {
        this.regattaOracle.fillRegattas(regattas);
    }

    private static /* synthetic */ void lambda$1(Button button, BusyIndicator busyIndicator, FormPanel formPanel, ClickEvent event) {
        button.setEnabled(false);
        busyIndicator.setBusy(true);
        formPanel.submit();
    }

    private /* synthetic */ void lambda$6(Runnable runnable, BusyIndicator busyIndicator, AdminConsoleView.Presenter presenter, StringMessages stringMessages, FormPanel.SubmitCompleteEvent event) {
        runnable.run();
        busyIndicator.setBusy(false);
        ExpeditionDataImportResponse response = ExpeditionDataImportResponse.parse((String)FileUploadUtil.getApplicationJsonContentFromHtml((String)event.getResults()));
        if (response == null) {
            Notification.notify((String)StringMessages.INSTANCE.unexpectedErrorDuringFileImport(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        } else if (response.hasEventId()) {
            new ExpeditionAllInOneAfterImportHandler(response.getEventId(), response.getRegattaName(), response.getLeaderboardName(), response.getLeaderboardGroupName(), response.getLeaderboardGroupId(), response.getRaceEntries(), response.getGpsDeviceIds(), response.getSensorDeviceIds(), response.getSensorFixImporterType(), response.getStartTimes(), presenter.getSailingService(), presenter.getUserService(), presenter.getCompetitorsRefresher(), presenter.getBoatsRefresher(), presenter.getRegattasRefresher(), presenter.getEventsRefresher(), presenter.getLeaderboardsRefresher(), presenter.getLeaderboardGroupsRefresher(), presenter.getErrorReporter(), stringMessages, this.getRegattasDisplayer());
        } else {
            ExpeditionDataImportResultsDialog.showResults((ExpeditionDataImportResponse)response);
        }
    }
}

