/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.ui.adminconsole.CreateDefaultRegattaDialog;
import com.sap.sailing.gwt.ui.adminconsole.CreateRegattaCallback;
import com.sap.sailing.gwt.ui.adminconsole.EventConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.EventCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.EventEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.EventListComposite;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.MigrateGroupOwnershipDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaWithSeriesAndFleetsCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.controls.MultipleLinkCell;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class EventListComposite
extends Composite {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final CellTable<EventDTO> eventTable;
    private final RefreshableMultiSelectionModel<EventDTO> refreshableEventSelectionModel;
    private final ListDataProvider<EventDTO> eventListDataProvider;
    private final List<EventDTO> allEvents;
    private final Label noEventsLabel;
    protected final LabeledAbstractFilterablePanel<EventDTO> filterTextbox;
    private final Displayer<LeaderboardGroupDTO> leaderboardGroupsDisplayer;
    private final Displayer<EventDTO> eventsDisplayer;
    private Iterable<LeaderboardGroupDTO> availableLeaderboardGroups;
    private static AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final AdminConsoleView.Presenter presenter;
    private final PlaceController placeController;

    public EventListComposite(AdminConsoleView.Presenter presenter, PlaceController placeController, StringMessages stringMessages) {
        RefreshableMultiSelectionModel selectionModel;
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.stringMessages = stringMessages;
        this.errorReporter = presenter.getErrorReporter();
        this.presenter = presenter;
        this.placeController = placeController;
        this.availableLeaderboardGroups = Collections.emptyList();
        this.allEvents = new ArrayList();
        VerticalPanel panel = new VerticalPanel();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.EVENT);
        panel.add((Widget)buttonPanel);
        this.leaderboardGroupsDisplayer = new /* Unavailable Anonymous Inner Class!! */;
        this.eventsDisplayer = new /* Unavailable Anonymous Inner Class!! */;
        this.eventListDataProvider = new ListDataProvider();
        this.filterTextbox = new /* Unavailable Anonymous Inner Class!! */;
        this.eventTable = this.createEventTable(this.userService.getCurrentUser());
        this.eventTable.ensureDebugId("EventsCellTable");
        this.refreshableEventSelectionModel = selectionModel = (RefreshableMultiSelectionModel)this.eventTable.getSelectionModel();
        this.eventTable.setVisible(false);
        Button refresh = buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> presenter.getEventsRefresher().reloadAndCallFillAll());
        refresh.ensureDebugId("RefreshEventsButton");
        Button create = buttonPanel.addCreateAction(stringMessages.actionAddEvent(), () -> this.openCreateEventDialog());
        create.ensureDebugId("CreateEventButton");
        Button remove = buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableEventSelectionModel, true, () -> this.removeEvents((Collection)this.refreshableEventSelectionModel.getSelectedSet()));
        remove.ensureDebugId("RemoveEventsButton");
        this.refreshableEventSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.addUnsecuredWidget((Widget)new HelpButton(HelpButtonResources.INSTANCE, stringMessages.videoGuide(), "https://sapsailing-documentation.s3-eu-west-1.amazonaws.com/adminconsole/CreatingYourFirstEvent.mp4"));
        panel.add((Widget)this.filterTextbox);
        panel.add((Widget)this.eventTable);
        this.noEventsLabel = new Label(stringMessages.noEventsYet());
        this.noEventsLabel.ensureDebugId("NoRegattasLabel");
        this.noEventsLabel.setWordWrap(false);
        panel.add((Widget)this.noEventsLabel);
        this.initWidget((Widget)panel);
        this.filterTextbox.setUpdatePermissionFilterForCheckbox(event -> this.userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    public Displayer<EventDTO> getEventsDisplayer() {
        return this.eventsDisplayer;
    }

    public Displayer<LeaderboardGroupDTO> getLeaderboardGroupsDisplayer() {
        return this.leaderboardGroupsDisplayer;
    }

    private CellTable<EventDTO> createEventTable(UserDTO user) {
        FlushableCellTable table = new FlushableCellTable(10000, (CellTable.Resources)this.tableRes);
        this.eventListDataProvider.addDataDisplay((HasData)table);
        table.setWidth("100%");
        SelectionCheckboxColumn eventSelectionCheckboxColumn = new SelectionCheckboxColumn(this.tableRes.cellTableStyle().cellTableCheckboxSelected(), this.tableRes.cellTableStyle().cellTableCheckboxDeselected(), this.tableRes.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterTextbox.getAllListDataProvider(), (Flushable)table);
        AnchorCell anchorCell = new AnchorCell();
        ColumnSortEvent.ListHandler listHandler = new ColumnSortEvent.ListHandler(this.eventListDataProvider.getList());
        AbstractSortableTextColumn eventUUidColumn = new AbstractSortableTextColumn(event -> event.getId() == null ? "<null>" : event.getId().toString(), listHandler);
        7 eventNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 venueNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 startEndDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 isPublicColumn = new /* Unavailable Anonymous Inner Class!! */;
        SafeHtmlCell courseAreasCell = new SafeHtmlCell();
        11 courseAreasColumn = new /* Unavailable Anonymous Inner Class!! */;
        MultipleLinkCell leaderboardGroupsCell = new MultipleLinkCell(true);
        12 leaderboardGroupsColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardGroupsCell.setOnLinkClickHandler((ValueUpdater)new /* Unavailable Anonymous Inner Class!! */);
        14 imagesColumn = new /* Unavailable Anonymous Inner Class!! */;
        15 videosColumn = new /* Unavailable Anonymous Inner Class!! */;
        SecuredDTOOwnerColumn groupColumn = SecuredDTOOwnerColumn.getGroupOwnerColumn();
        SecuredDTOOwnerColumn userColumn = SecuredDTOOwnerColumn.getUserOwnerColumn();
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new EventConfigImagesBarCell(this.stringMessages), (UserService)this.userService);
        actionsColumn.addAction(EventConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditEventDialog(arg_0));
        actionsColumn.addAction(EventConfigImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, event -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveEvent(event.getName()))) {
                this.removeEvent(event);
            }
        });
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.EVENT, event -> this.presenter.getEventsRefresher().reloadAndCallFillAll(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(EventConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)config).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.EVENT, event -> this.presenter.getEventsRefresher().reloadAndCallFillAll(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(EventConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        MigrateGroupOwnershipDialog.DialogConfig migrateDialogConfig = MigrateGroupOwnershipDialog.create((UserManagementServiceAsync)this.userService.getUserManagementService(), (event, dto) -> this.sailingServiceWrite.updateGroupOwnerForEventHierarchy(event.id, dto, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        actionsColumn.addAction("MIGRATE_GROUP_OWNERSHIP_HIERARCHY", (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((MigrateGroupOwnershipDialog.DialogConfig)migrateDialogConfig).openDialog(arg_0));
        eventNameColumn.setSortable(true);
        venueNameColumn.setSortable(true);
        isPublicColumn.setSortable(true);
        startEndDateColumn.setSortable(true);
        courseAreasColumn.setSortable(true);
        leaderboardGroupsColumn.setSortable(true);
        groupColumn.setSortable(true);
        userColumn.setSortable(true);
        this.configureTableColumnSortHandler(listHandler, eventSelectionCheckboxColumn, (Column)eventNameColumn, (TextColumn)venueNameColumn, (TextColumn)startEndDateColumn, (TextColumn)isPublicColumn, (Column)courseAreasColumn, (Column)leaderboardGroupsColumn, groupColumn, userColumn);
        table.addColumn((Column)eventSelectionCheckboxColumn, eventSelectionCheckboxColumn.getHeader());
        table.addColumn((Column)eventNameColumn, this.stringMessages.event());
        table.addColumn((Column)venueNameColumn, this.stringMessages.venue());
        table.addColumn((Column)startEndDateColumn, String.valueOf(this.stringMessages.from()) + "/" + this.stringMessages.to());
        table.addColumn((Column)isPublicColumn, this.stringMessages.isListedOnHomepage());
        table.addColumn((Column)courseAreasColumn, this.stringMessages.courseAreas());
        table.addColumn((Column)leaderboardGroupsColumn, this.stringMessages.leaderboardGroups());
        table.addColumn((Column)imagesColumn, this.stringMessages.images());
        table.addColumn((Column)videosColumn, this.stringMessages.videos());
        table.addColumn((Column)groupColumn, this.stringMessages.group());
        table.addColumn((Column)userColumn, this.stringMessages.user());
        table.addColumn((Column)eventUUidColumn, this.stringMessages.id());
        table.addColumn((Column)actionsColumn, this.stringMessages.actions());
        table.setSelectionModel((SelectionModel)eventSelectionCheckboxColumn.getSelectionModel(), eventSelectionCheckboxColumn.getSelectionManager());
        table.addColumnSortHandler((ColumnSortEvent.Handler)listHandler);
        table.getColumnSortList().push((Column)startEndDateColumn);
        return table;
    }

    private void configureTableColumnSortHandler(ColumnSortEvent.ListHandler<EventDTO> columnSortHandler, SelectionCheckboxColumn<EventDTO> eventSelectionCheckboxColumn, Column<EventDTO, SafeHtml> eventNameColumn, TextColumn<EventDTO> venueNameColumn, TextColumn<EventDTO> startEndDateColumn, TextColumn<EventDTO> isPublicColumn, Column<EventDTO, SafeHtml> courseAreasColumn, Column<EventDTO, List<MultipleLinkCell.CellLink>> leaderboardGroupsColumn, SecuredDTOOwnerColumn<EventDTO> groupColumn, SecuredDTOOwnerColumn<EventDTO> userColumn) {
        columnSortHandler.setComparator(eventSelectionCheckboxColumn, (Comparator)eventSelectionCheckboxColumn.getComparator());
        columnSortHandler.setComparator(eventNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(venueNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(startEndDateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(isPublicColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(courseAreasColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(leaderboardGroupsColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        columnSortHandler.setComparator(groupColumn, groupColumn.getComparator());
        columnSortHandler.setComparator(userColumn, userColumn.getComparator());
    }

    private void removeEvents(Collection<EventDTO> events) {
        if (!events.isEmpty()) {
            HashSet<UUID> eventIds = new HashSet<UUID>();
            for (EventDTO event : events) {
                eventIds.add(event.id);
            }
            this.sailingServiceWrite.removeEvents(eventIds, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void removeEvent(EventDTO event) {
        this.sailingServiceWrite.removeEvent(event.id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCreateEventDialog() {
        ArrayList existingEvents = new ArrayList(this.eventListDataProvider.getList());
        ArrayList existingLeaderboardGroups = new ArrayList();
        Util.addAll((Iterable)this.availableLeaderboardGroups, existingLeaderboardGroups);
        EventCreateDialog dialog = new EventCreateDialog(Collections.unmodifiableCollection(existingEvents), existingLeaderboardGroups, this.sailingServiceWrite, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("EventCreateDialog");
        dialog.show();
    }

    private void openCreateDefaultRegattaDialog(EventDTO createdEvent) {
        CreateDefaultRegattaDialog dialog = new CreateDefaultRegattaDialog((SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("CreateDefaultRegattaDialog");
        dialog.show();
    }

    private void openCreateRegattaDialog(List<RegattaDTO> existingRegattas, List<EventDTO> existingEvents, EventDTO createdEvent) {
        RegattaWithSeriesAndFleetsCreateDialog dialog = new RegattaWithSeriesAndFleetsCreateDialog(existingRegattas, existingEvents, createdEvent, (SailingServiceAsync)this.sailingServiceWrite, this.userService, this.stringMessages, (DataEntryDialog.DialogCallback)new CreateRegattaCallback(this.stringMessages, this.presenter, existingEvents));
        dialog.ensureDebugId("RegattaCreateDialog");
        dialog.show();
    }

    private void openLeaderboardGroupCreationDialog(List<LeaderboardGroupDTO> existingLeaderboardGroups, EventDTO newEvent) {
        LeaderboardGroupCreateDialog leaderboardGroupCreateDialog = new LeaderboardGroupCreateDialog(existingLeaderboardGroups, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        leaderboardGroupCreateDialog.setFieldsBasedOnEventName(newEvent.getName(), newEvent.getDescription());
        leaderboardGroupCreateDialog.ensureDebugId("LeaderboardGroupCreateDialog");
        leaderboardGroupCreateDialog.show();
    }

    private void openEditEventDialog(EventDTO selectedEvent) {
        ArrayList existingEvents = new ArrayList(this.eventListDataProvider.getList());
        existingEvents.remove(selectedEvent);
        ArrayList existingLeaderboardGroups = new ArrayList();
        Util.addAll((Iterable)this.availableLeaderboardGroups, existingLeaderboardGroups);
        EventEditDialog dialog = new EventEditDialog(selectedEvent, Collections.unmodifiableCollection(existingEvents), existingLeaderboardGroups, this.sailingServiceWrite, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, (MediaServiceAsync)this.presenter.getMediaServiceWrite());
        dialog.show();
    }

    private void updateEvent(EventDTO oldEvent, EventDTO updatedEvent) {
        Util.Pair courseAreasToAddAndRemove = this.getCourseAreasToAdd(oldEvent, updatedEvent);
        List courseAreasToAdd = (List)courseAreasToAddAndRemove.getA();
        List courseAreasToRemove = (List)courseAreasToAddAndRemove.getB();
        List updatedEventLeaderboardGroupIds = updatedEvent.getLeaderboardGroupIds();
        this.sailingServiceWrite.updateEvent(oldEvent.id, oldEvent.getName(), updatedEvent.getDescription(), updatedEvent.startDate, updatedEvent.endDate, updatedEvent.getVenue(), updatedEvent.isPublic, updatedEventLeaderboardGroupIds, updatedEvent.getOfficialWebsiteURL(), updatedEvent.getBaseURL(), updatedEvent.getSailorsInfoWebsiteURLs(), updatedEvent.getImages(), updatedEvent.getVideos(), updatedEvent.getWindFinderReviewedSpotsCollectionIds(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Util.Pair<List<CourseAreaDTO>, List<CourseAreaDTO>> getCourseAreasToAdd(EventDTO oldEvent, EventDTO updatedEvent) {
        ArrayList courseAreasToAdd = new ArrayList(updatedEvent.getVenue().getCourseAreas());
        courseAreasToAdd.removeAll(oldEvent.getVenue().getCourseAreas());
        ArrayList courseAreasToRemove = new ArrayList(oldEvent.getVenue().getCourseAreas());
        courseAreasToRemove.removeAll(updatedEvent.getVenue().getCourseAreas());
        return new Util.Pair(courseAreasToAdd, courseAreasToRemove);
    }

    private void createNewEvent(EventDTO newEvent, List<LeaderboardGroupDTO> existingLeaderboardGroups) {
        this.sailingServiceWrite.createEvent(newEvent.getName(), newEvent.getDescription(), newEvent.startDate, newEvent.endDate, newEvent.getVenue().getName(), newEvent.isPublic, newEvent.getVenue().getCourseAreas(), newEvent.getOfficialWebsiteURL(), newEvent.getBaseURL(), newEvent.getSailorsInfoWebsiteURLs(), newEvent.getImages(), newEvent.getVideos(), newEvent.getLeaderboardGroupIds(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void fillLeaderboardGroups(Iterable<LeaderboardGroupDTO> leaderboardGroups) {
        this.availableLeaderboardGroups = Util.filter(leaderboardGroups, lg -> this.userService.hasPermission((SecuredDTO)lg, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    public void fillEvents(Iterable<EventDTO> events) {
        if (events.iterator().hasNext()) {
            this.eventTable.setVisible(true);
            this.noEventsLabel.setVisible(false);
        } else {
            this.eventTable.setVisible(false);
            this.noEventsLabel.setVisible(true);
        }
        this.allEvents.clear();
        events.forEach(this.allEvents::add);
        this.filterTextbox.updateAll((Iterable)this.allEvents);
        this.eventTable.redraw();
    }

    public List<EventDTO> getAllEvents() {
        return this.allEvents;
    }

    public RefreshableMultiSelectionModel<EventDTO> getRefreshableMultiSelectionModel() {
        return this.refreshableEventSelectionModel;
    }

    static /* synthetic */ ErrorReporter access$0(EventListComposite eventListComposite) {
        return eventListComposite.errorReporter;
    }

    static /* synthetic */ StringMessages access$1(EventListComposite eventListComposite) {
        return eventListComposite.stringMessages;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$2(EventListComposite eventListComposite) {
        return eventListComposite.presenter;
    }

    static /* synthetic */ CellTable access$3(EventListComposite eventListComposite) {
        return eventListComposite.eventTable;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$4(EventListComposite eventListComposite) {
        return eventListComposite.refreshableEventSelectionModel;
    }

    static /* synthetic */ UserService access$5(EventListComposite eventListComposite) {
        return eventListComposite.userService;
    }

    static /* synthetic */ AnchorTemplates access$6() {
        return ANCHORTEMPLATE;
    }

    static /* synthetic */ PlaceController access$7(EventListComposite eventListComposite) {
        return eventListComposite.placeController;
    }

    static /* synthetic */ void access$8(EventListComposite eventListComposite, EventDTO eventDTO, List list) {
        eventListComposite.createNewEvent(eventDTO, list);
    }

    static /* synthetic */ SailingServiceWriteAsync access$9(EventListComposite eventListComposite) {
        return eventListComposite.sailingServiceWrite;
    }

    static /* synthetic */ void access$10(EventListComposite eventListComposite, List list, List list2, EventDTO eventDTO) {
        eventListComposite.openCreateRegattaDialog(list, list2, eventDTO);
    }

    static /* synthetic */ List access$11(EventListComposite eventListComposite) {
        return eventListComposite.allEvents;
    }

    static /* synthetic */ void access$12(EventListComposite eventListComposite, EventDTO eventDTO, EventDTO eventDTO2) {
        eventListComposite.updateEvent(eventDTO, eventDTO2);
    }

    static /* synthetic */ void access$13(EventListComposite eventListComposite, EventDTO eventDTO) {
        eventListComposite.openCreateDefaultRegattaDialog(eventDTO);
    }

    static /* synthetic */ void access$14(EventListComposite eventListComposite, List list, EventDTO eventDTO) {
        eventListComposite.openLeaderboardGroupCreationDialog(list, eventDTO);
    }
}

