/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ListBox;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.AbstractRegattaPanel;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractEventManagementPanel
extends AbstractRegattaPanel {
    protected final TrackedRacesListComposite trackedRacesListComposite;
    private final List<RegattaDTO> availableRegattas = new ArrayList();
    private final ListBox availableRegattasListBox = new ListBox();

    public AbstractEventManagementPanel(AdminConsoleView.Presenter presenter, boolean actionButtonsEnabled, StringMessages stringMessages) {
        super(presenter, stringMessages);
        this.availableRegattasListBox.ensureDebugId("AvailableRegattasListBox");
        this.trackedRacesListComposite = new TrackedRacesListComposite(null, null, presenter, stringMessages, true, actionButtonsEnabled);
        this.trackedRacesListComposite.ensureDebugId("TrackedRacesListComposite");
    }

    public void fillRegattas(Iterable<RegattaDTO> regattas) {
        this.trackedRacesListComposite.fillRegattas(regattas);
        RegattaDTO selectedRegatta = this.getSelectedRegatta();
        this.availableRegattas.clear();
        this.availableRegattasListBox.clear();
        this.availableRegattasListBox.addItem(this.stringMessages.defaultRegatta());
        ArrayList regattasSortedByName = new ArrayList();
        Util.addAll(regattas, regattasSortedByName);
        Collections.sort(regattasSortedByName, new /* Unavailable Anonymous Inner Class!! */);
        for (RegattaDTO regatta : regattasSortedByName) {
            this.availableRegattas.add(regatta);
            this.availableRegattasListBox.addItem(regatta.getName());
            if (selectedRegatta == null || !selectedRegatta.getName().equals(regatta.getName())) continue;
            this.availableRegattasListBox.setSelectedIndex(this.availableRegattasListBox.getItemCount() - 1);
        }
    }

    protected List<RegattaDTO> getAvailableRegattas() {
        return this.availableRegattas;
    }

    protected ListBox getAvailableRegattasListBox() {
        return this.availableRegattasListBox;
    }

    public RegattaDTO getSelectedRegatta() {
        RegattaDTO result = null;
        int selIndex = this.availableRegattasListBox.getSelectedIndex();
        if (selIndex > 0) {
            String itemValue = this.availableRegattasListBox.getValue(selIndex);
            for (RegattaDTO regatta : this.availableRegattas) {
                if (!regatta.getName().equals(itemValue)) continue;
                result = regatta;
                break;
            }
        }
        return result;
    }

    protected boolean checkBoatClassOK(RegattaDTO selectedRegatta, Iterable<? extends RaceRecordDTO> selectedRaces) {
        boolean result;
        if (selectedRegatta != null) {
            ArrayList<RaceRecordDTO> racesWithNotMatchingBoatClasses = new ArrayList<RaceRecordDTO>();
            for (RaceRecordDTO raceRecordDTO : selectedRaces) {
                if (this.checkBoatClassMatch(raceRecordDTO.getBoatClassNames(), selectedRegatta)) continue;
                racesWithNotMatchingBoatClasses.add(raceRecordDTO);
            }
            if (!racesWithNotMatchingBoatClasses.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(100 + racesWithNotMatchingBoatClasses.size() * 30);
                stringBuilder.append(this.stringMessages.boatClassDoesNotMatchSelectedRegatta(selectedRegatta.boatClass == null ? "" : selectedRegatta.boatClass.getName()));
                stringBuilder.append("\n\n");
                stringBuilder.append(this.stringMessages.races());
                stringBuilder.append("\n");
                for (RaceRecordDTO record : racesWithNotMatchingBoatClasses) {
                    stringBuilder.append(record.getName());
                    stringBuilder.append(" (");
                    stringBuilder.append(record.getBoatClassNames());
                    stringBuilder.append(")");
                    stringBuilder.append("\n");
                }
                result = Window.confirm((String)stringBuilder.toString());
            } else {
                result = true;
            }
        } else {
            HashMap existingRegattasWithMatchingBoatClassPerRace = new HashMap();
            for (RaceRecordDTO raceRecordDTO : selectedRaces) {
                if (raceRecordDTO.hasRememberedRegatta()) continue;
                LinkedHashSet<RegattaDTO> existingRegattasWithMatchingBoatClass = new LinkedHashSet<RegattaDTO>();
                for (RegattaDTO regatta : this.getAvailableRegattas()) {
                    if (!this.checkBoatClassMatch(raceRecordDTO.getBoatClassNames(), regatta)) continue;
                    existingRegattasWithMatchingBoatClass.add(regatta);
                }
                if (existingRegattasWithMatchingBoatClass.isEmpty()) continue;
                existingRegattasWithMatchingBoatClassPerRace.put(raceRecordDTO, existingRegattasWithMatchingBoatClass);
            }
            if (!existingRegattasWithMatchingBoatClassPerRace.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(100 + existingRegattasWithMatchingBoatClassPerRace.size() * 30);
                stringBuilder.append(this.stringMessages.regattaExistForSelectedBoatClass());
                stringBuilder.append("\n\n");
                stringBuilder.append(this.stringMessages.races());
                stringBuilder.append("\n");
                for (Map.Entry e : existingRegattasWithMatchingBoatClassPerRace.entrySet()) {
                    stringBuilder.append(((RaceRecordDTO)e.getKey()).getName());
                    stringBuilder.append(" (");
                    stringBuilder.append(((RaceRecordDTO)e.getKey()).getBoatClassNames());
                    stringBuilder.append("): ");
                    stringBuilder.append(e.getValue());
                    stringBuilder.append("\n");
                }
                result = Window.confirm((String)stringBuilder.toString());
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean checkBoatClassMatch(Iterable<String> boatClassNames, RegattaDTO selectedRegatta) {
        HashSet<BoatClassMasterdata> boatClassNamesMappedToMasterData = new HashSet<BoatClassMasterdata>();
        for (String boatClassName : boatClassNames) {
            boatClassNamesMappedToMasterData.add(BoatClassMasterdata.resolveBoatClass((String)boatClassName));
        }
        return boatClassNamesMappedToMasterData.contains(BoatClassMasterdata.resolveBoatClass((String)selectedRegatta.boatClass.getName()));
    }
}

