/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.searchresult;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.search.SearchResultDTO;
import com.sap.sailing.gwt.home.shared.app.AbstractPlaceNavigator;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import java.util.Collection;

public abstract class AbstractSearchResult
extends Composite {
    private int resultsCount = 0;

    protected final void init(AbstractPlaceNavigator navigator, Widget widget) {
        super.initWidget(widget);
        this.getSearchTextInputUi().getElement().setAttribute("placeholder", StringMessages.INSTANCE.searchResultHeaderPlaceholder());
        this.getSearchTextInputUi().addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.getSearchButtonUi().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void search(AbstractPlaceNavigator navigator) {
        navigator.getSearchResultNavigation(this.getSearchTextInputUi().getValue()).goToPlace();
    }

    public void setSearchText(String searchText) {
        this.getSearchTextInputUi().setValue((Object)searchText);
    }

    public void updateSearchResult(String searchText, Collection<SearchResultDTO> searchResultItems) {
        for (SearchResultDTO searchResult : searchResultItems) {
            this.addSearchResultItem(searchResult);
            ++this.resultsCount;
        }
        this.getSearchResultAmountUi().setInnerText(StringMessages.INSTANCE.resultsFoundForSearch(this.resultsCount, searchText));
    }

    public void setBusy(boolean busy) {
        this.getBusyIndicatorUi().setBusy(busy);
    }

    protected void onLoad() {
        super.onLoad();
        if (this.getSearchTextInputUi().getValue().isEmpty()) {
            this.getSearchTextInputUi().setFocus(true);
        }
    }

    protected abstract TextBox getSearchTextInputUi();

    protected abstract Button getSearchButtonUi();

    protected abstract Element getSearchResultAmountUi();

    protected abstract HasWidgets getSearchResultContainerUi();

    protected abstract void addSearchResultItem(SearchResultDTO var1);

    protected abstract BusyIndicator getBusyIndicatorUi();

    static /* synthetic */ void access$0(AbstractSearchResult abstractSearchResult, AbstractPlaceNavigator abstractPlaceNavigator) {
        abstractSearchResult.search(abstractPlaceNavigator);
    }
}

