/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.updatesBox;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.BoatClassImageResolver;
import com.sap.sailing.gwt.home.communication.event.news.NewsEntryDTO;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.NewsItemLinkProvider;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBoxItem;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBoxResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.util.ConditionalDateTimeFormatter;
import java.util.Date;

public class UpdatesBoxItem
extends Widget {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    AnchorElement link;
    @UiField
    DivElement icon;
    @UiField
    SpanElement titleUi;
    @UiField
    DivElement messageUi;
    @UiField
    DivElement timestampUi;

    public UpdatesBoxItem(NewsEntryDTO entry, Date currentTimestamp, NewsItemLinkProvider provider) {
        Date newsTimestamp;
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.titleUi.setInnerText(entry.getTitle());
        this.messageUi.setInnerText(entry.getMessage());
        String boatClass = entry.getBoatClass();
        if (boatClass != null && !boatClass.isEmpty()) {
            this.icon.getStyle().setBackgroundImage("url(\"" + BoatClassImageResolver.getBoatClassIconResource((String)boatClass).getSafeUri().asString() + "\")");
        }
        if ((newsTimestamp = entry.getTimestamp()) == null || currentTimestamp == null) {
            this.timestampUi.removeFromParent();
        } else {
            this.timestampUi.setInnerText(ConditionalDateTimeFormatter.format((Date)newsTimestamp, (Date)currentTimestamp, (StringMessages)StringMessages.INSTANCE));
            if (currentTimestamp.getTime() - 600000L < newsTimestamp.getTime()) {
                this.timestampUi.addClassName(UpdatesBoxResources.INSTANCE.css().updatesbox_item_live());
            }
        }
        String directLink = entry.getExternalURL();
        if (directLink != null) {
            this.link.setHref(directLink);
            this.link.setTarget("_blank");
        } else {
            PlaceNavigation placeNavigation = provider.getNewsEntryPlaceNavigation(entry);
            if (placeNavigation != null) {
                placeNavigation.configureAnchorElement(this.link);
            } else {
                this.link.removeFromParent();
                while (this.link.hasChildNodes()) {
                    Node firstChild = this.link.getChild(0);
                    firstChild.removeFromParent();
                    this.getElement().appendChild(firstChild);
                }
                this.addStyleName(UpdatesBoxResources.INSTANCE.css().updatesbox_item());
            }
        }
    }
}

