/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats.RaceEndWithBoatsView;
import com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats.RaceEndWithBoatsViewImpl;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.leaderboard.PreLiveRaceLeaderboardWithImageViewImpl;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.client.ImageOnFlowPanelHelper;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.panels.ResizableFlowPanel;

public class RaceEndWithBoatsViewImpl
extends ResizeComposite
implements RaceEndWithBoatsView {
    private static RaceEndWithBoatsViewImplUiBinder uiBinder = (RaceEndWithBoatsViewImplUiBinder)GWT.create(RaceEndWithBoatsViewImplUiBinder.class);
    @UiField
    ResizableFlowPanel leaderBoardHolder;
    @UiField
    ResizableFlowPanel infoHolder;
    @UiField
    FlowPanel image1;
    @UiField
    FlowPanel image2;
    @UiField
    FlowPanel image3;
    @UiField
    Label subline1;
    @UiField
    Label subline2;
    @UiField
    Label subline3;
    @UiField
    Label statisticValue1;
    @UiField
    Label statisticProperty1;
    @UiField
    Label statisticValue2;
    @UiField
    Label statisticProperty2;
    @UiField
    Label statisticValue3;
    @UiField
    Label statisticProperty3;
    @UiField(provided=true)
    MediaMenuIcon takedownButtonImage1;
    @UiField(provided=true)
    MediaMenuIcon takedownButtonImage2;
    @UiField(provided=true)
    MediaMenuIcon takedownButtonImage3;
    private NumberFormat compactFormat = NumberFormat.getFormat((String)"#.0");
    private PreLiveRaceLeaderboardWithImageViewImpl.ImageProvider provider;

    public RaceEndWithBoatsViewImpl(PreLiveRaceLeaderboardWithImageViewImpl.ImageProvider provider, TakedownNoticeService takedownNoticeService) {
        this.takedownButtonImage1 = new MediaMenuIcon(takedownNoticeService, provider.getTakedownNoticeContextKey());
        this.takedownButtonImage2 = new MediaMenuIcon(takedownNoticeService, provider.getTakedownNoticeContextKey());
        this.takedownButtonImage3 = new MediaMenuIcon(takedownNoticeService, provider.getTakedownNoticeContextKey());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.provider = provider;
    }

    public void startingWith(RaceEndWithBoatsView.NextRaceWithBoatsPresenter p, AcceptsOneWidget panel) {
        panel.setWidget((IsWidget)this);
    }

    public void setLeaderBoard(SingleRaceLeaderboardPanel leaderboardPanel) {
        this.leaderBoardHolder.add((Widget)leaderboardPanel);
    }

    private void setCompetitor(int position, Label subline, FlowPanel image, MediaMenuIcon takedownButton, CompetitorDTO c) {
        subline.setText(position + ". " + c.getName());
        String imageUrl = this.provider.getImageUrl(c);
        ImageOnFlowPanelHelper.setImage((FlowPanel)image, (String)this.provider.getImageUrl(c));
        takedownButton.setData(c.getName(), imageUrl);
    }

    public void setFirst(CompetitorDTO c) {
        this.setCompetitor(1, this.subline1, this.image1, this.takedownButtonImage1, c);
    }

    public void setSecond(CompetitorDTO c) {
        this.setCompetitor(2, this.subline2, this.image2, this.takedownButtonImage2, c);
    }

    public void setThird(CompetitorDTO c) {
        this.setCompetitor(3, this.subline3, this.image3, this.takedownButtonImage3, c);
    }

    public void setStatistic(int competitorCount, Distance distance, Duration duration) {
        this.statisticProperty1.setText(StringMessages.INSTANCE.competitors());
        this.statisticValue1.setText(String.valueOf(competitorCount));
        this.statisticProperty2.setText(StringMessages.INSTANCE.distance());
        if (distance == null) {
            this.statisticValue2.setText(StringMessages.INSTANCE.noDataFound());
        } else {
            this.statisticValue2.setText(String.valueOf(this.compactFormat.format(distance.getNauticalMiles())) + " " + StringMessages.INSTANCE.nauticalMiles());
        }
        this.statisticProperty3.setText(StringMessages.INSTANCE.durationPlain());
        this.statisticValue3.setText(String.valueOf(this.compactFormat.format(duration.asMinutes())) + " " + StringMessages.INSTANCE.minutes());
    }
}

