/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VLWSentence;

class VLWParser
extends SentenceParser
implements VLWSentence {
    private static final int TOTAL = 0;
    private static final int TOTAL_UNITS = 1;
    private static final int TRIP = 2;
    private static final int TRIP_UNITS = 3;

    public VLWParser(String nmea) {
        super(nmea);
    }

    public VLWParser(TalkerId talker) {
        super(talker, "VLW", 4);
    }

    @Override
    public double getTotal() {
        return this.getDoubleValue(0);
    }

    @Override
    public char getTotalUnits() {
        return this.getCharValue(1);
    }

    @Override
    public double getTrip() {
        return this.getDoubleValue(2);
    }

    @Override
    public char getTripUnits() {
        return this.getCharValue(3);
    }

    @Override
    public void setTotal(double distance) {
        this.setDoubleValue(0, distance, 1, 1);
    }

    @Override
    public void setTotalUnits(char unit) {
        this.setUnit(1, unit);
    }

    @Override
    public void setTrip(double distance) {
        this.setDoubleValue(2, distance, 1, 1);
    }

    @Override
    public void setTripUnits(char unit) {
        this.setUnit(3, unit);
    }

    private void setUnit(int index, char unit) {
        if (unit != 'K' && unit != 'N') {
            throw new IllegalArgumentException("Invalid distance unit, expected 'N' or 'K'");
        }
        this.setCharValue(index, unit);
    }
}

