/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import org.moxieapps.gwt.highcharts.client.Configurable;

public class Color
extends Configurable<Color> {
    private JSONValue value;
    private JSONArray colorStops = new JSONArray();

    public Color() {
    }

    public Color(String rgbHexColor) {
        this.value = new JSONString(rgbHexColor);
    }

    public Color(int r, int g, int b) {
        this.value = new JSONString(this.createRGB(r, g, b));
    }

    public Color(int r, int g, int b, double a) {
        this.value = new JSONString(this.createRGBA(r, g, b, a));
    }

    public Color setLinearGradient(String x1, String x2, String y1, String y2) {
        this.value = null;
        return (Color)this.setOption("linearGradient", new LinearGradient(x1, x2, y1, y2));
    }

    public Color setLinearGradient(int x1, int x2, int y1, int y2) {
        this.value = null;
        return (Color)this.setOption("linearGradient", new LinearGradient(x1, x2, y1, y2));
    }

    public Color setLinearGradient(double x1, double x2, double y1, double y2) {
        this.value = null;
        return (Color)this.setOption("linearGradient", new LinearGradient(x1, x2, y1, y2));
    }

    public Color addColorStop(double offset, String rgbHexColor) {
        return this.internalAddColorStop(offset, rgbHexColor);
    }

    public Color addColorStop(double offset, int r, int g, int b) {
        return this.internalAddColorStop(offset, this.createRGB(r, g, b));
    }

    public Color addColorStop(double offset, int r, int g, int b, double a) {
        return this.internalAddColorStop(offset, this.createRGBA(r, g, b, a));
    }

    public JSONValue getOptionValue() {
        return this.value != null ? this.value : this.getOptions();
    }

    private Color internalAddColorStop(double offset, String color) {
        this.value = null;
        JSONArray colorStop = new JSONArray();
        colorStop.set(0, (JSONValue)new JSONNumber(offset));
        colorStop.set(1, (JSONValue)new JSONString(color));
        this.colorStops.set(this.colorStops.size(), (JSONValue)colorStop);
        return (Color)this.setOption("stops", this.colorStops);
    }

    private String createRGB(int r, int g, int b) {
        return "rgb(" + r + "," + g + "," + b + ")";
    }

    private String createRGBA(int r, int g, int b, double a) {
        return "rgba(" + r + "," + g + "," + b + "," + a + ")";
    }

    private class LinearGradient
    extends Configurable<LinearGradient> {
        private LinearGradient() {
        }

        private LinearGradient(String x1, String x2, String y1, String y2) {
            ((LinearGradient)((LinearGradient)((LinearGradient)this.setOption("x1", x1)).setOption("x2", x2)).setOption("y1", y1)).setOption("y2", y2);
        }

        private LinearGradient(int x1, int x2, int y1, int y2) {
            ((LinearGradient)((LinearGradient)((LinearGradient)this.setOption("x1", new JSONNumber((double)x1))).setOption("x2", new JSONNumber((double)x2))).setOption("y1", new JSONNumber((double)y1))).setOption("y2", new JSONNumber((double)y2));
        }

        private LinearGradient(double x1, double x2, double y1, double y2) {
            ((LinearGradient)((LinearGradient)((LinearGradient)this.setOption("x1", new JSONString(String.valueOf(Double.valueOf(x1 * 100.0).intValue()) + "%"))).setOption("x2", new JSONString(String.valueOf(Double.valueOf(x2 * 100.0).intValue()) + "%"))).setOption("y1", new JSONString(String.valueOf(Double.valueOf(y1 * 100.0).intValue()) + "%"))).setOption("y2", new JSONString(String.valueOf(Double.valueOf(y2 * 100.0).intValue()) + "%"));
        }
    }
}

