/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.shared.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.model.lib.api.route.IControlRoute;
import com.tractrac.model.lib.api.route.IPathRoute;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.control.IControlRouteChangeListener;
import difflib.PatchFailedException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RaceCourseReceiver
extends AbstractReceiverWithQueue<IControlRoute, Long, Void> {
    private static final Logger logger = Logger.getLogger(RaceCourseReceiver.class.getName());
    private final long millisecondsOverWhichToAverageWind;
    private final long delayToLiveInMillis;
    private final WindStore windStore;
    private final DynamicRaceDefinitionSet raceDefinitionSetToUpdate;
    private final URI tracTracUpdateURI;
    private final String tracTracUsername;
    private final String tracTracPassword;
    private final IRace tractracRace;
    private final IControlRouteChangeListener listener;
    private final boolean useInternalMarkPassingAlgorithm;
    private final RaceLogAndTrackedRaceResolver raceLogResolver;
    private final MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry;
    private final LeaderboardGroupResolver leaderboardGroupResolver;
    private final RaceTrackingHandler raceTrackingHandler;

    public RaceCourseReceiver(DomainFactory domainFactory, DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, IRace tractracRace, WindStore windStore, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, Simulator simulator, URI updateURI, String tracTracUsername, String tracTracPassword, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, boolean useInternalMarkPassingAlgorithm, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
        this.tractracRace = tractracRace;
        this.raceLogResolver = raceLogResolver;
        this.markPassingRaceFingerprintRegistry = markPassingRaceFingerprintRegistry;
        this.leaderboardGroupResolver = leaderboardGroupResolver;
        this.millisecondsOverWhichToAverageWind = millisecondsOverWhichToAverageWind;
        this.delayToLiveInMillis = delayToLiveInMillis;
        this.raceTrackingHandler = raceTrackingHandler;
        this.windStore = simulator == null ? windStore : simulator.simulatingWindStore(windStore);
        this.raceDefinitionSetToUpdate = raceDefinitionSetToUpdate;
        this.tracTracUpdateURI = updateURI;
        this.tracTracUsername = tracTracUsername;
        this.tracTracPassword = tracTracPassword;
        this.useInternalMarkPassingAlgorithm = useInternalMarkPassingAlgorithm;
        this.listener = new IControlRouteChangeListener(){

            public void gotRouteChange(IControlRoute controlRoute, long timeStamp) {
                RaceCourseReceiver.this.enqueue(new Util.Triple((Object)controlRoute, (Object)timeStamp, null));
            }

            public void gotRouteChange(IPathRoute pathRoute, long timeStamp) {
            }
        };
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribeRouteChanges(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribeRouteChanges(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IControlRoute, Long, Void> event) {
        System.out.print("R");
        this.ensureAllSingleMarksOfCourseAreaAreCreated(this.tractracRace);
        IControlRoute route = (IControlRoute)event.getA();
        String routeMetadataString = route.getMetadata() != null ? route.getMetadata().getText() : null;
        List routeControlPoints = route.getControls();
        Map<Integer, PassingInstruction> courseWaypointPassingInstructions = this.getDomainFactory().getMetadataParser().parsePassingInstructionData(routeMetadataString, routeControlPoints.size());
        ArrayList<Util.Pair<IMapItem, PassingInstruction>> ttControlPoints = new ArrayList<Util.Pair<IMapItem, PassingInstruction>>();
        int i = 0;
        for (IMapItem cp : routeControlPoints) {
            PassingInstruction passingInstructions = courseWaypointPassingInstructions.containsKey(i) ? courseWaypointPassingInstructions.get(i) : PassingInstruction.None;
            ttControlPoints.add((Util.Pair<IMapItem, PassingInstruction>)new Util.Pair((Object)cp, (Object)passingInstructions));
            ++i;
        }
        Course course = this.getDomainFactory().createCourse(route.getName(), ttControlPoints);
        List<Sideline> sidelines = this.getDomainFactory().createSidelines(this.tractracRace.getMetadata() != null ? this.tractracRace.getMetadata().getText() : null, this.tractracRace.getEvent().getMapItems());
        RaceDefinition existingRaceDefinitionForRace = this.getDomainFactory().getExistingRaceDefinitionForRace(this.tractracRace.getId());
        DynamicTrackedRace trackedRace = null;
        if (existingRaceDefinitionForRace != null) {
            logger.log(Level.INFO, "Received course update for existing race " + this.tractracRace.getName() + ": " + ((IControlRoute)event.getA()).getControls());
            try {
                this.getDomainFactory().updateCourseWaypoints(existingRaceDefinitionForRace.getCourse(), ttControlPoints);
                if (this.getTrackedRegatta().getExistingTrackedRace(existingRaceDefinitionForRace) == null) {
                    trackedRace = this.createTrackedRace(existingRaceDefinitionForRace, sidelines, tr -> this.updateRaceTimes(this.tractracRace, (DynamicTrackedRace)tr));
                    this.addAllMarksFromCourseArea(trackedRace);
                }
            }
            catch (PatchFailedException e) {
                logger.log(Level.SEVERE, "Internal error updating race course " + course + ": " + e.getMessage());
                logger.log(Level.SEVERE, "handleEvent", e);
            }
        } else {
            logger.log(Level.INFO, "Received course for non-existing race " + this.tractracRace.getName() + ". Creating RaceDefinition.");
            BoatClass dominantBoatClass = this.getDomainFactory().resolveDominantBoatClassOfRace(this.tractracRace);
            Map<Competitor, Boat> competitorAndBoats = this.getDomainFactory().getOrCreateCompetitorsAndTheirBoats(this.getTrackedRegatta(), this.leaderboardGroupResolver, this.tractracRace, dominantBoatClass, this.raceTrackingHandler);
            trackedRace = this.getDomainFactory().getOrCreateRaceDefinitionAndTrackedRace(this.getTrackedRegatta(), this.tractracRace.getId(), this.tractracRace.getName(), this.getTrackedRegatta().getRegatta().getBoatClass(), competitorAndBoats, course, sidelines, this.windStore, this.delayToLiveInMillis, this.millisecondsOverWhichToAverageWind, this.raceDefinitionSetToUpdate, this.tracTracUpdateURI, this.getTracTracEvent().getId(), this.tracTracUsername, this.tracTracPassword, this.useInternalMarkPassingAlgorithm, this.raceLogResolver, tr -> this.updateRaceTimes(this.tractracRace, (DynamicTrackedRace)tr), this.tractracRace, this.raceTrackingHandler, this.markPassingRaceFingerprintRegistry);
            this.addAllMarksFromCourseArea(trackedRace);
            if (this.getSimulator() != null) {
                this.getSimulator().setTrackedRace(trackedRace);
            }
        }
    }

    private void addAllMarksFromCourseArea(DynamicTrackedRace trackedRace) {
        for (IMapItem tractracControlPoint : this.getDomainFactory().getControlsForCourseArea(this.getTracTracEvent(), this.tractracRace.getCourseArea())) {
            ControlPoint cp = this.getDomainFactory().getOrCreateControlPoint(tractracControlPoint);
            for (Mark mark : cp.getMarks()) {
                trackedRace.getOrCreateTrack(mark);
            }
        }
    }

    private void updateRaceTimes(IRace tractracRace, DynamicTrackedRace trackedRace) {
        long tractracEndTrackingTime;
        long tractracStartTrackingTime;
        long tractracRaceStartTime;
        int liveDelayInSeconds = tractracRace.getLiveDelay();
        long delayInMillis = liveDelayInSeconds * 1000;
        if (trackedRace != null) {
            logger.info("Setting delay for race " + trackedRace.getRace().getName() + " to " + delayInMillis + "ms");
            trackedRace.setDelayToLiveInMillis(delayInMillis);
        }
        Object startTime = (tractracRaceStartTime = tractracRace.getRaceStartTime()) != 0L ? (this.getSimulator() != null ? this.getSimulator().advanceStartTime((TimePoint)new MillisecondsTimePoint(tractracRaceStartTime)) : new MillisecondsTimePoint(tractracRaceStartTime)) : null;
        if (trackedRace != null && startTime != null) {
            trackedRace.setStartTimeReceived((TimePoint)startTime);
        }
        Object startTrackingTime = (tractracStartTrackingTime = tractracRace.getTrackingStartTime()) != 0L ? (this.getSimulator() != null ? this.getSimulator().advanceStartTime((TimePoint)new MillisecondsTimePoint(tractracStartTrackingTime)) : new MillisecondsTimePoint(tractracStartTrackingTime)) : null;
        if (trackedRace != null && startTrackingTime != null) {
            trackedRace.setStartOfTrackingReceived((TimePoint)startTrackingTime);
        }
        Object endTrackingTime = (tractracEndTrackingTime = tractracRace.getTrackingEndTime()) != 0L ? (this.getSimulator() != null ? this.getSimulator().advanceStartTime((TimePoint)new MillisecondsTimePoint(tractracEndTrackingTime)) : new MillisecondsTimePoint(tractracEndTrackingTime)) : null;
        if (trackedRace != null && endTrackingTime != null) {
            trackedRace.setEndOfTrackingReceived((TimePoint)endTrackingTime);
        }
    }

    private DynamicTrackedRace createTrackedRace(RaceDefinition race, Iterable<Sideline> sidelines, Consumer<DynamicTrackedRace> runAfterCreatingTrackedRace) {
        URL webUrl = this.tractracRace.getEvent().getWebURL();
        String webUrlString = webUrl == null ? null : webUrl.toString();
        DynamicTrackedRace trackedRace = this.raceTrackingHandler.createTrackedRace((TrackedRegatta)this.getTrackedRegatta(), race, sidelines, this.windStore, this.delayToLiveInMillis, this.millisecondsOverWhichToAverageWind, race.getBoatClass().getApproximateManeuverDurationInMilliseconds(), this.raceDefinitionSetToUpdate, this.useInternalMarkPassingAlgorithm, this.raceLogResolver, Optional.empty(), (TrackingConnectorInfo)new TrackingConnectorInfoImpl("TracTrac", "https://www.tractrac.com/", webUrlString), this.markPassingRaceFingerprintRegistry);
        if (runAfterCreatingTrackedRace != null) {
            runAfterCreatingTrackedRace.accept(trackedRace);
        }
        this.getDomainFactory().addTracTracUpdateHandlers(this.tracTracUpdateURI, this.getTracTracEvent().getId(), this.tracTracUsername, this.tracTracPassword, race, trackedRace, this.tractracRace);
        return trackedRace;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", race " + this.tractracRace.getName() + " with ID " + this.tractracRace.getId();
    }
}

