/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.management.DataMiningQueryManager;
import com.sap.sse.datamining.components.management.MemoryInfoProvider;
import com.sap.sse.datamining.components.management.MemoryMonitor;
import com.sap.sse.datamining.components.management.MemoryMonitorAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryManagerMemoryMonitor
implements MemoryMonitor {
    private static final String MEMORY_STATUS_LOG_PREFIX = "Memory Status: ";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final MemoryInfoProvider infoProvider;
    private final DataMiningQueryManager queryManager;
    private final List<MemoryMonitorAction> actions;
    private final Timer timer;
    private TimerTask timerTask;
    private final long periodInMs;
    private boolean isPaused;

    public QueryManagerMemoryMonitor(MemoryInfoProvider infoProvider, DataMiningQueryManager queryManager, Iterable<? extends MemoryMonitorAction> actions, long memoryCheckPeriod, TimeUnit unit) {
        this.infoProvider = infoProvider;
        this.queryManager = queryManager;
        this.actions = new ArrayList<MemoryMonitorAction>();
        Util.addAll(actions, this.actions);
        Collections.sort(this.actions);
        this.isPaused = false;
        this.periodInMs = unit.toMillis(memoryCheckPeriod);
        this.timer = new Timer(String.valueOf(this.getClass().getSimpleName()) + " Daemon", true);
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, 0L, this.periodInMs);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                QueryManagerMemoryMonitor.this.checkMemory();
            }
        };
    }

    private void checkMemory() {
        long freeMemoryInBytes = this.infoProvider.freeMemory();
        long totalMemoryInBytes = this.infoProvider.totalMemory();
        double freeMemoryRatio = (double)freeMemoryInBytes / (double)totalMemoryInBytes;
        int numberOfRunningQueries = this.queryManager.getNumberOfRunningQueries();
        if (numberOfRunningQueries > 0) {
            this.logStatus(freeMemoryInBytes, totalMemoryInBytes, freeMemoryRatio, numberOfRunningQueries);
        }
        boolean actionHasBeenPerformed = false;
        Iterator<MemoryMonitorAction> actionsIterator = this.actions.iterator();
        block0: while (!actionHasBeenPerformed && actionsIterator.hasNext()) {
            MemoryMonitorAction action = actionsIterator.next();
            actionHasBeenPerformed = action.checkMemoryAndPerformAction(freeMemoryRatio, freeMemoryInBytes);
            if (!actionHasBeenPerformed) continue;
            while (actionsIterator.hasNext()) {
                MemoryMonitorAction nextAction = actionsIterator.next();
                if (action.compareTo(nextAction) != 0) continue block0;
                nextAction.checkMemoryAndPerformAction(freeMemoryRatio, freeMemoryInBytes);
            }
        }
    }

    private void logStatus(long freeMemory, long totalMemory, double freeMemoryRatio, int numberOfRunningQueries) {
        double freeMemoryMB = (double)freeMemory / 1024.0 / 1024.0;
        double totalMemoryMB = (double)totalMemory / 1024.0 / 1024.0;
        this.logInfo("Memory Status: Free " + String.format("%1$,.2f", freeMemoryMB) + " MB, Total " + String.format("%1$,.2f", totalMemoryMB) + " MB, Free in Percent " + String.format("%1$,.2f", freeMemoryRatio * 100.0) + "% with " + numberOfRunningQueries + " queries running.");
    }

    @Override
    public void log(Level level, String message) {
        this.logger.log(level, message);
    }

    @Override
    public void logInfo(String message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void logWarning(String message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void logSevere(String message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public void pause() {
        if (!this.isPaused) {
            this.isPaused = true;
            this.timerTask.cancel();
        }
    }

    @Override
    public void unpause() {
        if (this.isPaused) {
            this.isPaused = false;
            this.timerTask = this.createTimerTask();
            this.timer.schedule(this.timerTask, 0L, this.periodInMs);
        }
    }
}

