/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.util.impl.HasTracingGet;
import com.sap.sse.util.impl.HasTracingGetImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class FutureTaskWithTracingGet<V>
extends FutureTask<V> {
    private final HasTracingGet<V> hasTracingGet;
    private final String traceInfo;

    public FutureTaskWithTracingGet(String traceInfo, Callable<V> callable) {
        super(callable);
        this.traceInfo = traceInfo;
        this.hasTracingGet = this.createHasTracingGet();
    }

    public FutureTaskWithTracingGet(String traceInfo, Runnable runnable, V result) {
        super(runnable, result);
        this.traceInfo = traceInfo;
        this.hasTracingGet = this.createHasTracingGet();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.hasTracingGet.callGetAndTraceAfterEachTimeout(this);
    }

    private HasTracingGet<V> createHasTracingGet() {
        return new HasTracingGetImpl<V>(){

            @Override
            protected String getAdditionalTraceInfo() {
                return FutureTaskWithTracingGet.this.traceInfo;
            }
        };
    }
}

