/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QRCodeGenerationUtil {
    public static InputStream create(String text, int sizeInPixels) throws Exception {
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        return QRCodeGenerationUtil.create(text, sizeInPixels, hintMap);
    }

    public static InputStream create(String text, int sizeInPixels, String errorCorrectionLevel) throws Exception {
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.valueOf((String)errorCorrectionLevel));
        return QRCodeGenerationUtil.create(text, sizeInPixels, hintMap);
    }

    public static InputStream create(String text, int sizeInPixels, Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, sizeInPixels, sizeInPixels, hintMap);
        int matrixSize = byteMatrix.getWidth();
        BufferedImage image = new BufferedImage(matrixSize, matrixSize, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, matrixSize, matrixSize);
        graphics.setColor(Color.BLACK);
        int i = 0;
        while (i < matrixSize) {
            int j = 0;
            while (j < matrixSize) {
                if (byteMatrix.get(i, j)) {
                    graphics.fillRect(i, j, 1, 1);
                }
                ++j;
            }
            ++i;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "gif", os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return is;
    }
}

