/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.trackfiles.TrackFilesDataSource;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.TrackFileExporter;
import com.sap.sailing.server.trackfiles.impl.WriteRaceDataCallable;
import com.sap.sailing.server.trackfiles.impl.WriteZipCallback;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TrackFileExporterImpl
implements TrackFileExporter {
    private static final Logger log = Logger.getLogger(TrackFileExporterImpl.class.toString());

    @Override
    public void writeAllData(List<TrackFilesDataSource> data, TrackFilesFormat format, List<TrackedRace> races, boolean dataBeforeAfter, boolean rawFixes, final ZipOutputStream out) throws IOException {
        WriteZipCallback callback = new WriteZipCallback(){

            @Override
            public synchronized void write(ZipEntry entry, byte[] data) throws IOException {
                out.putNextEntry(entry);
                out.write(data);
                out.closeEntry();
            }
        };
        ArrayList<WriteRaceDataCallable> callables = new ArrayList<WriteRaceDataCallable>();
        ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
        ArrayList errors = new ArrayList();
        for (TrackedRace race : races) {
            for (TrackFilesDataSource d : data) {
                WriteRaceDataCallable callable = new WriteRaceDataCallable(race, d, format, dataBeforeAfter, rawFixes, callback);
                callables.add(callable);
            }
        }
        ThreadPoolUtil.INSTANCE.invokeAllAndLogExceptions((ExecutorService)executor, Level.WARNING, "Error exporting race: %s", callables);
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String error : errors) {
                sb.append(error);
                sb.append("\n");
            }
            try {
                callback.write(new ZipEntry("ERRORS"), sb.toString().getBytes());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error exporting race: " + e.getMessage());
            }
        }
    }
}

