/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.RectangularGrid;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.LinkedList;

public class PathGenerator1TurnerLeftDirect
extends PathGeneratorBase {
    public PathGenerator1TurnerLeftDirect(SimulationParameters params) {
        this.parameters = params;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        RectangularGrid boundary = new RectangularGrid(this.parameters.getCourse().get(0), this.parameters.getCourse().get(1));
        WindFieldGenerator windField = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        Position start = this.parameters.getCourse().get(0);
        Position end = this.parameters.getCourse().get(1);
        TimePoint startTime = windField.getStartTime();
        Distance courseLength = start.getDistance(end);
        LinkedList<TimedPositionWithSpeedImpl> lst = null;
        Long timeResolution = 120000L;
        boolean turned = true;
        Long minTurn = Long.MAX_VALUE;
        int turningStep = 0;
        block0: while (turned) {
            LinkedList<TimedPositionWithSpeedImpl> tempLst = new LinkedList<TimedPositionWithSpeedImpl>();
            Position currentPosition = start;
            TimePoint currentTime = startTime;
            turned = false;
            ++turningStep;
            int currentStep = 0;
            do {
                Wind currWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currWind);
                MillisecondsTimePoint nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeResolution);
                tempLst.add(new TimedPositionWithSpeedImpl(currentTime, currentPosition, (SpeedWithBearing)currWind));
                if (currentStep >= turningStep) {
                    turned = true;
                    nextTime = new MillisecondsTimePoint(nextTime.asMillis() + polarDiagram.getTurnLoss());
                }
                if (!turned) {
                    Bearing direction = polarDiagram.optimalDirectionsUpwind()[0];
                    SpeedWithBearing currSpeed = polarDiagram.getSpeedAtBearing(direction);
                    currentPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                }
                if (turned) {
                    Bearing direction1 = currentPosition.getBearingGreatCircle(end);
                    Bearing direction2 = polarDiagram.optimalDirectionsUpwind()[1];
                    SpeedWithBearing currSpeed1 = polarDiagram.getSpeedAtBearing(direction1);
                    SpeedWithBearing currSpeed2 = polarDiagram.getSpeedAtBearing(direction2);
                    Position nextPosition1 = currSpeed1.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                    Position nextPosition2 = currSpeed2.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                    currentPosition = nextPosition1.getDistance(end).compareTo((Object)nextPosition2.getDistance(end)) < 0 && Math.abs(direction1.getDifferenceTo(direction2).getDegrees()) < 45.0 ? nextPosition1 : nextPosition2;
                }
                ++currentStep;
                currentTime = nextTime;
                if (currentTime.asMillis() > minTurn || !boundary.inBounds(currentPosition) || this.isTimedOut()) continue block0;
            } while (currentPosition.getDistance(end).compareTo((Object)courseLength.scale(0.005)) >= 0);
            minTurn = currentTime.asMillis();
            lst = new LinkedList<TimedPositionWithSpeedImpl>(tempLst);
            Bearing directionToEnd = currentPosition.getBearingGreatCircle(end);
            Wind crtWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
            polarDiagram.setWind((SpeedWithBearing)crtWind);
            SpeedWithBearing speedToEnd = polarDiagram.getSpeedAtBearing(directionToEnd);
            Distance distanceToEnd = currentPosition.getDistance(end);
            Long timeToEnd = (long)(1000.0 * distanceToEnd.getMeters() / speedToEnd.getMetersPerSecond());
            MillisecondsTimePoint endTime = new MillisecondsTimePoint(currentTime.asMillis() + timeToEnd);
            lst.addLast(new TimedPositionWithSpeedImpl((TimePoint)endTime, end, (SpeedWithBearing)crtWind));
        }
        if (lst != null) {
            return new PathImpl(lst, windField, this.algorithmTimedOut);
        }
        return null;
    }
}

