/*
 * Decompiled with CFR 0.152.
 */
package com.tractrac.subscription.app.tracapi;

import com.tractrac.model.lib.api.ModelLocator;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IEventFactory;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.subscription.app.tracapi.AbstractListener;
import com.tractrac.subscription.app.tracapi.DelayListener;
import com.tractrac.subscription.app.tracapi.EventListener;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.ISubscriberFactory;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.subscription.lib.api.SubscriptionLocator;
import com.tractrac.subscription.lib.api.competitor.ICompetitorsListener;
import com.tractrac.subscription.lib.api.competitor.IPositionListener;
import com.tractrac.subscription.lib.api.control.IControlPassingsListener;
import com.tractrac.subscription.lib.api.control.IControlRouteChangeListener;
import com.tractrac.subscription.lib.api.event.IConnectionStatusListener;
import com.tractrac.subscription.lib.api.event.IEventMessageListener;
import com.tractrac.subscription.lib.api.map.IMapItemsListener;
import com.tractrac.subscription.lib.api.race.IRaceCompetitorListener;
import com.tractrac.subscription.lib.api.race.IRaceStartStopTimesChangeListener;
import com.tractrac.subscription.lib.api.race.IRacesListener;
import com.tractrac.util.lib.api.autolog.LoggerLocator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class Main {
    public static void main(String[] args) throws IOException, SubscriberInitializationException, CreateModelException {
        LoggerLocator.getLoggerManager().init(1, new String[]{"println"});
        Object[] myArgs = Main.parseArguments(args);
        URI paramURI = (URI)myArgs[0];
        boolean measureDelay = (Boolean)myArgs[1];
        IEventFactory eventFactory = ModelLocator.getEventFactory();
        IRace race = eventFactory.createRace(paramURI);
        IEvent event = race.getEvent();
        event.getPositionedItems().forEach(positionedItem -> System.out.println(positionedItem.getMetadata().getText()));
        ISubscriberFactory subscriberFactory = SubscriptionLocator.getSusbcriberFactory();
        IEventSubscriber eventSubscriber = subscriberFactory.createEventSubscriber(event);
        AbstractListener listener = measureDelay ? new DelayListener() : new EventListener();
        eventSubscriber.subscribeConnectionStatus((IConnectionStatusListener)listener);
        eventSubscriber.subscribeEventMessages((IEventMessageListener)listener);
        eventSubscriber.subscribeRaces((IRacesListener)listener);
        eventSubscriber.subscribeMapItems((IMapItemsListener)listener);
        eventSubscriber.subscribeCompetitors((ICompetitorsListener)listener);
        IRaceSubscriber raceSubscriber = subscriberFactory.createRaceSubscriber(race);
        raceSubscriber.subscribeConnectionStatus((IConnectionStatusListener)listener);
        raceSubscriber.subscribePositions((IPositionListener)listener);
        raceSubscriber.subscribeControlPassings((IControlPassingsListener)listener);
        raceSubscriber.subscribeRaceTimesChanges((IRaceStartStopTimesChangeListener)listener);
        raceSubscriber.subscribeRouteChanges((IControlRouteChangeListener)listener);
        raceSubscriber.subscribeRaceCompetitor((IRaceCompetitorListener)listener);
        raceSubscriber.start();
        eventSubscriber.start();
        System.out.println("Press key to cancel live data stream");
        System.in.read();
        System.out.println("Cancelling data stream");
        eventSubscriber.stop();
        raceSubscriber.stop();
    }

    private static Object[] parseArguments(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -jar TracAPI.jar parametersfile measureDelay");
            System.exit(0);
        }
        Object[] myArgs = new Object[2];
        try {
            myArgs[0] = new URI(args[0]);
            myArgs[1] = args.length >= 2 && args[1].equals("1");
        }
        catch (URISyntaxException ex) {
            System.out.println("Malformed URL " + ex.getMessage());
            System.exit(0);
        }
        return myArgs;
    }
}

