/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Crew;
import com.sap.sailing.xrr.schema.CrewPosition;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.IFBoatStatus;
import com.sap.sailing.xrr.schema.Person;
import com.sap.sailing.xrr.schema.RaceResult;
import com.sap.sailing.xrr.schema.Team;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Logger;

public class RaceResultAsScoreCorrectionForCompetitorInRace
implements RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace {
    private final String sailID;
    private final Parser parser;
    private final RaceResult raceResult;
    private static final Logger logger = Logger.getLogger(RaceResultAsScoreCorrectionForCompetitorInRace.class.getName());

    public RaceResultAsScoreCorrectionForCompetitorInRace(Parser parser, Division division, Set<String> raceIDs, String sailID) {
        this.sailID = sailID;
        this.parser = parser;
        this.raceResult = this.determineRaceResult(division, raceIDs, sailID, parser);
    }

    public String getSailID() {
        return this.sailID;
    }

    private RaceResult determineRaceResult(Division division, Set<String> raceIDs, String sailID, Parser parser) {
        RaceResult result = null;
        for (Object o : division.getSeriesResultOrRaceResultOrTRResult()) {
            RaceResult raceResult;
            if (!(o instanceof RaceResult) || !raceIDs.contains((raceResult = (RaceResult)o).getRaceID())) continue;
            Team team = parser.getTeam(raceResult.getTeamID());
            if (team != null) {
                Boat boat = parser.getBoat(team.getBoatID());
                if (boat != null) {
                    String teamSailID = boat.getSailNumber();
                    if (!sailID.equals(teamSailID)) continue;
                    result = raceResult;
                    break;
                }
                logger.severe("Could not find a boat for ID " + team.getBoatID() + " for team with ID " + raceResult.getTeamID() + " for raceresult of race with ID " + raceResult.getRaceID());
                continue;
            }
            logger.severe("Could not find a team for ID " + raceResult.getTeamID() + " for raceresult of race with ID " + raceResult.getRaceID());
        }
        return result;
    }

    public String getCompetitorName() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        ArrayList sortedCrew = new ArrayList(this.parser.getTeam(this.raceResult.getTeamID()).getCrew());
        Collections.sort(sortedCrew, new Comparator<Crew>(){

            @Override
            public int compare(Crew o1, Crew o2) {
                if (o1.getPosition() == CrewPosition.S) {
                    return -1;
                }
                if (o2.getPosition() == CrewPosition.S) {
                    return 1;
                }
                return 0;
            }
        });
        for (Crew crew : sortedCrew) {
            if (first) {
                first = false;
            } else {
                result.append(" + ");
            }
            Person person = this.parser.getPerson(crew.getPersonID());
            result.append(person.getFamilyName());
            result.append(", ");
            result.append(person.getGivenName());
        }
        return result.toString();
    }

    public Double getPoints() {
        BigDecimal racePoints = this.raceResult.getRacePoints();
        return racePoints == null ? null : Double.valueOf(racePoints.doubleValue());
    }

    public MaxPointsReason getMaxPointsReason() {
        IFBoatStatus scoreCode = this.raceResult.getScoreCode();
        MaxPointsReason result = scoreCode == null ? MaxPointsReason.NONE : MaxPointsReason.valueOf((String)scoreCode.name());
        return result;
    }

    public Boolean isDiscarded() {
        return this.raceResult.isDiscard();
    }
}

