/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.aws.persistence.DomainObjectFactory;
import com.sap.sse.landscape.aws.persistence.impl.CollectionNames;
import com.sap.sse.landscape.aws.persistence.impl.FieldNames;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private final MongoDatabase db;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    @Override
    public Iterable<SSHKeyPair> loadSSHKeyPairs() {
        ArrayList<SSHKeyPair> result = new ArrayList<SSHKeyPair>();
        MongoCollection keyPairCollection = this.db.getCollection(CollectionNames.SSH_KEY_PAIRS.name());
        keyPairCollection.createIndex((Bson)new Document(FieldNames.SSH_KEY_PAIR_REGION_ID.name(), (Object)1));
        for (Object o : keyPairCollection.find()) {
            String regionId = (String)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_REGION_ID.name());
            String creatorName = (String)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_CREATOR_NAME.name());
            long creationDateMillis = ((Number)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_CREATION_DATE.name())).longValue();
            String name = (String)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_NAME.name());
            Binary privKey = (Binary)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_ENCRYPTED_PRIVATE_KEY.name());
            byte[] encryptedPrivateKey = privKey == null ? null : privKey.getData();
            Binary pubKey = (Binary)((Document)o).get((Object)FieldNames.SSH_KEY_PAIR_PUBLIC_KEY.name());
            byte[] publicKey = pubKey == null ? null : pubKey.getData();
            result.add(new SSHKeyPair(regionId, creatorName, TimePoint.of((long)creationDateMillis), name, publicKey, encryptedPrivateKey));
        }
        return result;
    }
}

