/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.usergroup.users;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.suggestion.AbstractListSuggestOracle;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class UserGroupSuggestOracle
extends AbstractListSuggestOracle<UserDTO> {
    private final Collection<UserDTO> allUsers = new ArrayList();
    private final UserManagementServiceAsync userManagementService;
    private final StringMessages stringMessages;

    public UserGroupSuggestOracle(UserManagementServiceAsync userManagementService, StringMessages stringMessages) {
        this.userManagementService = userManagementService;
        this.stringMessages = stringMessages;
        this.refresh();
    }

    public void refresh() {
        this.userManagementService.getUserList((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void resetAndRemoveExistingUsers(Iterable<String> existingUsers) {
        Collection users = new ArrayList(this.allUsers);
        users = users.stream().filter(u -> !Util.contains((Iterable)existingUsers, (Object)u.getName())).collect(Collectors.toList());
        super.setSelectableValues(users);
    }

    public UserDTO fromString(String userName) {
        if (this.getSelectableValues() == null) {
            throw new NullPointerException("Users are not loaded yet or could not be loaded.");
        }
        for (UserDTO user : this.getSelectableValues()) {
            if (!user.getName().equals(userName)) continue;
            return user;
        }
        return null;
    }

    protected String createSuggestionKeyString(UserDTO value) {
        return value.getName();
    }

    protected String createSuggestionAdditionalDisplayString(UserDTO value) {
        return null;
    }

    protected Iterable<String> getMatchingStrings(UserDTO value) {
        return this.getSelectableValues().stream().map(r -> this.createSuggestionKeyString(r)).collect(Collectors.toList());
    }

    static /* synthetic */ StringMessages access$3(UserGroupSuggestOracle userGroupSuggestOracle) {
        return userGroupSuggestOracle.stringMessages;
    }

    static /* synthetic */ Collection access$4(UserGroupSuggestOracle userGroupSuggestOracle) {
        return userGroupSuggestOracle.allUsers;
    }
}

