/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.CompetitorImpl;
import com.sap.sailing.domain.base.impl.CompetitorSerializationCustomizer;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import java.io.Serializable;
import java.net.URI;

public class CompetitorWithBoatImpl
extends CompetitorImpl
implements DynamicCompetitorWithBoat {
    private static final long serialVersionUID = 22679449208503264L;
    private DynamicBoat boat;

    public CompetitorWithBoatImpl(Serializable id, String name, String shortName, Color color, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat) {
        super(id, name, shortName, color, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag);
        this.boat = boat;
    }

    public CompetitorWithBoatImpl(Competitor competitor, DynamicBoat boat) {
        this(competitor.getId(), competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), competitor.getFlagImage(), (DynamicTeam)competitor.getTeam(), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag(), boat);
    }

    private Object writeReplace() {
        if (CompetitorSerializationCustomizer.getCurrentCustomizer().removalOfPersonalDataNecessary(this)) {
            return new CompetitorWithBoatImpl(this.getId(), this.getName(), this.getShortName(), this.getColor(), null, this.getFlagImage(), this.getTeam(), this.getTimeOnTimeFactor(), this.getTimeOnDistanceAllowancePerNauticalMile(), this.getSearchTag(), this.boat);
        }
        return this;
    }

    @Override
    public Competitor resolve(SharedDomainFactory<?> domainFactory) {
        Competitor result = !this.hasBoat() ? super.resolve(domainFactory) : domainFactory.getOrCreateCompetitorWithBoat(this.getId(), this.getName(), this.getShortName(), this.getColor(), this.getEmail(), this.getFlagImage(), this.getTeam(), this.getTimeOnTimeFactor(), this.getTimeOnDistanceAllowancePerNauticalMile(), this.getSearchTag(), this.getBoat(), true);
        return result;
    }

    @Override
    public DynamicBoat getBoat() {
        return this.boat;
    }

    @Override
    public void clearBoat() {
        this.boat = null;
    }

    @Override
    public boolean hasBoat() {
        return this.boat != null;
    }

    @Override
    public String getShortInfo() {
        String superResult = super.getShortInfo();
        String result = superResult != null ? superResult : (this.getBoat() != null ? (this.getBoat().getSailID() != null ? this.getBoat().getSailID() : this.getBoat().getName()) : null);
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " with boat " + this.getBoat();
    }
}

