/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Named;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;

public interface YellowBrickConfiguration
extends Named,
WithQualifiedObjectIdentifier {
    public String getRaceUrl();

    public String getUsername();

    public String getPassword();

    public String getCreatorName();

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.YELLOWBRICK_ACCOUNT;
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return YellowBrickConfiguration.getTypeRelativeObjectIdentifier(this.getRaceUrl(), this.getCreatorName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String raceUrl, String creatorName) {
        return creatorName == null ? new TypeRelativeObjectIdentifier(new String[]{raceUrl}) : new TypeRelativeObjectIdentifier(new String[]{raceUrl, creatorName});
    }
}

