/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.gateway.serialization.impl.BoatJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;

@Path(value="/v1/boats")
public class BoatsResource
extends AbstractSailingServerResource {
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{boatId}")
    public Response getBoat(@PathParam(value="boatId") String boatIdAsString, @QueryParam(value="secret") String regattaSecret, @QueryParam(value="leaderboardName") String leaderboardName) {
        Response response;
        DynamicBoat boat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(boatIdAsString);
        if (boat == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a boat with id '" + StringEscapeUtils.escapeHtml((String)boatIdAsString) + "'.")).type("text/plain").build();
        } else {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret);
            boolean boatInRegatta = false;
            if (skip) {
                Regatta regatta = this.getService().getRegattaByName(leaderboardName);
                boatInRegatta = Util.contains((Iterable)regatta.getAllBoats(), (Object)boat);
            }
            if (!skip || !boatInRegatta) {
                this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)boat, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
            }
            BoatJsonSerializer boatJsonSerializer = BoatJsonSerializer.create();
            response = Response.ok((Object)this.streamingOutput(boatJsonSerializer.serialize((Boat)boat))).build();
        }
        return response;
    }
}

