/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.data.transformer;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.windestimation.data.transformer.ConvertableToLabeledManeuverForEstimation;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import java.util.ArrayList;
import java.util.List;

public class ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData
implements ConvertableToLabeledManeuverForEstimation {
    private final CompleteManeuverCurveWithEstimationData maneuver;
    private final Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
    private final Double courseChangeInDegreesWithinTurningSectionOfNextManeuver;

    public ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData(CompleteManeuverCurveWithEstimationData maneuver, Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver, Double courseChangeInDegreesWithinTurningSectionOfNextManeuver) {
        this.maneuver = maneuver;
        this.courseChangeInDegreesWithinTurningSectionOfPreviousManeuver = courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
        this.courseChangeInDegreesWithinTurningSectionOfNextManeuver = courseChangeInDegreesWithinTurningSectionOfNextManeuver;
    }

    @Override
    public double getCourseChangeInDegreesWithinTurningSection() {
        return this.maneuver.getMainCurve().getDirectionChangeInDegrees();
    }

    @Override
    public boolean isMarkPassing() {
        return this.maneuver.isMarkPassing();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingBefore() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingBefore();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingAfter() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingAfter();
    }

    @Override
    public double getCourseChangeInDegrees() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getDirectionChangeInDegrees();
    }

    @Override
    public Double getCourseChangeInDegreesWithinTurningSectionOfPreviousManeuver() {
        return this.courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
    }

    @Override
    public Double getCourseChangeInDegreesWithinTurningSectionOfNextManeuver() {
        return this.courseChangeInDegreesWithinTurningSectionOfNextManeuver;
    }

    @Override
    public Duration getLongestIntervalBetweenTwoFixes() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getLongestIntervalBetweenTwoFixes();
    }

    @Override
    public Duration getIntervalBetweenFirstFixOfCurveAndPreviousFix() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getIntervalBetweenFirstFixOfCurveAndPreviousFix();
    }

    @Override
    public Duration getIntervalBetweenLastFixOfCurveAndNextFix() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getIntervalBetweenLastFixOfCurveAndNextFix();
    }

    @Override
    public Duration getDurationFromPreviousManeuverEndToManeuverStart() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getDurationFromPreviousManeuverEndToManeuverStart();
    }

    @Override
    public Duration getDurationFromManeuverEndToNextManeuverStart() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getDurationFromManeuverEndToNextManeuverStart();
    }

    @Override
    public Speed getLowestSpeed() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getLowestSpeed();
    }

    @Override
    public Speed getHighestSpeedWithinTurningSection() {
        return this.maneuver.getMainCurve().getHighestSpeed();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingBeforeWithinTurningSection() {
        return this.maneuver.getMainCurve().getSpeedWithBearingBefore();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingAfterWithinTurningSection() {
        return this.maneuver.getMainCurve().getSpeedWithBearingAfter();
    }

    @Override
    public Double getTargetTackAngleInDegrees() {
        return this.maneuver.getTargetTackAngleInDegrees();
    }

    @Override
    public Double getTargetJibeAngleInDegrees() {
        return this.maneuver.getTargetJibeAngleInDegrees();
    }

    @Override
    public boolean hasMarkPassingData() {
        return this.maneuver.getRelativeBearingToNextMarkAfterManeuver() != null || this.maneuver.getRelativeBearingToNextMarkBeforeManeuver() != null;
    }

    @Override
    public double getMaxTurningRateInDegreesPerSecond() {
        return this.maneuver.getMainCurve().getMaxTurningRateInDegreesPerSecond();
    }

    @Override
    public Bearing getMiddleCourse() {
        return this.maneuver.getCurveWithUnstableCourseAndSpeed().getMiddleCourse();
    }

    @Override
    public Position getPosition() {
        return this.maneuver.getPosition();
    }

    @Override
    public TimePoint getTimePoint() {
        return this.maneuver.getTimePoint();
    }

    @Override
    public Wind getWind() {
        return this.maneuver.getWind();
    }

    @Override
    public ManeuverType getManeuverTypeForCompleteManeuverCurve() {
        return this.maneuver.getManeuverTypeForCompleteManeuverCurve();
    }

    public static List<ConvertableToLabeledManeuverForEstimation> getConvertableManeuvers(List<CompleteManeuverCurveWithEstimationData> maneuvers) {
        ArrayList<ConvertableToLabeledManeuverForEstimation> convertableManeuvers = new ArrayList<ConvertableToLabeledManeuverForEstimation>(maneuvers.size());
        CompleteManeuverCurveWithEstimationData previousManeuver = null;
        CompleteManeuverCurveWithEstimationData currentManeuver = null;
        for (CompleteManeuverCurveWithEstimationData nextManeuver : maneuvers) {
            if (currentManeuver != null) {
                Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver = previousManeuver == null ? null : Double.valueOf(previousManeuver.getMainCurve().getDirectionChangeInDegrees());
                Double courseChangeInDegreesWithinTurningSectionOfNextManeuver = nextManeuver.getMainCurve().getDirectionChangeInDegrees();
                ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData convertableManeuver = new ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData(currentManeuver, courseChangeInDegreesWithinTurningSectionOfPreviousManeuver, courseChangeInDegreesWithinTurningSectionOfNextManeuver);
                convertableManeuvers.add(convertableManeuver);
            }
            previousManeuver = currentManeuver;
            currentManeuver = nextManeuver;
        }
        if (currentManeuver != null) {
            Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver = previousManeuver == null ? null : Double.valueOf(previousManeuver.getMainCurve().getDirectionChangeInDegrees());
            Double courseChangeInDegreesWithinTurningSectionOfNextManeuver = null;
            ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData convertableManeuver = new ConvertableManeuverForEstimationAdapterForCompleteManeuverCurveWithEstimationData(currentManeuver, courseChangeInDegreesWithinTurningSectionOfPreviousManeuver, courseChangeInDegreesWithinTurningSectionOfNextManeuver);
            convertableManeuvers.add(convertableManeuver);
        }
        return convertableManeuvers;
    }
}

