/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sailing.windestimation.aggregator.graph.DijkstraShortestPathFinderImpl;
import com.sap.sailing.windestimation.aggregator.graph.DijsktraShortestPathFinder;
import com.sap.sailing.windestimation.aggregator.graph.ElementAdjacencyQualityMetric;
import com.sap.sailing.windestimation.aggregator.graph.InnerGraphSuccessorSupplier;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelInference;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestPathsCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstManeuverGraphGenerator;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MstBestPathsCalculatorImpl
implements MstBestPathsCalculator {
    private final MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator;

    public MstBestPathsCalculatorImpl(MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator) {
        this.transitionProbabilitiesCalculator = transitionProbabilitiesCalculator;
    }

    @Override
    public MstGraphNodeTransitionProbabilitiesCalculator getTransitionProbabilitiesCalculator() {
        return this.transitionProbabilitiesCalculator;
    }

    @Override
    public Iterable<GraphLevelInference<MstGraphLevel>> getBestNodes(MstManeuverGraphGenerator.MstManeuverGraphComponents graphComponents) {
        ElementAdjacencyQualityMetric<GraphNode> edgeQualityMetric = (previousNode, currentNode) -> {
            double result = this.transitionProbabilitiesCalculator.getTransitionProbability((GraphNode<MstGraphLevel>)currentNode, (GraphNode<MstGraphLevel>)previousNode, previousNode.getGraphLevel() == null ? 0.0 : ((MstGraphLevel)previousNode.getGraphLevel()).getDistanceToParent());
            return result;
        };
        HashSet<DijsktraShortestPathFinder<GraphNode<MstGraphLevel>>> dijkstraShortestPathResults = new HashSet<DijsktraShortestPathFinder<GraphNode<MstGraphLevel>>>();
        for (MstGraphLevel leaf : graphComponents.getLeaves()) {
            InnerGraphSuccessorSupplier<GraphNode, MstGraphLevel> innerGraphSuccessorSupplier = new InnerGraphSuccessorSupplier<GraphNode, MstGraphLevel>(graphComponents, nameSupplier -> new GraphNode<MstGraphLevel>(null, null, new WindCourseRange(0.0, 360.0), 1.0, 0, null){

                @Override
                public String toString() {
                    return (String)nameSupplier.get();
                }
            });
            DijkstraShortestPathFinderImpl<GraphNode<MstGraphLevel>> dijsktraShortestPathFinder = new DijkstraShortestPathFinderImpl<GraphNode<MstGraphLevel>>(innerGraphSuccessorSupplier.getArtificialLeaf(leaf), innerGraphSuccessorSupplier.getArtificialRoot(), innerGraphSuccessorSupplier, edgeQualityMetric){

                @Override
                protected double getPathQuality(double qualityOfPathToCurrent, GraphNode<MstGraphLevel> currentNode, GraphNode<MstGraphLevel> successor) {
                    GraphNode<MstGraphLevel> nodeAgainstWhoseWindRangeToCompareThatOfSuccessor = currentNode;
                    while (nodeAgainstWhoseWindRangeToCompareThatOfSuccessor != this.getStartNode() && (nodeAgainstWhoseWindRangeToCompareThatOfSuccessor.getManeuverType() == ManeuverTypeForClassification.BEAR_AWAY || nodeAgainstWhoseWindRangeToCompareThatOfSuccessor.getManeuverType() == ManeuverTypeForClassification.HEAD_UP)) {
                        nodeAgainstWhoseWindRangeToCompareThatOfSuccessor = this.getPredecessorInBestPath(nodeAgainstWhoseWindRangeToCompareThatOfSuccessor);
                    }
                    return qualityOfPathToCurrent * this.getEdgeQualitySupplier().getQuality(nodeAgainstWhoseWindRangeToCompareThatOfSuccessor, successor) * successor.getQuality();
                }
            };
            dijkstraShortestPathResults.add((DijsktraShortestPathFinder<GraphNode<MstGraphLevel>>)dijsktraShortestPathFinder);
        }
        return this.disambiguate(dijkstraShortestPathResults);
    }

    private Iterable<GraphLevelInference<MstGraphLevel>> disambiguate(Set<DijsktraShortestPathFinder<GraphNode<MstGraphLevel>>> dijkstraShortestPathResults) {
        HashMap<MstGraphLevel, Map<ManeuverTypeForClassification, List<Double>>> qualitiesPerTypePerTreeNode = new HashMap<MstGraphLevel, Map<ManeuverTypeForClassification, List<Double>>>();
        for (DijsktraShortestPathFinder<GraphNode<MstGraphLevel>> onePathResult : dijkstraShortestPathResults) {
            Iterable<GraphNode<MstGraphLevel>> shortestPath = onePathResult.getShortestPath();
            for (GraphNode<MstGraphLevel> nodeSelected : shortestPath) {
                if (nodeSelected.getGraphLevel() == null) continue;
                Map mapForTreeNode = qualitiesPerTypePerTreeNode.computeIfAbsent(nodeSelected.getGraphLevel(), k -> new HashMap());
                mapForTreeNode.merge(nodeSelected.getManeuverType(), new ArrayList<Double>(Arrays.asList(onePathResult.getPathQuality())), (previousQualities, value) -> {
                    previousQualities.add((Double)value.get(0));
                    return previousQualities;
                });
            }
        }
        return this.getMajorityVerdicts(qualitiesPerTypePerTreeNode);
    }

    private Iterable<GraphLevelInference<MstGraphLevel>> getMajorityVerdicts(Map<MstGraphLevel, Map<ManeuverTypeForClassification, List<Double>>> qualitiesPerTypePerTreeNode) {
        ArrayList<GraphLevelInference<MstGraphLevel>> result = new ArrayList<GraphLevelInference<MstGraphLevel>>();
        for (Map.Entry<MstGraphLevel, Map<ManeuverTypeForClassification, List<Double>>> e : qualitiesPerTypePerTreeNode.entrySet()) {
            MstGraphLevel treeNodeToClassify = e.getKey();
            double maxQualitySum = -1.0;
            ManeuverTypeForClassification bestClassification = null;
            for (Map.Entry<ManeuverTypeForClassification, List<Double>> pathQualitiesForClassification : e.getValue().entrySet()) {
                double probabilitySum = pathQualitiesForClassification.getValue().stream().collect(Collectors.summingDouble(d -> d));
                if (!(probabilitySum > maxQualitySum)) continue;
                maxQualitySum = probabilitySum;
                bestClassification = pathQualitiesForClassification.getKey();
            }
            double invertedMatchesProduct = 1.0;
            double invertedNonMatchesProduct = 1.0;
            for (Map.Entry<ManeuverTypeForClassification, List<Double>> pathQualitiesForClassification : e.getValue().entrySet()) {
                for (Double pathQuality : pathQualitiesForClassification.getValue()) {
                    if (pathQualitiesForClassification.getKey() == bestClassification) {
                        invertedMatchesProduct *= 1.0 - pathQuality;
                        continue;
                    }
                    invertedNonMatchesProduct *= 1.0 - pathQuality;
                }
            }
            double bestClassificationQuality = (1.0 - invertedMatchesProduct) * invertedNonMatchesProduct;
            result.add(new GraphLevelInference(treeNodeToClassify.getLevelNodes().get(bestClassification.ordinal()), bestClassificationQuality));
        }
        return result;
    }
}

