/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.windestimation.WindEstimationComponentWithInternals;
import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.aggregator.polarsfitting.PolarsFittingWindEstimation;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifiersCache;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.preprocessing.PreprocessingPipeline;
import com.sap.sailing.windestimation.windinference.WindTrackCalculator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PolarsFittingBasedWindEstimationComponentImpl<InputType>
implements WindEstimationComponentWithInternals<InputType> {
    private final PolarDataService polarService;
    private final PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> preprocessingPipeline;

    public PolarsFittingBasedWindEstimationComponentImpl(PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> preprocessingPipeline, PolarDataService polarService) {
        this.preprocessingPipeline = preprocessingPipeline;
        this.polarService = polarService;
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrack(InputType input) {
        RaceWithEstimationData<ManeuverForEstimation> race = this.preprocessingPipeline.preprocessInput(input);
        return this.estimateWindTrackAfterPreprocessing(race);
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterPreprocessing(RaceWithEstimationData<ManeuverForEstimation> race) {
        PolarsFittingWindEstimation windEstimation = new PolarsFittingWindEstimation(this.polarService, race.getCompetitorTracks());
        List maneuvers = race.getCompetitorTracks().stream().flatMap(competitorTrack -> competitorTrack.getElements().stream()).sorted((one, two) -> one.getManeuverTimePoint().compareTo((Object)two.getManeuverTimePoint())).collect(Collectors.toList());
        ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> result = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>();
        WindWithConfidence<Void> wind = windEstimation.estimateAverageWind();
        if (wind != null) {
            for (ManeuverForEstimation maneuver : maneuvers) {
                if (!maneuver.isClean()) continue;
                Bearing twaBefore = ((Wind)wind.getObject()).getFrom().getDifferenceTo(maneuver.getSpeedWithBearingBefore().getBearing());
                Bearing twaAfter = ((Wind)wind.getObject()).getFrom().getDifferenceTo(maneuver.getSpeedWithBearingAfter().getBearing());
                if (!(twaBefore.getDegrees() * twaAfter.getDegrees() < 0.0) || !(Math.abs(Math.abs(twaBefore.getDegrees()) - Math.abs(twaAfter.getDegrees())) <= 20.0)) continue;
                WindImpl newWind = new WindImpl(maneuver.getManeuverPosition(), maneuver.getManeuverTimePoint(), (SpeedWithBearing)wind.getObject());
                result.add((WindWithConfidence<Util.Pair<Position, TimePoint>>)new WindWithConfidenceImpl((Wind)newWind, wind.getConfidence(), (Object)new Util.Pair((Object)maneuver.getManeuverPosition(), (Object)maneuver.getManeuverTimePoint()), newWind.getKnots() > 0.0));
            }
        }
        return result;
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterManeuverClassification(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterManeuverClassificationsAggregation(List<ManeuverWithEstimatedType> improvedManeuverClassifications) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> getPreprocessingPipeline() {
        return this.preprocessingPipeline;
    }

    @Override
    public ManeuverClassificationsAggregator getManeuverClassificationsAggregator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManeuverClassifiersCache getManeuverClassifiersCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WindTrackCalculator getWindTrackCalculator() {
        throw new UnsupportedOperationException();
    }
}

