/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.subscription.SubscriptionApiService;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProviderSubscriptionPlanUpdateTask
implements SubscriptionApiService.OnItemPriceResultListener {
    private static final Logger logger = Logger.getLogger(ProviderSubscriptionPlanUpdateTask.class.getName());
    private final SubscriptionApiService apiService;
    private final CompletableFuture<SecurityService> securityService;

    public ProviderSubscriptionPlanUpdateTask(SubscriptionApiService apiService, CompletableFuture<SecurityService> securityService) {
        this.apiService = apiService;
        this.securityService = securityService;
    }

    public void run() {
        try {
            this.apiService.getItemPrices(this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Fetch subscription plans failed, provider: " + this.apiService.getProviderName(), e);
        }
    }

    @Override
    public void onItemPriceResult(Map<String, BigDecimal> itemPrices) {
        if (itemPrices != null) {
            this.getSecurityService().updateSubscriptionPlanPrices(itemPrices);
        } else {
            logger.log(Level.SEVERE, "Updating item prices failed, provider: " + this.apiService.getProviderName());
        }
    }

    private SecurityService getSecurityService() {
        try {
            return this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Failure to get SecurityService", e);
            throw new RuntimeException(e);
        }
    }
}

