/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs.api;

import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.UnauthorizedException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/restsecurity/role")
public class RoleResource
extends AbstractSecurityResource {
    private static final String KEY_PERMISSIONS = "permissions";
    private static final String KEY_ROLE_ID = "roleId";
    private static final String KEY_ROLE_NAME = "roleName";

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createRole(final @FormParam(value="roleName") String roleName) {
        Response resp;
        final String roleDefinitionIdAsString = UUID.randomUUID().toString();
        RoleDefinition role = this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.ROLE_DEFINITION, new TypeRelativeObjectIdentifier(new String[]{roleDefinitionIdAsString}), roleName, new Callable<RoleDefinition>(){

            @Override
            public RoleDefinition call() throws Exception {
                return RoleResource.this.getSecurityService().createRoleDefinition(UUID.fromString(roleDefinitionIdAsString), roleName);
            }
        });
        if (role == null) {
            resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Role creation failed.").build();
        } else {
            JSONObject jsonResult = new JSONObject();
            jsonResult.put((Object)KEY_PERMISSIONS, (Object)new JSONArray());
            jsonResult.put((Object)KEY_ROLE_ID, (Object)role.getId().toString());
            jsonResult.put((Object)KEY_ROLE_NAME, (Object)role.getName());
            resp = Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.streamingOutput(jsonResult)).build();
        }
        return resp;
    }

    @Path(value="{roleId}")
    @DELETE
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response deleteRole(@PathParam(value="roleId") String roleId) {
        Response resp;
        try {
            UUID roleUUID = UUID.fromString(roleId);
            RoleDefinition roleDefinition = this.getSecurityService().getRoleDefinition(roleUUID);
            if (roleDefinition == null) {
                resp = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No role with id '%s' found.", roleUUID)).build();
            } else {
                this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)roleDefinition, () -> this.getSecurityService().deleteRoleDefinition(roleDefinition));
                resp = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        }
        catch (IllegalArgumentException e) {
            resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid roleId.").build();
        }
        catch (UnauthorizedException e) {
            resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return resp;
    }

    @Path(value="{roleId}")
    @PUT
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"application/json"})
    public Response updateRole(@PathParam(value="roleId") String roleId, String json) {
        Response resp;
        try {
            UUID roleUUID = UUID.fromString(roleId);
            RoleDefinition roleDefinition = this.getSecurityService().getRoleDefinition(roleUUID);
            if (roleDefinition == null) {
                resp = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No role with id '%s' found.", roleUUID)).build();
            } else {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)roleDefinition);
                HashSet<WildcardPermission> permissions = new HashSet<WildcardPermission>();
                JSONObject body = (JSONObject)new JSONParser().parse(json);
                Iterable permissionStrings = (Iterable)body.get((Object)KEY_PERMISSIONS);
                for (String permissionString : permissionStrings) {
                    permissions.add(new WildcardPermission(permissionString));
                }
                HashSet<WildcardPermission> addedPermissions = new HashSet<WildcardPermission>(roleDefinition.getPermissions());
                addedPermissions.removeAll(permissions);
                HashSet<WildcardPermission> removedPermissions = new HashSet<WildcardPermission>(permissions);
                removedPermissions.removeAll(roleDefinition.getPermissions());
                if (!this.getSecurityService().hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(roleDefinition, addedPermissions)) {
                    resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Not permitted to grant permissions for role " + roleDefinition.getName())).build();
                } else if (!this.getSecurityService().hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(roleDefinition, removedPermissions)) {
                    resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Not permitted to revoke permissions for role " + roleDefinition.getName())).build();
                } else {
                    roleDefinition.setPermissions(permissions);
                    String roleName = (String)body.get((Object)KEY_ROLE_NAME);
                    if (roleName != null) {
                        roleDefinition.setName(roleName);
                    }
                    this.getSecurityService().updateRoleDefinition(roleDefinition);
                    resp = Response.ok().build();
                }
            }
        }
        catch (IllegalArgumentException | ParseException e) {
            resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid roleId.").build();
        }
        catch (UnauthorizedException e) {
            resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return resp;
    }

    @GET
    @Path(value="{roleId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getRole(@PathParam(value="roleId") String roleId) {
        Response resp;
        try {
            UUID roleUUID = UUID.fromString(roleId);
            RoleDefinition roleDefinition = this.getSecurityService().getRoleDefinition(roleUUID);
            if (roleDefinition == null) {
                resp = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No role with id '%s' found.", roleUUID)).build();
            } else {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)roleDefinition);
                JSONObject jsonResult = new JSONObject();
                JSONArray jsonPermissions = new JSONArray();
                for (WildcardPermission permission : roleDefinition.getPermissions()) {
                    jsonPermissions.add((Object)permission.toString());
                }
                jsonResult.put((Object)KEY_PERMISSIONS, (Object)jsonPermissions);
                jsonResult.put((Object)KEY_ROLE_ID, (Object)roleId);
                jsonResult.put((Object)KEY_ROLE_NAME, (Object)roleDefinition.getName());
                resp = Response.ok((Object)this.streamingOutput(jsonResult)).build();
            }
        }
        catch (IllegalArgumentException e) {
            resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid roleId.").build();
        }
        catch (UnauthorizedException e) {
            resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return resp;
    }
}

