/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs.api;

import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.json.simple.parser.ParseException;

@Path(value="/restsecurity/preferences")
public class PreferencesResource
extends AbstractSecurityResource {
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{settingsKey}")
    public Response getPreference(@PathParam(value="settingsKey") String settingsKey) throws ParseException {
        Response response = null;
        if (SecurityUtils.getSubject().isAuthenticated()) {
            String username = SecurityUtils.getSubject().getPrincipal().toString();
            String settings = this.getSecurityService().getPreference(username, settingsKey);
            response = settings == null ? Response.noContent().build() : Response.ok((Object)settings).build();
        } else {
            response = Response.status((int)401).build();
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="{settingsKey}")
    public Response putPreference(@PathParam(value="settingsKey") String settingsKey, String json) throws ParseException {
        Response response = null;
        if (SecurityUtils.getSubject().isAuthenticated()) {
            String username = SecurityUtils.getSubject().getPrincipal().toString();
            this.getSecurityService().setPreference(username, settingsKey, json);
            response = Response.ok().build();
        } else {
            response = Response.status((int)401).build();
        }
        return response;
    }

    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{settingsKey}")
    public Response deletePreference(@PathParam(value="settingsKey") String settingsKey) throws ParseException {
        Response response = null;
        if (SecurityUtils.getSubject().isAuthenticated()) {
            String username = SecurityUtils.getSubject().getPrincipal().toString();
            this.getSecurityService().unsetPreference(username, settingsKey);
            response = Response.ok().build();
        } else {
            response = Response.status((int)401).build();
        }
        return response;
    }
}

