/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.common.Stoppable;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.security.StoreServiceTrackerCustomizer;
import com.sap.sse.security.interfaces.PreferenceObjectListener;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class PreferenceObjectBasedNotificationSet<PrefT, T>
implements Stoppable {
    private static final Logger logger = Logger.getLogger(PreferenceObjectBasedNotificationSet.class.getName());
    private UserStore store;
    private final PreferenceObjectListener<PrefT> listener = new PreferenceObjectListenerImpl();
    private final Map<T, Set<String>> notifications = new HashMap<T, Set<String>>();
    protected final BundleContext context;
    private final ServiceTracker<UserStore, UserStore> tracker;
    private final NamedReentrantReadWriteLock lock;

    public PreferenceObjectBasedNotificationSet(final String key, BundleContext context) {
        this.context = context;
        if (context == null) {
            this.tracker = null;
        } else {
            this.tracker = new ServiceTracker(context, UserStore.class, (ServiceTrackerCustomizer)new StoreServiceTrackerCustomizer<UserStore>(context, logger){

                @Override
                protected void setStore(UserStore store) {
                    PreferenceObjectBasedNotificationSet.this.store = store;
                    store.addPreferenceObjectListener(key, PreferenceObjectBasedNotificationSet.this.listener, true);
                }

                @Override
                protected void removeStore() {
                    PreferenceObjectBasedNotificationSet.this.store = null;
                }

                @Override
                protected UserStore getStore() {
                    return PreferenceObjectBasedNotificationSet.this.store;
                }
            });
            this.tracker.open();
        }
        this.lock = new NamedReentrantReadWriteLock(String.valueOf(this.getClass().getName()) + " for " + key, false);
    }

    public PreferenceObjectBasedNotificationSet(String key, UserStore store) {
        this(key, (BundleContext)null);
        this.store = store;
        store.addPreferenceObjectListener(key, this.listener, true);
    }

    public void stop() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.removeStore();
    }

    protected void removeStore() {
        if (this.store != null) {
            this.store.removePreferenceObjectListener(this.listener);
            this.store = null;
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.notifications.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    protected abstract Collection<T> calculateObjectsToNotify(PrefT var1);

    public Iterable<String> getUserNamesToNotifyFor(T object) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            HashSet<String> hashSet = new HashSet<String>((Collection)Util.get(this.notifications, object, Collections.emptySet()));
            return hashSet;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public void forUsersWithVerifiedEmailMappedTo(T object, Consumer<User> consumer) {
        for (String username : this.getUserNamesToNotifyFor(object)) {
            User user = this.store.getUserByName(username);
            if (user == null) {
                logger.log(Level.SEVERE, "Could not get User for name \"" + username + "\"");
                continue;
            }
            if (!user.isEmailValidated()) continue;
            consumer.accept(user);
        }
    }

    private class PreferenceObjectListenerImpl
    implements PreferenceObjectListener<PrefT> {
        private PreferenceObjectListenerImpl() {
        }

        public void preferenceObjectChanged(String username, String key, PrefT oldPreference, PrefT newPreference) {
            Set oldObjectsToNotify = oldPreference == null ? Collections.emptySet() : PreferenceObjectBasedNotificationSet.this.calculateObjectsToNotify(oldPreference);
            Set newObjectsToNotify = newPreference == null ? Collections.emptySet() : PreferenceObjectBasedNotificationSet.this.calculateObjectsToNotify(newPreference);
            HashSet objectsToRemove = new HashSet(oldObjectsToNotify);
            objectsToRemove.removeAll(newObjectsToNotify);
            HashSet objectsToAdd = new HashSet(newObjectsToNotify);
            objectsToAdd.removeAll(oldObjectsToNotify);
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)PreferenceObjectBasedNotificationSet.this.lock);
            try {
                for (Object objectToRemove : objectsToRemove) {
                    Util.removeFromValueSet((Map)PreferenceObjectBasedNotificationSet.this.notifications, objectToRemove, (Object)username);
                }
                for (Object objectToAdd : objectsToAdd) {
                    Util.addToValueSet((Map)PreferenceObjectBasedNotificationSet.this.notifications, objectToAdd, (Object)username);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)PreferenceObjectBasedNotificationSet.this.lock);
            }
        }
    }
}

