/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.settings;

import com.google.gwt.http.client.URL;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.serializer.SettingsToStringMapSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SettingsToStringSerializer {
    private final SettingsToStringMapSerializer settingsToStringMapSerializer = new SettingsToStringMapSerializer();

    public String fromSettings(GenericSerializableSettings settings) {
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        return this.writeParameterMapToString(serializedValues);
    }

    public String fromSettings(SettingsMap settings) {
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        return this.writeParameterMapToString(serializedValues);
    }

    public String fromSettings(GenericSerializableSettings context, GenericSerializableSettings settings) {
        Map serializedContext = this.settingsToStringMapSerializer.serialize(context);
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        serializedValues.putAll(serializedContext);
        return this.writeParameterMapToString(serializedValues);
    }

    public String fromSettings(GenericSerializableSettings context, SettingsMap settings) {
        Map serializedContext = this.settingsToStringMapSerializer.serialize(context);
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        serializedValues.putAll(serializedContext);
        return this.writeParameterMapToString(serializedValues);
    }

    private String writeParameterMapToString(Map<String, Iterable<String>> serializedValues) {
        String settingsString = "";
        for (Map.Entry<String, Iterable<String>> val : serializedValues.entrySet()) {
            String ekey = URL.encode((String)val.getKey());
            for (String vval : val.getValue()) {
                String evval = URL.encode((String)vval);
                if (!settingsString.isEmpty()) {
                    settingsString = String.valueOf(settingsString) + "&";
                }
                settingsString = String.valueOf(settingsString) + ekey + "=" + evval;
            }
        }
        return settingsString;
    }

    public final <T extends GenericSerializableSettings, C extends GenericSerializableSettings> void fromString(String serializedSettings, C contextSettings, T settings) {
        Map<String, Iterable<String>> values = this.deserializeStringToMap(serializedSettings);
        this.settingsToStringMapSerializer.deserialize(settings, values);
        this.settingsToStringMapSerializer.deserialize(contextSettings, values);
    }

    public final <T extends SettingsMap, C extends GenericSerializableSettings> void fromString(String serializedSettings, C contextSettings, T settings) {
        Map<String, Iterable<String>> values = this.deserializeStringToMap(serializedSettings);
        this.settingsToStringMapSerializer.deserializeSettingsMap(settings, values);
        this.settingsToStringMapSerializer.deserialize(contextSettings, values);
    }

    public final <T extends GenericSerializableSettings> T fromString(String serializedSettings, T settings) {
        Map<String, Iterable<String>> values = this.deserializeStringToMap(serializedSettings);
        return (T)this.settingsToStringMapSerializer.deserialize(settings, values);
    }

    public final <T extends SettingsMap> T fromString(String serializedSettings, T settings) {
        Map<String, Iterable<String>> values = this.deserializeStringToMap(serializedSettings);
        return (T)this.settingsToStringMapSerializer.deserializeSettingsMap(settings, values);
    }

    private Map<String, Iterable<String>> deserializeStringToMap(String serializedSettings) {
        HashMap<String, Iterable<String>> values = new HashMap<String, Iterable<String>>();
        if (serializedSettings != null && !serializedSettings.isEmpty()) {
            String[] singleSettings;
            String[] stringArray = singleSettings = serializedSettings.split("&");
            int n = singleSettings.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] entryParts = entry.split("=");
                String key = URL.decode((String)entryParts[0]);
                String value = URL.decode((String)entryParts[1]);
                ArrayList listOrNull = (ArrayList)values.get(key);
                if (listOrNull == null) {
                    listOrNull = new ArrayList();
                    values.put(key, listOrNull);
                }
                ((ArrayList)listOrNull).add(value);
                ++n2;
            }
        }
        return values;
    }
}

