/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.perspective;

import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.Perspective;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeTabbedSettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPerspectiveComposite<PL extends PerspectiveLifecycle<PS>, PS extends Settings>
extends AbstractCompositeComponent<PerspectiveCompositeSettings<PS>>
implements Perspective<PS> {
    private final PL perspectiveLifecycle;
    private PS perspectiveOwnSettings;
    private final Map<String, Component<? extends Settings>> childComponents = new HashMap<String, Component<? extends Settings>>();

    protected void addChildComponent(Component<? extends Settings> childComponent) {
        Component<? extends Settings> old = this.childComponents.put(childComponent.getId(), childComponent);
        if (old != null) {
            throw new IllegalStateException("Child with same id is already added " + childComponent.getId());
        }
    }

    @Override
    public Collection<Component<? extends Settings>> getComponents() {
        return this.childComponents.values();
    }

    protected SettingsDialogComponent<PS> getPerspectiveSettingsDialogComponent(PS perspectiveSettings) {
        return this.perspectiveLifecycle.getPerspectiveOwnSettingsDialogComponent(perspectiveSettings);
    }

    public AbstractPerspectiveComposite(Component<?> parent, ComponentContext<PerspectiveCompositeSettings<PS>> componentContext, PL lifecycle, PerspectiveCompositeSettings<PS> settings) {
        super(parent, componentContext);
        this.perspectiveLifecycle = lifecycle;
        this.perspectiveOwnSettings = settings.getPerspectiveOwnSettings();
    }

    @Override
    public PerspectiveCompositeSettings<PS> getSettings() {
        HashMap<String, Settings> settingsPerComponent = new HashMap<String, Settings>();
        for (Component<Settings> c : this.getComponents()) {
            if (!c.hasSettings()) continue;
            settingsPerComponent.put(c.getId(), c.getSettings());
        }
        return new PerspectiveCompositeSettings<PS>(this.getPerspectiveSettings(), settingsPerComponent);
    }

    @Override
    public void updateSettings(PerspectiveCompositeSettings<PS> newSettings) {
        for (Map.Entry<String, Settings> componentAndSettings : newSettings.getSettingsPerComponentId().entrySet()) {
            this.updateSettings(componentAndSettings);
        }
        this.perspectiveOwnSettings = newSettings.getPerspectiveOwnSettings();
    }

    @Override
    private <S extends Settings> void updateSettings(Map.Entry<String, S> componentIdAndSettings) {
        Component<?> component = this.findComponentById(componentIdAndSettings.getKey());
        if (component != null) {
            component.updateSettings((Settings)componentIdAndSettings.getValue());
        }
    }

    private Component<?> findComponentById(String componentId) {
        for (Component<Settings> component : this.getComponents()) {
            if (!component.getId().equals(componentId)) continue;
            return component;
        }
        return null;
    }

    @Override
    public Widget getEntryWidget() {
        return this.asWidget();
    }

    @Override
    public String getLocalizedShortName() {
        return this.perspectiveLifecycle.getLocalizedShortName();
    }

    @Override
    public boolean hasSettings() {
        return this.perspectiveLifecycle.hasSettings();
    }

    @Override
    public SettingsDialogComponent<PerspectiveCompositeSettings<PS>> getSettingsDialogComponent(PerspectiveCompositeSettings<PS> settings) {
        return new PerspectiveCompositeTabbedSettingsDialogComponent(this);
    }

    protected PS getPerspectiveSettings() {
        return this.perspectiveOwnSettings;
    }

    protected PL getPerspectiveLifecycle() {
        return this.perspectiveLifecycle;
    }
}

