/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.panels;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.DeckLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractTabLayoutPanel
extends ResizeComposite
implements HasWidgets,
ProvidesResize,
IndexedPanel.ForIsWidget,
AnimatedLayout,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    protected final TabbedDeckLayoutPanel deckPanel = new TabbedDeckLayoutPanel();
    protected final FlowPanel tabBar = new FlowPanel();
    protected final ArrayList<Tab> tabs = new ArrayList();
    private int selectedIndex = -1;

    public abstract String getContentConteinerStyle();

    public abstract String getContentStyle();

    public abstract String getTabStyle();

    public abstract String getTabInnerStyle();

    public AbstractTabLayoutPanel(double barHeight, Style.Unit barUnit) {
        LayoutPanel panel = new LayoutPanel();
        this.initWidget((Widget)panel);
        panel.add((Widget)this.tabBar);
        panel.setWidgetLeftRight((Widget)this.tabBar, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        panel.setWidgetTopHeight((Widget)this.tabBar, 0.0, Style.Unit.PX, barHeight, barUnit);
        panel.setWidgetVerticalPosition((Widget)this.tabBar, Layout.Alignment.END);
        this.deckPanel.addStyleName(this.getContentConteinerStyle());
        panel.add((Widget)this.deckPanel);
        panel.setWidgetLeftRight((Widget)this.deckPanel, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        panel.setWidgetTopBottom((Widget)this.deckPanel, barHeight, barUnit, 0.0, Style.Unit.PX);
    }

    public void add(IsWidget w) {
        this.add(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)w));
    }

    public void add(IsWidget w, IsWidget tab) {
        this.add(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)w), AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)tab));
    }

    public void add(IsWidget w, String text) {
        this.add(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)w), text);
    }

    public void add(IsWidget w, String text, boolean asHtml) {
        this.add(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)w), text, asHtml);
    }

    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void add(Widget child, String text) {
        this.insert(child, text, this.getWidgetCount());
    }

    public void add(Widget child, SafeHtml html) {
        this.add(child, html.asString(), true);
    }

    public void add(Widget child, String text, boolean asHtml) {
        this.add(child, text, asHtml, true);
    }

    public void add(Widget child, String text, boolean asHtml, boolean fireEvents) {
        this.insert(child, text, asHtml, this.getWidgetCount(), fireEvents);
    }

    public void add(Widget child, Widget tab) {
        this.insert(child, tab, this.getWidgetCount());
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void animate(int duration) {
        this.animate(duration, null);
    }

    public void animate(int duration, Layout.AnimationCallback callback) {
        this.deckPanel.animate(duration, callback);
    }

    public void clear() {
        Iterator<Widget> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public void forceLayout() {
        this.deckPanel.forceLayout();
    }

    public int getAnimationDuration() {
        return this.deckPanel.getAnimationDuration();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Widget getTabWidget(int index) {
        this.checkIndex(index);
        return this.tabs.get(index).getWidget();
    }

    public Widget getTabWidget(IsWidget child) {
        return this.getTabWidget(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child));
    }

    public Widget getTabWidget(Widget child) {
        this.checkChild(child);
        return this.getTabWidget(this.getWidgetIndex(child));
    }

    public Widget getWidget(int index) {
        return this.deckPanel.getWidget(index);
    }

    public int getWidgetCount() {
        return this.deckPanel.getWidgetCount();
    }

    public int getWidgetIndex(IsWidget child) {
        return this.getWidgetIndex(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child));
    }

    public int getWidgetIndex(Widget child) {
        return this.deckPanel.getWidgetIndex(child);
    }

    public void insert(IsWidget child, int beforeIndex) {
        this.insert(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child), beforeIndex);
    }

    public void insert(IsWidget child, IsWidget tab, int beforeIndex) {
        this.insert(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child), AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)tab), beforeIndex);
    }

    public void insert(IsWidget child, String text, boolean asHtml, int beforeIndex) {
        this.insert(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child), text, asHtml, beforeIndex);
    }

    public void insert(IsWidget child, String text, int beforeIndex) {
        this.insert(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child), text, beforeIndex);
    }

    public void insert(Widget child, int beforeIndex) {
        this.insert(child, "", beforeIndex);
    }

    public void insert(Widget child, SafeHtml html, int beforeIndex) {
        this.insert(child, html.asString(), true, beforeIndex);
    }

    public void insert(Widget child, String text, boolean asHtml, int beforeIndex) {
        this.insert(child, text, asHtml, beforeIndex, true);
    }

    public void insert(Widget child, String text, boolean asHtml, int beforeIndex, boolean fireEvents) {
        Object contents = asHtml ? new HTML(text) : new Label(text);
        this.insert(child, (Widget)contents, beforeIndex, fireEvents);
    }

    public void insert(Widget child, String text, int beforeIndex) {
        this.insert(child, text, false, beforeIndex);
    }

    public void insert(Widget child, Widget tab, int beforeIndex) {
        this.insert(child, new Tab(tab), beforeIndex);
    }

    public void insert(Widget child, Widget tab, int beforeIndex, boolean fireEvents) {
        this.insert(child, new Tab(tab), beforeIndex, fireEvents);
    }

    public boolean isAnimationVertical() {
        return this.deckPanel.isAnimationVertical();
    }

    public Iterator<Widget> iterator() {
        return this.deckPanel.iterator();
    }

    public boolean remove(int index) {
        return this.remove(index, true);
    }

    public boolean remove(int index, boolean fireEvents) {
        if (index < 0 || index >= this.getWidgetCount()) {
            return false;
        }
        Widget child = this.getWidget(index);
        this.tabBar.remove(index);
        this.deckPanel.removeProtected(child);
        child.removeStyleName(this.getContentStyle());
        Tab tab = this.tabs.remove(index);
        tab.getWidget().removeFromParent();
        if (index == this.selectedIndex) {
            this.selectedIndex = -1;
            if (this.getWidgetCount() > 0) {
                this.selectTab(0, fireEvents);
            }
        } else if (index < this.selectedIndex) {
            --this.selectedIndex;
        }
        return true;
    }

    public boolean remove(Widget w) {
        int index = this.getWidgetIndex(w);
        if (index == -1) {
            return false;
        }
        return this.remove(index);
    }

    public void selectTab(int index) {
        this.selectTab(index, true);
    }

    public void selectTab(int index, boolean fireEvents) {
        BeforeSelectionEvent event;
        this.checkIndex(index);
        if (index == this.selectedIndex) {
            return;
        }
        if (fireEvents && (event = BeforeSelectionEvent.fire((HasBeforeSelectionHandlers)this, (Object)index)) != null && event.isCanceled()) {
            return;
        }
        if (this.selectedIndex != -1) {
            this.tabs.get(this.selectedIndex).setSelected(false);
        }
        this.deckPanel.showWidget(index);
        this.tabs.get(index).setSelected(true);
        this.selectedIndex = index;
        if (fireEvents) {
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)index);
        }
    }

    public void selectTab(IsWidget child) {
        this.selectTab(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child));
    }

    public void selectTab(IsWidget child, boolean fireEvents) {
        this.selectTab(AbstractTabLayoutPanel.asWidgetOrNull((IsWidget)child), fireEvents);
    }

    public void selectTab(Widget child) {
        this.selectTab(this.getWidgetIndex(child));
    }

    public void selectTab(Widget child, boolean fireEvents) {
        this.selectTab(this.getWidgetIndex(child), fireEvents);
    }

    public void setAnimationDuration(int duration) {
        this.deckPanel.setAnimationDuration(duration);
    }

    public void setAnimationVertical(boolean isVertical) {
        this.deckPanel.setAnimationVertical(isVertical);
    }

    public void setTabHTML(int index, String html) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget((Widget)new HTML(html));
    }

    public void setTabHTML(int index, SafeHtml html) {
        this.setTabHTML(index, html.asString());
    }

    public void setTabText(int index, String text) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget((Widget)new Label(text));
    }

    private void checkChild(Widget child) {
        assert (this.getWidgetIndex(child) >= 0) : "Child is not a part of this panel";
    }

    private void checkIndex(int index) {
        assert (index >= 0 && index < this.getWidgetCount()) : "Index out of bounds";
    }

    private void insert(final Widget child, Tab tab, int beforeIndex, boolean fireEvents) {
        assert (beforeIndex >= 0 && beforeIndex <= this.getWidgetCount()) : "beforeIndex out of bounds";
        int idx = this.getWidgetIndex(child);
        if (idx != -1) {
            this.remove(child);
            if (idx < beforeIndex) {
                --beforeIndex;
            }
        }
        this.deckPanel.insertProtected(child, beforeIndex);
        this.tabs.add(beforeIndex, tab);
        this.tabBar.insert((Widget)tab, beforeIndex);
        tab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractTabLayoutPanel.this.selectTab(child);
            }
        });
        child.addStyleName(this.getContentStyle());
        if (this.selectedIndex == -1) {
            this.selectTab(0, fireEvents);
        } else if (this.selectedIndex >= beforeIndex) {
            ++this.selectedIndex;
        }
    }

    private void insert(Widget child, Tab tab, int beforeIndex) {
        this.insert(child, tab, beforeIndex, true);
    }

    private class Tab
    extends SimplePanel {
        private Element inner;
        private boolean replacingWidget;

        public Tab(Widget child) {
            super((Element)Document.get().createDivElement());
            this.inner = Document.get().createDivElement();
            this.getElement().appendChild((Node)this.inner);
            this.setWidget(child);
            this.setStyleName(AbstractTabLayoutPanel.this.getTabStyle());
            this.inner.setClassName(AbstractTabLayoutPanel.this.getTabInnerStyle());
            this.getElement().addClassName(CommonResources.getInlineBlockStyle());
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
        }

        public boolean remove(Widget w) {
            int index = AbstractTabLayoutPanel.this.tabs.indexOf((Object)this);
            if (this.replacingWidget || index < 0) {
                return super.remove(w);
            }
            return AbstractTabLayoutPanel.this.remove(index);
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.addStyleDependentName("selected");
            } else {
                this.removeStyleDependentName("selected");
            }
        }

        public void setWidget(Widget w) {
            this.replacingWidget = true;
            super.setWidget(w);
            this.replacingWidget = false;
        }

        protected com.google.gwt.user.client.Element getContainerElement() {
            return (com.google.gwt.user.client.Element)this.inner.cast();
        }
    }

    private class TabbedDeckLayoutPanel
    extends DeckLayoutPanel {
        private TabbedDeckLayoutPanel() {
        }

        public void add(Widget w) {
            throw new UnsupportedOperationException("Use TabLayoutPanel.add() to alter the DeckLayoutPanel");
        }

        public void clear() {
            throw new UnsupportedOperationException("Use TabLayoutPanel.clear() to alter the DeckLayoutPanel");
        }

        public void insert(Widget w, int beforeIndex) {
            throw new UnsupportedOperationException("Use TabLayoutPanel.insert() to alter the DeckLayoutPanel");
        }

        public boolean remove(Widget w) {
            return AbstractTabLayoutPanel.this.remove(w);
        }

        protected void insertProtected(Widget w, int beforeIndex) {
            super.insert(w, beforeIndex);
        }

        protected void removeProtected(Widget w) {
            super.remove(w);
        }
    }
}

