/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.datetime;

import com.google.gwt.dom.client.Document;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.text.shared.Parser;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.ValueBox;
import com.sap.sse.gwt.client.controls.datetime.AbstractInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputResources;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputType;
import com.sap.sse.gwt.client.controls.datetime.NativeDateTimeInput;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;

public class TimeInput
extends AbstractInput {
    public TimeInput(DateTimeInput.Accuracy accuracy) {
        super(DateTimeInputType.TIME.isSupported() ? NativeDateTimeInput.time(accuracy) : new TimeBox(new TimeConverter(accuracy)));
    }

    private static class TimeBox
    extends ValueBox<Date> {
        private TimeBox(TimeConverter converter) {
            super(Document.get().createElement("input"), (Renderer)converter, (Parser)converter);
            this.addStyleName(DateTimeInputResources.INSTANCE.css().dateTimeInput());
            this.getElement().setAttribute("placeholder", converter.viewFormat.getPattern());
        }
    }

    private static class TimeConverter
    extends AbstractRenderer<Date>
    implements Parser<Date> {
        private static final DateTimeFormat VIEW_FORMAT_SHORT = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_SHORT);
        private static final DateTimeFormat VIEW_FORMAT_MEDIUM = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM);
        private static final String EMPTY_VALUE = "";
        private final DateTimeFormat viewFormat;

        private TimeConverter(DateTimeInput.Accuracy accuracy) {
            this.viewFormat = accuracy == DateTimeInput.Accuracy.SECONDS ? VIEW_FORMAT_MEDIUM : VIEW_FORMAT_SHORT;
        }

        public String render(Date object) {
            return Objects.isNull(object) ? EMPTY_VALUE : this.viewFormat.format(object);
        }

        public Date parse(CharSequence text) throws ParseException {
            if (EMPTY_VALUE.equals(text.toString())) {
                return null;
            }
            try {
                return this.viewFormat.parse(text.toString());
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
    }
}

