/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.datetime;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputResources;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

class NativeDateTimeInput
extends Widget
implements DateTimeInput {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_STEP = "step";
    private final DateTimeFormat format;
    private final InputElement input;
    private final List<DateTimeFormat> additionalFormatsForParsing;

    static DateTimeInput date() {
        return new NativeDateTimeInput(DateTimeInputType.DATE, "", DateTimeInput.Accuracy.getDateFormat(), Collections.emptyList());
    }

    static DateTimeInput time(DateTimeInput.Accuracy accuracy) {
        ArrayList<DateTimeFormat> additionalFormats = new ArrayList<DateTimeFormat>();
        switch (accuracy) {
            case MILLISECONDS: {
                additionalFormats.add(DateTimeInput.Accuracy.SECONDS.getTimeFormat());
            }
            case SECONDS: {
                additionalFormats.add(DateTimeInput.Accuracy.MINUTES.getTimeFormat());
            }
        }
        return new NativeDateTimeInput(DateTimeInputType.TIME, accuracy.getStep(), accuracy.getTimeFormat(), additionalFormats);
    }

    static DateTimeInput datetimeLocale(DateTimeInput.Accuracy accuracy) {
        ArrayList<DateTimeFormat> additionalFormats = new ArrayList<DateTimeFormat>();
        switch (accuracy) {
            case MILLISECONDS: {
                additionalFormats.add(DateTimeInput.Accuracy.SECONDS.getDatetimeFormat());
            }
            case SECONDS: {
                additionalFormats.add(DateTimeInput.Accuracy.MINUTES.getDatetimeFormat());
            }
        }
        return new NativeDateTimeInput(DateTimeInputType.DATETIME_LOCAL, accuracy.getStep(), accuracy.getDatetimeFormat(), additionalFormats);
    }

    private NativeDateTimeInput(DateTimeInputType inputType, String step, DateTimeFormat format, List<DateTimeFormat> additionalFormatsForParsing) {
        this.additionalFormatsForParsing = additionalFormatsForParsing;
        this.input = (InputElement)Document.get().createElement("input").cast();
        this.input.setAttribute(ATTR_TYPE, inputType.getType());
        this.input.setAttribute(ATTR_STEP, step);
        this.input.addClassName(DateTimeInputResources.INSTANCE.css().dateTimeInput());
        this.format = format;
        this.setElement((Element)this.input);
        this.sinkEvents(5632);
    }

    public final void onBrowserEvent(Event event) {
        int type = event.getTypeInt();
        if (type == 1024 || type == 4096 || type == 512) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
        super.onBrowserEvent(event);
    }

    /*
     * Unable to fully structure code
     */
    public final Date getValue() {
        value = this.input.getValue();
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return this.format.parse(value);
        }
        catch (IllegalArgumentException exc) {
            ** for (additionalFormat : this.additionalFormatsForParsing)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return additionalFormat.parse(value);
            }
            catch (IllegalArgumentException var5_5) {
                // empty catch block
            }
            continue;
        }
lbl13:
        // 1 sources

        return null;
    }

    public final void setValue(Date value) {
        this.input.setValue(Objects.isNull(value) ? null : this.format.format(value));
    }

    public final HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }
}

